static char rcsid[] = "@(#)$Id: listinfocmd.c,v 1.6 2014/11/15 11:00:24 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.6 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_command.h"
#include "s_command.h"
#include "patchlevel.h"

DEBUG_VAR(Debug,__FILE__,"command");

/* increment refcount */
struct elm_commands *give_list_info_commands() 
{        

    static struct elm_commands  * list_info_commands = NULL;
    struct elm_commands  * ret = NULL;

    if (list_info_commands) {
	inc_commands_refcount(list_info_commands);
	return list_info_commands;
    }

    ret =  new_commands(format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandListInfoKeyTitle,"List info command")),
			format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandListIinfoDescTitle,
					      "Elm %s PL%s Action"),
				      VERSION,PATCHLEVEL),
			&list_info_commands);


    add_commands_help_single(ret,NULL,FLAG_KEY_no_nested ,'?',
			     CATGETS(elm_msg_cat, CommandSet, CommandCommonCommandHelp,
				     "Show command help or this screen of information."));

    add_commands_help_single(ret,NULL,0, 'a',
			     CATGETS(elm_msg_cat, CommandSet,
				     CommandListInfoArchive,
				     "Request a mailing list archive."));

    add_commands_help_single(ret,NULL,0, 'h',
			     CATGETS(elm_msg_cat, CommandSet,
				     CommandListInfoHelp,
				     "Request a mailing list help."));

    add_commands_help_single(ret,NULL,FLAG_KEY_no_nested, 'i',
			     CATGETS(elm_msg_cat, CommandSet,
				     CommandListInfoIndex,
				     "Quit list info screen and go to the index screen."));


    add_commands_help_single(ret,NULL,0, 'l',
			     CATGETS(elm_msg_cat, CommandSet,
				     CommandListInfoSendList,
				     "Send mail to the mailing list."));


    add_commands_help_single(ret,NULL,FLAG_KEY_no_nested, ctrl('L'),
			     CATGETS(elm_msg_cat, CommandSet,
				     CommandListInfoRedraw,
				     "Redraws list info screen."));

    add_commands_help_single(ret,NULL,0, 'o',
			     CATGETS(elm_msg_cat, CommandSet,
				     CommandListInfoSendOwner,
				     "Send mail to the owner the mailing list."));

    add_commands_help_single(ret,NULL,0, 's',
			     CATGETS(elm_msg_cat, CommandSet,
				     CommandListInfoSubscribe,
				     "Subscribe the mailing list."));

    add_commands_help_single(ret,NULL,0, 'u',
			     CATGETS(elm_msg_cat, CommandSet,
				     CommandListInfoUnsubscribe,
				     "Unsubscribe the mailing list."));

    {
      int cmds[] = { ctrl('J'),ctrl('M'), 'q', 'x', TERMCH_interrupt_char, 0 };

      add_commands_help_many(ret,FLAG_KEY_no_nested, cmds,
			     CATGETS(elm_msg_cat, CommandSet,
				     CommandListInfoQuit,
				     "Quit  list info screen."));
    }
			     

    DPRINT(Debug,30,(&Debug,
		     "give_list_info_commands=%p [pointer %p]\n",
		     ret,&list_info_commands));


    return ret;
}
