static char rcsid[] = "@(#)$Id: pagercmd.c,v 1.9 2014/11/15 11:00:24 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.9 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_command.h"
#include "s_command.h"
#include "patchlevel.h"

DEBUG_VAR(Debug,__FILE__,"command");

/* increment refcount */
struct elm_commands *give_cpager_commands() 
{        

    static struct elm_commands  * cpager_commands = NULL;
    struct elm_commands  * ret = NULL;

    if (cpager_commands) {
	inc_commands_refcount(cpager_commands);
	return cpager_commands;
    }

    ret =  new_commands(format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandPagerKeyTitle,"Pager command")),
			format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandPagerDescTitle,
					      "Elm %s PL%s Action"),
				      VERSION,PATCHLEVEL),
			&cpager_commands);


    {
	int cmds[] = { '\n','\r', 0 };
	
	add_commands_help_many(ret,0, cmds,
			       CATGETS(elm_msg_cat, CommandSet, CommandPagerScrollForward,
				       "Display current message, or (builtin pager only) scroll forward."));
    }

			    
    add_commands_help_single(ret,NULL,0,' ',
			     CATGETS(elm_msg_cat, CommandSet, CommandPagerNextScreen,
				     "Display next screen of current message (or first screen of next)."));

    /* This command is available, if help is shown ... */
    add_commands_help_single(ret,NULL,0,'?',
			     CATGETS(elm_msg_cat, CommandSet, CommandCommonCommandHelp,
				     "Show command help or this screen of information."));

    add_commands_help_single(ret,NULL,0,'n',
			     CATGETS(elm_msg_cat, CommandSet, CommandPagerDisplayNext,
				     "Display the next message."));

    add_commands_help_single(ret,NULL,0,ctrl('N'),
			     CATGETS(elm_msg_cat, CommandSet, CommandPagerDisplayNextU,
				     "Display the next unread message."));


    {
	int cmds[] = { 'q', 'i', 0 };

	add_commands_help_many(ret,0, cmds, 
			       CATGETS(elm_msg_cat, CommandSet, CommandPagerQuitPager,
				       "Quit the pager and return to the index."));
    }

    add_commands_help_single(ret,NULL,0,'x',
			     CATGETS(elm_msg_cat, CommandSet, CommandCommonExitFolder,
				     "Exit leaving the folder untouched, ask permission if changed."));

    DPRINT(Debug,30,(&Debug,
		     "give_cpager_commands=%p [pointer %p]\n",
		     ret,&cpager_commands));


    return ret;
}


/* increment refcount */
struct elm_commands *give_pager_commands() 
{        

    static struct elm_commands  * pager_commands = NULL;
    struct elm_commands  * ret = NULL;

    if (pager_commands) {
	inc_commands_refcount(pager_commands);
	return pager_commands;
    }

    ret =  new_commands(format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandPagerKeyTitle,"Pager command")),
			format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandPagerDescTitle,
					      "Elm %s PL%s Action"),
				      VERSION,PATCHLEVEL),
			&pager_commands);
	    
    {
	struct elm_commands *cpager = give_cpager_commands();
	
	add_commands_help_merge(ret,cpager,0);

	free_commands(&cpager);    /* Just decrements refcount */

    }

    {
	struct elm_commands *common = give_common_commands();
	
	add_commands_help_merge(ret,common,0);

	free_commands(&common);    /* Just decrements refcount */

    }

    DPRINT(Debug,30,(&Debug,
		     "give_pager_commands=%p [pointer %p]\n",
		     ret,&pager_commands));

    return ret;
}


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
