/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.4 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_elm.h"
#include "pager.h"
#include "pg_range_imp.h"

#define BROWSER_EDIT_magic	0xF517

struct browser_edit {
    unsigned short           magic;        /* BROWSER_EDIT_magic */

    int                      gb_flags;
    int                      gb_page;
    int                      gb_line;      

    int                      comment_col;

    folder_dir               dir_p;
    struct AliasView       * aview;

    struct span_helper_data  span_helper;
    struct pager_helper_data pager_helper;

    struct pg_wrap_info    * wrap_info;

    struct browser_help_line {
	struct string         *text;
	struct pager_range    *range;

    } * help_text;
    int                      help_text_count;
    union pager_help_param   self;

    int                      virtual_line_top;
    int                      idx_top;
    int                      buffer_x_top;
    struct pager_lineext   * lineext_top;
};

extern void init_browser_edit P_((struct browser_edit *BE,
				  struct folder_browser *p,
				  struct AliasView    *aview));
extern void clear_browser_edit P_((struct browser_edit *BE));

extern void browser_change_help_page P_((struct enter_info *I));
extern void browser_change_prev_line P_((struct enter_info *I));
extern void browser_change_next_line P_((struct enter_info *I));
extern void browser_change_page_up P_((struct enter_info *I));
extern void browser_change_page_down P_((struct enter_info *I));


extern enum br_help_status {
    br_help_none = 0,
	br_help_redraw = 1
} browser_draw_help P_((struct enter_info *I));
extern void browser_reset_help_page P_((struct enter_info *I));

#define GB_REDRAW                      (1<<0)
#define GB_MENU                        (1<<1)
#define GB_FILL                        (1<<2)
#define GB_HELP                        (1<<3)
#define GB_SAVE_COPY                   (1<<4)
#define GB_EXTENSION                   (1<<6)
#define GB_FILENAME                    (1<<7)
#define GB_SWITCH_FBROWSER             (1<<8)
#define GB_FBROWSER_AVAILABLE          (1<<9)
#define GB_SWITCH_FBROWSER_SELECT      (1<<10)
#define GB_MBOX_CHECK                  (1<<11)
#define GB_SORT_IT                     (1<<12)

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
