static char rcsid[] = "@(#)$Id: delete.c,v 2.6 2018/06/28 07:37:39 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.6 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                       (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *           or  Kari Hurtta <elm@elmme-mailer.org>
 ******************************************************************************
 *  Based on Elm 2.4 src/delete.c. That code was following copyright:
 *
 *  The Elm Mail System 
 *
 * 			Copyright (c) 1988-1992 USENET Community Trust
 * 			Copyright (c) 1986,1987 Dave Taylor
 *
 *****************************************************************************/

/**  Delete or undelete files: just set flag in header record! 
     Also tags specified message(s)...

**/

#include "def_elm.h"
#include "s_elm.h"

DEBUG_VAR(Debug,__FILE__,"menu");

void delete_msg(real_del, menu, LOC)
     int real_del;
     struct menu_common *menu;
     struct screen_parts *LOC;
{
    /** Delete current message.  If real-del is false, then we're
	actually requested to toggle the state of the current
	message... 
    **/
    int current = mcommon_get_current(menu);

    if (mcommon_get_type(menu, current-1) & SYSTEM)
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmNoDelSysAlias,
			  "Can't delete a system alias!"));
    else if (real_del) {
	
	mcommon_setf_status(menu,current-1,status_basic,DELETED);

    } else {

	if (mcommon_ison_status(menu,current-1,status_basic,DELETED))
	    mcommon_clearf_status(menu,current-1,status_basic,DELETED);
	else
	    mcommon_setf_status(menu,current-1,status_basic,DELETED);
		
    }
    
    if (LOC) {
	int vis;

	vis = compute_visible(current, menu);
	menu_header_status_update(LOC->header_page,vis-1);
    }
}

void unread_msg(mailbox, header_area)
     struct MailboxView *mailbox;
     struct menu_context *header_area;
{
    int current = get_current(mailbox);

    /** change the message flag to unread **/
   
    setf_status_message(mailbox,current-1,status_basic,UNREAD);
    
    if (header_area) {
	struct menu_common MENU;
	int vis;

	set_mcommon_from_mbxview(&MENU,mailbox);

	vis = compute_visible(current, &MENU);
	menu_header_status_update(header_area,vis-1);
    }
}

void undelete_msg(menu,header_area)
     struct menu_common *menu;
     struct menu_context *header_area;
{
    int current = mcommon_get_current(menu);

    mcommon_clearf_status(menu,current-1,status_basic,DELETED);

    if (header_area) {
	int vis;

	vis = compute_visible(current, menu);
	menu_header_status_update(header_area,vis-1);
    }
}


int tag_message(menu, header_area)
     struct menu_common *menu;
     struct menu_context *header_area;
{
    /** Tag current message and return TRUE.
	If already tagged, untag it and return FALSE. **/
    
    int istagged;
    int current = mcommon_get_current(menu);
    
    if (mcommon_ison_status(menu,current-1,status_basic,TAGGED)) {
	
	mcommon_clearf_status(menu,current-1,status_basic,TAGGED);
	istagged = FALSE;
	
    } else {
	
	mcommon_setf_status(menu,current-1,status_basic,TAGGED);
	istagged = TRUE;
	
    }
    
    if (header_area) {
	int vis;

	vis = compute_visible(current, menu);

	menu_header_status_update(header_area,vis-1);    
    }

    return(istagged);
}

int flag_message(menu, header_area)
     struct menu_common *menu;
     struct menu_context *header_area;
{
    /** flag current message and return TRUE.
	If already flagged, untag it and return FALSE. **/
    
    int isflagged;
    int current = mcommon_get_current(menu);
    
    if (mcommon_ison_status(menu,current-1,status_1,S1_FLAGGED)) {
	
	mcommon_clearf_status(menu,current-1,status_1,S1_FLAGGED);
	isflagged = FALSE;
	
    } else {
	
	mcommon_setf_status(menu,current-1,status_1,S1_FLAGGED);
	isflagged = TRUE;
	
    }
    
    if (header_area) {
	int vis;

	vis = compute_visible(current, menu);

	menu_header_status_update(header_area,vis-1);    
    }

    return(isflagged);
}

int DeleteTagged(menu, page, header_area)
     struct menu_common *menu;
     struct menu_context  *page;
     struct menu_context *header_area;
{

    /** delete all tagged messages.  return TRUE if the current message was
	deleted. 
    **/

    int iindex, count = 0;  
    int mc      = mcommon_get_count(menu);
    int current = mcommon_get_current(menu);
    int selected = mcommon_get_selected(menu);
    int LINES, COLUMNS;

    menu_get_sizes(page, &LINES, &COLUMNS);

    for (iindex=0; iindex < mc; iindex++) {

	if (!selected ||
	    (selected && mcommon_ison_status(menu,iindex,
					     status_basic,VISIBLE))) {
	    
	    if (mcommon_ison_status(menu,iindex,status_basic,TAGGED)) {
		
		mcommon_setf_status(menu,iindex,status_basic,DELETED);
		count++;
		
		if (header_area)
		    menu_header_status_update(header_area,iindex);

	    }
	}
    }
    
    if (count == 1)
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmItemDeleted,
			  "%S deleted."),
		  mcommon_give_item(menu,m_Item));
    else
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmItemsDeleted,
			  "%d %S deleted."), 
		  count,
		  mcommon_give_item(menu,m_items));
    
    return( mcommon_ison_status(menu,current-1, status_basic,
				DELETED) ? 1 : 0);        
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
