static char rcsid[] = "@(#)$Id: digest.c,v 2.24 2021/01/10 15:47:32 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.24 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                  (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 ******************************************************************************
 * This routine mimics some routines from Elm 2.4 src/file.c and src/elm.c.
 * That code was following copyright:
 *
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

#include "def_elm.h"
#include "s_elm.h"

DEBUG_VAR(Debug,__FILE__,"ELM");

#if ANSI_C
static subpage_simple_redraw sb_digest_menu;
#endif
static int sb_digest_menu P_((struct menu_context  *ptr,
			      struct menu_param *list));
static int sb_digest_menu(ptr,list)
     struct menu_context  *ptr;
     struct menu_param *list;
{
    enum user_level_v ul = 
	give_dt_enumerate_as_int(&user_level);

    menu_ClearScreen(ptr);

    if (ul == user_level_beginner) {	/* a rank beginner.  Give less options  */
	menu_print_format_center(ptr,0, 
				 CATGETS(elm_msg_cat, ElmSet, 
					 ElmLevel0MenuLine1,
					 "You can use any of the following commands by pressing the first character;"));
	menu_print_format_center(ptr,1, 
				 CATGETS(elm_msg_cat, ElmSet, 
					 ElmLevel0DgtLine2,
					 "m)ail a message,  r)eply or f)orward mail,  return to i)ndex"));
	menu_print_format_center(ptr,2, 
				 CATGETS(elm_msg_cat, ElmSet, 
					 ElmLevel0DgtLine3,
					 "To read a message, press <return>.  j = move down, k = move up"));
    } else {
	menu_print_format_center(ptr,0,
				 CATGETS(elm_msg_cat, ElmSet, 
					 ElmLevel1MenuLine1,
					 "|=pipe, !=shell, ?=help, <n>=set current to n, /=search pattern"));
        menu_print_format_center(ptr,1, 
				 CATGETS(elm_msg_cat, ElmSet, 
					 ElmLevel1DgtLine2,
					 "a)lias, C)opy, f)orward, g)roup reply, m)ail,"));
	menu_print_format_center(ptr,2, 
				 CATGETS(elm_msg_cat, ElmSet, 
					 ElmLevel1DgtLine3,
					 "n)ext, o)ptions, P)rint text, r)eply, s)ave, t)ag, or i)ndex"));
    }
    
    return 1;
}

static int showmsg_digest_cmd P_((     struct MailboxView *mailbox,
				       int cmd, 
				       struct pager_page *pager_page));
static int showmsg_digest_cmd(mailbox,cmd,pager_page)
     struct MailboxView *mailbox;
     int cmd; 
     struct pager_page *pager_page;
{

    return cmd;
}



static void set_mailbox_screen P_((struct menu_context  *page, 
				   struct screen_parts *LOC,
				   struct menu_param   *LIST));
static void set_mailbox_screen(page,LOC, LIST)
     struct menu_context  *page;
     struct screen_parts  *LOC;
     struct menu_param    *LIST;
{    
    int   LINES, COLUMNS;	

    menu_get_sizes(page,&LINES, &COLUMNS);
    
    /* 1)  Title part of screen */

    if (! LOC->title_page)
	LOC->title_page = new_menu_subpage(page,0,4,sb_update_title,LIST);
    else
	menu_subpage_relocate(LOC->title_page,page,0,4);

    /* 2) menu part */

     if (LOC->menu_page && LINES < 14)
	erase_menu_context (&(LOC->menu_page));
    else if (LOC->menu_page)
	menu_subpage_relocate(LOC->menu_page,page,LINES-8,4);
    else if (mini_menu && LINES > 14)
	LOC->menu_page = new_menu_subpage(page,LINES-8,4,
					  sb_digest_menu,LIST);
   
    mailbox_screen_common(page,LOC, LIST);	
}


static void check_mailbox_screen P_((struct screen_parts *LOC,
    				     struct menu_param *list));
static void check_mailbox_screen(LOC,list)
     struct screen_parts *LOC;
     struct menu_param *list;
{
    if (menu_resized(LOC->title_page)) {
	DPRINT(Debug,1, (&Debug, "title page resized\n"));

    }
    if (menu_need_redraw(LOC->title_page)) {
	DPRINT(Debug,1, (&Debug, "title page redraw???\n"));
	sb_update_title(LOC->title_page,list);
    }

    if (LOC->menu_page) {
	/* 2) menu page */
	if (menu_resized(LOC->menu_page)) {
	    DPRINT(Debug,1, (&Debug, "menu page resized\n"));
	    
	}
	if (menu_need_redraw(LOC->menu_page)) {
	    DPRINT(Debug,1, (&Debug, "menu page redraw???\n"));
	    sb_digest_menu(LOC->menu_page,list);
	}
    }

    /* 3) prompt part */
    if (menu_resized(LOC->prompt_page)) {
	DPRINT(Debug,1, (&Debug, "prompt page resized\n"));
    }
    if (menu_need_redraw(LOC->prompt_page)) {
	menu_ClearScreen(LOC->prompt_page);

	show_last_error();	/* for those operations that have to
				 * clear the footer except for a message.
				 */
    }    

    /* 4) headers part */
    if (menu_resized(LOC->header_page)) {
	DPRINT(Debug,1, (&Debug, "header page resized\n"));
    }
    if (menu_need_redraw(LOC->header_page)) {
	DPRINT(Debug,1, (&Debug, "header page redraw\n"));
	menu_ClearScreen(LOC->header_page);
    }
}

/* Return 'i' if to should return to i)ndex */
static int digest_loop P_((struct MailboxView *mailbox,
			   struct AliasView *aview,
			   int *needresort));
static int digest_loop(mailbox, aview, needresort)
     struct MailboxView *mailbox;
     struct AliasView *aview;
     int *needresort;
{
    int retch = '\0';
    int leave = 0;
    int auto_assemble = 1;

    struct menu_context  *page = new_menu_context();
    struct screen_parts LOC = { NULL };
    struct menu_common MENU;
    struct menu_param  PARAM[elm_mp_COUNT+1] = { 
	{ mp_menu_common, { 0 } },
	{ mp_integer,     { 0 } },
	{ mp_integer,     { 0 } },
	{ mp_integer,     { 0 } },
	{ mp_integer,     { 0 } },
	{ mp_END,         { 0 } }
    };

    struct elm_commands *pager_cmds = give_digestpager_commands();
    struct elm_commands *menu_cmds  = give_digestmbx_commands();

    mp_list_set_mcommon(PARAM,elm_mp_menu,&MENU);

    set_mcommon_from_mbxview(&MENU,mailbox);
    set_mailbox_screen(page,&LOC,PARAM);

    resort_mailbox(mailbox,1);
    get_page(&MENU, LOC.header_page);  /* resort_mailbox no longer call get_page() */
    copy_current(&MENU,LOC.header_page);
    
    showscreen(page);

    while (!leave) {
	int ch;
	int   LINES, COLUMNS;	

	menu_set_default(page);

	menu_get_sizes(page,&LINES, &COLUMNS);

	set_mcommon_from_mbxview(&MENU,mailbox);

	if (menu_resized(page)) {
	    
	    set_mailbox_screen(page,&LOC,PARAM);

	    menu_get_sizes(page,&LINES, &COLUMNS);

	    menu_trigger_redraw(page);
	} 

	if (update_view(mailbox)) {
	    resort_mailbox(mailbox,1);
	    get_page(&MENU, LOC.header_page);  /* resort_mailbox no longer call get_page() */
	    menu_trigger_redraw(LOC.header_page);
	    menu_trigger_redraw(LOC.title_page);	
	}

	if (menu_need_redraw(page)) 
	    showscreen(page);
	check_mailbox_screen(&LOC, PARAM);
	
	{   
	    int lin,col;
	    enum fragment_handling_v fh = 
		give_dt_enumerate_as_int(&fragment_handling);

	    menu_PutLineX(LOC.prompt_page,0,0,
			  FRM("%S"),mcommon_give_item(&MENU, m_Prompt));
	    menu_GetXYLocation(LOC.prompt_page,&lin,&col);

	    menu_CleartoEOLN(LOC.prompt_page);

	    if (auto_assemble && fragment_handling_auto == fh &&
		have_partial(mailbox)) {
		ch = 'A';
		auto_assemble = 0;
		
		DPRINT(Debug,4,(&Debug,"Automatic assemble ... \n"));
	    } else
		ch = GetPrompt(LOC.prompt_page,elm_timeout);
	
	    menu_CleartoEOS(LOC.prompt_page);

	    if (isascii(ch) && isprint(ch)) {
		DPRINT(Debug,4,(&Debug, 
				"\nCommand: %c [%d]\n\n", ch, ch));
	    } else {
		DPRINT(Debug,4,(&Debug, 
				"\nCommand: %d\n\n", ch));
	    }
	    
	    set_error("");	/* clear error buffer */
	
	    menu_MoveCursor(LOC.prompt_page,lin,col);
	}	

	ch = mailbox_command(mailbox,ch, &LOC,
			     showmsg_digest_cmd, aview,
			     page,pager_cmds,0,menu_cmds);


	switch (ch) {
	case 0:  /* OK */
	    break;

	case F3_KEY_MARK:
	    mini_menu = ! mini_menu;

	    if (LOC.menu_page && !mini_menu)
		erase_menu_context (&(LOC.menu_page));

	    DPRINT(Debug,10,(&Debug,"mini_menu = %d \n",mini_menu));

	    set_mailbox_screen(page,&LOC,PARAM);
		
	    menu_trigger_redraw(page);   /* ? Is needed? */
	    
	    break;

	case 'A': {
	    int r;

	    menu_Write_to_screen(LOC.prompt_page,
				 CATGETS(elm_msg_cat, 
					     ElmSet, ElmAssemble,
					     "Assemble message fragments"));
	    FlushBuffer();
	    sleep_message();

	    r = ViewPartial(mailbox,aview,page,0);
	    
	    get_page(&MENU, LOC.header_page);

	    switch(r) {
		/* These should not be used ... */
	    case 'i':
		goto index_label;

	    case ctrl('Q') :
	    case 'q':
	    case 'Q':
	    case 'x':
	    case 'X':
		
		leave = 1;
		
		break;
	    case EOF:
		retch = EOF;
		goto OUT;
	    }
	}
	    break;

 	case 'o'    :  {
#if UNUSED
 	    int current = get_current(mailbox);
#endif
 	    int i;
	    int setscreen = 0;
	    
	    *needresort = 1;

 	    menu_Write_to_screen(LOC.prompt_page,
 				 CATGETS(elm_msg_cat, ElmSet,
					 ElmOptions,
 					 "Options"));

	    i=options(mailbox, aview, page,&setscreen);

	    if (setscreen) {
		if (LOC.menu_page && !mini_menu)
		    erase_menu_context (&(LOC.menu_page));
		
		DPRINT(Debug,10,(&Debug,"mini_menu = %d \n",mini_menu));
		
		set_mailbox_screen(page,&LOC,PARAM);
		menu_trigger_redraw(page);
	    }

 	    if (i > 0) {
#if UNUSED
 		current = get_current(mailbox);
#endif
 		get_page(&MENU, LOC.header_page);
 	    } else if(i < 0)
 		goto OUT;
 	    
 	}
	    break;
 
	index_label:
	case 'i':
	    retch = 'i';
	    menu_Write_to_screen(LOC.prompt_page,
				 CATGETS(elm_msg_cat, ElmSet,
					 ElmReturnIndex,
					 "Return to index"));  
	    FlushBuffer();
	    /* FALLTHRU */
	case ctrl('Q') :
	case 'q':
	case 'Q':
	case 'x':
	case 'X':

	    leave = 1;

	    break;
	case EOF:
	    retch = EOF;
	    goto OUT;

	default:
	    lib_error(CATGETS(elm_msg_cat, ElmSet,
			      ElmUnknownCommand2,			
			      "Unknown command."));

	}
	
	if (menu_need_redraw(page))
	    showscreen(page);
	
	check_range(&MENU,&LOC);
	check_mailbox_screen(&LOC,PARAM);
	
    } /* the BIG while loop! */

 OUT:

    free_commands(&pager_cmds);   /* Decrement refcount */
    free_commands(&menu_cmds);   /* Decrement refcount */

    free_mailbox_screen(&LOC);
    erase_menu_context(&page);

    return retch;
}

int ViewDigest(parent_mailbox, aview, parent_page)
     struct MailboxView *parent_mailbox;
     struct AliasView *aview;
     struct menu_context  *parent_page;
{
    int retch = '0';
    int tagged = 0;
    int mc,i;
    struct MailboxView *new_mailbox = NULL;
    int current = get_current(parent_mailbox);

    mc = get_message_count(parent_mailbox);
    for (i=0; i < mc; i++) {
	if (ison_status_message(parent_mailbox,i,status_basic,TAGGED)) {
	    tagged++;
	}
    }

    if (tagged == 0) {
	tagged = 1;
	setf_status_message(parent_mailbox,current-1,status_basic,TAGGED);
    }

    mc = get_message_count(parent_mailbox);
    for (i=0; i < mc; i++) {	/* get each tagged msg */
	if (ison_status_message(parent_mailbox,i,status_basic,TAGGED)) {
	    struct header_rec * hdr;
	    FILE *F;

	    clearf_status_message(parent_mailbox,i,status_basic,
				  TAGGED);

	    if (give_message_data(parent_mailbox,i,
				  &hdr,&F,NULL,
				  mime_parse_routine)) {
		if (new_mailbox)
		    add_digest(new_mailbox,
			       & hdr->mime_rec,
			       hdr->received_time,
			       hdr->env_from,
			       F,
			       hdr->header_charset);
		else
		    new_mailbox = 
			digest_to_mailbox_view(& hdr->mime_rec,
					       hdr->received_time,
					       hdr->env_from,
					       F,
					       hdr->header_charset);
	    }

	}
    }

    if (new_mailbox) {
	int need_resort = 0;
	
	if (get_message_count(new_mailbox) > 0) {
	    set_current(new_mailbox,1);   /* Set current to first message */

	    update_view(new_mailbox);
	}

	retch = digest_loop(new_mailbox, aview, &need_resort);

	{
	    int r;
	    
	    struct cancel_data *cd = NULL;

	    setup_mbx_cancel_message(&cd,mbx_leaving_mailbox);

	    DPRINT(Debug,9, (&Debug, "ViewDigest:  freeing new_mailbox\n"));
	    
	    r = free_mailbox(& new_mailbox,cd);
	    if (!r) {
		DPRINT(Debug,9, (&Debug, 
				 "ViewDigest: free_mailbox failed\n"));
	    }
	    if (is_canceled(cd)) {
		DPRINT(Debug,9, (&Debug, 
				 "ViewDigest: Cancel on free_mailbox\n"));
	    }
	    free_cancel(&cd);
	}
	
	/* This is needed if sort order is changed on o)ptions menu */
	if (need_resort)
	    resort_mailbox(parent_mailbox,1);

	menu_trigger_redraw(parent_page);
	
	/* Force default return to parent page ... */
	menu_set_default(parent_page); 
    }

    return retch;
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */

