static char rcsid[] = "@(#)$Id: duplicate_removal.c,v 2.24 2021/01/10 15:47:32 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.24 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 ******************************************************************************
 * This routine mimics some routines from src/file.c and src/elm.c.
 * That code was following copyright:
 *
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

#include "def_elm.h"
#include "s_elm.h"

DEBUG_VAR(Debug,__FILE__,"ELM");



#if ANSI_C
static subpage_simple_redraw sb_duplicate_menu;
#endif
static int sb_duplicate_menu P_((struct menu_context  *ptr,
			       struct menu_param *list));
static int sb_duplicate_menu(ptr,list)
     struct menu_context  *ptr;
     struct menu_param *list;
{
    enum user_level_v ul = 
	give_dt_enumerate_as_int(&user_level);

    menu_ClearScreen(ptr);
    
    if (ul == user_level_beginner) {	/* a rank beginner.  Give less options  */
	menu_print_format_center(ptr,0,
				 CATGETS(elm_msg_cat, ElmSet, 
					 ElmLevel0MenuLine1,
					 "You can use any of the following commands by pressing the first character;"));
	menu_print_format_center(ptr,1,
				 CATGETS(elm_msg_cat, ElmSet, 
					 ElmLevel0DuplLine2,
					 "d)elete or u)ndelete mail,  m)ail a message,  r)eply mail,  return to i)ndex"));
	menu_print_format_center(ptr,2,
				 CATGETS(elm_msg_cat, ElmSet, 
					 ElmLevel0DuplLine3,
					 "To read a message, press <return>.  j = move down, k = move up"));
    } else {
	menu_print_format_center(ptr,0,
				 CATGETS(elm_msg_cat, ElmSet, 
					 ElmLevel1DuplLine1,
					 "!=shell, ?=help, <n>=set current to n, /=search pattern"));
        menu_print_format_center(ptr,1,
				 CATGETS(elm_msg_cat, ElmSet, 
					 ElmLevel1DuplLine2,
					 "a)lias, C)opy, d)elete, f)orward, g)roup reply, m)ail,"));
	menu_print_format_center(ptr,2, 
				 CATGETS(elm_msg_cat, ElmSet, 
					 ElmLevel1DuplLine3,
					 "n)ext, o)ptions, P)rint text, r)eply, s)ave, t)ag, or i)ndex"));
    }

    return 1;
}

static int showmsg_duplicate_cmd P_((     struct MailboxView *mailbox,
					int cmd, 
					struct pager_page *pager_page));
static int showmsg_duplicate_cmd(mailbox,cmd,pager_page)
     struct MailboxView *mailbox;
     int cmd; 
     struct pager_page *pager_page;
{
    struct menu_common MENU;
    
    set_mcommon_from_mbxview(&MENU,mailbox);
			     
#if 0
    /* Folder state is not supported on duplicate mode
       -- therefore readmsg do not work
       -- and then also pipe not work
    */
    switch (cmd) {
    case '|' : {
	int current = get_current(mailbox);
	
	put_cmd_name(pager_page, TRUE,
		     CATGETS(elm_msg_cat, ElmSet, ElmPipe, "Pipe"));
	
	if (give_message_data(mailbox,current-1,
			      NULL,NULL,NULL,
			      NO_mime_parse))
	    do_pipe(mailbox, 
		    pager_page->root,
		    pager_page->prompt_area);     
	    
	else {
	    DPRINT(Debug,3,(&Debug, 
			    "give_message_data [%d] fails",current-1));
	}
    }
	break;
    }
#endif

    return cmd;
}


static void set_duplicate_mode_screen P_((struct menu_context  *page, 
				   struct screen_parts *LOC,
				   struct menu_param   *LIST));
static void set_duplicate_mode_screen(page,LOC, LIST)
     struct menu_context  *page;
     struct screen_parts *LOC;
     struct menu_param   *LIST;
{    
    int   LINES, COLUMNS;	

    menu_get_sizes(page,&LINES, &COLUMNS);

    /* 1)  Title part of screen */

    if (! LOC->title_page)
	LOC->title_page = new_menu_subpage(page,0,4,sb_update_title,LIST);
    else
	menu_subpage_relocate(LOC->title_page,page,0,4);

    /* 2) menu part */

    if (LOC->menu_page && LINES < 14)
	erase_menu_context (&(LOC->menu_page));
    else if (LOC->menu_page)
	menu_subpage_relocate(LOC->menu_page,page,LINES-8,4);
    else if (mini_menu && LINES > 14)
	LOC->menu_page = new_menu_subpage(page,LINES-8,4,
					  sb_duplicate_menu,LIST);
   

    mailbox_screen_common(page,LOC, LIST);	
}


static void check_duplicate_mode_screen P_((struct screen_parts *LOC,
					    struct menu_param *list));
static void check_duplicate_mode_screen(LOC,list)
     struct screen_parts *LOC;
     struct menu_param *list;
{
    if (menu_resized(LOC->title_page)) {
	DPRINT(Debug,1, (&Debug, "title page resized\n"));

    }
    if (menu_need_redraw(LOC->title_page)) {
	DPRINT(Debug,1, (&Debug, "title page redraw???\n"));
	sb_update_title(LOC->title_page,list);	
    }
    if (LOC->menu_page) {
	/* 2) menu page */
	if (menu_resized(LOC->menu_page)) {
	    DPRINT(Debug,1, (&Debug, "menu page resized\n"));
	    
	}
	if (menu_need_redraw(LOC->menu_page)) {
	    DPRINT(Debug,1, (&Debug, "menu page redraw???\n"));
	    sb_duplicate_menu(LOC->menu_page,list);
	}
    }

    /* 3) prompt part */
    if (menu_resized(LOC->prompt_page)) {
	DPRINT(Debug,1, (&Debug, "prompt page resized\n"));
    }
    if (menu_need_redraw(LOC->prompt_page)) {
	menu_ClearScreen(LOC->prompt_page);

	show_last_error();	/* for those operations that have to
				 * clear the footer except for a message.
				 */
    }    

    /* 4) headers part */
    if (menu_resized(LOC->header_page)) {
	DPRINT(Debug,1, (&Debug, "header page resized\n"));
    }
    if (menu_need_redraw(LOC->header_page)) {
	DPRINT(Debug,1, (&Debug, "header page redraw\n"));
	menu_ClearScreen(LOC->header_page);
    }
}

static int duplicate_loop P_((struct MailboxView *mailbox,
			       struct AliasView *aview,
			       int is_main_message_loop));
static int duplicate_loop(mailbox, aview, is_main_message_loop)
     struct MailboxView *mailbox;
     struct AliasView *aview;     
     int is_main_message_loop;
{
    int leave = 0;
    int ret = '\0';
    const char * exit_hint_folder = NULL;  /* If not "", gives failed folder type */
    
    struct menu_context  *page = new_menu_context();
    struct screen_parts LOC = { NULL };
    struct menu_common MENU;
    struct menu_param  PARAM[elm_mp_COUNT+1] = { 
	{ mp_menu_common, { 0 } },
	{ mp_integer,     { 0 } },
	{ mp_integer,     { 0 } },
	{ mp_integer,     { 0 } },
	{ mp_integer,     { 0 } },
	{ mp_END,         { 0 } }
    };

    struct elm_commands *pager_cmds = give_duprempager_commands();
    struct elm_commands *menu_cmds = is_main_message_loop ? 
	give_dupremmain_commands () : 
	give_dupremmbx_commands();
    int   LINES, COLUMNS;	

    mp_list_set_mcommon(PARAM,elm_mp_menu,&MENU);


    menu_get_sizes(page,&LINES, &COLUMNS);

    set_mcommon_from_mbxview(&MENU,mailbox);
    set_duplicate_mode_screen(page,&LOC,PARAM);

    resort_mailbox(mailbox,1);

    get_page(&MENU, LOC.header_page);  /* resort_mailbox no longer call get_page() */
    copy_current(&MENU,LOC.header_page);

    showscreen(page);

    while (!leave) {
	int ch;

	menu_set_default(page);

	if (menu_resized(page)) {
	
	    set_duplicate_mode_screen(page,&LOC,PARAM);
		    
	    menu_get_sizes(page,&LINES, &COLUMNS);

	    menu_trigger_redraw(page);

	} 

	new_mail_check(mailbox, page, &LOC,
		       is_main_message_loop ? &exit_hint_folder : NULL);
	
	if (update_view(mailbox)) {
	    resort_mailbox(mailbox,1);

	    get_page(&MENU, LOC.header_page);  /* resort_mailbox no longer call get_page() */
	    menu_trigger_redraw(LOC.header_page);
	    menu_trigger_redraw(LOC.title_page);	 
	}

	if (menu_need_redraw(page)) 
	    showscreen(page);
	check_duplicate_mode_screen(&LOC, PARAM);

	{   
	    int lin,col;
	    
	    menu_PutLineX(LOC.prompt_page,0,0,
			    FRM("%S"),mcommon_give_item(&MENU, m_Prompt));
	    menu_GetXYLocation(LOC.prompt_page,&lin,&col);
	    
	    menu_CleartoEOS(LOC.prompt_page);   
	    
	    if (!show_last_error() &&
		exit_hint_folder) {
		if (exit_hint_folder[0])
		    lib_transient(CATGETS(elm_msg_cat, ElmSet, 
					  ElmSFailedUseXforQuickExit,
					  "%s failed. Use 'X' for Quick Exit"),
				  exit_hint_folder);
		else
		    lib_transient(CATGETS(elm_msg_cat, ElmSet, 
					  ElmUseXforQuickExit,
					  "Use 'X' for Quick Exit"));
		exit_hint_folder = NULL;
	    }
	    
	    ch = GetPrompt(LOC.prompt_page,elm_timeout);
	    
	    menu_CleartoEOS(LOC.prompt_page);
	    
	    if (isascii(ch) && isprint(ch)) {
		  DPRINT(Debug,4,(&Debug, 
				  "\nCommand: %c [%d]\n\n", ch, ch));
	    } else {
		DPRINT(Debug,4,(&Debug, 
				"\nCommand: %d\n\n", ch));
	    }
	    
	    set_error("");	/* clear error buffer */
	    
	    menu_MoveCursor(LOC.prompt_page,lin,col);
	}
	
	ch = mailbox_command(mailbox,ch, &LOC,
			     showmsg_duplicate_cmd, aview, 
			     page,pager_cmds,0, menu_cmds);
	
	switch (ch) {
	case 0:  /* OK */
	    break;
	    
	case F3_KEY_MARK:
	    mini_menu = ! mini_menu;
	    
	    if (LOC.menu_page && !mini_menu)
		erase_menu_context (&(LOC.menu_page));

	    DPRINT(Debug,10,(&Debug,"mini_menu = %d \n",mini_menu));
	    
	    set_duplicate_mode_screen(page,&LOC,PARAM);
	    	    
	    menu_trigger_redraw(page);
	    
	    break;
	    
	case F5_KEY_MARK:
	case '$'    :  /* Resynchronize folder */
	    if (is_main_message_loop) {
		ret = ch;
		goto OUT;
	    }
	    goto bad_command_label;
	       
#if 0
	    /* Folder state is not supported on duplicate mode
	       -- therefore readmsg do not work
	       -- and then also pipe not work
	    */
	case '|'    :   {
	    int current = get_current(mailbox);
	    
	    menu_Writechar(LOC.prompt_page,
			   '|');
	    
	    if (current < 1) {
		lib_error(CATGETS(elm_msg_cat, ElmSet, 
				  ElmNoMailToPipe,
				  "No mail to pipe!"));
		
	    } else if (give_message_data(mailbox,current-1,
					 NULL,NULL,NULL,NO_mime_parse)) {
		
		/* softkeys_off(); */
		
		do_pipe(mailbox, page,LOC.prompt_page);			       

		/* softkeys_on(); */
	    } else {
		DPRINT(Debug,3,(&Debug, 
				"give_message_data [%d] fails",current-1));
	    }
	}
	    break;
#endif
	    
 	case 'o'    :  {
#if UNUSED
 	    int current = get_current(mailbox);
#endif
 	    int i;
	    int setscreen = 0;
	    
 	    menu_Write_to_screen(LOC.prompt_page,
 				 CATGETS(elm_msg_cat, ElmSet,
					 ElmOptions,
 					 "Options"));

	    i=options(mailbox, aview, page, &setscreen);

	    if (setscreen) {
		if (LOC.menu_page && !mini_menu)
		    erase_menu_context (&(LOC.menu_page));
		
		
		DPRINT(Debug,10,(&Debug,"mini_menu = %d \n",mini_menu));

		set_duplicate_mode_screen(page,&LOC,PARAM);

		menu_trigger_redraw(page);
	    }

 	    if (i > 0) {
#if UNUSED
 		current = get_current(mailbox);
#endif
 		get_page(&MENU, LOC.header_page);
 	    } else if (i < 0)
 		goto OUT;
 	    
 	}
	    break;

	case 'c':    /* Change folder */
	    if (is_main_message_loop) {
		ret = ch;
		goto OUT;
	    }
	    goto bad_command_label;

	case ctrl('Q') :
	case 'Q':
	case 'x':
	case 'X':
	    if (is_main_message_loop) {
		ret = ch;
		goto OUT;
	    }
	    /* FALLTHROUGH */
	    
	case 'q':
	case 'i':

	    menu_Write_to_screen(LOC.prompt_page,
				 CATGETS(elm_msg_cat, ElmSet,
					 ElmReturnIndex,
					 "Return to index"));  
	    FlushBuffer();

	    leave = 1;

	    break;
	case EOF:
	    ret = EOF;

	    goto OUT;

	bad_command_label:
	default:
	    lib_error(CATGETS(elm_msg_cat, ElmSet,
			      ElmUnknownCommand2,			
			      "Unknown command."));

	}

	
	if (menu_need_redraw(page))
	    showscreen(page);
	
	check_range(&MENU, &LOC);
	check_duplicate_mode_screen(&LOC, PARAM);

    } /* the BIG while loop! */

 OUT:

    free_commands(&pager_cmds);   /* Decrement refcount */
    free_commands(&menu_cmds);   /* Decrement refcount */

    free_mailbox_screen(&LOC);	
    erase_menu_context(&page);

    DPRINT(Debug,3,(&Debug, 
		    "duplicate_loop() exits with %d\n",ret));

    return ret;

}

int ViewRemoveDuplicate(parent_mailbox, aview, parent_page,
			 is_main_message_loop)
     struct MailboxView *parent_mailbox;
     struct AliasView *aview;     
     struct menu_context  *parent_page;
     int is_main_message_loop;
{
    int ret = '\0';

    struct MailboxView *new_mailbox = NULL;

    new_mailbox = duplicate_to_mailbox_view(parent_mailbox);

    if (new_mailbox) {
	if (get_message_count(new_mailbox) > 0) {
	    set_current(new_mailbox,1);   /* Set current to first message */

	    update_view(new_mailbox);
	}

	ret = duplicate_loop(new_mailbox, aview, is_main_message_loop);

	{
	    int r;
	    
	    struct cancel_data *cd = NULL;

	    setup_mbx_cancel_message(&cd,mbx_leaving_mailbox);
	    
	    DPRINT(Debug,9, (&Debug, "ViewRemoveDuplicate:  freeing new_mailbox\n"));

	    r = free_mailbox(& new_mailbox,cd);
	    if (!r) {
		DPRINT(Debug,9, (&Debug, 
				 "ViewRemoveDuplicate: free_mailbox failed\n"));
	    }
	    if (is_canceled(cd)) {
		DPRINT(Debug,9, (&Debug, 
				 "ViewRemoveDuplicate: Cancel on free_mailbox\n"));
	    }
	    free_cancel(&cd);
	}

	menu_trigger_redraw(parent_page);
    
	/* Force default return to parent page ... */
	menu_set_default(parent_page); 

	/* If there is new messages arrived when running on duplicate_loop()
	   parent mailbox is not sorted
	   
	   However, because duplicate removal mode uses original mailbox,
	   update_view() status of parent mailbox is reset, so we need
	   do resorting on here....
	*/
	resort_mailbox(parent_mailbox,1);
    }

    return ret;
}



/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
