case $CONFIG in
'')
    if test ! -f config.sh; then
	ln ../config.sh . || \
	ln ../../config.sh . || \
	ln ../../../config.sh . || \
	ln ../../../../config.sh . || \
	(echo "Can't find config.sh."; exit 1)
    fi
    . ./config.sh
    ;;
esac

case "$subdir" in
'')
    case "$0" in
    */*) cd `expr X$0 : 'X\(.*\)/'` ;;
    esac	    

    vpathdef="#VPATH		= "
    XXsrc="."
    XXsrcroot="../.."
    ;;
*)
    vpathdef="VPATH		=	$source_dir/$subdir"
    XXsrc="$source_dir/$subdir"
    XXsrcroot="$source_dir"
    ;;
esac

echo "Extracting src/list/Makefile (with variable substitutions)"
cat >Makefile <<!GROK!THIS!
#!$make
#
# $Id: Makefile.SH,v 2.8 2018/08/01 09:36:26 hurtta Exp $
#
#  Makefile for the ELM (ME+) mail program.
#
# Variables
#	Variables established by Configure
AR		=	$ar
CC		=	$cc
CCFLAGS		=	$ccflags $picflag $xencf
CHMOD		=	$chmod
CP		=	$cp
OPTIMIZE	=	$optimize
RANLIB		=	$ranlib
RM		= 	$rm -f
TOUCH		=	$touch
TAGS		=	ctags
$vpathdef
SRC		=	$XXsrc
SRCROOT		=	$XXsrcroot
!GROK!THIS!

cat >>Makefile <<'!NO!SUBS!'
#	Other general variables
CFLAGS		=	-I$(IHDR) -I$(INCLDIR) $(CCFLAGS) $(OPTIMIZE) $(DEBUG) 
INCLDIR		=	$(SRCROOT)/hdrs
IHDR		=	../../hdrs
SHELL		=	/bin/sh

OBJ		=	list.o reply.o select.o info.o visit_mailbox.o

all:			Makefile liblist.a

install_s:		Makefile liblist.a

uninstall_s:		

clean:
	$(RM) $(OBJ) liblist.a


Makefile: Makefile.SH ../../config.sh
	@echo "You must run 'sh Configure -S' or 'sh Configure'"
	exit 1

liblist.a:		$(OBJ)
			$(AR) r $@ $?
			$(RANLIB) $@

#	Dependencies of header files upon other header files they include
.PRECIOUS:		$(IHDR)/elm_defs.h $(IHDR)/defs_major.h def_list.h \
 $(IHDR)/me.h $(IHDR)/misclib.h

$(IHDR)/elm_defs.h:	$(IHDR)/defs_major.h $(INCLDIR)/elm_nl_types.h \
 $(INCLDIR)/elmlib.h 
			-$(CHMOD) -f u+w $@
			$(TOUCH) $@

def_list.h:		$(IHDR)/elm_defs.h $(IHDR)/me.h \
 $(INCLDIR)/mboxlib.h  $(INCLDIR)/elm_globals.h
			cmp $(SRC)/$@ $@ 2>/dev/null || $(CP) $(SRC)/$@ $@
			$(CHMOD) u+w $@
			$(TOUCH) $@

$(IHDR)/misclib.h: $(INCLDIR)/mlist_common.h
			-$(CHMOD) -f u+w $@
			$(TOUCH) $@

$(IHDR)/me.h:	$(INCLDIR)/melib.h $(IHDR)/misclib.h $(INCLDIR)/addrlib.h \
  $(INCLDIR)/mime.h
			-$(CHMOD) -f u+w $@
			$(TOUCH) $@


#	Dependencies of C object files

list.o:		     def_list.h $(INCLDIR)/s_me.h
reply.o:	     def_list.h $(INCLDIR)/s_me.h $(INCLDIR)/mailerlib.h \
  $(INCLDIR)/schedule_time.h
select.o:	     def_list.h $(INCLDIR)/s_me.h
info.o:	     def_list.h $(INCLDIR)/s_me.h $(INCLDIR)/mailerlib.h \
  $(INCLDIR)/schedule_time.h
visit_mailbox.o:	def_list.h $(INCLDIR)/s_elm.h
!NO!SUBS!

