/* $Id: def_list.h,v 2.9 2020/01/18 20:07:41 hurtta Exp $ */

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.9 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "elm_defs.h"
#include "mboxlib.h"
#include "me.h"
#include "elm_globals.h"

#define LIST_INFO_magic         0xEE00

struct list_elem {
    struct url    *url;
    struct string *comment;
};

struct list_info {
    unsigned short        magic;     /* LIST_INFO_magic */

    struct string        *list_phrase;  /* phrase from List-ID */
    char                 *list_id;      /* id from LIST-ID */

    struct list_elem     *list_help;
    int                   list_help_len;

    struct list_elem     *list_unsubscribe;
    int                   list_unsubscribe_len;

    struct list_elem     *list_subscribe;
    int                   list_subscribe_len;

    struct list_elem     *list_post;
    int                   list_post_len;
    int                   list_post_no;     /* Flag: NO */
    struct string        *list_post_no_comment;

    struct list_elem     *list_owner;
    int                   list_owner_len;

    struct list_elem     *list_archive;
    int                   list_archive_len;

};


/* selection.c */

extern const struct url * select_post_url P_((struct list_elem *list,
					      int               list_len,
					      struct menu_context  *page,
					      subpage_simple_redraw *title));

/* visit_mailbox.c */

/* Returns 'i' is return to index given */
extern int visit_mailbox_loop P_((struct MailboxView *mailbox,
				  struct AliasView *aview,
				  int  command_letter));


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
