static char rcsid[] = "@(#)$Id: mailbox.c,v 2.36 2021/01/10 15:47:32 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.36 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                  (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************
 * Based on code from Elm 2.4 src/elm.c. It have following copyright:
 * 
 *  The Elm Mail System 
 *
 * This file and all associated files and documentation:
 *			Copyrighst (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************
 *  Incorparated Elm 2.5 code from src/elm.c. 
 *  That code was following copyright:
 *
 *  The Elm Mail System
 *
 * This file and all associated files and documentation:
 *                      Copyright (c) 1988-1995 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

#include "def_elm.h"
#include "s_elm.h"

DEBUG_VAR(Debug,__FILE__,"ELM");

static void set_mailbox_screen P_((struct menu_context  *page, 
				   struct screen_parts *LOC,
				   struct menu_param  *LIST));


static void set_mailbox_screen(page,LOC, LIST)
     struct menu_context  *page;
     struct screen_parts *LOC;
     struct menu_param  *LIST;
{    
    int   LINES, COLUMNS;	

    menu_get_sizes(page,&LINES, &COLUMNS);

    /* 1)  Title part of screen */

    if (! LOC->title_page)
	LOC->title_page = new_menu_subpage(page,0,4,sb_update_title,LIST);
    else
	menu_subpage_relocate(LOC->title_page,page,0,4);
					  
    /* 2) menu part */

    if (LOC->menu_page && LINES < 14)
	erase_menu_context (&(LOC->menu_page));
    else if (LOC->menu_page)
	menu_subpage_relocate(LOC->menu_page,page,LINES-8,4);
    else if (mini_menu && LINES > 14)
	LOC->menu_page = new_menu_subpage(page,LINES-8,4,
					  sb_show_menu,LIST);
   
    mailbox_screen_common(page,LOC, LIST);	
}


static void check_mailbox_screen P_((struct screen_parts *LOC,
				     struct menu_param *list));
static void check_mailbox_screen(LOC,list)
     struct screen_parts *LOC;
     struct menu_param *list;
{
    /* 1) title page */
    if (menu_resized(LOC->title_page)) {
	DPRINT(Debug,1, (&Debug, "title page resized\n"));

    }
    if (menu_need_redraw(LOC->title_page)) {
	DPRINT(Debug,1, (&Debug, "title page redraw???\n"));
	sb_update_title(LOC->title_page,list);
    }

    if (LOC->menu_page) {
	/* 2) menu page */
	if (menu_resized(LOC->menu_page)) {
	    DPRINT(Debug,1, (&Debug, "menu page resized\n"));
	    
	}
	if (menu_need_redraw(LOC->menu_page)) {
	    DPRINT(Debug,1, (&Debug, "menu page redraw\n"));
	    sb_show_menu(LOC->menu_page,list);
	}
    }

    /* 3) prompt part */
    if (menu_resized(LOC->prompt_page)) {
	DPRINT(Debug,1, (&Debug, "prompt page resized\n"));
    }
    if (menu_need_redraw(LOC->prompt_page)) {
	DPRINT(Debug,7, (&Debug, "prompt page redraw\n"));
	menu_ClearScreen(LOC->prompt_page);

	show_last_error();	/* for those operations that have to
				 * clear the footer except for a message.
				 */
    }

    /* 4) headers part */
    if (menu_resized(LOC->header_page)) {
	DPRINT(Debug,1, (&Debug, "header page resized\n"));
    }
    if (menu_need_redraw(LOC->header_page)) {
	DPRINT(Debug,1, (&Debug, "header page redraw\n"));
	menu_ClearScreen(LOC->header_page);
    }
}

/* returns:

   0  == failure
   1   == OK
   EOF

*/

static int main_messages_loop P_((struct MailboxView  ** cur_mailbox,
				  struct menu_common   * MENU,
				  struct screen_parts  * LOC,
				  struct menu_param    * PARAM,
				  struct menu_context  * page,
				  struct AliasView     * cur_aliaslist,
				  int command_letter /* Maybe '\0' */));
static int main_messages_loop(cur_mailbox,MENU,LOC,PARAM,page,
			      cur_aliaslist,command_letter)
     struct MailboxView  ** cur_mailbox;
     struct menu_common   * MENU;
     struct screen_parts  * LOC;
     struct menu_param    * PARAM;
     struct menu_context  *page;
     struct AliasView     * cur_aliaslist;
     int command_letter /* Maybe '\0' */;
{
    int ret = 0;

    int auto_assemble = 1;
    int ch = '\0';

    struct elm_commands *pager_cmds = give_pager_commands();
    struct elm_commands *menu_cmds = give_main_commands();

    const char * exit_hint_folder = NULL;  /* If not "", gives failed folder type */
    const char * was_disconnected = NULL;
    int   disconnected_hint_counter = 0;

    static const int disconnected_hint_frq = 5;
    
    set_mcommon_from_mbxview(MENU,*cur_mailbox);

    get_page(MENU, LOC->header_page);  /* resort_mailbox no longer call get_page() */
    copy_current(MENU,LOC->header_page);
    
    showscreen(page);

    while (1) {

    	int   LINES, COLUMNS;	

	menu_set_default(page);

	menu_get_sizes(page,&LINES, &COLUMNS);

	set_mcommon_from_mbxview(MENU,*cur_mailbox);

	if (menu_resized(page)) {
	    
	    set_mailbox_screen(page,LOC,PARAM);

	    menu_get_sizes(page,&LINES, &COLUMNS);

	    menu_trigger_redraw(page);   
	}	


#ifdef BACKGROUD_PROCESSES      
	if (handle_sigchld)
	    sigchld_handler();
#endif

	new_mail_check(*cur_mailbox,page, LOC,
		       &exit_hint_folder);
	
	/* ??? FIX    Is this correct ?? */
	if (update_view(*cur_mailbox)) {
	    resort_mailbox(*cur_mailbox,1);

	    get_page(MENU, LOC->header_page);  /* resort_mailbox no longer call get_page() */
	    menu_trigger_redraw(LOC->header_page);
	    menu_trigger_redraw(LOC->title_page);
	}

	if (menu_need_redraw(page)) {
	    DPRINT(Debug,7, (&Debug, 
			     "main: pending redraw\n"));
	    
	    showscreen(page);
	}
	check_mailbox_screen(LOC, PARAM);


	
	{   
	    int lin,col;
	    enum fragment_handling_v fh = 
		give_dt_enumerate_as_int(&fragment_handling);

	    menu_PutLineX(LOC->prompt_page,0,0,
			  FRM("%S"),mcommon_give_item(MENU, m_Prompt));
	    menu_GetXYLocation(LOC->prompt_page,&lin,&col);

	    menu_CleartoEOS(LOC->prompt_page);   
	    
	    if (!show_last_error()) {
		const char * XX = found_disconnected(*cur_mailbox);

		if (XX) {
		    if (XX == was_disconnected &&
			disconnected_hint_counter++ < disconnected_hint_frq)
			goto ignore_disconnect;

		    was_disconnected = XX;
		    disconnected_hint_counter = 1;
		    
		    if (was_disconnected == exit_hint_folder) {
			lib_transient(CATGETS(elm_msg_cat, ElmSet, 
					      ElmSFailedUseErorX,
					      "%s disconnected and failed. Use 'Er' for reconnecting or 'X' for Quick Exit"),
				      was_disconnected);
			exit_hint_folder = NULL;					      
		    } else
			lib_transient(CATGETS(elm_msg_cat, ElmSet, 
					      ElmSFailedUseErforReconnect,
					      "%s disconnected.  Use 'Er' for reconnecting broken connection"),
				      was_disconnected);
		    		    		   		    
		} else {
		    was_disconnected = NULL;
		    disconnected_hint_counter = 0;
		    
		ignore_disconnect:
		    if (exit_hint_folder) {
			if (exit_hint_folder[0])
			    lib_transient(CATGETS(elm_msg_cat, ElmSet, 
						  ElmSFailedUseXforQuickExit,
						  "%s failed. Use 'X' for Quick Exit"),
					  exit_hint_folder);
			else
			    lib_transient(CATGETS(elm_msg_cat, ElmSet, 
						  ElmUseXforQuickExit,
						  "Use 'X' for Quick Exit"));
			exit_hint_folder = NULL;
		    }
		}
	    }

	    menu_MoveCursor(LOC->prompt_page,lin,col);

	    /* fragment_handling: 0 == none,
	       1 == manual,
	       2 == auto  */

	    if (command_letter) {
		DPRINT(Debug,4,(&Debug,
				"Auto command %c",
				command_letter));
		if (isascii(command_letter) && isprint(command_letter)) {
		    DPRINT(Debug,4,(&Debug," (%c)",
				    command_letter));
		}
		
		DPRINT(Debug,4,(&Debug,"\n"));
		
		ch = command_letter;
		command_letter = '\0';
				
		
	    } else if (auto_assemble && fragment_handling_auto == fh &&
		have_partial(*cur_mailbox)) {
	        ch = 'A';
		auto_assemble = 0;
		
		DPRINT(Debug,4,(&Debug,"Automatic assemble ... \n"));
	    } else
		ch = GetPrompt(LOC->prompt_page, elm_timeout);
	
	    /* ? ? ?    resize again? */ 

	    menu_CleartoEOS(LOC->prompt_page);

	    if (isascii(ch) && isprint(ch)) {
		DPRINT(Debug,4,(&Debug, 
				"\nCommand: %c [%d]\n\n", ch, ch));
	    } else {
		DPRINT(Debug,4,(&Debug, 
				"\nCommand: %d\n\n", ch));
	    }
	    
	    set_error("");	/* clear error buffer */

	    
	    
	    menu_MoveCursor(LOC->prompt_page,lin,col);
	}

	ch = mailbox_command(*cur_mailbox,ch, LOC,
			     showmsg_main_cmd,
			     cur_aliaslist,
			     page,pager_cmds,1,menu_cmds);
	 

	switch (ch) {
	case 0:  /* OK */
	    break;
	      
	case F3_KEY_MARK:
	    mini_menu = ! mini_menu;

	    if (LOC->menu_page && !mini_menu)
		erase_menu_context (&(LOC->menu_page));

	    DPRINT(Debug,10,(&Debug,"mini_menu = %d \n",mini_menu));

	    set_mailbox_screen(page,LOC,PARAM);
		
	    menu_trigger_redraw(page);   /* ? Is needed? */
	    
	    break;
	    
	resynchronize_folder_label:  
	case F5_KEY_MARK:
	case '$'    :  {
#ifdef UNUSED
	      int current;
#endif
	      menu_Write_to_screen(LOC->prompt_page,
				   CATGETS(elm_msg_cat, ElmSet, 
					   ElmResyncFolder,
					   "Resynchronize folder"));
	      FlushBuffer();

	      /* WARNING: Currently resync may quit if resyncing
		 failed ...
	      */
	      resync(cur_mailbox, page, LOC);	    

	      /* FIX MENU pointer ... */
	      set_mcommon_from_mbxview(MENU,*cur_mailbox);

#ifdef UNUSED
	      current = get_current(*cur_mailbox);
#endif
	      get_page(MENU, LOC->header_page);
	  }
	      break;

	  case '|'    :   {
	      int current = get_current(*cur_mailbox);
	      
	      menu_Writechar(LOC->prompt_page,'|');
	      
	      if (current < 1) {
		  lib_error(CATGETS(elm_msg_cat, ElmSet, 
				    ElmNoMailToPipe,
				    "No mail to pipe!"));
		  
	      } else if (give_message_data(*cur_mailbox,current-1,
					   NULL,NULL,NULL,NO_mime_parse)) {
		  
		  /* softkeys_off(); */
		  
		  do_pipe(*cur_mailbox, page,LOC->prompt_page);		


		  /* softkeys_on(); */
	      } else {
		  DPRINT(Debug,3,(&Debug, 
				  "give_message_data [%d] fails",current-1));
	      }
	    }
	      break;

	     case '&'   : {
		 TreatAsSpooled = !TreatAsSpooled;
		 if (TreatAsSpooled) {
		     /*  !!!   Message should be better!
		      */
		     lib_transient(CATGETS(elm_msg_cat, ElmSet, ElmMagicOn,
				   "[Magic On]"));
		 } else {
		     lib_transient(CATGETS(elm_msg_cat, ElmSet, ElmMagicOff,
				   "[Magic Off]"));
		 }
	     } 
		 break;

	  case 'A':    {
	      int r;
#if UNUSED
	      int current = get_current(*cur_mailbox);
#endif
	      
	      menu_Write_to_screen(LOC->prompt_page,
				   CATGETS(elm_msg_cat, 
					   ElmSet, ElmAssemble,
					   "Assemble message fragments"));
	      FlushBuffer();
	      sleep_message();

	      r = ViewPartial(*cur_mailbox, cur_aliaslist, page, 1);

#if UNUSED
	      current = get_current(*cur_mailbox);
#endif
	      get_page(MENU, LOC->header_page);

	      if (menu_need_redraw(page)) {
		  DPRINT(Debug,7, (&Debug, 
				   " main_messages_loop: pending redraw\n"));
		  
		  showscreen(page);
	      }
	      
	      if (r) {        /* Print prompt again */
		  int lin,col;

		  menu_PutLineX(LOC->prompt_page,0,0,
				FRM("%S"),mcommon_give_item(MENU, m_Prompt));
		  menu_GetXYLocation(LOC->prompt_page,&lin,&col);
		  
		  menu_CleartoEOS(LOC->prompt_page);   
		  
		  show_last_error();
		  menu_MoveCursor(LOC->prompt_page,lin,col);
	      }

	      switch(r) {
	      case ctrl('Q') :
	      case 'x':
		  goto exit_label;

	      case 'q':
		  goto quit_label;

	      case 'Q':
		  goto quick_quit_label;

	      case 'X':
		  goto quick_exit_label;
		  
	      case 'c':
		  goto change_folder_label;
		  
	      case F5_KEY_MARK:
	      case '$'    :
		  goto resynchronize_folder_label;

	      case EOF:
		  ret = EOF;
		  goto OUT;
		  /* Read failed, control tty died? */		
		  break;
	      }
	  }
	      break;

	change_folder_label:
	case 'c'    : {
	    struct MailboxView * new_mailbox = NULL;
	    struct cancel_data *cd = NULL;
	    int r;
	    
	      if (TreatAsSpooled)
		  menu_Write_to_screen(LOC->prompt_page,
				       CATGETS(elm_msg_cat, 
					       ElmSet, ElmChangeMailbox,
					       "Change mailbox"));
	      else
		  menu_Write_to_screen(LOC->prompt_page,
				       CATGETS(elm_msg_cat, 
					       ElmSet, ElmChangeFolder,
					       "Change folder"));

 	      FlushBuffer();

	      /* define_softkeys(CHANGE); */
	      new_mailbox = change_file(*cur_mailbox, cur_aliaslist,
					page,LOC->prompt_page,
					&command_letter,menu_cmds);
		  
	      if (!new_mailbox) {
		  if (EOF == command_letter) {
		      ret = EOF;
		      goto OUT;
		      /* Read failed, control tty died? */		
		  }
		  
		  break;
	      }
	      /* FIX MENU pointer ... redraw may use it */
	      set_mcommon_from_mbxview(MENU,new_mailbox);
     
	      get_page(MENU, LOC->header_page);  /* resort_mailbox no longer call get_page() */
	
	      menu_trigger_redraw(LOC->header_page);
	      menu_trigger_redraw(LOC->title_page);
	      
	      /* close_cleanup_mbox() may remove mailbox */
	      close_cleanup_mbox(*cur_mailbox);

	      setup_mbx_cancel_message(&cd,mbx_leaving_mailbox);
	      
	      DPRINT(Debug,9, (&Debug, 
			       "main_messages_loop: freeing cur_mailbox\n"));
	      
	      r = free_mailbox(cur_mailbox,cd);
	      if (!r) {
		  DPRINT(Debug,9, (&Debug, 
				   "main_messages_loop: free_mailbox failed\n"));
	      }       
	      if (is_canceled(cd)) {
		  DPRINT(Debug,9, (&Debug, 
				   "main_messages_loop: Cancel on free_mailbox\n"));
	      }	      
	      free_cancel(&cd);
	      
	      *cur_mailbox = new_mailbox;

	      if (EOF == command_letter) {
		  ret = EOF;
		  goto OUT;
		  /* Read failed, control tty died? */		
	      }
	      
	      /* define_softkeys(MAIN); */
	}
	    break;

	  case 'e'    :  {

	      if (ALLOW_mailbox_editing) {
		  int current = get_current(*cur_mailbox);
		  enum user_level_v ul = 
		      give_dt_enumerate_as_int(&user_level);
		  
		  menu_Write_to_screen(LOC->prompt_page,
				       CATGETS(elm_msg_cat, 
					       ElmSet, ElmEditFolder,
					       "Edit folder"));
		  
		  if (ul < user_level_expert) {
		      lib_error(CATGETS(elm_msg_cat, ElmSet, 
					ElmNoFolderEditing,
					"You are not experienced to use folder editing"));
		  
		      break;
		  }
	      
		  if (current < 1) 
		      lib_error(CATGETS(elm_msg_cat, ElmSet, 
					ElmFolderIsEmpty,
					"Folder is empty!"));
		  else
		      edit_mailbox(cur_mailbox, 
				   page);
		  
	      } else {

		  lib_error(CATGETS(elm_msg_cat, ElmSet, 
				    ElmNoFolderEdit,
				    "Folder editing isn't configured in this version of ELM."));
	      }
	  }
	      break;

	  case 'o'    :  {
#if UNUSED
	      int current = get_current(*cur_mailbox);
#endif
	      int i;
	      int setscreen = 0;
	      
	      menu_Write_to_screen(LOC->prompt_page,
				   CATGETS(elm_msg_cat, ElmSet,
					   ElmOptions,
					   "Options"));

	      i=options(*cur_mailbox, cur_aliaslist, page, &setscreen);

	      if (setscreen) {

		  if (LOC->menu_page && !mini_menu)
		      erase_menu_context (&(LOC->menu_page));
		  
		  DPRINT(Debug,10,(&Debug,"mini_menu = %d \n",mini_menu));

		  set_mailbox_screen(page,LOC,PARAM);

		  menu_trigger_redraw(page);   
	      }

	      if (i > 0) {

#if UNUSED
		  current = get_current(*cur_mailbox);
#endif
		  get_page(MENU, LOC->header_page);

	      } else if (i < 0)
		  goto OUT;
	  }
	      break;

	  case 'p'    :  {
	      int current = get_current(*cur_mailbox);
	      
	      menu_Write_to_screen(LOC->prompt_page,
				   CATGETS(elm_msg_cat, ElmSet,
					   ElmPrintMail,
					   "Print mail"));
	      FlushBuffer();

	      if (current < 1) {
		  lib_error(CATGETS(elm_msg_cat, ElmSet, 
				    ElmNoMailToPrint,
				    "No mail to print!"));
		
	      } else if (give_message_data(*cur_mailbox,current-1,
					   NULL,NULL,NULL,NO_mime_parse)) {
		  
		  print_msg(TRUE,*cur_mailbox, page,LOC->prompt_page);
		   		 
	      } else {
		  DPRINT(Debug,3,(&Debug, 
				  "give_message_data [%d] fails",current-1));
	      }
	  }
	      break;
	      
	      
	quit_label:
	case 'q'    :  {
	      int idx, mbxcount, found = 0;

	      menu_Write_to_screen(LOC->prompt_page,
				   CATGETS(elm_msg_cat, ElmSet,
					   ElmQuit,
					   "Quit"));
	      FlushBuffer();
	      sleep_message();

	      mbxcount = get_storage_count(*cur_mailbox);
		
	      for (idx = 0 ; idx < mbxcount; idx++) {
		  long bytes = 0;
		  int newmails = 0;
		  enum new_mail_stat r1;
		  int err = 0;
		  
		  struct current_storage * storage = 
		      get_storage(*cur_mailbox,idx);
		  
		  if (!storage || !storage->current_folder)
			continue;


		  r1 = new_mail_on_folder(storage->current_folder,&bytes,
					  &newmails,&err,NULL);
		  switch (r1) {
		  case failed_mbx_ign_new_mail:
		  case new_mail_check_failed: {
		      const char * ftype = folder_type(storage->current_folder);
		      
		      if (err) 
			  lib_error(CATGETS(elm_msg_cat, ElmSet, 
					    ElmFailedQuitCancelledS,
					    "%s failed! Quit canceled: %s"),
				    ftype,strerror(err));
		      else
			  lib_error(CATGETS(elm_msg_cat, ElmSet, 
					    ElmFailedQuitCancelled,
					    "%s failed! Quit canceled..."),
				    ftype);
		      found++;
		      exit_hint_folder = ftype;
		      }
			  break;
		      break;
		  case no_new_mail: break;
		  case have_new_mail:
		      if (newmails > 1) {  /* IMAP mailbox, count is available */
			   lib_error(CATGETS(elm_msg_cat, ElmSet, 
					     ElmXNewMailsQuitCancelled,
					     "%d new mails!  Quit canceled..."),
				     newmails);
		      } else {
			  lib_error(CATGETS(elm_msg_cat, ElmSet, 
					    ElmNewMailQuitCancelled,
					    "New Mail!  Quit canceled..."));
		      }
		      found++;
		      break;
		  case new_mail_reconnect: {
		      const char * ftype = folder_type(storage->current_folder);
		      
		      lib_error(CATGETS(elm_msg_cat, ElmSet, 
					ElmReconnectedQuitCancelled,
					"%s reconnected! Quit canceled..."),
				ftype);
		      found++;		      
		  }
		      break;
		  }
	      }

		if (!found) {
		    int r = quit(TRUE, *cur_mailbox,
				 page,LOC->prompt_page);		

		    if (EOF == r) {
			ret = EOF;
			goto OUT;
			/* Read failed, control tty died? */		
		    }
		    
		    if (r) {
			ret = 1;
			goto OUT;
		    }
		    /* XXXX   differentiate failure and cancel of Quit ? */

		}
	    }			   
		break;

	quick_quit_label:
	  case 'Q'    :  {
	      int idx, mbxcount, found = 0;

	      menu_Write_to_screen(LOC->prompt_page,
				   CATGETS(elm_msg_cat, ElmSet,
					   ElmQuickQuit,
					   "Quick quit"));
	      FlushBuffer();

	      mbxcount = get_storage_count(*cur_mailbox);
	      
	      for (idx = 0 ; idx < mbxcount; idx++) {
		  long bytes = 0;
		  int newmails = 0;
		  enum new_mail_stat r1;
		  int err = 0;
		  
		  struct current_storage * storage = 
		      get_storage(*cur_mailbox,idx);
		 		  
		  if (!storage || !storage->current_folder)
		      continue;

		  r1 = new_mail_on_folder(storage->current_folder,&bytes,
					  &newmails,&err,NULL);
		  switch (r1) {
		  case failed_mbx_ign_new_mail:
		  case  new_mail_check_failed: {
		      const char * ftype = folder_type(storage->current_folder);
		      
		      if (err) 
			  lib_error(CATGETS(elm_msg_cat, ElmSet, 
					    ElmFailedQuickQuitCancelledS,
					    "%s failed! Quick Quit canceled: %s"),
				    ftype,strerror(err));
		      else
			  lib_error(CATGETS(elm_msg_cat, ElmSet,
					    ElmFailedQuickQuitCancelled,
					    "%s failed! Quick Quit canceled..."),
				    ftype);
		      exit_hint_folder = ftype;
		      found++;
		  }
		      break;
		  
		  case no_new_mail: break;
		  case have_new_mail:
		      if (newmails > 1) {  /* IMAP mailbox, count is available */
			  lib_error(CATGETS(elm_msg_cat, ElmSet, 
					    ElmXNewMailsQuickQuitCancelled,
					    "%d new mails!  Quick Quit canceled..."),
				    newmails);
		      } else {
			  lib_error(CATGETS(elm_msg_cat, ElmSet, 
					    ElmNewMailQuickQuitCancelled,
					    "New Mail!  Quick Quit canceled..."));
		      }
		      found++;
		      break;
		  case new_mail_reconnect: {
		      const char * ftype = folder_type(storage->current_folder);
		      
		      lib_error(CATGETS(elm_msg_cat, ElmSet, 
					ElmReconnectedQuickQuitCancelled,
					"%s reconnected! Quick Quit canceled..."),
				ftype);	
		      found++;
		  }
		      break;		      				      
		  }
	      }

	      if (!found) {
		  int r = quit(FALSE, *cur_mailbox,
			       page,LOC->prompt_page);		
		  
		  
		  if (EOF == r) {
		      ret = EOF;
		      goto OUT;
		      /* Read failed, control tty died? */		
		  }
		  
		  if (r) {
		      ret = 1;
		      goto OUT;
		  }
		  /* XXXX   differentiate failure of Quit Quit ? */
		  
	      }
	  }
	      break;
	      
	quick_exit_label:
	case 'X'    :  
	      menu_Write_to_screen(LOC->prompt_page,
				   CATGETS(elm_msg_cat, ElmSet,
					   ElmQuickExit,
					   "Quick Exit"));
	      FlushBuffer();

	      goto OUT;
			 
		
	exit_label:
	case ctrl('Q') :
	case 'x'    : {   
	    int r;

	    menu_Write_to_screen(LOC->prompt_page,
				 CATGETS(elm_msg_cat, ElmSet,
					 ElmExit,
					 "Exit"));  
	    FlushBuffer();
	    sleep_message();	    

	    r = exit_mailbox(*cur_mailbox,
			     page);

	    if (EOF == r) {
		ret = EOF;
		goto OUT;
		/* Read failed, control tty died? */		
	    }

	    if (r) {
		ret = 1;
		goto OUT;
	    }
	    /* XXXX   differentiate failure and cancel of Exit ? */

	}
	    break;

	  case EOF :  

	      ret = EOF;
	      goto OUT;
	      /* Read failed, control tty died? */
	     	    	
	  default:
	      lib_error(CATGETS(elm_msg_cat, ElmSet, 
				ElmUnknownCommand,
				"Unknown command. Use '?' for help."));		    
	  }

	  if (menu_need_redraw(page))
	      showscreen(page);

          check_range(MENU,LOC);

	  check_mailbox_screen(LOC, PARAM);
	    
    } /* the BIG while loop! */

 OUT:

    free_commands(&pager_cmds);   /* Decrement refcount */
    free_commands(&menu_cmds);   /* Decrement refcount */


    DPRINT(Debug,3,(&Debug, 
		    "main_message_loop() exits with %d\n",ret));


    return ret;
}

/* returns:

   0  == failure
   1   == OK
   EOF

*/

int main_messages_menu(page,req_mfile_vector,cur_aliaslist)
     struct menu_context  *page;
     char **req_mfile_vector;
     struct AliasView     * cur_aliaslist;
{
    int   ret = 0;

    struct MailboxView   * cur_mailbox = NULL;
    
    struct menu_common MENU;
    struct screen_parts  LOC  = { NULL, NULL, NULL, NULL };
    struct menu_param  PARAM[elm_mp_COUNT+1] = { 
	{ mp_menu_common, { 0 } },
	{ mp_integer,     { 0 } },
	{ mp_integer,     { 0 } },
	{ mp_integer,     { 0 } },
	{ mp_integer,     { 0 } },
	{ mp_END,         { 0 } }
    };

    int command_letter = '\0';
    struct elm_commands *menu_cmds = give_main_commands();
    
    set_mcommon_from_mbxview(&MENU,NULL);               /* Clear initially */
    mp_list_set_mcommon(PARAM,elm_mp_menu,&MENU);


    set_mailbox_screen(page,&LOC,PARAM);  
    
    cur_mailbox = initialize_mailbox(req_mfile_vector,page,
				     cur_aliaslist,
				     &command_letter,
				     menu_cmds );

    if (EOF == command_letter) {
	ret = EOF;
	goto fail;
    }

    if (!cur_mailbox)
	goto fail;

    ret = main_messages_loop(&cur_mailbox,&MENU,&LOC,PARAM,page,
			     cur_aliaslist,command_letter);


 fail:  
    free_mailbox_screen(&LOC);

    if (cur_mailbox) {
	int r;
	
	struct cancel_data *cd = NULL;

	setup_mbx_cancel_message(&cd,mbx_leaving_mailbox);
	
	DPRINT(Debug,9, (&Debug, 
			 "main_messages_menu: freeing cur_mailbox\n"));
	r = free_mailbox(&cur_mailbox,cd);
	if (!r) {
	    DPRINT(Debug,9, (&Debug, 
			     "main_messages_menu: free_mailbox failed\n"));
	}	
	if (is_canceled(cd)) {
	    DPRINT(Debug,9, (&Debug, 
			     "main_messages_menu: Cancel on free_mailbox\n"));
	}
	free_cancel(&cd);
    }

    free_commands(&menu_cmds);   /* Decrement refcount */

    
    return ret;
}

/* returns:

   0  == failure
   1   == OK
   EOF

*/

int url_messages_menu(page,url,cur_aliaslist)		      
     struct menu_context  * page;
     struct url           * url;
     struct AliasView     * cur_aliaslist;
{
    int ret = 0;

    struct MailboxView   * cur_mailbox = NULL;

    struct menu_common MENU;
    struct screen_parts  LOC  = { NULL, NULL, NULL, NULL };
    struct menu_param  PARAM[elm_mp_COUNT+1] = { 
	{ mp_menu_common, { 0 } },
	{ mp_integer,     { 0 } },
	{ mp_integer,     { 0 } },
	{ mp_integer,     { 0 } },
	{ mp_integer,     { 0 } },
	{ mp_END, { 0 } }
    };

    int command_letter = '\0';
    struct elm_commands *menu_cmds = give_main_commands();

    
    set_mcommon_from_mbxview(&MENU,NULL);               /* Clear initially */
    mp_list_set_mcommon(PARAM,elm_mp_menu,&MENU);


    set_mailbox_screen(page,&LOC,PARAM);  

    cur_mailbox = initialize_mailbox_from_url(url,page,
					      confirm_url,
					       &command_letter,
					      menu_cmds
					      );
    if (EOF == command_letter) {
	ret = EOF;
	goto fail;
    }

    if (!cur_mailbox)
	goto fail;

    ret = main_messages_loop(&cur_mailbox,&MENU,&LOC,PARAM,page,
			     cur_aliaslist,command_letter);
  
 fail:
    free_mailbox_screen(&LOC);

    if (cur_mailbox) {
	int r;
	
	struct cancel_data *cd = NULL;

	setup_mbx_cancel_message(&cd,mbx_leaving_mailbox);
	
	DPRINT(Debug,9, (&Debug, 
			 "url_messages_menu: freeing cur_mailbox\n"));
	r = free_mailbox(&cur_mailbox,cd);
	if (!r) {
	    DPRINT(Debug,9, (&Debug, 
			     "url_messages_menu: free_mailbox failed\n"));
	}
	if (is_canceled(cd)) {
	    DPRINT(Debug,9, (&Debug, 
			     "url_messages_menu: Cancel on free_mailbox\n"));
	}
	free_cancel(&cd);
    }

    free_commands(&menu_cmds);   /* Decrement refcount */
    
    return ret;
}


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
