static char rcsid[] = "@(#)$Id: mailcap_sel.c,v 2.1 2022/08/19 16:13:05 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.1 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/


#include "def_elm.h"
#include "s_me.h"

#include "mailcap_imp.h"

DEBUG_VAR(Debug,__FILE__,"ui");

#if ANSI_C
#define S_(x) static x;
#else
#define S_(x)
#endif


static void print_mailcap_vector P_((struct menu_context  *page,
				     int line, int col,
				     struct mailcap_vector * vector,
				     int vector_len,
				     int max_col));
static void print_mailcap_vector(page,line,col,
				 vector,vector_len,
				 max_col)
     struct menu_context  *page;
     int line;
     int col;
     struct mailcap_vector * vector;
     int vector_len;
     int max_col;
{
    int idx;

    DPRINT(Debug,12, (&Debug,
		      "print_mailcap_vector: line=%d col=%d vector_len=%d max_col=%d\n",
		      line,col,vector_len,max_col));
    
    menu_MoveCursor(page,line,col);

    for (idx = 0; idx < vector_len; idx++) {

	int subidx;
	char quote_char = 0;

	if (col +3 >= max_col) {
	    menu_StartXX(page,pg_BOLD);
	    menu_Write_to_screen(page,FRM("..."));
	    menu_EndXX(page,pg_BOLD);
	    goto out;
	}

	if (idx > 0) {
	    menu_Writechar(page,' ');
	    col++;

	    if (col +3 >= max_col) {
		menu_StartXX(page,pg_BOLD);
		menu_Write_to_screen(page,FRM("..."));
		menu_EndXX(page,pg_BOLD);
		goto out;
	    }
	}
	
	if (MAILCAP_PARAM_magic != vector[idx].magic)
	    mime_panic(__FILE__,__LINE__,
		       "print_mailcap_vector",
		       "Bad magic number (mailcap_vector)");

        DPRINT(Debug,12, (&Debug,
			  "print_mailcap_vector: [%d].subcount=%d\n",
			  idx,vector[idx].subcount));
	
	for (subidx = 0; subidx < vector[idx].subcount; subidx++) {

	    if (col +3 >= max_col) {
		menu_StartXX(page,pg_BOLD);
		menu_Write_to_screen(page,FRM("..."));
		menu_EndXX(page,pg_BOLD);
		goto out;
	    }
	    	    
	    if (quote_char != vector[idx].subvector[subidx].quote_char) {
		
		if (quote_char) {
		    menu_StartXX(page,pg_BOLD);
		    menu_Writechar(page,quote_char);
		    col++;
		    quote_char = 0;
		    menu_EndXX(page,pg_BOLD);
		}

		if (col +3 >= max_col) {
		    menu_StartXX(page,pg_BOLD);
		    menu_Write_to_screen(page,FRM("..."));
		    menu_EndXX(page,pg_BOLD);
		    goto out;
		}

		if (vector[idx].subvector[subidx].quote_char) {
		    menu_StartXX(page,pg_BOLD);
		    menu_Writechar(page,vector[idx].subvector[subidx].quote_char);
		    col++;
		    quote_char = vector[idx].subvector[subidx].quote_char;
		    menu_EndXX(page,pg_BOLD);
		}

		if (col +3 >= max_col) {
		    menu_StartXX(page,pg_BOLD);
		    menu_Write_to_screen(page,FRM("..."));
		    menu_EndXX(page,pg_BOLD);
		    goto out;
		}
		
	    }
	    

	    switch (vector[idx].subvector[subidx].type) {
	    case mv_literal:
		
		if (vector[idx].subvector[subidx].arg.arg) {
		    int i;
		    
		    /* \ is not allowed on mailcap parser
		       even inside of quoted so not
		       need special handling for \' and \"
		       like printing
		    */
		    
		    for (i = 0; i < vector[idx].subvector[subidx].arg.arg_len; i++) {
			menu_Writechar(page,
				       vector[idx].subvector[subidx].arg.arg[i]);
			col++;
			
			if (col +3 >= max_col) {
			    menu_StartXX(page,pg_BOLD);
			    menu_Write_to_screen(page,FRM("..."));
			    menu_EndXX(page,pg_BOLD);
			    goto out;
			}			
		    }
		}
		
		break;
		
	    case mv_filename:
		
		if (col +5 >= max_col) {
		    menu_StartXX(page,pg_BOLD);
		    menu_Write_to_screen(page,FRM("..."));
		    menu_EndXX(page,pg_BOLD);
		    goto out;
		}
		
		menu_StartXX(page,pg_UNDERLINE);
		menu_Writechar(page,'%');
		menu_Writechar(page,'s');
		menu_EndXX(page,pg_UNDERLINE);
		col += 2;
		break;
		
	    case mv_type:
		
		if (col +5 >= max_col) {
		    menu_StartXX(page,pg_BOLD);
		    menu_Write_to_screen(page,FRM("..."));
		    menu_EndXX(page,pg_BOLD);
		    goto out;
		}

		menu_StartXX(page,pg_UNDERLINE);
		menu_Writechar(page,'%');
		menu_Writechar(page,'t');
		menu_EndXX(page,pg_UNDERLINE);
		col += 2;
		break;
		
	    case mv_parameter:
		
		if (col +6 >= max_col) {
		    menu_StartXX(page,pg_BOLD);
		    menu_Write_to_screen(page,FRM("..."));
		    menu_EndXX(page,pg_BOLD);
		    goto out;
		}

		if (vector[idx].subvector[subidx].arg.arg) {
		    int i;

		    menu_StartXX(page,pg_UNDERLINE);
		    menu_Writechar(page,'%');
		    menu_Writechar(page,'{');

		    col += 2;

		    for (i = 0; i < vector[idx].subvector[subidx].arg.arg_len; i++) {
			menu_Writechar(page,
				       vector[idx].subvector[subidx].arg.arg[i]);
			col++;
			
			if (col +3 >= max_col) {
			    menu_EndXX(page,pg_UNDERLINE);
			    menu_StartXX(page,pg_BOLD);
			    menu_Write_to_screen(page,FRM("..."));
			    menu_EndXX(page,pg_BOLD);
			    goto out;
			}			
		    }
		    
		    if (col +3 >= max_col) {
			menu_EndXX(page,pg_UNDERLINE);
			menu_StartXX(page,pg_BOLD);
			menu_Write_to_screen(page,FRM("..."));
			menu_EndXX(page,pg_BOLD);
			goto out;
		    }			

		    menu_Writechar(page,'}');
		    col++;
		    
		    menu_EndXX(page,pg_UNDERLINE);
		}
		    
		break;
		
		case mv_environ:

		    if (col +6 >= max_col) {
			menu_StartXX(page,pg_BOLD);
			menu_Write_to_screen(page,FRM("..."));
			menu_EndXX(page,pg_BOLD);
			goto out;
		    }
		    
		    if (vector[idx].subvector[subidx].arg.arg) {
			int i;
			
			menu_StartXX(page,pg_UNDERLINE);
			menu_Writechar(page,'$');
			col++;

			for (i = 0; i < vector[idx].subvector[subidx].arg.arg_len; i++) {
			    menu_Writechar(page,
					   vector[idx].subvector[subidx].arg.arg[i]);
			    col++;
			    
			    if (col +3 >= max_col) {
				menu_EndXX(page,pg_UNDERLINE);
				menu_StartXX(page,pg_BOLD);
				menu_Write_to_screen(page,FRM("..."));
				menu_EndXX(page,pg_BOLD);
				goto out;
			    }			
			}
			
			if (col +3 >= max_col) {
			    menu_EndXX(page,pg_UNDERLINE);
			    menu_StartXX(page,pg_BOLD);
			    menu_Write_to_screen(page,FRM("..."));
			    menu_EndXX(page,pg_BOLD);
			    goto out;
			}			
			
			menu_EndXX(page,pg_UNDERLINE);
		    }
		    		    
		break;
	    }
	   	    
	}

	if (col +3 >= max_col && idx+1 < vector_len) {
	    menu_StartXX(page,pg_BOLD);
	    menu_Write_to_screen(page,FRM("..."));
	    menu_EndXX(page,pg_BOLD);
	    goto out;
	}
		
	if (quote_char) {
	    menu_StartXX(page,pg_BOLD);
	    menu_Writechar(page,quote_char);
	    col++;
	    quote_char = 0;
	    menu_EndXX(page,pg_BOLD);
	}	
    }

    if (0) {
    out:
	DPRINT(Debug,12, (&Debug,
			  "print_mailcap_vector: truncated at col=%d, max_col=%d\n",
			  col,max_col));
    }
    
}

/* Returns 0 if redraw was needed 
   draws ": "
*/

static enum title_col_mode {
    title_col_redraw = 0,
    title_col_ok     = 1
} set_title_col P_((struct menu_context  *page,
			     int * title_col,
			     int columns));
static enum title_col_mode set_title_col(page,title_col,columns)
     struct menu_context  *page;
     int * title_col;
     int columns;
{
    int lin,col;
    
    menu_GetXYLocation(page,&lin,&col);

    if (*title_col < 0 ) {
	*title_col = col;
    } else if (*title_col < col && col < columns/2 &&
	       *title_col + 8 > col) {
	*title_col = col;
	return title_col_redraw;
    }

    while (col < *title_col && col +8 < columns) {
	menu_Writechar(page,' ');
	col++;
    }

    menu_Writechar(page,':');
    menu_Writechar(page,' ');

    return title_col_ok;
}

#define PROMPT_MAILCAP_OTHER_magic	0xF40A

struct menu_anon_param {
    unsigned short magic;   /* PROMPT_MAILCAP_OTHER_magic */

    struct prompt_programs_list *pg;
};

enum { mailcap_mp_list,

       mailcap_mp_COUNT };


static void show_mailcap_program P_((struct prompt_programs_list * pg,
				     struct menu_context         * ptr,
				     int line_number,
				     int index,
				     int is_current));
static void show_mailcap_program(pg,ptr,line_number,index,is_current)
     struct prompt_programs_list * pg;
     struct menu_context         * ptr;
     int line_number;
     int index;
     int is_current;
{
    int LINES, COLUMNS;

    menu_get_sizes(ptr, &LINES, &COLUMNS);

    DPRINT(Debug,13, (&Debug,
		      "show_mailcap_program: LINES=%d COLUMNS=%d\n",
		      LINES,COLUMNS));
    
    menu_ClearLine(ptr,line_number);  
    menu_MoveCursor(ptr,line_number,0);

    DPRINT(Debug,10, (&Debug,
		      "show_mailcap_program: line_number=%d, index=%d, is_current=%d",		      
		      line_number,index,is_current));
    
    if (pg) {
	DPRINT(Debug,10, (&Debug,", pg=%p",pg));
	
	if (pg->structure) {
	    DPRINT(Debug,10, (&Debug,"; pg->structure=%p\n",
			      pg->structure));
	    
	    if (MIME_magic != pg->structure->magic)
		mime_panic(__FILE__,__LINE__,
			   "show_mailcap_program",
			   "Bad magic number (struct mimeinfo)");

	    if (pg->structure->handler_data) {
		struct mime_selected_handler * H = NULL;

		DPRINT(Debug,15, (&Debug,
				  "                    : pg->structure->handler_data=%p\n",
				  pg->structure->handler_data));
		
		if (MIME_selector_magic != pg->structure->handler_data->magic)
		    mime_panic(__FILE__,__LINE__,
			       "show_mailcap_program",
			       "Bad magic number (mime_selected_handler)");

		H = pg->structure->handler_data;
		
		if (index >= 0 && H->other_entries && H->num_other_entries > index) {

		    int c = ' ';
		    int lin,col;

		    if (H->entry == H->other_entries[index]) {
			c = 'X';
		    }
		    
		    if (has_highlighting && ! arrow_cursor) {
			if (is_current) {
			    menu_StartXX(ptr,pg_STANDOUT);
			}

			menu_PutLine0(ptr,line_number,0,"  ");
		    } else {
			if (is_current) {
			    menu_PutLine0(ptr,line_number,0,"->");
			} else {
			    menu_PutLine0(ptr,line_number,0,"  ");
			}
		    }

		    menu_Write_to_screen(ptr,FRM("[%c] "),c);
		    menu_GetXYLocation(ptr,&lin,&col);

		    if (H->other_entries[index]) {
			DPRINT(Debug,15, (&Debug,
					  "                    : entry %d is %p\n",
					  index,H->other_entries[index]));
			
			if (MAILCAP_magic != H->other_entries[index]->magic)
			    mime_panic(__FILE__,__LINE__,
				       "show_mailcap_program",
				       "Bad magic number (mailcap_entry)");
			
			if (H->other_entries[index]->view_command) {
			    DPRINT(Debug,15, (&Debug,
					      "                    : view command  for entry %d is %p, len %d\n",
					      index,
					      H->other_entries[index]->view_command,
					      H->other_entries[index]->view_command_len));
					      
			    print_mailcap_vector(ptr,lin,col,
						 H->other_entries[index]->view_command,
						 H->other_entries[index]->view_command_len,
						 COLUMNS);			    
			} else {
			    DPRINT(Debug,15, (&Debug,
					      "                    : no view command for entry %d\n",index));

			}

			if (is_current) {

			    menu_GetXYLocation(ptr,&lin,&col);

			    while (col < COLUMNS) {
				menu_Writechar(ptr,' ');
				col++;
			    }
			}
		    } else {
			DPRINT(Debug,15, (&Debug,
					  "                    : no entry %d\n",index));
		    }
		    
		    if (has_highlighting && ! arrow_cursor) {
			menu_EndXX(ptr,pg_STANDOUT);
		    }

		    
		} else {
		    DPRINT(Debug,15, (&Debug,
				      "                    : no entry\n"));
		    goto empty_line;
		}
	    } else {
		DPRINT(Debug,15, (&Debug,
				  "                    : pg->structure->handler_data=null\n"));
		goto empty_line;
	    }
	} else {
	    DPRINT(Debug,10, (&Debug,"; pg->structure=null\n"));
	    goto empty_line;
	}
    } else {
	DPRINT(Debug,10, (&Debug,", pg=null\n"));
    empty_line:
	DPRINT(Debug,10, (&Debug,
			  "                    : empty line\n"));
	 
	if (has_highlighting && ! arrow_cursor) {
	    if (is_current) {
		int l = 0;
		
		menu_StartXX(ptr,pg_STANDOUT);
		
		while (l < COLUMNS) {
		    menu_Writechar(ptr,' ');
		    l++;
		}
		menu_EndXX(ptr,pg_STANDOUT);
	    }

	    menu_Writechar(ptr,'\r');
	    menu_Writechar(ptr,'\n');   
	} else {
	    if (is_current)
                menu_PutLine0(ptr,line_number,0,"->");
	}
    }
	
}
				     
S_(header_line_redraw hdr_show_mailcap_prg)
void hdr_show_mailcap_prg(ptr,list,line_number,index,is_current)
     struct menu_context  *ptr;
     struct menu_param *list;	   
     int line_number;
     int index;
     int is_current;
{
    struct menu_anon_param * menu = mp_lookup_anon(list, mailcap_mp_list);

    DPRINT(Debug,9, (&Debug,
		     "hdr_show_mailcap_prg: line_number=%d index=%d is_current=%d\n",
		     line_number,index,is_current));

    if (PROMPT_MAILCAP_OTHER_magic != menu->magic)
	mime_panic(__FILE__,__LINE__,
		   "hdr_show_mailcap_prg",
		   "Bad magic number menu_anon_param()");

    show_mailcap_program(menu->pg,ptr,line_number,index,is_current);
}

S_(header_line_redraw hdr_show_mailcap_current)
void hdr_show_mailcap_current(ptr,list,line_number,index,is_current)
     struct menu_context  *ptr;
     struct menu_param *list;	   
     int line_number;
     int index;
     int is_current;
{
    struct menu_anon_param * menu = mp_lookup_anon(list, mailcap_mp_list);

    DPRINT(Debug,9, (&Debug,
		     "hdr_show_mailcap_current: line_number=%d index=%d is_current=%d\n",
		     line_number,index,is_current));

    if (PROMPT_MAILCAP_OTHER_magic != menu->magic)
	mime_panic(__FILE__,__LINE__,
		   "hdr_show_mailcap_current",
		   "Bad magic number menu_anon_param()");

    
    if (has_highlighting && ! arrow_cursor) {
	show_mailcap_program(menu->pg,ptr,line_number,index,is_current);
    } else {
	if (is_current)
	    menu_PutLine0(ptr,line_number,0,"->");
	else	    
	    menu_PutLine0(ptr,line_number,0,"  ");  /* remove old pointer... */
    }
}

S_(header_line_redraw hdr_show_mailcap_status)
void hdr_show_mailcap_status(ptr,list,line_number,index,is_current)
     struct menu_context  *ptr;
     struct menu_param *list;	   
     int line_number;
     int index;
     int is_current;
{
    struct menu_anon_param * menu = mp_lookup_anon(list, mailcap_mp_list);
    struct prompt_programs_list * pg;


    DPRINT(Debug,9, (&Debug,
		     "hdr_show_mailcap_status: line_number=%d index=%d is_current=%d\n",
		     line_number,index,is_current));

    if (PROMPT_MAILCAP_OTHER_magic != menu->magic)
	mime_panic(__FILE__,__LINE__,
		   "hdr_show_mailcap_status",
		   "Bad magic number menu_anon_param()");

    pg = menu->pg;

    menu_MoveCursor(ptr,line_number,0);

    if (pg) {

	if (MIME_magic != pg->structure->magic)
	    mime_panic(__FILE__,__LINE__,
		       "hdr_show_mailcap_status",
		       "Bad magic number (struct mimeinfo)");

	if (pg->structure) {

	    if (pg->structure->handler_data) {
		struct mime_selected_handler * H = NULL;
		
		if (MIME_selector_magic != pg->structure->handler_data->magic)
		    mime_panic(__FILE__,__LINE__,
			       "hdr_show_mailcap_status",
			       "Bad magic number (mime_selected_handler)");
		
		H = pg->structure->handler_data;
		
		if (index >= 0 && H->other_entries && H->num_other_entries > index) {
		    
		    int c = ' ';

		    if (H->entry == H->other_entries[index]) {
			c = 'X';
		    }

		    if (has_highlighting && ! arrow_cursor) {
			if (is_current) {
			    menu_StartXX(ptr,pg_STANDOUT);
			}
			
			menu_PutLine0(ptr,line_number,0,"  ");
		    } else {
			if (is_current) {
			    menu_PutLine0(ptr,line_number,0,"->");
			} else {
			    menu_PutLine0(ptr,line_number,0,"  ");
			}
		    }
		    
		    menu_Write_to_screen(ptr,FRM("[%c] "),c);

		    if (has_highlighting && ! arrow_cursor) {
			menu_EndXX(ptr,pg_STANDOUT);
		    }
		}
	    }
	}
    } 
}



enum prompt_mailcap_other_stat prompt_mailcap_other(pg,parent_page,ret_ch)
     struct prompt_programs_list *pg;			   
     struct menu_context  *parent_page;
     int * ret_ch;
{
    enum prompt_mailcap_other_stat ret = prompt_mailcap_other_none;
    
    struct menu_context  *page = new_menu_context();

    struct menu_context  *list_page = NULL;

    int ch = 0;
    int lines, columns;

    int need_redraw = 1;
    int enter_is_confirm = 0;

    struct mime_selected_handler * H = NULL;

    struct menu_anon_param P;

    struct menu_param PARAM[mailcap_mp_COUNT+1] = {
	{ mp_anon_param,  { 0 } },
	
	{ mp_END,         { 0 } }
	
    };
    
    int title_col = -1;

    int prompt_line;
    

    bzero (&P, sizeof P);

    P.magic = PROMPT_MAILCAP_OTHER_magic;
    P.pg    = pg;

    mp_list_set_anon(PARAM,mailcap_mp_list,&P);

    
    

    menu_get_sizes(page,&lines, &columns);

    prompt_line = lines -2;

    if (pg) {
	int current_line = 1; 
	
	do {

	resize_mark:
	    if (menu_resized(page)) {
		DPRINT(Debug,4, (&Debug,"    .... resizing\n"));
		
		menu_get_sizes(page,&lines, &columns);

		prompt_line = lines -2;
		
		need_redraw = 1;
	    }
	    	    
	    if (menu_need_redraw(page) || need_redraw) {
		current_line = 1;  /* start from second line */
		
		DPRINT(Debug,4, (&Debug,"    .... redrawing\n"));
		
		need_redraw = 0;
		
		menu_ClearScreen(page);  /* Reset redraw flag */

		menu_redraw_children(page);  /* redraw list_page */
		
		menu_StartXX(page,pg_BOLD);
		menu_print_format_center(page,current_line,
					 CATGETS(elm_msg_cat, MeSet, 
						 MeMailcapPrgSelTitle,
						 "Mailcap program selection [ELM %s]"),
					 version_buff);
		 menu_EndXX(page,pg_BOLD);    
		 current_line += 2;

		 if (pg->structure) {
		     if (MIME_magic != pg->structure->magic)
			 mime_panic(__FILE__,__LINE__,
				    "prompt_mailcap_other",
				    "Bad magic number (struct mimeinfo)");

		     if (pg->structure->TYPE) {
			 menu_PutLineX(page,current_line++,0,
				       CATGETS(elm_msg_cat, MeSet, 
					       MeMailcapConType,
					       "Content-Type"));

			 switch (set_title_col(page,&title_col,columns)) {
			 case title_col_redraw: need_redraw = 1; break;
			 case title_col_ok:
			     menu_Write_to_screen(page,FRM("%s/%s"),
						  get_major_type_name(pg->structure->TYPE), 
						  get_subtype_name(pg->structure->TYPE));
			     break;
			 }
			     
		     }
		     
		     if (pg->structure->description) {
			 int lin,col;
			 
			 menu_PutLineX(page,current_line++,0,
				       CATGETS(elm_msg_cat, MeSet, 
					       MeMailcapConDesc,
					       "Content-Description"));

			 switch (set_title_col(page,&title_col,columns)) {
			 case title_col_redraw: need_redraw = 1; break;
			 case title_col_ok:			 
			     menu_GetXYLocation(page,&lin,&col);
			     
			     if (col+3 < columns) {
				 int len = columns - col -3;
				 int POS = 0;
				 int visible_len = 0;
				 int L = string_len(pg->structure->description);
				 
				 struct string * X =
				     curses_printable_clip(pg->structure->description,
							   &POS,L,&visible_len,len);
				 
				 if (X) {
				     menu_PutLineX(page,lin,col,FRM("%S%s"),
						   X,
						   POS < L ? "..." : "");
				     
				     free_string(&X);
				 }
			     }
			     break;
			 }			     			 
		     }
					       
		     if (pg->structure->handler_data) {
			 int lin,col;
			 if (MIME_selector_magic != pg->structure->handler_data->magic)
			     mime_panic(__FILE__,__LINE__,
					"prompt_mailcap_other",
					"Bad magic number (mime_selected_handler)");

			 H = pg->structure->handler_data;

			 if (H->entry) {
			     if (MAILCAP_magic != H->entry->magic)
				 mime_panic(__FILE__,__LINE__,
					    "prompt_mailcap_other",
					    "Bad magic number (mailcap_entry)");
			    			     
			     menu_PutLineX(page,current_line++,0,
					   CATGETS(elm_msg_cat, MeSet, 
						   MeMailcapSelCommand,
						   "Selected command"));
			     
			     switch (set_title_col(page,&title_col,columns)) {
			     case title_col_redraw: need_redraw = 1; break;
			     case title_col_ok:			 
				 			     
				 menu_GetXYLocation(page,&lin,&col);
				 
				 if (H->entry->view_command) {

				     DPRINT(Debug,12,(&Debug,
						      "prompt_mailcap_other: ... view_command=%p view_command_len=%d\n",
						      H->entry->view_command,
						      H->entry->view_command_len));
				     
				     print_mailcap_vector(page,lin,col,
							  H->entry->view_command,
							  H->entry->view_command_len,
							  columns);
				 } else {
				     menu_PutLineX(page,lin,col,
						   CATGETS(elm_msg_cat, MeSet, 
							   MeMailcapCommandNotSel,
							   "Command not selected"));
				 }
				 break;
			     }

			 }

			 if (H->use_entry ||
			     pg->selected) {

			     menu_PutLineX(page,current_line++,0,
					   CATGETS(elm_msg_cat, MeSet, 
						   MeMailcapCommandAct,
						   "Command activation"));
			     
			     switch (set_title_col(page,&title_col,columns)) {
			     case title_col_redraw: need_redraw = 1; break;
			     case title_col_ok:
				 menu_GetXYLocation(page,&lin,&col);
				 
				 if (H->use_entry)
				     menu_PutLineX(page,lin,col,
						   CATGETS(elm_msg_cat, MeSet, MeYesWord, 
							   "Yes."));
				 else
				     menu_PutLineX(page,lin,col,
						   CATGETS(elm_msg_cat, MeSet, MeNoWord, 
							   "No."));
			     }			     
			 }
			 
			 if (H->other_entries &&
			     H->num_other_entries > 0  &&
			     current_line < prompt_line -5) {
			     
			     current_line++;

			     DPRINT(Debug,12,(&Debug,
					      "prompt_mailcap_other: ... other_entries=%p num_other_entries=%d\n",
					      H->other_entries,
					      H->num_other_entries));

			     
			     menu_PutLineX(page,current_line++,0,
					   CATGETS(elm_msg_cat, MeSet, 
						   MeMailcapCommandAvail,
						   "Available commands:"));

			     current_line++;
			     
			     if (list_page)
				 menu_header_relocate(list_page,page,
						      current_line,prompt_line-current_line-1);
			     else
				 list_page =
				     new_menu_header(page,current_line,prompt_line-current_line-1,
						     hdr_show_mailcap_prg,
						     hdr_show_mailcap_current,
						     null_header_param_changed,
						     hdr_show_mailcap_status,
						     null_header_line_separator_index,
						     header_separator_noredraw,
						     null_header_separator_start,
						     header_setup_noinit,
						     header_setup_noline,
						     PARAM);
			     
			 } else if (list_page)
			     erase_menu_context(&list_page);
			     			 			 			     
		     }		     
		 }
		 				     
	    } /* end redraw main page */

	    if (list_page) {
		if (menu_need_redraw(list_page)) {
		    
		    DPRINT(Debug,4, (&Debug,"    .... redraw ... list_page\n"));
		    
		    menu_ClearScreen(list_page);  /* Reset redraw flag */
		}		
	    }
	    
	    if (need_redraw) {
		DPRINT(Debug,4, (&Debug,"    .... need redraw menu\n"));
		continue;
	    }
	    
	    if (prompt_line > current_line) {
		
		menu_MoveCursor(page,prompt_line,0);
		menu_CleartoEOLN(page);   /* Clear current answer */

		if (enter_is_confirm) {
		    menu_Write_to_screen(page,
					 CATGETS(elm_msg_cat, MeSet, 
						 MeMailcapEnterConfirm,
						 "Press ENTER to confirm selection and quit menu: "));
		} else if (!pg->selected && list_page && H) {
		     menu_Write_to_screen(page,
					 CATGETS(elm_msg_cat, MeSet, 
						 MeMailcapAskYesNoAct,
						 "Press '%c' for enable or '%c' for disable command activation: "),
					  *def_ans_yes,*def_ans_no);
						           
		} else if (list_page && H) {
		    menu_Write_to_screen(page,
					 CATGETS(elm_msg_cat, MeSet, 
						 MeMailcapSelectDone,
						 "Select mailcap command or d)one: "));
		}
		
		FlushBuffer();
				
		ch = menu_ReadCh(page,REDRAW_MARK|READCH_CURSOR|
				 READCH_resize|READCH_sig_char);

		if (ch == *def_ans_yes && list_page && H)
		    goto list_navigate;
		if (ch == *def_ans_no && list_page && H)
		    goto list_navigate;

		
		switch (ch) {
		case TERMCH_interrupt_char:
		    ret = prompt_mailcap_other_none;
		    goto out;
		    
		case EOF:
		    ret = prompt_mailcap_other_EOF;
		    goto out;

		case 'i':
		    if (ret_ch) {
			*ret_ch = ch;
			ret = prompt_mailcap_other_navigate;
			goto out;
		    }

		    /* FALLTHRU */
		case 'q':
		    menu_Write_to_screen(page,
					 CATGETS(elm_msg_cat, MeSet, 
						 MeMailcapQuit,
						 "Quit"));
		    FlushBuffer();
		    
		    ret = prompt_mailcap_other_none;
		    goto out;

		case RESIZE_MARK:
		    
		    DPRINT(Debug,4, (&Debug,"    .... resizing\n"));
		    goto resize_mark;

		case REDRAW_MARK:
		    DPRINT(Debug,4, (&Debug,"    .... redraw requested\n"));
		    
		    need_redraw = 1;	    		    
		    continue;
		   
		case DOWN_MARK:
		case UP_MARK:
		    if (list_page && H)
			goto list_navigate;

		    if (ret_ch) {
			*ret_ch = ch;
			ret = prompt_mailcap_other_navigate;
			goto out;
		    }
		    break;

		case 'd':
		    menu_Write_to_screen(page,
					 CATGETS(elm_msg_cat, MeSet, 
						 MeMailcapDone,
						 "Done"));
		    FlushBuffer();
		    
		    ret = prompt_mailcap_other_none;
		    goto out;
		    
		default:
		list_navigate:
		    if (list_page && H) {
			int li,co;
			int top     = menu_header_get(list_page,header_top_line);
			int current = menu_header_get(list_page,header_current);
			int bottom  = menu_header_get(list_page,header_bottom_line);
			int len;

			menu_get_sizes(list_page,&li, &co);
			
			if (MIME_selector_magic != H->magic)
			    mime_panic(__FILE__,__LINE__,
				       "prompt_mailcap_other",
				       "Bad magic number (mime_selected_handler)");

			len = H->num_other_entries;

			switch (ch) {
			case '-':
			case LEFT_MARK:
			case PAGEUP_MARK:
			    if (top > 0) {
				enter_is_confirm = 0;
				
				top = menu_header_change_page(list_page,-li);
				if (top < 0)
				    top = 0;
				menu_header_change(list_page, header_top_line,top);

				bottom  = menu_header_get(list_page,header_bottom_line);
				if (current > bottom) {
				    current = bottom;
				    if (current > len-1)
					current = len-1;
				    if (current < 0)
					current = 0;				    
				    menu_header_change(list_page, header_current,current);
				}
				
			    } else if (current > 0) {
				enter_is_confirm = 0;

				menu_header_change(list_page, header_current,0);
			    }
			    break;

			case '+':
			case RIGHT_MARK:
			case PAGEDOWN_MARK:
			    if (bottom < len-1) {
				enter_is_confirm = 0;

				top = menu_header_change_page(list_page,li);

				if (top >= len)
				    top = len -1;
				if (top < 0)
				    top = 0;
				menu_header_change(list_page, header_top_line,top);

				if (current < top)
				    menu_header_change(list_page, header_current,top);
				
			    } else if (current < bottom) {
				enter_is_confirm = 0;
				
				current = bottom;
				if (current >= len)
				    current = len-1;				
				if (current < 0)
				    current = 0;
				
				menu_header_change(list_page, header_current,current);
			    }
			    break;
			    
			case DOWN_MARK:
			    if (current < len-1) {
				enter_is_confirm = 0;

				menu_header_change(list_page, header_current,current+1);
				if (bottom < current+1)
				    menu_header_change(list_page, header_top_line,current+1);
			    } else if (ret_ch) {
				*ret_ch = ch;
				ret = prompt_mailcap_other_navigate;
				goto out;
			    }
			    break;
			case UP_MARK:
			    if (current > 0) {
				enter_is_confirm = 0;

				menu_header_change(list_page, header_current,current-1);
				
				if (top > current-1) {
				    top = menu_header_change_page(list_page,-li);
				    
				    if (current-1 < top)
					top = current-3;
				    
				    if (top < 0)
					top = 0;
				    
				    menu_header_change(list_page, header_top_line,top);
				}

			    } else if (ret_ch) {
				*ret_ch = ch;
				ret = prompt_mailcap_other_navigate;
				goto out;
			    }
			    break;
			case '\n':
			    if (H->other_entries) {

				if (current >= 0 && current <  H->num_other_entries) {
				    
				    if (H->entry == H->other_entries[current]) {
					
					if (pg->selected && enter_is_confirm) {
					
					    goto out;
					} else {
					    if (! pg->selected) {
						pg->selected = 1;
						
						/* need redraw header */
						need_redraw = 1;
					    }
					    
					    enter_is_confirm = 1;
					}
					    
				    } else {
					goto change_entry;
				    }
				    
				} else
				    goto out;
				
			    } else
				goto out;
			    break;

			case ' ':
			change_entry:
			    
			    if (H->other_entries) {
			    
				int old = -1;
				int i;

				if (' ' == ch)
				    enter_is_confirm = 0;
				
				for (i = 0; i < H->num_other_entries; i++) {
				    if (H->other_entries[i] == H->entry)
					old = i;
				}

				if (current >= 0 && current <  H->num_other_entries) {

				    if (H->entry != H->other_entries[current]) {
					char * cmd = NULL;
					int IS_OK = 0;
					
					H->entry = H->other_entries[current];
					
					/* Not really needed */
					if (old >= 0)
					    menu_header_status_update(list_page,old);
					menu_header_status_update(list_page,current);
					
					/* need redraw header */
					need_redraw = 1;
					
					cmd = check_mailcap_view_cmd(pg->structure,&IS_OK);
					
					if (pg->printable_command)
					    free(pg->printable_command);
					pg->printable_command = cmd;
					
					if (IS_OK) {
					    pg->selected  = 1;
					    H->use_entry = 1;

					    if ('\n' == ch)
						enter_is_confirm = 1;				
					}

					
				    } else if (' ' == ch) { /* Condition not really needed */
					/* need redraw header */
					need_redraw = 1;
					
					pg->selected  = 1;
					H->use_entry = ! H->use_entry;
				    }
				}								
			    }
			    break;

			default:
			    if (ch == *def_ans_yes) {
				
				/* need redraw header */
				need_redraw = 1;
				
				pg->selected  = 1;
				H->use_entry = 1;

				if (current >= 0 && current <  H->num_other_entries) {
				    enter_is_confirm = H->entry == H->other_entries[current];
				} else
				    enter_is_confirm = 0;
				    
			    } else if (ch == *def_ans_no) {
				
				/* need redraw header */
				need_redraw = 1;
				
				pg->selected  = 1;
				H->use_entry  = 0;

				if (current >= 0 && current <  H->num_other_entries) {
				    enter_is_confirm = H->entry == H->other_entries[current];
				} else
				    enter_is_confirm = 0;
				
			    } else {
			    
				int pos_lin, pos_col;
				
				menu_GetXYLocation(page,&pos_lin,&pos_col);
				
				menu_Write_to_screen(page,
						     FRM("%c??"), 07);
				FlushBuffer();
				if (sleepmsg > 0)
				    error_sleep((sleepmsg + 1) / 2);
				
				menu_MoveCursor(page,pos_lin,pos_col);
				
				menu_CleartoEOLN(page);   
				
			    }
			    
			    break;
			}
			    
		    }


		    break;
		}

	    }
	    
	   	    
	} while(ch || need_redraw);

    }

    out:
    if (list_page)
	erase_menu_context(&list_page);
    	
    erase_menu_context(&page);
    menu_set_default(parent_page);

    DPRINT(Debug,9,(&Debug, "prompt_mailcap_other=%d",ret));
    switch (ret) {
    case prompt_mailcap_other_EOF:  DPRINT(Debug,9,(&Debug, " prompt_mailcap_other_EOF")); break;
    case prompt_mailcap_other_none: DPRINT(Debug,9,(&Debug, " prompt_mailcap_other_none")); break;
    case prompt_mailcap_other_navigate:
	DPRINT(Debug,9,(&Debug, " prompt_mailcap_other_navigate")); break;
    }
    if (ret_ch) {
	DPRINT(Debug,9,(&Debug, "; *ret_ch=%d",
			*ret_ch));

	if (isascii(*ret_ch) && isprint(*ret_ch)) {
	    DPRINT(Debug,9,(&Debug, " '%c'",
			    *ret_ch));
	}
    }    
    DPRINT(Debug,9,(&Debug, "\n"));
    
    return ret;

}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
