static char rcsid[] = "@(#)$Id: alias.c,v 2.7 2018/06/28 07:37:39 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.7 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_mcommon.h"
#include "s_aliases.h"

DEBUG_VAR(Debug,__FILE__,"menu");

#if ANSI_C
#define S_(x) static x;
#else
#define S_(x)
#endif

S_(mc_get_type_common mc_get_type_alias)
static int mc_get_type_alias P_((union mcommon_union *u, int idx));
static int mc_get_type_alias(u,idx)
     union mcommon_union *u; 
     int idx;
{
    struct AliasView *aview = u->alias.aw;
    struct aliasview_record *a = give_alias(aview,idx);
    int r = 0;

    if (a)
	r = aliasview_get_type(a);

    return r;
}


S_(mc_setf_status_common mc_setf_status_alias)
static int mc_setf_status_alias P_((union mcommon_union *u, int idx, 
				    enum status_x t, int stat));
static int mc_setf_status_alias(u,idx, t, stat)
     union mcommon_union *u; 
     int idx;
     enum status_x t;
     int stat;
{
    struct AliasView *aview = u->alias.aw;
    struct aliasview_record *a = give_alias(aview,idx);
    int r = 0;

    if (a) {      
	switch (t) {
	case status_basic:

	    r = aliasview_setf_status(a,stat);
	    break;

	default:
	    /* other status types ignored */
	    break;
	}
	
    }

    return r;
}

S_(mc_get_current_common mc_get_current_alias)
static int mc_get_current_alias P_((union mcommon_union *u));
static int mc_get_current_alias(u)
     union mcommon_union *u; 
{
    struct AliasView *aview = u->alias.aw;

    return get_alias_current(aview);
}


S_(mc_ison_status_common mc_ison_status_alias)
static int mc_ison_status_alias P_((union mcommon_union *u, int idx, 
				    enum status_x t, int stat));
static int mc_ison_status_alias(u,idx, t, stat)
     union mcommon_union *u; 
     int idx;
     enum status_x t;
     int stat;
{
    struct AliasView *aview = u->alias.aw;
    struct aliasview_record  *a = give_alias(aview,idx);
    int r = 0;

    if (a) {
	switch (t) {

	case status_basic:
	    r = aliasview_ison_status(a,stat);
	    break;

	default:
	    /* other status types ignored */
	    break;
	}
    }

    return r;
}


S_(mc_clearf_status_common mc_clearf_status_alias)
static int mc_clearf_status_alias P_((union mcommon_union *u, int idx, 
				      enum status_x t, int stat));
static int mc_clearf_status_alias(u,idx, t, stat)
     union mcommon_union *u; 
     int idx;
     enum status_x t;
     int stat;
{
    struct AliasView *aview = u->alias.aw;
    struct  aliasview_record  *a = give_alias(aview,idx);
    int r = 0;

    if (a) {
	switch (t) {
	case status_basic:

	    r = aliasview_clearf_status(a,stat);
	    break;

	default:
	    /* other status types ignored */
	    break;
	}
    }

    return r;
}

S_(mc_show_status_common mc_show_status_alias)
static char * mc_show_status_alias P_((union mcommon_union *u, int idx));
static char * mc_show_status_alias(u,idx)
     union mcommon_union *u; 
     int idx;
{
    struct AliasView *aview = u->alias.aw;
    struct  aliasview_record  *a = give_alias(aview,idx);
    char * r = "";

    if (a) {       
	r = show_alias_status(a);            
    }

    return r;
}

S_(mc_get_count_common mc_get_count_alias)
static int mc_get_count_alias P_((union mcommon_union *u));
static int mc_get_count_alias(u)
     union mcommon_union *u; 
{
    struct AliasView *aview = u->alias.aw;

    return get_alias_count(aview);
}


S_(mc_get_selected_common mc_get_selected_alias)
static int mc_get_selected_alias P_((union mcommon_union *u));
static int mc_get_selected_alias(u)
     union mcommon_union *u; 
{
    struct AliasView *aview = u->alias.aw;

    return get_alias_selected(aview);
}

S_(mc_set_current_common mc_set_current_alias)
static void mc_set_current_alias P_((union mcommon_union *u, int cur));
static void mc_set_current_alias(u, cur)
     union mcommon_union *u; 
     int cur;
{
    struct AliasView *aview = u->alias.aw;

    set_alias_current(aview,cur);
}


S_(mc_set_selected_common mc_set_selected_alias)
static void mc_set_selected_alias P_((union mcommon_union *u, int cur));
static void mc_set_selected_alias(u, cur)
     union mcommon_union *u; 
     int cur;
{
    struct AliasView *aview = u->alias.aw;

    set_alias_selected(aview,cur);
}


S_(mc_title_common mc_title_alias)
static struct string * mc_title_alias P_((union mcommon_union *u));
static struct string *  mc_title_alias(u)
     union mcommon_union *u; 
{
    return format_string(CATGETS(elm_msg_cat, AliasesSet, 
				 AliasesMode,
				 "Alias mode"));
}

S_(mc_init_common_sep mc_init_alias_sep)
static int mc_init_alias_sep P_((union mcommon_union * u,
				 struct menu_context * page));
static int mc_init_alias_sep(u,page)
     union mcommon_union * u;
     struct menu_context * page;
{
    return 0;
}


S_(mc_common_sepcount mc_alias_sepcount)
static int mc_alias_sepcount P_((union mcommon_union *u));
static int mc_alias_sepcount(u)
     union mcommon_union *u;
{
    return 0;
}

S_(mc_get_common_separator_index mc_get_alias_separator_index)
static int mc_get_alias_separator_index P_((union mcommon_union *u,
					     int idx));
static int mc_get_alias_separator_index(u,idx)
     union mcommon_union *u;
     int idx;
{
    return HEADER_NO_SEPARATOR;
}

static struct mcommon_type  mcommon_alias = {
    MCOMMON_TYPE_magic,
    mc_get_type_alias,
    mc_setf_status_alias,
    mc_get_current_alias,
    mc_ison_status_alias,
    mc_clearf_status_alias,
    mc_show_status_alias,
    mc_get_count_alias,
    mc_matches_alias,
    mc_get_selected_alias,
    mc_set_current_alias,
    mc_set_selected_alias,
    mc_limit_helper_alias,
    mc_limit_print_help_alias,
    mc_limit_print_result_alias,
    mc_match_in_text_alias,
    mc_screen_print_alias_line,
    mc_give_item_alias,
    mc_title_alias,
    mc_screen_print_alias_sepline,
    mc_init_alias_sep,
    mc_alias_sepcount,
    mc_get_alias_separator_index,
    mc_screen_setup_alias_init,
    mc_screen_setup_alias_line
};

void set_mcommon_from_aliasview P_((struct menu_common * m,
				    struct AliasView   * aw
				    ));
void set_mcommon_from_aliasview(m,aw)
     struct menu_common * m; 
     struct AliasView   * aw;
{
    union mcommon_union u;
    
    if (sizeof u != sizeof (*m)) {
	panic("MENU COMMON PANIC",__FILE__,__LINE__,"set_mcommon_from_aliasview",
	      "size mismatch",0);
    }

    u.alias.magic = MENU_COMMON_magic;
    u.alias.mtype = &mcommon_alias;
    u.alias.aw    = aw;

    if (u.gen.mtype != &mcommon_alias) {
	panic("MENU COMMON PANIC",__FILE__,__LINE__,"set_mcommon_from_aliasview",
	      "pointer error",0);
    }

    *m = u.gen;
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
