static char rcsid[] = "@(#)$Id: alias_item.c,v 2.4 2014/11/15 11:00:25 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.4 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                  (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************
 *  Include some miminal code from Elm 2.4 src/alias.c  which have following 
 *  copyright:
 *
 *  The Elm Mail System 
 *
 * 			Copyright (c) 1988-1992 USENET Community Trust
 * 			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/


#include "def_mcommon.h"
#include "s_aliases.h"
#include "s_elm.h"

DEBUG_VAR(Debug,__FILE__,"menu");

const struct string * mc_give_item_alias(I)
     enum mcommon_item I;
{
    static struct string * storage[MCOMMON_ITEM_COUNT] = { NULL };

    if (I < 0 || I >= MCOMMON_ITEM_COUNT)
	panic("MENU COMMON PANIC",__FILE__,__LINE__,"mc_give_item_alias",
	      "bad item",0);

    /* NOTICE: storage pointers are leaked on end of program */
  
    switch(I) {
    case m_item:
      if (! storage[I])
	storage[I] = format_string(CATGETS(elm_msg_cat, AliasesSet, Aliasesitem, 
					   "alias"));
      break;
      
    case m_items:
      if (! storage[I])
	storage[I] = format_string(CATGETS(elm_msg_cat, AliasesSet, Aliasesitems, 
					   "aliases"));
      break;
      
    case m_Item:
      if (! storage[I])
	storage[I] = format_string(CATGETS(elm_msg_cat, AliasesSet, AliasesItem, 
					   "Alias"));
      break;
      
    case m_Items:
      if (! storage[I])
	storage[I] = format_string(CATGETS(elm_msg_cat, AliasesSet, AliasesItems, 
					   "Aliases"));
      break;
      
    case m_Prompt:
      if (! storage[I])
	storage[I] = format_string(CATGETS(elm_msg_cat, AliasesSet, AliasesPrompt, 
					   "Alias: "));
      break;
    case m_no_item:
      if (! storage[I])
	storage[I] = format_string(CATGETS(elm_msg_cat, ElmSet, ElmNoAliases,
					   "No aliases!"));
      break;
	   
    default:
      panic("MENU COMMON PANIC",__FILE__,__LINE__,"mc_give_item_alias",
	    "bad item",0);


    }
 
    if (! storage[I])
      panic("MENU COMMON PANIC",__FILE__,__LINE__,"mc_give_item_mbx",
	    "item not initialized",0);
	
    return storage[I];
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
