static char rcsid[] = "@(#)$Id: mailbox.c,v 2.8 2018/08/15 07:18:02 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.8 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_mcommon.h"
#include "s_elm.h"

DEBUG_VAR(Debug,__FILE__,"menu");

#if ANSI_C
#define S_(x) static x;
#else
#define S_(x)
#endif

S_(mc_get_type_common mc_get_type_mbx)
static int mc_get_type_mbx P_((union mcommon_union *u, int idx));
static int mc_get_type_mbx(u,idx)
     union mcommon_union *u; 
     int idx;
{
    /* messages do not have types */

    return 0;
}


S_(mc_setf_status_common mc_setf_status_mbx)
static int mc_setf_status_mbx P_((union mcommon_union *u, int idx, 
				  enum status_x t, int stat));
static int mc_setf_status_mbx(u,idx, t, stat)
     union mcommon_union *u; 
     int idx;
     enum status_x t;
     int stat;
{
    struct MailboxView *mbxview = u->mbx.mw;
    int r = 0;

    if (mbxview) 
	r = setf_status_message(mbxview,idx,t,stat);
	           
    return r;
}

S_(mc_get_current_common mc_get_current_mbx)
static int mc_get_current_mbx P_((union mcommon_union *u));
static int mc_get_current_mbx(u)
     union mcommon_union *u; 
{
    struct MailboxView *mbxview = u->mbx.mw;

    if (!mbxview)
	return 0;

    return get_current(mbxview);
}


S_(mc_ison_status_common mc_ison_status_mbx)
static int mc_ison_status_mbx P_((union mcommon_union *u, int idx, 
				  enum status_x t, int stat));
static int mc_ison_status_mbx(u,idx, t, stat)
     union mcommon_union *u; 
     int idx;
     enum status_x t;
     int stat;
{
    struct MailboxView *mbxview = u->mbx.mw;
    int r = 0;

    if (mbxview) 
	r = ison_status_message(mbxview,idx,t,stat);
    
    return r;
}


S_(mc_clearf_status_common mc_clearf_status_mbx)
static int mc_clearf_status_mbx P_((union mcommon_union *u, int idx, 
				    enum status_x t, int stat));
static int mc_clearf_status_mbx(u,idx, t, stat)
     union mcommon_union *u; 
     int idx;
     enum status_x t;
     int stat;
{
    struct MailboxView *mbxview = u->mbx.mw;
    int r = 0;

    if (mbxview) 
	r = clearf_status_message(mbxview,idx,t,stat);
   
    return r;
}

S_(mc_show_status_common mc_show_status_mbx)
static char * mc_show_status_mbx P_((union mcommon_union *u, int idx));
static char * mc_show_status_mbx(u,idx)
     union mcommon_union *u; 
     int idx;
{
    struct MailboxView *mbxview = u->mbx.mw;
    char * r = "??";

    if (mbxview) 
	r = show_status_message(mbxview,idx);
    
    return r;
}

S_(mc_get_count_common mc_get_count_mbx)
static int mc_get_count_mbx P_((union mcommon_union *u));
static int mc_get_count_mbx(u)
     union mcommon_union *u; 
{
    struct MailboxView *mbxview = u->mbx.mw;

    if (!mbxview)
	return 0;

    return get_message_count(mbxview);
}

S_(mc_get_selected_common mc_get_selected_mbx)
static int mc_get_selected_mbx P_((union mcommon_union *u));
static int mc_get_selected_mbx(u)
     union mcommon_union *u; 
{
    struct MailboxView *mbxview = u->mbx.mw;

    if (!mbxview)
	return 0;

    return get_selected(mbxview);
}

S_(mc_set_current_common mc_set_current_mbx)
static void mc_set_current_mbx P_((union mcommon_union *u, int cur));
static void mc_set_current_mbx(u, cur)
     union mcommon_union *u; 
     int cur;
{
    struct MailboxView *mbxview = u->mbx.mw;

    if (!mbxview)
	return;

    set_current(mbxview,cur);
}


S_(mc_set_selected_common mc_set_selected_mbx)
static void mc_set_selected_mbx P_((union mcommon_union *u, int cur));
static void mc_set_selected_mbx(u, cur)
     union mcommon_union *u; 
     int cur;
{
    struct MailboxView *mbxview = u->mbx.mw;

    if (!mbxview)
	return;

    set_selected(mbxview,cur);
}

S_(mc_title_common mc_title_mbx)
static struct string * mc_title_mbx P_((union mcommon_union *u));
static struct string *  mc_title_mbx(u)
     union mcommon_union *u; 
{
    struct MailboxView *mbxview = u->mbx.mw;
    
    if (!mbxview) 
	return format_string(CATGETS(elm_msg_cat, ElmSet, 
				     ElmShownTitleNoMailbox,
				     "No mailbox"));

    return mailbox_title(mbxview);
}


S_(mc_init_common_sep mc_init_mbx_sep)
static int mc_init_mbx_sep P_((union mcommon_union * u,
			       struct menu_context * page));
static int mc_init_mbx_sep(u,page)
     union mcommon_union * u;
     struct menu_context * page;
{
    struct MailboxView *mbxview = u->mbx.mw;
    int LINES, COLUMNS;

    menu_get_sizes(page, &LINES, &COLUMNS);

    if (!mbxview)
	return 0;

    return menu_separator_init(mbxview,LINES,COLUMNS);
}


S_(mc_common_sepcount mc_mbx_sepcount)
static int mc_mbx_sepcount P_((union mcommon_union *u));
static int mc_mbx_sepcount(u)
     union mcommon_union *u;
{
    struct MailboxView *mbxview = u->mbx.mw;

    if (!mbxview)
	return 0;
    
    return menu_separator_count(mbxview);
}


S_(mc_get_common_separator_index mc_get_mbx_separator_index)
static int mc_get_mbx_separator_index P_((union mcommon_union *u,
					     int idx));
static int mc_get_mbx_separator_index(u,idx)
     union mcommon_union *u;
     int idx;
{
    struct MailboxView *mbxview = u->mbx.mw;

    if (!mbxview)
	return HEADER_NO_SEPARATOR;
    
    return  get_menu_separator_index(mbxview,idx);
}


static struct mcommon_type  mcommon_mbx = {
    MCOMMON_TYPE_magic,
    mc_get_type_mbx,
    mc_setf_status_mbx,
    mc_get_current_mbx,
    mc_ison_status_mbx,
    mc_clearf_status_mbx,
    mc_show_status_mbx,
    mc_get_count_mbx,
    mc_matches_mbx,
    mc_get_selected_mbx,
    mc_set_current_mbx,
    mc_set_selected_mbx,
    mc_limit_helper_mbx,
    mc_limit_print_help_mbx,
    mc_limit_print_result_mbx,
    mc_match_in_text_mbx,
    mc_screen_print_mbx_line,
    mc_give_item_mbx,
    mc_title_mbx,
    mc_screen_print_mbx_sepline,
    mc_init_mbx_sep,
    mc_mbx_sepcount,
    mc_get_mbx_separator_index,
    mc_screen_setup_mbx_init,
    mc_screen_setup_mbx_line
};

void set_mcommon_from_mbxview P_((struct menu_common * m,
				  struct MailboxView * mw
				  ));
void set_mcommon_from_mbxview(m,mw)
     struct menu_common * m; 
     struct MailboxView * mw;
{
    union mcommon_union u;
    
    if (sizeof u != sizeof (*m)) {
	panic("MENU COMMON PANIC",__FILE__,__LINE__,"set_mcommon_from_mbxview",
	      "size mismatch",0);
    }

    u.mbx.magic = MENU_COMMON_magic;
    u.mbx.mtype = &mcommon_mbx;
    u.mbx.mw    = mw;
    
    if (u.gen.mtype != &mcommon_mbx) {
	panic("MENU COMMON PANIC",__FILE__,__LINE__,"set_mcommon_from_mbxview",
	      "pointer error",0);
    }

    *m = u.gen;
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
