static char rcsid[] = "@(#)$Id: mcommon.c,v 2.7 2018/06/28 07:37:39 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.7 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_mcommon.h"

DEBUG_VAR(Debug,__FILE__,"menu");

static void mcommon_st_to_union P_((struct menu_common *m,
				    union mcommon_union *u));
static void mcommon_st_to_union(m,u)
     struct menu_common *m;
     union mcommon_union *u;
{
    /* Be sure that whole structure is initialized */
    if (sizeof (*u) != sizeof (*m))
	panic("MENU COMMON PANIC",__FILE__,__LINE__,"mcommon_st_to_union",
	      "size mismatch",0);
    u->gen = *m;

    if (u->gen.magic != MENU_COMMON_magic)
	panic("MENU COMMON PANIC",__FILE__,__LINE__,"mcommon_st_to_union",
	      "bad magic",0);

    if (u->gen.mtype->magic != MCOMMON_TYPE_magic)
	panic("MENU COMMON PANIC",__FILE__,__LINE__,"mcommon_st_to_union",
	      "bad type magic",0);

}

int mcommon_get_type(m,idx)
     struct menu_common *m; 
     int idx;
{
    union mcommon_union u;

    mcommon_st_to_union(m,&u);
	
    return u.gen.mtype->mc_get_type_it(&u,idx);
}

int mcommon_setf_status(m,idx, t, stat)
     struct menu_common *m; 
     int idx;
     enum status_x t;
     int stat;
{
    union mcommon_union u;

    mcommon_st_to_union(m,&u);
	
    return u.gen.mtype->mc_setf_status_it(&u,idx,t, stat);
}

int mcommon_get_current(m)
     struct menu_common *m; 
{
    union mcommon_union u;

    mcommon_st_to_union(m,&u);
	
    return u.gen.mtype->mc_get_current_it(&u);
}

int mcommon_ison_status(m,idx, t, stat)
     struct menu_common *m; 
     int idx;
     enum status_x t;
     int stat;
{
    union mcommon_union u;

    mcommon_st_to_union(m,&u);
	
    return u.gen.mtype->mc_ison_status_it(&u,idx,t, stat);
}


int mcommon_clearf_status(m,idx, t, stat)
     struct menu_common *m; 
     int idx;
     enum status_x t;
     int stat;
{
    union mcommon_union u;

    mcommon_st_to_union(m,&u);
	
    return u.gen.mtype->mc_clearf_status_it(&u,idx,t, stat);
}

char * mcommon_show_status(m,idx)
     struct menu_common *m; 
     int idx;
{
    union mcommon_union u;

    mcommon_st_to_union(m,&u);

    return u.gen.mtype->mc_show_status_it(&u,idx);
}

int mcommon_get_count(m)
     struct menu_common *m; 
{
    union mcommon_union u;

    mcommon_st_to_union(m,&u);
	
    return u.gen.mtype->mc_get_count_it(&u);
}


int mcommon_matches(m,idx, meta_pattern)
     struct menu_common *m; 
     int idx;
     struct string * meta_pattern;
{
    union mcommon_union u;

    mcommon_st_to_union(m,&u);
	
    return u.gen.mtype->mc_matches_it(&u, idx, meta_pattern);   
}

int mcommon_get_selected(m)
     struct menu_common *m; 
{
    union mcommon_union u;

    mcommon_st_to_union(m,&u);
	
    return u.gen.mtype->mc_get_selected_it(&u);
}


void mcommon_set_current(m, cur)
     struct menu_common *m; 
     int cur;
{
    union mcommon_union u;

    mcommon_st_to_union(m,&u);
	
    u.gen.mtype->mc_set_current_it(&u, cur);
}

void mcommon_set_selected(m, sel)
     struct menu_common *m; 
     int sel;
{
    union mcommon_union u;

    mcommon_st_to_union(m,&u);
	
    u.gen.mtype->mc_set_selected_it(&u, sel);
}

int mcommon_limit_helper(m,arg,retarr, page)
     struct menu_common *m;
     struct string *arg; 
     int **retarr;
     struct menu_context  *page;
{
    union mcommon_union u;

    mcommon_st_to_union(m,&u);

    return u.gen.mtype->mc_limit_helper_it(&u,arg,retarr, page);
} 

void mcommon_limit_print_help(m,last_selected)
     struct menu_common *m;
     int last_selected;
{
    if (m->magic != MENU_COMMON_magic)
	panic("MENU COMMON PANIC",__FILE__,__LINE__,"mcommom_limit_print_help",
	      "bad magic",0);

    if (m->mtype->magic != MCOMMON_TYPE_magic)
	panic("MENU COMMON PANIC",__FILE__,__LINE__,"mcommom_limit_print_help",
	      "bad type magic",0);

    m->mtype->mc_limit_print_help_it(last_selected);
}

void mcommon_limit_print_result(m)
     struct menu_common *m;
{
    union mcommon_union u;

    mcommon_st_to_union(m,&u);

    u.gen.mtype->mc_limit_print_result_it(&u);
}

enum pattern_result mcommon_match_in_text(m, meta_pattern, page,LOC)
     struct menu_common *m;
     struct string * meta_pattern;
     struct menu_context  *page;
     struct screen_parts *LOC; 
{
    union mcommon_union u;

    mcommon_st_to_union(m,&u);

    return u.gen.mtype->mc_match_in_text_it(&u, meta_pattern, 
					    page, LOC);
}

void mcommon_screen_print_menu_line(m,idx,page,list)
     struct menu_common  * m; 
     int                   idx;
     struct menu_context * page;
     struct menu_param   * list;
{
    union mcommon_union u;

    mcommon_st_to_union(m,&u);

    u.gen.mtype->mc_screen_print_it_line(&u,idx,page,list);
}	

int mcommon_screen_setup_menu_init(m,page,list)
     struct menu_common  * m;
     struct menu_context * page;
     struct menu_param   * list;
{
    union mcommon_union u;
    int r;
    
    mcommon_st_to_union(m,&u);

    r = u.gen.mtype->mc_screen_setup_it_init(&u,page,list);

    return r;
}

void mcommon_screen_setup_menu_line(m,idx,page,list)
     struct menu_common  * m;
     int                   idx;
     struct menu_context * page;
     struct menu_param   * list;
{
    union mcommon_union u;
    
    mcommon_st_to_union(m,&u);
    
    u.gen.mtype->mc_screen_setup_it_line(&u,idx,page,list);
}

void mcommon_screen_print_sep_line(m,sepidx,page,list)
     struct menu_common  * m; 
     int                   sepidx;
     struct menu_context * page;
     struct menu_param   * list;
{
    union mcommon_union u;

    mcommon_st_to_union(m,&u);
   
    u.gen.mtype->mc_screen_print_it_sepline(&u,sepidx,page,list);
}

const struct string * mcommon_give_item(m,I)
     struct menu_common *m;
     enum mcommon_item I;
{
    if (m->magic != MENU_COMMON_magic)
	panic("MENU COMMON PANIC",__FILE__,__LINE__,"mcommon_give_item",
	      "bad magic",0);

    if (m->mtype->magic != MCOMMON_TYPE_magic)
	panic("MENU COMMON PANIC",__FILE__,__LINE__,"mcommon_give_item",
	      "bad type magic",0);

    return m->mtype->mc_give_item_it(I);
}

struct string * mcommon_title(m)
     struct menu_common *m;
{
    union mcommon_union u;

    mcommon_st_to_union(m,&u);

    return u.gen.mtype->mc_title_it(&u);
}

int  mcommon_init_separators(m,page)
         struct menu_common  * m;
	 struct menu_context * page;
{    
    union mcommon_union u;

    mcommon_st_to_union(m,&u);

    return u.gen.mtype->mc_init_it_sep(&u,page);
}

int mcommon_separator_count(m)
         struct menu_common *m;
{
    union mcommon_union u;

    mcommon_st_to_union(m,&u);

    return u.gen.mtype->mc_it_sepcount(&u);
}

int mcommon_get_separator_index(m,idx)
     struct menu_common *m; 
     int idx;
{
    union mcommon_union u;

    mcommon_st_to_union(m,&u);

    return u.gen.mtype->mc_get_it_separator_index(&u,idx);
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
