static char rcsid[] = "@(#)$Id: message_screen.c,v 2.16 2021/01/10 15:47:32 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.16 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 ******************************************************************************
 * Inludes  code from Elm 2.4 src/screen.c which have following copyright:
 *
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 ******************************************************************************
 *  Incorparated Elm 2.5 code from src/screen.c. 
 *  That code was following copyright:
 *
 *  The Elm Mail System
 *
 *                      Copyright (c) 1988-1995 USENET Community Trust
 *                      Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

#include "def_mcommon.h"
#include "s_elm.h"

DEBUG_VAR(Debug,__FILE__,"menu");

static void print_dummy_header_line P_((int message_number,int selected,
					struct menu_context  *page,
					int index_width));
static void print_header_line P_((struct header_rec       * entry,
				  int                       message_number,
				  int                       selected,
				  struct string           * from,
				  int                       really_to,
				  struct menu_context     * page,
				  char                    * status,
				  int                       tagged,
				  const struct address    * usraddr,
				  int                       index_width,
				  const struct today_info * today_info,
				  int                       time_menu_width,
				  int                       size_lines_width,
				  struct MailboxView        *mailbox,
				  int                       mbx_idx
				  ));

void mc_screen_print_mbx_line(u,idx, page,list)
     union mcommon_union * u;
     int                   idx;
     struct menu_context * page;
     struct menu_param   * list;
{
    struct MailboxView *mbxview = u->mbx.mw;
    int index_width      = 3;
    int time_menu_width  = 6;
    int size_lines_width = 4;
    
    if (list) {
	index_width = mp_lookup_integer(list,elm_mp_index_width);
	time_menu_width = mp_lookup_integer(list,elm_mp_time_menu_width);
	size_lines_width = mp_lookup_integer(list,elm_mp_size_with);
    }
    
    DPRINT(Debug,14,(&Debug,
		     " ... mc_screen_print_mbx_line idx #%d index_width %d time_menu_width %d\n",
		     idx,index_width,time_menu_width));
		     
    if (mbxview) {
    
	/* from function show_headers() */
	int current = get_current(mbxview);
	struct header_rec * hdr = give_header(mbxview,idx);
	
	const struct remote_server  * 
	    remote_server = give_message_remote_server(mbxview,idx);
	struct address              * usraddr = NULL;
	int selected = idx == current-1;
	
	if (remote_server)
	    usraddr = give_remote_server_useraddr(remote_server,NULL);
	
	DPRINT(Debug,14,(&Debug,
			 " ... mc_screen_print_mbx_line idx #%d %s %s remote server",
			 idx,
			 selected ? "(selected)" : "",
			 remote_server ? "have" : "no"));
	
	if (usraddr) {
	    const char * usraddr_a  UNUSED_VAROK =  
		address_get_ascii_addr(usraddr);
	    
	    DPRINT(Debug,14,(&Debug, " usraddr=%s\n",
			     usraddr_a ?  usraddr_a : "<NULL>"));
	}
	DPRINT(Debug,14,(&Debug,"\n"));
	
	if (hdr) {
	    char * status = show_status_message(mbxview,idx);
	    struct string * newfrom = NULL;
	    int using_to = DisplayAddress(hdr,&newfrom,usraddr);
	    
	    int tagged = ' ';
	    
	    if (ison_status_message(mbxview,idx,status_basic,TAGGED))
		tagged = '+';
	    else if (ison_status_message(mbxview,idx,status_1,S1_FLAGGED))
		tagged = 'F';
	    else
		tagged = ' ';
	    
	    
	    print_header_line(hdr, idx+1, selected, newfrom, using_to, page,
			      status,tagged,usraddr,
			      index_width,
			      get_today_info(mbxview),
			      time_menu_width,
			      size_lines_width,
			      mbxview,idx			      
			      );
	    free_string(&newfrom);
	} else {		
	    print_dummy_header_line(idx+1,selected, page,index_width);
	}    

	if (usraddr)
	    free_address(& usraddr);
    } else {
	print_dummy_header_line(idx+1,0, page,index_width);
    }
}

void mc_screen_print_mbx_sepline(u,idx,page,list)
     union mcommon_union * u;
     int                   idx;
     struct menu_context * page;
     struct menu_param   * list;
{
    struct MailboxView    * mbxview = u->mbx.mw;
    int index_width      = 3;
    int time_menu_width  = 6;
    
    if (list) {
	index_width      = mp_lookup_integer(list,elm_mp_index_width);
	time_menu_width  = mp_lookup_integer(list,elm_mp_time_menu_width);
    }
    
    DPRINT(Debug,14,(&Debug,
		     " ... mc_screen_print_mbx_sepline idx #%d index_width %d time_menu_width %d\n",
		     idx,index_width,time_menu_width));

    if (mbxview) {
	const struct menu_separator * sep     = give_menu_separator(mbxview,
								    idx);
	
	if (sep) {
	    struct string * buffer = NULL;
	    struct string * buffer2 = NULL;
	    
	    int LINES, COLUMNS;
	    int width = 0;

	    int prefix = 0;
	    
	    if (MENU_SEPARATOR_magic != sep->magic)
		panic("MENU COMMON PANIC",__FILE__,__LINE__,
		      "mc_screen_print_mbx_sepline",
		      "bad magic number ( menu_separator)",0);
	    
	    menu_get_sizes(page, &LINES, &COLUMNS);

	    if (COLUMNS > 20) {
		while (prefix < COLUMNS -20 &&
		       prefix < 6+index_width) {  
		    prefix++;
		    menu_Writechar(page,' ');
		}
	    }
		
	    switch (sep->sep_type) {
	    case sep_none:    break;
		
	    case sep_year:
		buffer = format_string(FRM(" %4d "),
				       sep->sep_value);
		break;
	    case sep_other:
		buffer = format_string(CATGETS(elm_msg_cat, ElmSet, 
					       ElmSepOther,
					       "other "));
		break;
	    case sep_today:
		buffer = format_string(CATGETS(elm_msg_cat, ElmSet, 
					       ElmSepToday,
					       "today "));

	    }
	    
	    if (buffer) {
		int X = 0;
		
		/* clip_from_string updates X */
		buffer2 = curses_printable_clip(buffer,&X,COLUMNS,
						&width,
						COLUMNS-prefix);
		free_string(&buffer);
	    }
	    
	    if (buffer2) {
		int fill = (time_menu_width - width)/2;
		
		menu_StartXX(page,pg_UNDERLINE);

		/* try center it */
		while (width < time_menu_width &&
		       width < COLUMNS-prefix-1 &&
		       fill > 0 ) {
		    menu_Writechar(page,' ');
		    width++;
		    fill--;
		}
		
		menu_Write_to_screen(page,FRM("%S"),buffer2);
		free_string(&buffer2);

		while (width < time_menu_width &&
		       width < COLUMNS-prefix-1) {
		    menu_Writechar(page,' ');
		    width++;
		}
		
		menu_EndXX(page,pg_UNDERLINE);
	    }
	}
    }

    menu_Writechar(page,'\r');
    menu_Writechar(page,'\n');
}

int mc_screen_setup_mbx_init(u,page,list)
     union mcommon_union * u;
     struct menu_context * page;
     struct menu_param   * list;
{
    int r = 0;
    struct MailboxView *mbxview = u->mbx.mw;
    
    if (list) {
	int index_width = 3;

	mp_list_set_integer(list,elm_mp_index_width,index_width);
	
	DPRINT(Debug,14,(&Debug,
			 "mc_screen_setup_mbx_init: index_width %d\n",
			 index_width));
	r = 1;
    }

    if (mbxview) {

	if (message_hdr_setup_init(mbxview,list))
	    r = 1;

    }
    
    DPRINT(Debug,14,(&Debug,
		     "mc_screen_setup_mbx_init=%d\n",r));
    
    return r;
}

void mc_screen_setup_mbx_line(u,idx,page,list)
     union mcommon_union * u;
     int                   idx;
     struct menu_context * page;
     struct menu_param   * list;     
{
    struct MailboxView *mbxview = u->mbx.mw;
    
    if (list) {
	int index_width = mp_lookup_integer(list,elm_mp_index_width);
	
	/* Printed index is idx+1 */
	
	if (idx >= 9999 && index_width < 5) {
	    index_width = 5;
	    mp_list_set_integer(list,elm_mp_index_width,index_width);
	    
	    DPRINT(Debug,14,(&Debug," ... mc_screen_setup_mbx_line idx #%d index_width %d\n",
			     index_width));

	} else if (idx >= 999 &&  index_width < 4) {
	    index_width = 4;
	    mp_list_set_integer(list,elm_mp_index_width,index_width);
	    
	    DPRINT(Debug,14,(&Debug," ... mc_screen_setup_mbx_line idx #%d index_width %d\n",
			     idx,index_width));
	}
    }

    if (mbxview) 
	message_hdr_setup_line(mbxview,idx,list);    
}

static void print_dummy_header_line(message_number,selected,page,
				    index_width)
     int message_number;
     int selected;
     struct menu_context  *page;
     int index_width;
{

    int l;
    int X;
    struct string * buffer = NULL;
    struct string * buffer1 = NULL;
    int LINES, COLUMNS;

    menu_get_sizes(page, &LINES, &COLUMNS);

    if (selected && has_highlighting && ! arrow_cursor) 
	menu_StartXX(page,pg_STANDOUT);

    buffer = format_string(CATGETS(elm_msg_cat, ElmSet, 
				   ElmNotCollected,
				   "%.2s-- %-*d  <--- message not collected --->"),
			   (selected && arrow_cursor)? "->" : "  ",
			   index_width,
			   message_number);
		
    X = 0;

    buffer1 = curses_printable_clip(buffer,&X,COLUMNS,
				    &l,
				    COLUMNS);
    
    free_string(&buffer);

    if (buffer1) {
	menu_Write_to_screen(page,FRM("%S"),buffer1);
	free_string(&buffer1);
    }

    if (selected && !arrow_cursor) {
	while (l < COLUMNS) {
	    menu_Writechar(page,' ');
	    l++;
	}
    }
        
    if (selected && has_highlighting && ! arrow_cursor) 
	menu_EndXX(page,pg_STANDOUT);

    menu_Writechar(page,'\r');
    menu_Writechar(page,'\n');
}

static struct string * mlist_token P_((enum mlist_tokens idx));
static struct string * mlist_token(idx)
     enum mlist_tokens idx;
{
    const struct string * X = NULL;

    if (user_mlist_conf)
	X = get_mlist_token(user_mlist_conf,idx);

    if (!X && system_mlist_conf)
	X = get_mlist_token(system_mlist_conf,idx);

    if (X)
	return format_string(FRM(" %12S/"),X);
    

    switch (idx) {
    case mlist_to_me_token:  
	return format_string(FRM(" ------------/"));
    case mlist_to_many_token:
	return format_string(FRM(" ======------/"));
    case mlist_cc_me_token:
	return format_string(FRM(" ============/"));

    case mlist_TOKEN_COUNT:
	/* Not used */
	break;

    }

    return NULL;
}

#if ANSI_C
static mlist_match_id_f match_list_id;
#endif
static int match_list_id P_((char * list_id,
			     struct list_info *list));
static int match_list_id(list_id,list)
     char * list_id;
     struct list_info *list;
{
    const char * id = get_list_id(list);

    if (!id)
	return  0;
    
    return 0 == strcmp(list_id,id);
}

static struct units {
    unsigned long limit;
    unsigned long div;
    char * unit;
} UNITS[] = {
    {        0L,       1L, ""  },
    {    10000L,    1000L, "k" },
    { 10000000L, 1000000L, "M" },    
};

static  struct units * get_unit P_((const unsigned long value,
				    unsigned long *res));
static  struct units * get_unit(value,res)
     const unsigned long value;
     unsigned long *res;
{
    struct units * ret = NULL;
    int i;
    
    if (res)
	*res = value;

    for (i = 0 ; i < (sizeof UNITS) / sizeof (UNITS[0]); i++) {
	if (UNITS[i].limit <= value) {
	    ret = &UNITS[i];
	    if (res)
		*res = value / UNITS[i].div;
	}	    
    }
    
    return ret;
}

      
void make_size_lines(h,mailbox,mbx_idx)
     struct header_rec  * h;
     struct MailboxView * mailbox;
     int                  mbx_idx;
{
    if (h->size_lines_s)
	free_string(& h->size_lines_s);

    if (h->lines < 0) {
	unsigned long msg_size = 0;
	if (give_message_menu_size(mailbox,mbx_idx,&msg_size)) {
	    unsigned long res = msg_size;
	    struct units *u = get_unit(msg_size,&res);

	    if (u) {
		h->size_lines_s = format_string(FRM("[%lu%sB]"),
						res,u->unit);
	    } else {
		h->size_lines_s = format_string(FRM("[%luB]"),msg_size);
	    }

	} else
	    h->size_lines_s = format_string(FRM("(?)"));
    } else {
	unsigned long res = h->lines;
	struct units *u = get_unit((unsigned long)h->lines,&res);

	if (u) {
	    h->size_lines_s = format_string(FRM("(%d%s)"),
					    res,u->unit);

	} else {
	    h->size_lines_s = format_string(FRM("(%d)"),
					    h->lines);
	}
    }
}
     
static void print_header_line(entry,message_number,selected,from,really_to,
			      page,status,tagged,usraddr,index_width,today_info,
			      time_menu_width, size_lines_width,mailbox,
			      mbx_idx
			      )
     struct header_rec       * entry;
     int                       message_number; 
     int                       selected;
     struct string           * from;
     int                       really_to;
     struct menu_context     * page;
     char                    * status;
     int                       tagged;
     const struct address    * usraddr;   /* from address from hashmark */
     int                       index_width;
     const struct today_info * today_info;
     int                       time_menu_width;
     int                       size_lines_width;
     struct MailboxView      * mailbox;
     int                       mbx_idx;
{
    /** Print in buffer the message header ... entry is the current
	message entry, 'from' is a modified (displayable) from line, 
	'highlight' is either TRUE or FALSE, and 'message_number'
	is the number of the message.
    **/
	
    int who_width = 18, subj_width = 0;
    int header_without_subj_width;

    struct string * buffer = NULL;
    struct string * buffer1 = NULL;
    struct string * bufferwho = NULL;
    struct string * list_buffer = NULL;
    int X,len1,fill_len;
    int was_len;
    int LINES, COLUMNS;


    enum list_mode {
	lm_unknown,
	lm_myself_to,
	lm_myself_cc,
	lm_list_id,
	lm_mlist
    } list_mode = lm_unknown;

    int other_seen = 0;  /* if other than sender or reader
			    seen on address headers 
			 */

    const struct mlist_info * mlist = NULL;
    
    int  use_year_or_time = dt_flag_is_set(&mail_menu_time,mmtime_year_time_flag);
    enum time_menu_mode mode =
	use_year_or_time ? time_menu_month_day_year : time_menu_month_day;
    
    DPRINT(Debug,25,(&Debug,"print_header_line: #%d: from=%S, status=%s\n",
		     message_number,from,status));

    
    if (today_info) {
	int   use_today = 0;
	
	short this_year = 0;
	
	if (TODAY_INFO_magic != today_info->magic)
	    panic("MENU COMMON PANIC",__FILE__,__LINE__,"print_header_line",
		  "Bad magic number (today_info)",0);

	use_today        = dt_flag_is_set(&mail_menu_time,mmtime_today_flag);	
	    
	this_year = today_info->tm_year+1900;

	if ( !entry->time_menu_year ||
	     this_year == entry->time_menu_year) {	
	    if (use_today)
		mode = use_year_or_time ? time_menu_hhmm_or_year : time_menu_hhmm_24hour;
	    else if (use_year_or_time)
		mode = time_menu_month_day_hhmm;
	}
    }

    if (!status)
	status = "??";
    

    /* Check if reader is also on recipient headers */
    if (entry->list_info) {
	list_mode = lm_list_id;
	DPRINT(Debug,25,(&Debug,"print_header_line: #%d: have list_info\n",
			 message_number));
    }


    if (entry->cc) {
	int i, len = addr_list_item_count(entry->cc);

	for (i = 0; i < len; i++) {
	    int g = -1;
	    const struct address * address = 
		addr_list_get_item(entry->cc,i,&g);

	    
	    if (!okay_address_l(address,NULL,usraddr)) {
		list_mode = lm_myself_cc;
		DPRINT(Debug,25,(&Debug,"print_header_line: #%d: self on cc\n",
				 message_number));
	    }

	    
	    if (okay_address_l(address,entry->from,usraddr))
		other_seen++;
	}
    }


    if (entry->to) {
	int i, len = addr_list_item_count(entry->to);


	for (i = 0; i < len; i++) {
	    int g = -1;
	    const struct address * address = 
		addr_list_get_item(entry->to,i,&g);

	    if (!okay_address_l(address,NULL,usraddr)) {
		list_mode = lm_myself_to;
		DPRINT(Debug,25,(&Debug,"print_header_line: #%d: self on to\n",
				 message_number));
	    }	    
		       
	    if (okay_address_l(address,entry->from,usraddr))
		other_seen++;
	}
    }

    if (list_mode  == lm_unknown ||
	lm_list_id == list_mode) {

	struct mlist_scan * X1 = NULL;

	if (user_mlist_conf) 
	    X1 = mlist_get_matches(user_mlist_conf,entry,match_list_id);

	if (system_mlist_conf) {
	    struct mlist_scan * X2 = mlist_get_matches(system_mlist_conf,
						       entry,match_list_id);

	    if (X1) {
		append_mlist_scan(X1,X2);
		free_mlist_scan(&X2);
	    } else
		X1 = X2;
	}
	
	if (X1) {
	    mlist = get_mlist_info(X1);

	    if (mlist) {
		list_mode = lm_mlist;

		DPRINT(Debug,25,(&Debug,"print_header_line: #%d: on mlist\n",
				 message_number));
	    }

	    free_mlist_scan(&X1);
	}
    }

    DPRINT(Debug,25,(&Debug,"print_header_line: #%d: list_mode=%d",
		     message_number,list_mode));
    switch(list_mode) {
    case lm_unknown:    DPRINT(Debug,25,(&Debug," lm_unknown"));     break;
    case lm_myself_to:  DPRINT(Debug,25,(&Debug," lm_myself_to"));   break;
    case lm_myself_cc:  DPRINT(Debug,25,(&Debug," lm_myself_cc"));   break;
    case lm_list_id:    DPRINT(Debug,25,(&Debug," lm_list_id"));     break;
    case lm_mlist:      DPRINT(Debug,25,(&Debug," lm_mlist"));       break;
    }
    DPRINT(Debug,25,(&Debug,"\n"));


    if (show_mlists) {
	const int MLIST_LEN = 12;

	/* 1) Just to me or to sender only */

	if (lm_myself_to == list_mode &&
	    0 == other_seen)
	    list_buffer = mlist_token(mlist_to_me_token);

	
	/* 2) to me and others */

	else if (lm_myself_to == list_mode)
	    list_buffer = mlist_token(mlist_to_many_token);


	/* 3) cc to me */

	else if (lm_myself_cc == list_mode)
	    list_buffer = mlist_token(mlist_cc_me_token);

	/* 4) mailing list post */
	
	else if (lm_mlist == list_mode) {
	    const struct string * list_phrase = 
		get_mlist_display_name(mlist);

	    if (list_phrase) {
		int X = 0,len1;
		struct string * N = 
		    curses_printable_clip(list_phrase,
					  &X,MLIST_LEN,&len1,MLIST_LEN);

		int fill_len = MLIST_LEN - len1;

		list_buffer = format_string(FRM(" %S%*s/"),
					    N,fill_len,"");

		free_string(&N);

	    } else
		goto list_name_failed;

	} else if (lm_list_id == list_mode) {
	    const struct string * list_phrase = 
		get_list_phrase(entry->list_info);
	    const char * list_id = 
		get_list_id(entry->list_info);

	    
	    if (list_phrase) {
		int X = 0,len1;
		struct string * N = 
		    curses_printable_clip(list_phrase,
					  &X,MLIST_LEN,&len1,MLIST_LEN);

		int fill_len = MLIST_LEN - len1;

		list_buffer = format_string(FRM(" %S%*s/"),
					    N,fill_len,"");

		free_string(&N);

	    } else if (list_id) {
		/* FIXME?  DO not take account header charset */
		list_buffer = format_string(FRM(" %*.*s/"),
					    -MLIST_LEN,MLIST_LEN,
					    list_id);

	    } else 
		goto list_name_failed;

	   
	/* 5) Show To: -header */

	} else {
	list_name_failed:
	    if (really_to) {
		/* If we are idplaying anyway To -address, do not display
		   it twice 
		*/
	    
		list_buffer = new_string(display_charset);
		who_width += MLIST_LEN +2;

	    } else if (entry->to) {
	    
		int  len = addr_list_item_count(entry->to);

		if (1 == len) {
		    int g;
		    const struct address * address = 
			addr_list_get_item(entry->to,0,&g);
		    const char * addr =
			address_get_ascii_addr(address);
		    const struct string * fullname =
			address_get_phrase(address);

		    if (fullname &&
			string_len(fullname) > 0) {
			int X = 0,len1;
			struct string * N = 
			    curses_printable_clip(fullname,
						  &X,MLIST_LEN-2,&len1,MLIST_LEN-2);
			
			int fill_len = MLIST_LEN - len1 -2;
			
			list_buffer = format_string(FRM(" (%S%*s)/"),
						N,fill_len,"");
		    
			free_string(&N);
		    } else if (addr) {
		    
			/* FIXME?  DO not take account header charset */
			list_buffer = format_string(FRM(" (%*.*s)/"),
						    -MLIST_LEN+2,
						    MLIST_LEN-2,
						    addr);
		    } else
			goto to_failure;
		} else
		    goto to_failure;
	    }

	    /* 6) No To: -header or number of addresses != 1 */
	    else {
	    to_failure:

		list_buffer = format_string(FRM(" ***         /"));

	    }

	}

    } else {

	/* 1) Just to me or to sender only */

	if (lm_myself_to == list_mode &&
	    0 == other_seen)
	    list_buffer = format_string(FRM(" %c"),
					to_chars[0] ? 
					to_chars[0] :
					DEFAULT_TO_CHARS[0]);
	
	/* 2) to me and others */
	else if (lm_myself_to == list_mode)
	    list_buffer = format_string(FRM(" %c"),
					to_chars[1] ? 
					to_chars[1] :
					DEFAULT_TO_CHARS[1]);
	
	/* 3) cc to me */

	else if (lm_myself_cc == list_mode ) 
	    list_buffer = format_string(FRM(" %c"),
					to_chars[2] ? 
					to_chars[2] :
					DEFAULT_TO_CHARS[2]);


	/* 4) mailing list post */	
	else if (lm_list_id == list_mode ||
		 lm_mlist == list_mode)
	    list_buffer = format_string(FRM(" %c"),
					to_chars[4] ? 
					to_chars[4] :
					DEFAULT_TO_CHARS[4]);

	/* 5) unknown */	
	else
	    list_buffer = format_string(FRM(" %c"),
					to_chars[3] ? 
					to_chars[3] :
					DEFAULT_TO_CHARS[3]);
    }

    menu_get_sizes(page, &LINES, &COLUMNS);


    /* truncate 'from' to 18 characters -
     * this includes the leading "To" if really_to is true.
     */
	
    if (! entry->time_menu_s ||
	mode != entry->time_menu_type)
	make_menu_date(entry,mode,today_info); 

    /* show "To " in a way that it can never be truncated. */
    if (really_to) {
	who_width -= 3;
    }

    if (selected && has_highlighting && ! arrow_cursor) 
	menu_StartXX(page,pg_STANDOUT);

    X = 0;
    bufferwho = curses_printable_clip(from,&X,who_width,&len1,who_width);

    if (!bufferwho) {
	bufferwho = new_string(display_charset);
	fill_len = who_width;
    } else
	fill_len = who_width - len1;

    if (fill_len < 0)
	fill_len = 0;

    if (! entry->size_lines_s)
	make_size_lines(entry,mailbox,mbx_idx);
    
    buffer = format_string(FRM("%.2s%.2s%c%-*d %-*S%S %.3s%S%*s %-*S "),
			   (selected && arrow_cursor)? "->" : "  ",
			   status,
			   tagged,
			   index_width,
			   message_number,
			   time_menu_width,
			   entry->time_menu_s,
			   list_buffer,
			   (really_to ? "To " : ""),
			   /* give max and min width parameters for 'from' */
			   bufferwho,
			   
			   fill_len,"",
			   size_lines_width,
			   entry->size_lines_s);
    free_string(&bufferwho);
    free_string(&list_buffer);

    DPRINT(Debug,25,(&Debug,"print_header_line: #%d: buffer=%S\n",
		     message_number,buffer));

    X = 0;
    /* clip_from_string updates X */
    buffer1 = curses_printable_clip(buffer,&X,COLUMNS,
				    &header_without_subj_width,
				    COLUMNS);

    free_string(&buffer);


    /* Max printable width of subject -- note that
       this may be longer than number of characters
       on line -- we can't use string_len as subj_width
       because some characters may consume several positions
       (double width characters)
    */
    subj_width = COLUMNS-header_without_subj_width;

    if (buffer1) {
	menu_Write_to_screen(page,FRM("%S"),buffer1);
	free_string(&buffer1);
    }

    /* complete line with subject. */
    if (subj_width > 0 && entry->subject) {
	struct string * buffer2 = NULL;

	X = 0;
	/* clip_from_string updates X */
	buffer2 = curses_printable_clip(entry->subject,&X,subj_width,
					&was_len,subj_width);

	if (buffer2) {
	    menu_Write_to_screen(page,FRM("%S"),buffer2);
	    free_string(&buffer2);
	}

    } else if (subj_width > 0 && 0 != (entry->status1 & S1_NODATA)) {
	struct string * message =
	    format_string(CATGETS(elm_msg_cat, ElmSet, 
				  ElmNotCollected1,
				  "<--- message not collected --->"));
	struct string * buffer2 = NULL;
	
	X = 0;
	/* clip_from_string updates X */
	buffer2 = curses_printable_clip(message,&X,subj_width,
					&was_len,subj_width);

	if (buffer2) {
	    menu_Write_to_screen(page,FRM("%S"),buffer2);
	    free_string(&buffer2);
	}
	
	free_string(&message);
			  
    } else
	was_len = 0;   /* No subject ? */

    /* If it is highlighted but not with the arrow  cursor,
     * expand subject to fit so that the reverse video bar extends
     * aesthetically the full length of the line.
     */
    if (selected && !arrow_cursor) {
	while (was_len < subj_width) {
	    menu_Writechar(page,' ');
	    was_len++;
	}
    }
        
    if (selected && has_highlighting && ! arrow_cursor) 
	menu_EndXX(page,pg_STANDOUT);

    menu_Writechar(page,'\r');
    menu_Writechar(page,'\n');
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
