static char rcsid[] = "@(#)$Id: motion.c,v 2.11 2018/06/27 13:55:50 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.11 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                  (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************
 *  Based on Elm 2.4 src/elm.c. That code have following copyright:
 *
 *  The Elm Mail System 
 *
 * This file and all associated files and documentation:
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************
 *  Incorparated Elm 2.5 code from src/elm.c. 
 *  That code have following copyright:
 *
 *  The Elm Mail System
 *
 * This file and all associated files and documentation:
 *                      Copyright (c) 1988-1995 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *
 *****************************************************************************/

#include "def_elm.h"
#include "s_elm.h"


DEBUG_VAR(Debug,__FILE__,"motion");

/* Return key if unknown */
int motion(ch,mc, LOC,  page, menu_cmds)
     int ch;
     struct menu_common *mc;    
     struct screen_parts *LOC;
     struct menu_context  *page;
     struct elm_commands *menu_cmds;
{
    /* Consolidated the standard menu navigation and delete/tag
     * commands to a function.                                   */

    int  i;

    int current = mcommon_get_current(mc);

    switch (ch) {

	case HELP_MARK:
        case '?'        : 
	    if (menu_cmds) {
		int X =  help_generic(menu_cmds,FALSE, page, LOC->prompt_page);
		
		if (EOF == X) {
		    return EOF;
		    /* Read failed, control tty died? */		
		}

		break;
	    }
	    return ch;  /* Unknown command */

	case FIND_MARK:
	case '/'    :  /* scan mbox or aliases for string */
	    if  (mcommon_get_count(mc) < 1) {
		lib_error(CATGETS(elm_msg_cat, ElmSet,
				  ElmNoItemToScan, "No %S to scan!"), 
			  mcommon_give_item(mc,m_items));
			
	    }
	    else {
		enum pattern_result x = pattern_match(mc, page, LOC);
		
		switch (x) {
		case pattern_eof:
		    return EOF;   /* ERROR */

		case  pattern_intr:
		    break;
		
		case pattern_found:
		    current = mcommon_get_current(mc);
		    get_page(mc, LOC->header_page);
		    break;
		
		case pattern_not_found:
		    lib_error(CATGETS(elm_msg_cat, ElmSet, 
				      ElmPatternNotFound,
				      "pattern not found!"));
		    break;
		}
	    }
	    break;


	case PAGEDOWN_MARK :
	case RIGHT_MARK :
	case '+'	:  {
	    int selected = mcommon_get_selected(mc);
	    int top      = menu_header_get(LOC->header_page,header_top_line);
	    int li,co;

	    menu_get_sizes(LOC->header_page, &li, &co);   

	    /* move to next page if we're not on the last */
	    
	    if ((selected && (top+li < selected))
		||
		(!selected && (top+li < mcommon_get_count(mc)))) {

		top =  menu_header_change_page(LOC->header_page,li);
		
		if(move_when_paged) {
		    /* move to first message of new page */
		    if(selected)
			current = visible_to_index(top+1,mc) + 1;
		    else
			current = top+1;
		    
		    mcommon_set_current(mc,current);
		    menu_header_change(LOC->header_page, 
				       header_current,top);
		}
	    } else
		lib_error(CATGETS(elm_msg_cat, ElmSet, 
				  ElmAlreadyOnLastPage,
				  "Already on last page."));
	}
	    break;

	case PAGEUP_MARK :
	case LEFT_MARK  :
	case '-'	:  {
	    int selected = mcommon_get_selected(mc);
	    int top      = menu_header_get(LOC->header_page,header_top_line);
	    int li,co;

	    menu_get_sizes(LOC->header_page, &li, &co);   
		
	    /* move to prev page if we're not on the first */
	    if(top > 0) {

		top =  menu_header_change_page(LOC->header_page,-li);

		if(move_when_paged) {
		    /* move to first message of new page */
		    if(selected)
			current = visible_to_index(top + 1, mc) + 1;
		    else
			current = top + 1;
		    mcommon_set_current(mc,current);
		    menu_header_change(LOC->header_page, 
				       header_current,top);
		}
	    } else
		lib_error(CATGETS(elm_msg_cat, ElmSet, 
				  ElmAlreadyOnFirstPage,
				  
				  "Already on first page."));
	}
	    break;

	case HOME_MARK:
	case '='    :  {
	    int selected = mcommon_get_selected(mc);
	    
	    if (selected)
		current = visible_to_index(1,mc)+1;
	    else
		current = 1;
	    mcommon_set_current(mc,current);
	    menu_header_change(LOC->header_page, header_current,0);
	    
	    get_page(mc, LOC->header_page);
	}
	    break;
	    
	case END_MARK:
	case '*'    :  {
	    int selected = mcommon_get_selected(mc);
	    
	    if (selected) {
		current = (visible_to_index(selected,mc)+1);
	    } else {
		current = mcommon_get_count(mc);
	    }
	    
	    mcommon_set_current(mc,current);
	    copy_current(mc,LOC->header_page);
	    
	    get_page(mc, LOC->header_page);
	}
	    break;
	    
    case EOF    : return EOF;   /* ERROR */


    case ctrl('D') :
    case '^'    :
    case 'd'    :
    case DELETE_MARK:
	    if (mcommon_get_count(mc) < 1) {
		lib_error(CATGETS(elm_msg_cat, ElmSet, 
				  ElmNoItemToDelete,
				  "No %S to delete!"), 
			  mcommon_give_item(mc,m_item));
		
	    } else {

		if (DELETE_MARK == ch) 
		    ch = 'd';     /* Translate */

		if(ch == ctrl('D')) {
		    
		    /* if current item did not become deleted,
		     * don't to move to the next undeleted item */
		    if(!meta_match(DELETED, mc, page, LOC)) 
			break;
		    
		} else
		    delete_msg((ch == 'd'), mc, LOC);
		
		/* If given '^' command (toggle delete flag)
		   go to next command regagdles is next command
		   marked for deletion or not on resolve mode.
		   In other words works same way than u)undelete
		   command works.
		*/
		
		if (resolve_mode) 	/* move after mail resolved */
		    if((i=next_message(current-1, 
				       (ch == 'd') ? TRUE : FALSE,
				       mc)) != -1) {
			
			current = i+1;
			mcommon_set_current(mc,current);
			copy_current(mc,LOC->header_page);
			
			get_page(mc, LOC->header_page);
		    }
	    }
	    break;
	    
    case 'F': {    /* Actually this works only for messages
		    * and not aliases
		    */
	if (mcommon_get_count(mc) < 1) {
	    lib_error(CATGETS(elm_msg_cat, ElmSet, 
			      ElmNoItemToFlag,
			      "No %S to flag!"), 
		      mcommon_give_item(mc,m_items));
	    
	} else 
	    flag_message(mc, LOC->header_page); 
    }
    break;


    case 'H'    : {
	/* move to first line of page */

	int selected = mcommon_get_selected(mc);
	
	int top      = menu_header_get(LOC->header_page,header_top_line);
	int li,co;

	menu_get_sizes(LOC->header_page, &li, &co);   

	if (selected)
	    current = visible_to_index(top+li,mc) + 1;
	else
	    current = top + 1;

	mcommon_set_current(mc,current);
	
	copy_current(mc,LOC->header_page);
	get_page(mc, LOC->header_page);

    }
	break;


	case 'J'    :  
	    if (current > 0) {
		if((i=next_message(current-1, FALSE,
				   mc)) != -1) {
		    
		    DPRINT(Debug,5,(&Debug,  
				    " current %d => %d\n",
				    current,i+1));
		    
		    current = i+1;
		    mcommon_set_current(mc,current);
		    copy_current(mc,LOC->header_page);
		    
		    get_page(mc, LOC->header_page);
		} else
		    lib_error(CATGETS(elm_msg_cat, ElmSet, 
				      ElmNoMoreItemBelow,
				      "No more %S below."), 
			      mcommon_give_item(mc,m_items));
	    } else 
		lib_error(FRM("%S"),
			  mcommon_give_item(mc,m_no_item));
	    
	    break;	       

next_undel_msg:
	case DOWN_MARK :
	case 'j'    :  
	    if (current > 0) {
		if((i=next_message(current-1, TRUE,
				   mc)) != -1) {
		    
		    DPRINT(Debug,5,(&Debug,  
				    " current %d => %d\n",
				    current,i+1));
		    
		    current = i+1;
		    mcommon_set_current(mc,current);
		    copy_current(mc,LOC->header_page);

		    get_page(mc, LOC->header_page);
		} else
		    lib_error(CATGETS(elm_msg_cat, ElmSet, 
				      ElmNoItemUndeletedBelow,
				      "No more undeleted %S below."), 
			      mcommon_give_item(mc,m_items));
	    } else
		lib_error(FRM("%S"),
			  mcommon_give_item(mc,m_no_item));
		
	    break;
	    
	case 'K'    :  
	    if (current > 0) {
		if((i=prev_message(current-1, FALSE,
				   mc)) != -1) {

		    DPRINT(Debug,5,(&Debug,  
				    " current %d => %d\n",
				    current,i+1));
		    
		    current = i+1;
		    mcommon_set_current(mc,current);
		    copy_current(mc,LOC->header_page);

		    get_page(mc, LOC->header_page);
		} else
		    lib_error(CATGETS(elm_msg_cat, ElmSet, 
				      ElmNoMoreItemAbove,
				      "No more %S above."), 
			      mcommon_give_item(mc,m_items));
	    } else 
		lib_error(FRM("%S"),
			  mcommon_give_item(mc,m_no_item));
	    
	    break;

	case UP_MARK :
	case 'k'    :  
	    if (current > 0) {
		if((i=prev_message(current-1, TRUE, 
				   mc)) != -1) {
		    
		    DPRINT(Debug,5,(&Debug,  
				    " current %d => %d\n",
				    current,i+1));
		    
		    current = i+1;
		    mcommon_set_current(mc,current);
		    copy_current(mc,LOC->header_page);

		    get_page(mc, LOC->header_page);
		} else
		    lib_error(CATGETS(elm_msg_cat, ElmSet, 
				      ElmNoMoreUndeletedAbove,
				      "No more undeleted %S above."), 
			      mcommon_give_item(mc,m_items));
	    } else 
		lib_error(FRM("%S"),
			  mcommon_give_item(mc,m_no_item));
	    
	    break;
	    
    case 'L'    : {
	/* move to last line of page */

	int selected = mcommon_get_selected(mc);
	int count = mcommon_get_count(mc);

	int top      = menu_header_get(LOC->header_page,header_top_line);
	int li,co;
	int last_of_all;

	menu_get_sizes(LOC->header_page, &li, &co);   

	if (selected) {
	    current = visible_to_index(top+li,mc) + 1;
	    last_of_all = visible_to_index(selected,mc) + 1;
	} else {
	    current = top + li;
	    last_of_all = count;
	}

	if (current > last_of_all)
	    current = last_of_all;

	mcommon_set_current(mc,current);
	
	copy_current(mc,LOC->header_page);
	get_page(mc, LOC->header_page);

    }	
	break;

    case 'l'    :  
	    menu_Write_to_screen(LOC->prompt_page,
				 CATGETS(elm_msg_cat, ElmSet,
					 ElmLimitDisplayBy,
					 "Limit displayed %S by..."), 
				 mcommon_give_item(mc,m_items));

	    clear_error();
	    limit(mc, page,LOC);

	    break;
	    

	case ctrl('T') :
	case 'T'       :
	case 't'       :  
	    if (mcommon_get_count(mc) < 1) {
		lib_error(CATGETS(elm_msg_cat, ElmSet, 
				  ElmNoItemToTag,
				  "No %S to tag!"), 
			  mcommon_give_item(mc,m_items));
		
	    } else if (ch == 't')
		tag_message(mc, LOC->header_page); 
	    else if (ch == 'T') {
		tag_message(mc, LOC->header_page); 
		goto next_undel_msg;
	    } else
		meta_match(TAGGED, mc, page, LOC);
	    break;

	case 'u'    :  
	    if (mcommon_get_count(mc) < 1) {
		lib_error(CATGETS(elm_msg_cat, ElmSet, 
				  ElmNoItemToMarkUndeleted,
				  "No %S to mark as undeleted!"), 
			  mcommon_give_item(mc,m_items));
		
	    } else {
		undelete_msg(mc, LOC->header_page);

		if (resolve_mode) 	/* move after mail resolved */
		    if((i=next_message(current-1, FALSE, mc)) != -1) {
				   
			current = i+1;
			mcommon_set_current(mc,current);
			copy_current(mc,LOC->header_page);

			get_page(mc, LOC->header_page);

		    }

/*************************************************************************
 **  What we've done here is to special case the "U)ndelete" command to
 **  ignore whether the next message is marked for deletion or not.  The
 **  reason is obvious upon usage - it's a real pain to undelete a series
 **  of messages without this quirk.  Thanks to Jim Davis @ HPLabs for
 **  suggesting this more intuitive behaviour.
 **
 **  The old way, for those people that might want to see what the previous
 **  behaviour was to call next_message with TRUE, not FALSE.
 **************************************************************************/

	    }
	    break;

	case ctrl('U') : 
	    if (mcommon_get_count(mc) < 1) {
		lib_error(CATGETS(elm_msg_cat, ElmSet, 
				  ElmNoItemToUndelete,
				  "No %S to undelete!"), 
			  mcommon_give_item(mc,m_items));
		
	    } else 
		meta_match(UNDELETE, mc, page, LOC);
	    break;

	case ctrl('L') : 
	    menu_trigger_redraw(page);
	    break;

	case NO_OP_COMMAND : break;	/* noop for timeout loop */

	default	: 
	    if (ch > '0' && ch <= '9') {

		int selected = mcommon_get_selected(mc);

		menu_Write_to_screen(LOC->prompt_page,
				     CATGETS(elm_msg_cat, ElmSet,
					     ElmNewCurrentItem,
					     "New Current %S"), 
				     mcommon_give_item(mc,m_Item));
		
		i = read_number(ch, 
				mcommon_give_item(mc,m_item),
				current, page, LOC->prompt_page);
		
		DPRINT(Debug,5,(&Debug,  
				" current %d => %d (?)\n",
				current,i));
		
		if( i > mcommon_get_count(mc))
		    lib_error(CATGETS(elm_msg_cat, ElmSet, 
				      ElmNotThatMany,
				      "Not that many %S."), 
			      mcommon_give_item(mc,m_items));
		else if(selected
			&& mcommon_isoff_status(mc,i-1,
						status_basic,VISIBLE))
		    lib_error(CATGETS(elm_msg_cat, ElmSet, 
				      ElmNotInLimitedDisplay,
				      "%S not in limited display."),
			      mcommon_give_item(mc,m_Item));
		else {
		    current = i;
		    mcommon_set_current(mc,current);
		    copy_current(mc,LOC->header_page);
		    
		    get_page(mc, LOC->header_page);
		}
		
	    } else {
		return ch;  /* UNKNOWN command */
		
	    }
	    break;
	}

	return 0;   /* COmmand OK */
}


/* Returns enum process_motion_actions or
   key if unknown */

enum process_motion_actions process_motion_command(ch,mc,msg_line)
     int ch;
     struct menu_common *mc; 
     struct string **msg_line;
{
    switch (ch) {
    case 'd' : 
    case DELETE_MARK:
	delete_msg(TRUE, mc, NULL); 
	/* really delete it, silent */
	
	if (! resolve_mode) {
	    if (*msg_line)
		free_string(msg_line);
	    *msg_line =
		format_string(CATGETS(elm_msg_cat, ElmSet, ElmItemMarkedForDeleteion,
				      "%S marked for deletion."),
			      mcommon_give_item(mc,m_Item));
	    
	    
	
	
	} else
	    goto next_undel_msg;

	return motion_done;
	
    next_undel_msg:  	/* a target for resolve mode actions */

    case DOWN_MARK :
    case 'j'    : {
	int current = mcommon_get_current(mc);
	int i;

	if ((i=next_message(current-1, TRUE, mc)) != -1) {

	    current = i+1;
	    mcommon_set_current(mc,current);
	    
	    return motion_view;
	}	
    }
	return motion_exit_loop;
    
    next_msg:
    case 'J': {
	int current = mcommon_get_current(mc);
	int i;
	
	if ((i=next_message(current-1, FALSE, mc)) != -1) {
	    
	    current = i+1;
	    mcommon_set_current(mc,current); 

	    return motion_view;
	}
    }
	return motion_exit_loop;

    case UP_MARK:
    case 'k' : {
	int current = mcommon_get_current(mc);
	int i;
	
	if((i=prev_message(current-1, TRUE, mc)) != -1) {
	    
	    current = i+1;
	    mcommon_set_current(mc,current); 
	    
	    return motion_view; 
	}
    }
	return motion_exit_loop;
	
    case 'K' : {
	int current = mcommon_get_current(mc);
	int i;

	if((i=prev_message(current-1, FALSE, mc)) != -1) {

	    current = i+1;
	    mcommon_set_current(mc,current); 
	    
	    return motion_view; 
	}
    }
	return motion_exit_loop;

    case 'T' :
    case 't' : {
	int istagged=tag_message(mc, NULL);
	
	if (*msg_line)
	    free_string(msg_line);
	
	if (istagged)
	    *msg_line =
		format_string(CATGETS(elm_msg_cat, ElmSet, ElmItemTagged,
				      "%S tagged."),
			      mcommon_give_item(mc,m_Item));
	else 
	    *msg_line =
		format_string(CATGETS(elm_msg_cat, ElmSet, ElmItemUntagged,
				      "%S untagged."),
			      mcommon_give_item(mc,m_Item));
	
	if (ch == 'T')
	    goto next_undel_msg;
    }
	return motion_done;
	
    case 'u' : 
	undelete_msg(mc, NULL); /* undelete it, silently */
	
	if (! resolve_mode) {

	    if (*msg_line)
		free_string(msg_line);	
	    *msg_line =
		format_string(CATGETS(elm_msg_cat, ElmSet, ElmItemUndeleted,
				      "%S undeleted."),
			      mcommon_give_item(mc,m_Item));
		    
	} else {

/******************************************************************************
 ** We're special casing the U)ndelete command here *not* to move to the next
 ** undeleted message ; instead it'll blindly move to the next message in the
 ** list.  See motion() command by "case 'u'" for further information.
 ** The old way was:
 **			 goto next_undel_msg;
 ******************************************************************************/

	    goto next_msg;
	}
	return motion_done;
	
    default:

	return ch;
    }
    
    /* NOT reached */
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
