static char rcsid[] = "@(#)$Id: movement.c,v 2.6 2018/06/27 13:55:50 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.6 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************
 * do_movement() is loosely based on motion() elm elm.c. Code on elm.c was
 * following copyright:
 *
 *  The Elm Mail System 
 *
 * This file and all associated files and documentation:
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

#include "def_elm.h"
#include "s_me.h"

DEBUG_VAR(Debug,__FILE__,"ui");

/* Return key if unknown */
int do_movement(ptr,ch, len,m)
     struct menu_context *ptr;
     int ch;
     int len;
     struct move_messages *m;
{
    /* Somewhat based on motion() from elm.c */

    switch (ch) {
    case DOWN_MARK :
    case 'j'    :  
	ch = 'J';
	break;
	
    case UP_MARK :
    case 'k'     :  
	ch = 'K';
	break;
    }
	
    return do_movement1(ptr,ch, len,m);
}

/* Return key if unknown */

int do_movement1(ptr,ch, len,m)
     struct menu_context *ptr;
     int ch;
     int len;
     struct move_messages *m;
{
    /* Somewhat based on motion() from elm.c */

    int li,co;
    int top     = menu_header_get(ptr,header_top_line);
    int current = menu_header_get(ptr,header_current);

    menu_get_sizes(ptr, &li, &co);   

    switch (ch) {
	/* Move to next page */
    case PAGEDOWN_MARK :
    case '+'	       :  

	if (top+li < len) {

	    top = menu_header_change_page(ptr,li);

	    if(move_when_paged) 
		menu_header_change(ptr,header_current,top);	    
	} else
	    lib_error(CATGETS(elm_msg_cat, MeSet, MeAlreadyOnLastPage,
			      "Already on last page."));
	break;

    case PAGEUP_MARK :
    case '-'         :

	if (top > 0) {

	    top = menu_header_change_page(ptr,-li);

	    if(move_when_paged) 
		menu_header_change(ptr,header_current,top);	    
	} else
	    lib_error(CATGETS(elm_msg_cat, MeSet, 
			      MeAlreadyOnFirstPage,			      
			      "Already on first page."));

	break;
	
    case HOME_MARK:
    case '='      : 

	menu_header_change(ptr, header_top_line,0);
	menu_header_change(ptr, header_current,0);

	break;
	
    case END_MARK:
    case '*'     : 
	menu_header_change(ptr, header_current,len-1);

	if (top+li < len) {
	    top = len -li +1;
	    if (top <0)
		top = 0;
	    menu_header_change(ptr, header_top_line,top);
	}

	break;

    case 'J'    :  

	if (current < len-1) {
	    int bottom     = menu_header_get(ptr,header_bottom_line);
	    
	    menu_header_change(ptr, header_current,current+1);
	    if (bottom < current+1)
		menu_header_change(ptr, header_top_line,current+1);
	} else
	    m->last_item();

	break;

    case 'K'     : 
	if (current > 0) {
	    menu_header_change(ptr, header_current,current-1);

	    if (top > current-1) {
		top = menu_header_change_page(ptr,-li);

		if (current-1 < top)
		    top = current-3;
		
		if (top < 0)
		    top = 0;

		menu_header_change(ptr, header_top_line,top);
	    }
	} else
	    m->first_item();
	
	break;

    default:
	return ch;  /* UNKNOWN command */
    }

    return 0;   /* Command OK */
}


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */


