static char rcsid[] = "@(#)$Id: options.c,v 2.11 2022/07/14 14:16:01 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.11 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *                       (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *           or  Kari Hurtta <elm@elmme-mailer.org>
 ******************************************************************************
 *  Based on Elm 2.4 src/options.c. That code was following copyright:
 *
 *  The Elm Mail System 
 *
 * 			Copyright (c) 1986,1987 Dave Taylor
 * 			Copyright (c) 1988-1992 USENET Community Trust
 *****************************************************************************
 *  Incorparated Elm 2.5 code from src/options.c. 
 *  That code was following copyright:
 *
 *  The Elm Mail System
 *
 * 			Copyright (c) 1986,1987 Dave Taylor
 *                      Copyright (c) 1988-1995 USENET Community Trust
 ****************************************************************************/

/** This set of routines allows the alteration of a number of paramaters
    in the Elm mailer, including the following;


    a)  arrow-cursor	<on or off>
    b)  border for copy <string for left margin>
    c)  calendar-file	<where to put calendar entries>
    d)  display pager	<how to page messages>
    e)  editor		<name of primary editor or "builtin">
    f)  folder-dir	<folder directory>
    h)  hold sent msgs  <on or off>
  * i) (internal: quit to index screen)
    j)  reply editor    <name of editor for replies>
    k)  pause pager     <on or off>
    l)  alias sort      <how to sort the alias display>
    m)  menu-display    <on or off>
    n)  names-only      <on or off>
    o)  sent-mail	<file to save outbound message copies to>
    p)  printmail	<how to print messages>
  * q) (internal: quit to previous screen)
    r)  reply copy      <on or off>
    s)  sort-by		<how to sort folders>
    t)  text editor     <name of ~e editor>
    u)  user-level	<BEGINNER|INTERMEDIATE|EXPERT>
    v)  visual editor	<name of ~v editor>
    w)  want CC prompt  <on or off>
  * x) (internal: exit ELM now)
    y)  full_username	<your full user name for outgoing mail>
    z)  zap sign dashes <on or off>
	
    And others as they seem useful.

    Formatting parameters:

    _)		Add a blank line
    ^)		Put the title on this line

    A subset of the above parameters may be selected as the
    o)ptions screen using the parameter "configoptions" which is
    a string of letters representing the "key" letter for each
    item as listed above.  The current default is "^_cdefsopyv_am_un".
    The order of the options displayed is as listed in the string.

**/

#include "def_elm.h"
#include "rc_imp.h"
#include "save_opts.h"
#include "s_elm.h"
#include "patchlevel.h"

DEBUG_VAR(Debug,__FILE__,"ui");


static int resort = 0;
static int global_setscreen = 0;

static void post_sort P_((int f));
static void post_sort(f)
     int f;
{
    DPRINT(Debug,9, (&Debug, "post_sort(%d)\n",f));

    if (f) {
	
	resort++;
    }

}

static void post_menu P_((int f));
static void post_menu(f)
     int f;
{
    DPRINT(Debug,9, (&Debug, "post_menu(%d)\n",f));

    if (f) {
	
	if (mini_menu_rc != mini_menu) {
	    global_setscreen++;
	    mini_menu = mini_menu_rc;
	} else {
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmMenuChangeF3,
			      "Only (initial) rc value of \"menu\" is changed. F3 key hides or shows mini menu."));
			      
	}
    }

}

static struct OLD_optsmenu cfg_opts_OLD[] = {

    {'a', "A)rrow cursor",	ElmOptionArrowMenu,  "arrow",	NULL,
     "This defines whether the ELM cursor is an arrow or a highlight bar.", ElmOptionArrowHelp,
     NULL
    },

    {'b', "B)order on copy", ElmOptionBorderMenu,	"prefix",	NULL,
     "Left margin string (prefix) for reply and forward.", ElmOptionBorderHelp,
     NULL
    },

    {'c', "C)alendar file", ElmOptionCalendarMenu,	"calendar",	NULL,
     "This is the file where calendar entries from messages are saved.", ElmOptionCalendarHelp,
     &ENABLE_calendar
    },

    {'d', "D)isplay mail using", ElmOptionDisplayMenu,	"pager",  NULL,
     "This is the program invoked to display individual messages (try 'builtin').", 
     ElmOptionDisplayHelp, NULL
    },

    {'e', "E)ditor (primary)", ElmOptionEditorMenu,	"editor",	NULL,
     "This is the editor used for all outbound messages (may be 'builtin').", ElmOptionEditorHelp,
     NULL
    },

    {'f', "F)older directory", ElmOptionFolderMenu,	"maildir",	NULL,
     "This is the folders directory used when '=' (etc) is used in filenames.", 
     ElmOptionFolderHelp, NULL
    },

    {'h', "H)old sent message", ElmOptionHoldMenu,	"copy",		NULL,
     "Whether to save a copy of outbound messages in O)utbound folder.", ElmOptionHoldHelp,
     NULL
    },

    {'j', "J) reply editor", ElmOptionJreplyMenu,	"alteditor",	NULL,
     "This is the editor that will be used for replies (Editor=\"builtin\").", ElmOptionJreplyHelp,
     NULL
    },

    {'k', "K) pause after pager", ElmOptionKpauseMenu, "promptafter",	NULL,
     "Whether to pause (prompt) at end of message with display message pager.", 
     ElmOptionKpauseHelp, NULL
    },

    {'l', "A(l)ias Sorting", ElmOptionaLiasMenu,	"aliassortby",	post_sort,
     "This is used to specify the sorting criteria for the alias display.", ElmOptionaLiasHelp,
     NULL
    },

    {'m', "M)enu display", ElmOptionMenuMenu,	"menu",		post_menu,
     "This determines if you have the mini-menu displayed or not.", ElmOptionMenuHelp,
     NULL
    },

    {'n', "N)ames only", ElmOptionNameMenu,		"names",	NULL,
     "Whether to display the names and addresses on mail, or names only.", ElmOptionNameHelp,
     NULL
    },
    
    {'o', "O)utbound mail saved", ElmOptionOutboundMenu, "sentmail",	NULL,
     "This is where copies of outbound messages are saved automatically.", ElmOptionOutboundHelp,
     NULL
    },

    {'p', "P)rint mail using", ElmOptionPrintMenu,	"print",	NULL,
     "This is the command used to print mail messages.", ElmOptionPrintHelp,
     NULL
    },

    {'r', "R)eply copies msg", ElmOptionReplyMenu,	"autocopy",	NULL,
     "Whether to copy the message being replied to into the reply.", ElmOptionReplyHelp,
     NULL
    },

    {'s', "S)orting criteria", ElmOptionSortMenu,	"sortby",	post_sort,
     "This is used to specify the sorting criteria for the folders.", ElmOptionSortHelp,
     NULL
    },

    {'t', "T)ext editor (~e)", ElmOptionTextMenu,	"easyeditor",	NULL,
     "This is the editor that will be used by the ~e command (Editor=\"builtin\").", 
     ElmOptionTextHelp, NULL
    },

    {'u', "U)ser level", ElmOptionUserMenu,		"userlevel",	NULL,
     "The level of knowledge you have about the ELM mail system.", ElmOptionUserHelp,
     NULL
    },

    {'v', "V)isual Editor (~v)", ElmOptionVisualMenu,	"visualeditor",	NULL,
     "This is the editor that will be used by the ~v command (Editor=\"builtin\").", 
     ElmOptionVisualHelp, NULL
    },

    {'w', "W)ant Cc: prompt", ElmOptionWantMenu,	"askcc",	NULL,
     "Whether to ask for \"Copies to:\" list when sending messages.", ElmOptionWantHelp,
     NULL
    },

    {'y', "Y)our full name", ElmOptionYourMenu,	"fullname",	NULL,
     "When mail is sent out, this is what your full name will be recorded as.", ElmOptionYourHelp,
     NULL
    },

    {'z', "Z) signature dashes", ElmOptionZdashMenu,	"sigdashes",	NULL,
     "Whether to print dashes before including signature on outbound messages.", 
     ElmOptionZdashHelp, NULL
    },
    
    { 0 } 
};

struct optsmenu *cfg_opts = NULL;

void init_opts_menu()
{
    if (cfg_opts)
	panic("RC PANIC",__FILE__,__LINE__,"init_opts_menu",
	      "Double call",0);

    DPRINT(Debug,9, (&Debug, "init_opts_menu: Initializing\n"));


    cfg_opts = malloc_optsmenu();

    add_old_options(cfg_opts,cfg_opts_OLD);

}

void free_opts_menu()
{

    DPRINT(Debug,9, (&Debug, "free_opts_menu: Finishing\n"));

    if (cfg_opts)
	free_optsmenu(& cfg_opts);

}

const struct opts_menu_item * find_cfg_opts(c)
     int c;
{
    return gen_find_cfg_opts(cfg_opts,c);
}


#if ANSI_C
#define S_(x) static x;
#else
#define S_(x)
#endif

S_(option_extra_func option_exit_folder)
static int option_exit_folder P_((struct optsmenu *cfg_opts,
				  struct menu_context *page,
				  int key));
static int option_exit_folder(cfg_opts,page,key)
     struct optsmenu *cfg_opts;
     struct menu_context *page;
     int key;
{
    return 'X';
}

S_(option_extra_func option_return_index)
static int option_return_index P_((struct optsmenu *cfg_opts,
				  struct menu_context *page,
				  int key));
static int option_return_index(cfg_opts,page,key)
     struct optsmenu *cfg_opts;
     struct menu_context *page;
     int key;
{
    return 'i';
}


static struct option_extra *  get_extra_actions P_((void));
static struct option_extra * get_extra_actions() 
{
    struct option_extra * ret = NULL;

    struct option_extra * tmp;

    tmp = alloc_extra_action_f('x',option_exit_folder,
			       CATGETS(elm_msg_cat, ElmSet, 
				       ElmOptionsQuickExitA,
				       "Exit leaving the folder untouched, unconditionally."));

    tmp->next = ret;
    ret = tmp;

    tmp = alloc_extra_action_f('i',option_return_index,
			       CATGETS(elm_msg_cat, ElmSet, 
				       ElmOptionReturnHelp0,
				       "Return to the index screen from option menu."));
    tmp->next = ret;
    ret = tmp;



    return ret;
}



char * level_name(n)
     int n;
{
	/** return the 'name' of the level... **/

	switch (n) {
	  case 0 : return(catgets(elm_msg_cat, ElmSet, ElmBeginningUser,
			"Beginning User   "));
	  case 1 : return(catgets(elm_msg_cat, ElmSet, ElmIntermediateUser,
			"Intermediate User"));
	  default: return(catgets(elm_msg_cat, ElmSet, ElmExpertUser,
			"Expert User      "));
	}
}

int options(mailbox,aview,parent_page,setscreen)
     struct MailboxView *mailbox;
     struct AliasView *aview;
     struct menu_context * parent_page;
     int *setscreen;
{
    static struct elm_commands * STORE = NULL;

    struct elm_commands *cmds = NULL;
    int	ch;

    int last_sortby           = sortby.val;
    int last_alias_sortby     = alias_sortby.val;
    int last_unstable   = unstable_reverse_thread;

   
    struct option_extra * extra_actions = get_extra_actions();

    struct string * title = format_string(CATGETS(elm_msg_cat, ElmSet, 
						  ElmOptionsEditor,
						  "-- ELM Options Editor --"));

    struct string * menu_text = 
	format_string(CATGETS(elm_msg_cat, ElmSet, 
			      ElmSelectOptionLetter,
			      "Select letter of option line, '>' to save, or 'i' to return to index."));


    /** change options... **/
    /* return:
     *	> 0	if resort was done - to indicate we might need to
     *	 	change the page of our headers as a consequence
     *		of the new sort order
     *	< 0	if user entered 'X' to quit elm immediately
     *	0	otherwise
     */
    

    global_setscreen = 0;

    if (!config_options[0]) {
	if (ENABLE_calendar)
	    strfcpy(config_options,"^_cdefsopyv_am_un",
		    sizeof config_options);
	else
	    strfcpy(config_options,"^_defsopyv_am_un",
		    sizeof config_options);
    }

    cmds = 
	give_option_commands(&STORE,cfg_opts, extra_actions,
			     format_string(CATGETS(elm_msg_cat, ElmSet, 
						   ElmOptKeyTitle,
						   "Command")),
			     format_string(CATGETS(elm_msg_cat, ElmSet, 
						   ElmOptActionTitle,
						   "Elm %s PL%s Action"),
					   VERSION,PATCHLEVEL),
			     pg_BOLD,
			     format_string(CATGETS(elm_msg_cat, ElmSet, 
						   ElmOptHelpTitle,
						   "Commands available from the Options Menu in Elm ME+ 2.5")),
			     format_string(CATGETS(elm_msg_cat, ElmSet, 
						   ElmOptQuitHelp,
						   "Return to the index screen.")),
			     config_options);
						   

    resort = 0;

    ch = gen_options(cfg_opts, parent_page, extra_actions,
		     cmds,title,config_options,menu_text);


    free_extra_action_list(&extra_actions);
    free_string(&menu_text);
    free_string(&title);


    if (resort) {

	if (sortby.val != last_sortby ||
	    unstable_reverse_thread != last_unstable) {
	    
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmResortingFolder,
			      "Resorting folder..."));
	    if (sleepmsg > 0) {
		error_sleep((sleepmsg + 1) / 2);
	    }
	    sort_mailbox(get_message_count(mailbox), 0, mailbox);
	    
	    
	    if (unstable_reverse_thread != last_unstable) {
		mark_local_changed(&unstable_reverse_thread,1 /* no history record */);
	    }
	}

	if (alias_sortby.val != last_alias_sortby) {
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmResortingAliases,
			      "Resorting aliases..."));

	    if (sleepmsg > 0) {
		error_sleep((sleepmsg + 1) / 2);
	    }
	    
	    sort_aliases(get_alias_count(aview), sa_silent_sort, aview);
	}
    }


    *setscreen = global_setscreen;


    DPRINT(Debug,9, (&Debug, 
		     "*setscreen=%d, resort=%d\n",
		     *setscreen,resort));

    switch(ch) {
    case EOF:
	free_commands(&cmds);

	leave(0,1); 

	break;

    case 'X' :	
	free_commands(&cmds);

	return(-1);	/* exit elm */

    case 0:
    case 'q' :	/* pop back up to previous level, in this case == 'i' */
    case 'i' :  /* return to index screen */

	free_commands(&cmds);
	return(resort ? 1 : 0);

    }

    DPRINT(Debug,1,(&Debug, 
		    "gen_options returns ch=%d\n",ch));


    panic("RC PANIC",__FILE__,__LINE__,"options",
	  "Bad return value from gen_options()",0);
			     
    free_commands(&cmds);
			     
    return(resort ? 1 : 0);
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
