/* $Id: def_scommon.h,v 2.4 2022/07/14 14:16:01 hurtta Exp $ */

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.4 $   $State: Exp $
 *
 *  Author: Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

struct subpage_common {
    unsigned short magic;            /* MENU_SCOMMON_magic */

    int rel_start_line;
    struct menu_param     * param_ptr; 
};

extern void scommon_zero P_((struct subpage_common *c));
extern void scommon_clear P_((struct subpage_common *c));

extern void calculate_printing_area P_((struct menu_context *ctx));
extern void scommon_relocate P_((struct menu_context  *subpage,
				 struct menu_context  *parent,
				 int rel_start_line,
				 int lines));

#if ANSI_C
#define E_(x) extern x;
#else
#define E_(x)
#endif

E_(w_menu_Writechar scommon_Writechar)
extern void scommon_Writechar P_((struct menu_context * ctx, int ch));

E_(w_menu_PutLineS scommon_PutLineS)
extern void scommon_PutLineS  P_((struct menu_context * ctx,
				  struct string *text));

E_(w_menu_PutLine0 scommon_PutLine0)
extern void scommon_PutLine0 P_((struct menu_context * ctx,
				 int row, int col,
				 const char *line));

E_(w_menu_CleartoEOLN scommon_CleartoEOLN)
extern void scommon_CleartoEOLN P_((struct menu_context * ctx));

E_(w_menu_CleartoEOS scommon_CleartoEOS)
extern void scommon_CleartoEOS P_((struct menu_context * ctx));

E_(w_menu_ReadCh2 scommon_ReadCh2)
extern struct charset_state * scommon_ReadCh2 P_((struct menu_context *ctx,
						  int flags,
						  int break_flag));
	
E_(w_menu_ScreenSize scommon_ScreenSize)
extern void scommon_ScreenSize P_((struct menu_context *ctx,
				   int *lines, int *columns));
				
E_(w_menu_GetXYLocation scommon_GetXYLocation)
extern void scommon_GetXYLocation P_((struct menu_context *ctx,
				      int *row, int *col));

E_(w_menu_ClearScreen scommon_ClearScreen)
extern void scommon_ClearScreen P_((struct menu_context *ctx));

E_(w_menu_MoveCursor scommon_MoveCursor)
extern void scommon_MoveCursor P_((struct menu_context *ctx,
				   int row, int col));

E_(w_menu_changemode scommon_changemode)
extern void scommon_changemode P_((struct menu_context *ctx,
				   int start, int end));

E_(w_menu_SyncEnter scommon_SyncEnter)
extern void scommon_SyncEnter P_((struct menu_context *ctx));

E_(w_menu_SyncLeave scommon_SyncLeave)
extern void scommon_SyncLeave P_((struct menu_context *ctx));

E_(w_menu_resized scommon_resized)
/* called from menu_resized() */
extern void scommon_resized P_((struct menu_context *ctx));

E_(w_menu_calculate_line scommon_calculate_line)
extern void scommon_calculate_line P_((struct menu_context *ctx,
				       int rel_line, int *result));

E_(w_menu_calculate_rline scommon_calculate_rline)
extern int scommon_calculate_rline P_((struct menu_context *ctx,
				       int absline, int *result));

E_(w_menu_get_linelimit scommon_get_linelimit)
extern void scommon_get_linelimit P_((struct menu_context *ctx,
				  int *startline, int *endline));

E_(w_menu_reset_redraw scommon_reset_redraw)
/* called by need_redraw() */
extern void scommon_reset_redraw P_((struct menu_context *ctx));

E_(w_menu_WriteUnicode scommon_WriteUnicode)
extern void scommon_WriteUnicode P_((struct menu_context * ctx, int unicode));


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
