static char rcsid[] = "@(#)$Id: init.c,v 2.5 2014/11/15 11:00:25 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.5 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *                       (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *           or  Kari Hurtta <elm@elmme-mailer.org>
 ******************************************************************************
 * Most of code copied from Elm 2.4 src/init.c. It have following copyright:
 *
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

#include "def_screen.h"

DEBUG_VAR(Debug,__FILE__,"screen");

#include <errno.h>
#ifndef ANSI_C
extern int errno;		/* system error number on failure */
#endif       



char backspace,			/* the current backspace char */
     kill_line,			/* the current kill-line char */
     word_erase,		/* the current word-erase char */
     interrupt_char,		/* the current interrupt char */
     reprint_char,		/* the current reprint-line char */
     eof_char;			/* the current end-of-file char */

char VQUIT_char,                /* the current quit char */
    VSUSP_char,                 /* the current suspend char */
    VSTART_char,                /* The current start character */
    VSTOP_char;                 /* The current stop character */
    

int get_term_chars(fd, term_buffer)
     int fd;
     term_buff *term_buffer;
{
    int ret = 0;
    /** This routine sucks out the special terminal characters
	ERASE and KILL for use in the input routine.  The meaning 
	of the characters are (dare I say it?) fairly obvious... **/
        
    if (tcgetattr(fd,term_buffer) == -1) {
	int err UNUSED_VAROK = errno;

	DPRINT(Debug,3,
	       (&Debug, 
		"Error: %s encountered on ioctl call (get_term_chars, fd=%d)\n", 
		strerror(err), fd));

	/* set to defaults for terminal driver */
	backspace = 010;         /*  backspace */
	kill_line = ctrl('U');
	word_erase = ctrl('W');
	interrupt_char = 0177;	/* DEL */
	reprint_char = ctrl('R');
	eof_char   = ctrl('D');
	VQUIT_char = 034;       /* Ctrl \ */
	VSUSP_char = ctrl('Z');
	VSTART_char = ctrl('Q');
	VSTOP_char  = ctrl('S');
    } else {
	int isset UNUSED_VAROK;

	DPRINT(Debug,4,
	   (&Debug,"get_term_chars(%d): tcgetattr succeed\n",fd));
	
	ret = 1;

#if defined(TERMIO) || defined(TERMIOS)
	backspace = term_buffer->c_cc[VERASE];
	kill_line = term_buffer->c_cc[VKILL];
#if   defined(TERMIOS) && defined(VWERASE)
	word_erase = term_buffer->c_cc[VWERASE];
#else
	word_erase = ctrl('W');
#endif
	interrupt_char = term_buffer->c_cc[VINTR];
#if defined(TERMIOS) && defined(VREPRINT)
	reprint_char = term_buffer->c_cc[VREPRINT];
#else
	reprint_char = ctrl('R');
#endif
	eof_char = term_buffer->c_cc[VEOF];
#else
	backspace = term_buffer->sgttyb.sg_erase;
	kill_line = term_buffer->sgttyb.sg_kill;
#ifdef     TIOCLGET
	word_erase = term_buffer->ltchars.t_werasc;
	reprint_char = term_buffer->ltchars.t_rprntc;
#else
	word_erase = ctrl('W');
	reprint_char = ctrl('R');
#endif
	interrupt_char = term_buffer->tchars.t_intrc;
	eof_char = term_buffer->tchars.t_eofc;
#endif

#if defined(TERMIOS)
	VQUIT_char = term_buffer->c_cc[VQUIT];
	VSUSP_char = term_buffer->c_cc[VSUSP];
	VSTART_char = term_buffer->c_cc[VSTART];
	VSTOP_char  = term_buffer->c_cc[VSTOP];
#else
	VQUIT_char = 034;       /* Ctrl \ */
	VSUSP_char = ctrl('Z');
	VSTART_char = ctrl('Q');
	VSTOP_char  = ctrl('S');
#endif

#ifdef TERMIOS
	
	DPRINT(Debug,4, (&Debug," c_iflag:\n"));

#ifdef IGNBRK
	isset =  term_buffer->c_iflag & IGNBRK;
	DPRINT(Debug,4, (&Debug," - IGNBRK %s\n", isset ? "set" : "not set"));
#endif

#ifdef BRKINT
	isset =  term_buffer->c_iflag & BRKINT;
	DPRINT(Debug,4, (&Debug," - BRKINT %s\n", isset ? "set" : "not set"));
#endif

#ifdef IGNPAR
	isset =  term_buffer->c_iflag & IGNPAR;
	DPRINT(Debug,4, (&Debug," - IGNPAR %s\n", isset ? "set" : "not set"));
#endif

#ifdef PARMRK
	isset =  term_buffer->c_iflag & PARMRK;
	DPRINT(Debug,4, (&Debug," - PARMRK %s\n", isset ? "set" : "not set"));
#endif

#ifdef INPCK
	isset =  term_buffer->c_iflag & INPCK;
	DPRINT(Debug,4, (&Debug," - INPCK %s\n", isset ? "set" : "not set"));
#endif

#ifdef ISTRIP
	isset =  term_buffer->c_iflag & ISTRIP;
	DPRINT(Debug,4, (&Debug," - ISTRIP %s\n", isset ? "set" : "not set"));
#endif

#ifdef INLCR
	isset =  term_buffer->c_iflag & INLCR;
	DPRINT(Debug,4, (&Debug," - INLCR %s\n", isset ? "set" :"not set"));
#endif

#ifdef IGNCR
	isset =  term_buffer->c_iflag & IGNCR;
	DPRINT(Debug,4, (&Debug," - IGNCR %s\n", isset ? "set" : "not set"));
#endif

#ifdef IUCLC
	isset =  term_buffer->c_iflag & IUCLC;
	DPRINT(Debug,4, (&Debug," - IUCLC %s\n", isset ? "set" : "not set"));
#endif

#ifdef IXON
	isset =  term_buffer->c_iflag & IXON;
	DPRINT(Debug,4, (&Debug," - IXON %s\n", isset ? "set" : "not set"));
#endif

#ifdef IXANY
	isset =  term_buffer->c_iflag & IXANY;
	DPRINT(Debug,4, (&Debug," - IXANY %s\n", isset ? "set" : "not set"));
#endif

#ifdef IXOFF
	isset =  term_buffer->c_iflag & IXOFF;
	DPRINT(Debug,4, (&Debug," - IXOFF %s\n", isset ? "set" : "not set"));
#endif

#ifdef IMAXBEL
	isset =  term_buffer->c_iflag & IMAXBEL;
	DPRINT(Debug,4, (&Debug," - IMAXBEL %s\n", isset ? "set" : "not set"));
#endif

#ifdef IUTF8
	isset =  term_buffer->c_iflag & IUTF8;
	DPRINT(Debug,4, (&Debug," - IUTF8 %s\n", isset ? "set" : "not set"));
#endif


	DPRINT(Debug,4, (&Debug," c_oflag:\n"));

#ifdef OPOST
	isset =  term_buffer->c_oflag & OPOST;
	DPRINT(Debug,4, (&Debug," - OPOST %s\n", isset ? "set" : "not set"));
#endif

#ifdef OLCUC
	isset =  term_buffer->c_oflag & OLCUC;
	DPRINT(Debug,4, (&Debug," - OLCUC %s\n", isset ? "set" : "not set"));
#endif

#ifdef ONLCR
	isset =  term_buffer->c_oflag & ONLCR;
	DPRINT(Debug,4, (&Debug," - ONLCR %s\n", isset ? "set" : "not set"));
#endif

#ifdef OCRNL
	isset =  term_buffer->c_oflag & OCRNL;
	DPRINT(Debug,4, (&Debug," - OCRNL %s\n", isset ? "set" : "not set"));
#endif

#ifdef ONOCR
	isset =  term_buffer->c_oflag & ONOCR;
	DPRINT(Debug,4, (&Debug," - ONOCR %s\n", isset ? "set" : "not set"));
#endif

#ifdef ONLRET
	isset =  term_buffer->c_oflag & ONLRET;
	DPRINT(Debug,4, (&Debug," - ONLRET %s\n", isset ? "set" : "not set"));
#endif

#ifdef OFILL
	isset =  term_buffer->c_oflag & OFILL;
	DPRINT(Debug,4, (&Debug," - OFILL %s\n", isset ? "set" : "not set"));
#endif

#ifdef OFDEL
	isset =  term_buffer->c_oflag & OFDEL;
	DPRINT(Debug,4, (&Debug," - OFDEL %s\n", isset ? "set" : "not set"));
#endif


#endif


    }

    DPRINT(Debug,4,
	   (&Debug,"get_term_chars(%d)=%d: \n\
    backspace      %3d\n\
    kill_line      %3d\n\
    word_erase     %3d\n\
    interrupt_char %3d\n\
    reprint_char   %3d\n\
    eof_char       %3d\n\
",
	    fd,
	    ret,
	    backspace,
	    kill_line,
	    word_erase,
	    interrupt_char,
	    reprint_char,
	    eof_char));
    
    return ret;
}

int report_TERMCH_char(key) 
     int key;
{
    switch(key) {
    case TERMCH_backspace:    return backspace;
    case TERMCH_kill_line:    return kill_line;
    case TERMCH_word_erase:   return word_erase;
    case TERMCH_reprint_char: return reprint_char;
    case TERMCH_eof_char:     return eof_char;

    case TERMCH_interrupt_char:  return interrupt_char;

	/* report only */
    case TERMCH_report_VQUIT: return  VQUIT_char; /* actually TERMCH_interrupt_char
						     is returned -- but that can also
						     generate signal
						  */

    case TERMCH_report_VSUSP: return VSUSP_char;
    case TERMCH_report_VSTART: return VSTART_char;
    case TERMCH_report_VSTOP: return VSTOP_char;
    }

    return -1;
}


#if !defined(TERMIO) && !defined(TERMIOS)
int tcgetattr(fd, buf)
     int fd;
     term_buff *buf;
{
    if (ioctl(fd, TIOCGETP, &buf->sgttyb) < 0)
	return(-1);
    if (ioctl(fd, TIOCGETC, &buf->tchars) < 0)
	return(-1);
#ifdef TIOCLGET
    if (ioctl(fd, TIOCLGET, &buf->ltchars) < 0)
	return(-1);
#endif
    return(0);
}
#endif


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
