static char rcsid[] = "@(#)$Id: termcharset.c,v 2.6 2020/01/18 20:07:41 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.6 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                  (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_screen.h"

DEBUG_VAR(Debug,__FILE__,"elmpage");

charset_t target_display_charset = NULL;
screen_info_p  last_display_state = NULL;


charset_t * give_display_charsets(storage,max,maybe_signal)
     charset_t *storage;
     int max;
     int maybe_signal;
{
    int n = 0,i;
    max--;

    storage[n++] = display_charset;

    if (system_charset != display_charset &&
	n < max)
	storage[n++] = system_charset;

    if (allow_charset_switching)
	terminal_can_switch(terminal_type,storage,&n,max,maybe_signal);
    storage[n] = NULL;

    SIGDPRINT(Debug,4,(&Debug, 
		    "Possible sets:"));
    for (i = 0; i < n; i++) {
	const char * MIME_name UNUSED_VAROK = 
	    get_charset_MIME_name(storage[i]);

	SIGDPRINT(Debug,4,(&Debug, 
			" %s%c",
			MIME_name ? MIME_name : "<no MIME name>",
			i < n-1 ? ',' : '\n'));
    }

    return storage;
}


int set_display_charset(set,silent,maybe_signal)
     charset_t set; 
     int silent;
     int maybe_signal;
{   
    const char * MIME_name UNUSED_VAROK = NULL;

    if (!terminal_can_switch_to(terminal_type,set,silent,
				maybe_signal
				))
	return 0;

    target_display_charset = set;

    MIME_name = get_charset_MIME_name(target_display_charset);

    SIGDPRINT(Debug,4,(&Debug, 
		       "set_display_charset: Initializes target_display_charset to %s\n",
		       MIME_name ? MIME_name : ""));


    switch_display_charset(1,maybe_signal);
    return 1;
}

void init_system_charset() 
{
    char *str;

    /* Changes system_charset to type unknown if system supports 
       wide characters and there is DW flag on terminal.info
    */

    DPRINT(Debug,10,(&Debug,
		     "init_system_charset: terminal_type=%s have_DW_characters=%d\n",
		     terminal_type,have_DW_characters));

    terminal_change_system_charset(terminal_type,have_DW_characters);

    target_display_charset = system_charset;
    display_charset        = system_charset;

    if (!last_display_state) {
	DPRINT(Debug,4,(&Debug,
		       "init_system_charset: Creating terminal state\n"));

	last_display_state = create_terminal_info();
    }

    /* if buffer is set to NULL, malloces result */
    str = terminal_set_info(terminal_type,system_charset,
			    last_display_state,have_DW_characters);

    if (str) {

	const char * MIME_name UNUSED_VAROK = 
	    get_charset_MIME_name(system_charset);

	/* NOTE:   Extra initialization is returned only for type
	           ISO2022/DW
	*/

	int i;

	DPRINT(Debug,4,(&Debug, 
			   "init_system_charset: Extra initialization for %s (",
			   MIME_name ? MIME_name : "<no MIME name>"));
	for (i = 0; str[i]; i++) {
	    DPRINT(Debug,4,(&Debug, 
			       "%s%02X",
			       i ? " " : "", str[i]));
	}
	DPRINT(Debug,4,(&Debug,
			   ") for terminal %s\n",terminal_type));
	
	for (i = 0; str[i]; i++) {
	    outchar(str[i]);
	}
	
	free(str);
    } else {
	DPRINT(Debug,4,(&Debug,
			"init_system_charset: No initialization...\n"));
    }
}


/* May be called form signal */
void switch_display_charset(to_display, maybe_signal)
     int to_display;
     int maybe_signal;
{
    char buffer[256];

    charset_t t;
    char * str;
    
    SIGDPRINT(Debug,9,(&Debug,"switch_display_charset: to_display=%d maybe_signal=%d\n",
		       to_display,maybe_signal));

    if (!last_display_state) {

	if (maybe_signal) {
	    SIGDPRINT(Debug,4,(&Debug,
			       "switch_display_charset: terminal state not set, can't allocate on signal handler\n"));
	    return;
	    
	}
	
	SIGDPRINT(Debug,4,(&Debug,
			   "switch_display_charset: Creating terminal state\n"));
       	last_display_state = create_terminal_info();
    }


    
    if (!target_display_charset) {
	const char * MIME_name UNUSED_VAROK = NULL;

	target_display_charset = display_charset;
	MIME_name = get_charset_MIME_name(target_display_charset);

	SIGDPRINT(Debug,4,(&Debug, 
			   "switch_display_charset: Initializes target_display_charset to %s\n",
			   MIME_name ? MIME_name : ""));
    }    




    t = to_display ? target_display_charset : system_charset;
    
    if (!t) {
	SIGDPRINT(Debug,4,(&Debug, 
			   "switch_display_charset: target charset is NULL\n"));
	return;
    }

    str = terminal_switch_to(terminal_type,t,last_display_state,
			     buffer, sizeof buffer, 1,
			     maybe_signal);

    if (str) {
	const char *MIME_name UNUSED_VAROK = get_charset_MIME_name(t);
	int i;

	SIGDPRINT(Debug,4,(&Debug, 
			"Setting display charset to %s (",
			MIME_name ? MIME_name : "<no MIME name>"));
	for (i = 0; str[i]; i++) {
	    SIGDPRINT(Debug,4,(&Debug, 
			    "%s%02X",
			    i ? " " : "", str[i]));
	}
	SIGDPRINT(Debug,4,(&Debug,
		  ") [terminal %s]\n",terminal_type));
	
	for (i = 0; str[i]; i++) {
	    outchar(str[i]);
	}

	display_charset = t;
      
    } else {
	const char * MIME_name UNUSED_VAROK = get_charset_MIME_name(t);

	SIGDPRINT(Debug,4,(&Debug,
			    "No way to set terminal %s to charset %s\n",
			    terminal_type,
			    MIME_name ? MIME_name : "<no MIME name>"));
		  
    }
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
