static char rcsid[] = "@(#)$Id: no_url.c,v 2.6 2020/01/18 20:07:41 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.6 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_url.h"

DEBUG_VAR(Debug,__FILE__,"url");

#define URL_no_url_magic	0xEC05

struct no_url {

    unsigned short        magic;     /* URL_no_url_magic */

    struct string       * stored;
    struct string       * params;
    struct string       * query;

};


#if ANSI_C
#define S_(x) static x;
#else
#define S_(x)
#endif

S_(uh_init_url uh_init_NO_URL)
static void uh_init_NO_URL  P_((struct url *url));
static void uh_init_NO_URL(url)
     struct url *url;
{
    url->u.NO_URL = safe_malloc (sizeof (*  url->u.NO_URL));

    /* bzero is defined hdrs/elm_defs.h */
    bzero((void *)url->u.NO_URL,sizeof (* url->u.NO_URL));

    url->u.NO_URL->magic = URL_no_url_magic;

    url->u.NO_URL->stored = NULL;
    url->u.NO_URL->params = NULL;    
    url->u.NO_URL->query  = NULL;    
}

S_(uh_free_url uh_free_NO_URL)
static void uh_free_NO_URL  P_((struct url *url));
static void uh_free_NO_URL(url)
     struct url *url;
{
    if (URL_no_url_magic != url->u.NO_URL->magic)
	panic("URL PANIC",__FILE__,__LINE__,"uh_free_NO_URL",
	      "bad  magic number",0);

    if (url->u.NO_URL->stored)
	free_string(& (url->u.NO_URL->stored));
    if (url->u.NO_URL->params)
	free_string(& (url->u.NO_URL->params));
    if (url->u.NO_URL->query)
	free_string(& (url->u.NO_URL->query));


    url->u.NO_URL->magic = 0;  /* Invalidate */
    free(url->u.NO_URL);
    url->u.NO_URL = NULL;
}

S_(uh_parse_url_not_path  uh_parse_NO_URL_not_path)
static int uh_parse_NO_URL_not_path  P_((struct url *url, 
					 struct string *scheme_pesifix,
					 struct header_errors **header_error));

static int uh_parse_NO_URL_not_path(url,scheme_pesifix,header_error)
     struct url *url;
     struct string *scheme_pesifix;
     struct header_errors **header_error;
{
    if (URL_no_url_magic != url->u.NO_URL->magic)
	panic("URL PANIC",__FILE__,__LINE__,"uh_parse_NO_URL_not_path",
	      "bad  magic number",0);

    url->u.NO_URL->stored = dup_string(scheme_pesifix);

    return 1;
}

S_(uh_dup_url_not_path uh_dup_NO_URL_not_path)
static int uh_dup_NO_URL_not_path  P_((struct url *url,
				       struct url *source));
static int uh_dup_NO_URL_not_path(url,source)
     struct url *url;
     struct url *source;
{
    if (URL_no_url_magic != url->u.NO_URL->magic)
	panic("URL PANIC",__FILE__,__LINE__,"uh_dup_NO_URL_not_path",
	      "bad  magic number (url)",0);

    if (URL_no_url_magic != source->u.NO_URL->magic)
	panic("URL PANIC",__FILE__,__LINE__,"uh_dup_NO_URL_not_path",
	      "bad  magic number (source)",0);

    if (source->u.NO_URL->stored)
	url->u.NO_URL->stored = dup_string(source->u.NO_URL->stored);

    return 1;
}

S_(uh_parse_url_params uh_parse_NO_URL_params)
static int uh_parse_NO_URL_params  P_((struct url *url, 
				       struct string *scheme_pesifix,
				       struct header_errors **header_error));
static int uh_parse_NO_URL_params(url,scheme_pesifix,header_error)
     struct url *url;
     struct string *scheme_pesifix;
     struct header_errors **header_error;
{
    if (URL_no_url_magic != url->u.NO_URL->magic)
	panic("URL PANIC",__FILE__,__LINE__,"uh_parse_NO_URL_params",
	      "bad  magic number",0);

    url->u.NO_URL->params = dup_string(scheme_pesifix);

    return 1;
}

S_(uh_dup_url_params uh_dup_NO_URL_params)
static int uh_dup_NO_URL_params  P_((struct url *url,
				       struct url *source));
static int uh_dup_NO_URL_params(url,source)
     struct url *url;
     struct url *source;
{
    if (URL_no_url_magic != url->u.NO_URL->magic)
	panic("URL PANIC",__FILE__,__LINE__,"uh_dup_NO_URL_params",
	      "bad  magic number (url)",0);

    if (URL_no_url_magic != source->u.NO_URL->magic)
	panic("URL PANIC",__FILE__,__LINE__,"uh_dup_NO_URL_params",
	      "bad  magic number (source)",0);

    if (source->u.NO_URL->params)
	url->u.NO_URL->params = dup_string(source->u.NO_URL->params);

    return 1;
}

S_(uh_parse_url_query uh_parse_NO_URL_query)
static int uh_parse_NO_URL_query  P_((struct url *url, 
				      struct string *scheme_pesifix,
				      struct header_errors **header_error));
static int uh_parse_NO_URL_query(url,scheme_pesifix,header_error)
     struct url *url;
     struct string *scheme_pesifix;
     struct header_errors **header_error;
{
    if (URL_no_url_magic != url->u.NO_URL->magic)
	panic("URL PANIC",__FILE__,__LINE__,"uh_parse_NO_URL_query",
	      "bad  magic number",0);

    url->u.NO_URL->query = dup_string(scheme_pesifix);

    return 1;
}

S_(uh_dup_url_query uh_dup_NO_URL_query)
static int uh_dup_NO_URL_query  P_((struct url *url,
				       struct url *source));
static int uh_dup_NO_URL_query(url,source)
     struct url *url;
     struct url *source;
{
    if (URL_no_url_magic != url->u.NO_URL->magic)
	panic("URL PANIC",__FILE__,__LINE__,"uh_dup_NO_URL_query",
	      "bad  magic number (url)",0);

    if (URL_no_url_magic != source->u.NO_URL->magic)
	panic("URL PANIC",__FILE__,__LINE__,"uh_dup_NO_URL_query",
	      "bad  magic number (source)",0);

    if (source->u.NO_URL->query)
	url->u.NO_URL->query = dup_string(source->u.NO_URL->query);

    return 1;
}

S_(uh_set_mailing_headers_from_url uh_set_mailing_headers_from_NO_URL)
static int uh_set_mailing_headers_from_NO_URL P_((struct mailing_headers *hdrs,
						  const struct url *url,
						  struct mailer_info 
						  *mailer_info));
static int uh_set_mailing_headers_from_NO_URL(hdrs,url,mailer_info)
     struct mailing_headers *hdrs;
     const struct url *url;
     struct mailer_info  *mailer_info;
{
    return 0;
}


S_(uh_get_body_string_from_url uh_get_body_string_from_NO_URL)
static const struct string * uh_get_body_string_from_NO_URL P_((const struct 
								url *url,
								int *errors));
static const struct string * uh_get_body_string_from_NO_URL(url,errors)
     const struct url *url;
     int *errors;
{
    return NULL;
}


S_(uh_not_path_to_raw_url uh_not_path_to_raw_NO_URL)
static struct string * uh_not_path_to_raw_NO_URL P_((const struct url *url));
static struct string * uh_not_path_to_raw_NO_URL(url) 
     const struct url *url;
{
    if (URL_no_url_magic != url->u.NO_URL->magic)
	panic("URL PANIC",__FILE__,__LINE__,"uh_not_path_to_raw_NO_URL",
	      "bad  magic number",0);

    if (url->u.NO_URL->stored)
	return dup_string(url->u.NO_URL->stored);

    return NULL;
}

S_(uh_params_to_raw_url uh_params_to_raw_NO_URL)
static int uh_params_to_raw_NO_URL P_((const struct url *url, 
				       struct string **result));
static int uh_params_to_raw_NO_URL(url,result)
     const struct url *url; 
     struct string **result;
{
    *result = NULL;

    if (URL_no_url_magic != url->u.NO_URL->magic)
	panic("URL PANIC",__FILE__,__LINE__,"uh_params_to_raw_url",
	      "bad magic number",0);

    if (url->u.NO_URL->params)
	*result = dup_string(url->u.NO_URL->params);

    return 1;
}

S_(uh_query_to_raw_url uh_query_to_raw_NO_URL)
static int uh_query_to_raw_NO_URL P_((const struct url *url, 
				      struct string **result));
static int uh_query_to_raw_NO_URL(url,result)
     const struct url *url; 
     struct string **result;
{
    *result = NULL;

    if (URL_no_url_magic != url->u.NO_URL->magic)
	panic("URL PANIC",__FILE__,__LINE__,"uh_query_to_raw_NO_URL",
	      "bad magic number",0);

    if (url->u.NO_URL->query)
	*result = dup_string(url->u.NO_URL->query);

    return 1;
}

S_(uh_get_folder_from_url uh_get_folder_from_NO_URL)
static struct folder_info * uh_get_folder_from_NO_URL P_((const struct url *url,
				  verify_remote_url_f    * verify_remote,
				  int   * ret_letter /* returns '\0' or EOF */));
static struct folder_info * uh_get_folder_from_NO_URL(url,verify_remote,ret_letter)
     const struct url *url;
     verify_remote_url_f    * verify_remote;
     int   * ret_letter /* returns '\0' or EOF */;

{
    return NULL;
}


struct url_handler NO_URL_HANDLER = {
    URL_handler_magic,
    0,
    url_unknown,
    uh_init_NO_URL,
    uh_free_NO_URL,
    uh_parse_NO_URL_not_path,
    uh_dup_NO_URL_not_path,
    uh_parse_NO_URL_params,
    uh_dup_NO_URL_params,
    uh_parse_NO_URL_query,
    uh_dup_NO_URL_query,
    uh_set_mailing_headers_from_NO_URL,
    uh_get_body_string_from_NO_URL,
    uh_not_path_to_raw_NO_URL,
    uh_params_to_raw_NO_URL,
    uh_query_to_raw_NO_URL,
    uh_get_folder_from_NO_URL,
    get_url_type_default
};

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
