static char rcsid[] = "@(#)$Id: elmaliases-write.c,v 2.16 2021/07/13 07:58:37 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.16 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_utils.h"
#include "addrlib.h"
#include "aliaslib.h"
#include "aliases_helper.h"

#include "reghelper.h"
#include "s_me.h"
#include "s_elm.h"
#include "rc_imp.h"


extern char *optarg;		
extern int   optind;		

DEBUG_VAR(Debug,__FILE__,"util");

const char * program_name = "elmaliases-write";
int    register_fd  = -1;
char * register_module = NULL;

static char version_buff[NLEN];

static const char OPTION_LETTERS[] = "Gd:w:cC:r:";

int main P_((int argc, char *argv[]));
int main(argc, argv)
     int argc;
     char *argv[];
{
    int err = 0;
    int c;
    int global = 0;       
    
    struct aliases_map     * MAP = NULL;
    charset_t                cs = NULL;
    struct editor_propline * pl = NULL;
    char *targetfile = NULL;
    FILE * commentfile = NULL;
    int config_merge = 0;

    int read_flags = 0;

    int r_dump = 0;
    
#if DEBUG
    init_debugfile("ELMALIASES-WRITE");
#endif
    
    while ((c = ELM_GETOPT(argc, argv, OPTION_LETTERS)) != EOF) {
	switch(c) {
	case 'G':
	    global++;
	    break;
	case 'd' : 	
#if DEBUG
	    set_debugging(optarg);	  
#endif
	    /* Error is printed later */
	    break;
	}
    }
    optind = 1;     /* Reset scanning */

    locale_init();
    
    REGHELPER_INIT(argv[0]);

    read_flags = global ? READ_FLAG_GLOBAL_ONLY : 0;
    
    user_init();

    init_addrlib(read_flags);
    init_aliaslib(read_flags);
    init_defaults(read_flags);
    
    while ((c = ELM_GETOPT(argc, argv, OPTION_LETTERS)) != EOF) {
	switch(c) {
	case 'G':
	    global++;
	    break;
	case 'c':
	    config_merge++;
	    break;

	case 'C':
	    if (0 != access(optarg,READ_ACCESS)) {
		int errcode = errno;
		lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotReadable,
				  "File %.50s is not readable: %s"),
			  optarg, strerror(errcode));
		err++;
		goto fail;
	    }

	    commentfile = fopen(optarg,"r");
	    if (!commentfile) {
		int errcode = errno;
		lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotReadable,
				  "File %.50s is not readable: %s"),
			  optarg, strerror(errcode));
		err++;
		goto fail;
		
	    }
	    break;

	case 'd' : 
#if DEBUG
	    set_debugging(optarg);	 
#else
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmArgsIngoringDebug,
			      "Warning: system created without debugging enabled - request ignored\n"));
#endif
	    break;

	case 'r':
	    set_user_rc_location(optarg); 
	    break;

	case 'w' : 
	    targetfile = optarg;
	    if (0 != access(targetfile,WRITE_ACCESS)) {
		int errcode = errno;
		
		if (errcode != ENOENT) {
		    lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotWriteable,
				      "File %.50s is not writeable: %s"),
			      targetfile, strerror(errcode));
		    err++;
		    goto fail;
		}
	    }
	    break;
	case '?':
	    err = 1;
	    goto fail;
	}
    }
    
    elm_sfprintf(version_buff, sizeof version_buff,
		 FRM("%s PL%s"), VERSION, PATCHLEVEL);
    
#ifdef DEBUG
    { 
	int d UNUSED_VAROK = panic_dprint("\n\
======================================================\n\
Debug output of the ELMALIASES-WRITE program (version %s).\n",
			     version_buff);

#if 0	
	if (d >= 50) {
	    panic_dprint("WARNING: Edit manually out sensitive information from that file!\n");
	    
	    lower_prompt("WARNING: Debug file may include passwords -- edit it!");
	    sleep(5+sleepmsg);	    
	}
#endif
    }
#endif
    
    if (!global)
	read_rc_file(read_flags);
    else
	post_init_check(read_flags);
    
    if (optind < argc) {
	int errcount = 0;
	MAP =  load_aliases_map(argv[optind],&errcount,&cs,&pl,
				NULL,NULL);
	if (!MAP || errcount) {
	    err = 1;
	    goto fail;
	}
    }
    
    if (config_merge) {
	
	if (!MAP) {
	    lib_error(CATGETS(elm_msg_cat, MeSet, MeConfigMergeMap,
			      "Config merge (-c) requires map as argument"));
	    err++;
	    goto fail;
	}
	
	if (targetfile) {
	    lib_error(CATGETS(elm_msg_cat, MeSet, MeConfigMergeNoW,
			      "Config merge (-c) Can not used with -w"));
	    err++;
	    goto fail;
	}
	
	if (pl)
	    free_editor_propline(&pl);

	if (global) {	    
	    change_aliases_map(& system_aliases_map, MAP);
	    free_aliases_map(&MAP);
	    
	    MAP        = system_aliases_map;
	    targetfile = system_aliases_file;
	    cs  = system_aliases_cs;	   
	    pl  = system_aliases_pl;	    

	} else {
	    
	    change_aliases_map(& user_aliases_map, MAP);

	    free_aliases_map(&MAP);
	    
	    MAP = user_aliases_map;
	    targetfile = user_aliases_file;
	    cs = user_aliases_cs;
	    pl = user_aliases_pl;
	}
	
	if (0 != access(targetfile,WRITE_ACCESS)) {
	    int errcode = errno;
	    
	    if (errcode != ENOENT) {
		lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotWriteable,
				  "File %.50s is not writeable: %s"),
			  targetfile, strerror(errcode));
		err++;
		goto fail;
	    }
	}
    }
    
    if (!MAP) {
	if (global) {
	    MAP = system_aliases_map;
	    cs  = system_aliases_cs;
	    pl  = system_aliases_pl;
	} else {
	    MAP = user_aliases_map;
	    cs = user_aliases_cs;
	    pl = user_aliases_pl;
	}
    }
    
    if (targetfile) {
	char * tmp = elm_message(FRM("%s.N"),targetfile);
	int errcode = can_open(tmp,"w");
	FILE *f;
	
	if (errcode) {
	    lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotWriteable,
			      "File %.50s is not writeable: %s"),
		      tmp, strerror(errcode));
	    
	    err++;
	    free(tmp);
	    goto fail;
	}

	f = fopen(tmp,"w");
	
	if (!f) {
	    int errcode = errno;
	    lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotWriteable,
			      "File %.50s is not writeable: %s"),
		      tmp, strerror(errcode));
	    
	    err++;
	    free(tmp);
	    goto fail;
	}
	
	r_dump = dump_aliases_map(f,MAP,commentfile,"ELMALIASES-WRITE",version_buff,
				  cs,pl,NULL,&errcode);

	if (! r_dump) {

	    lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotWriteable,
			      "File %.50s is not writeable: %s"),
		      tmp, strerror(errcode));

	    fclose(f);  /* ignore error */
	    
	    err++;
	    free(tmp);
	    goto fail;

	    
	} else if (EOF == fclose(f)) {
	    int errcode = errno;
	    lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotWriteable,
			      "File %.50s is not writeable: %s"),
		      tmp, strerror(errcode));
	    
	    err++;
	    free(tmp);
	    goto fail;
	}
	if (0 != rename(tmp,targetfile)) {
	    int errcode = errno;
	    lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotRenamed,
			      "Failed to rename temporary file to %.50s: %.30s"),
		      targetfile, strerror(errcode));
	    
	    err++;
	    free(tmp);
	    goto fail;
	}
	log_config(targetfile);
	free(tmp);

    } else
	dump_aliases_map(stdout,MAP,commentfile,
			 "ELMALIASES-WRITE",version_buff,
			 system_charset,pl,NULL,NULL);

    if (MAP && 
	MAP != system_aliases_map &&
	MAP != user_aliases_map)
	 free_aliases_map(&MAP);
    
 fail:
    if (commentfile)
	fclose(commentfile);

    if (err)
	lib_error(CATGETS(elm_msg_cat, MeSet, MeProgFailed,
			  "%s failed; exit code=%d"),
		  argv[0],err);
    
    return err;
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */


