static char rcsid[] = "@(#)$Id: elmrc-write.c,v 2.9 2018/12/21 11:21:43 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.9 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                  (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************
 * Some code based on Elm 2.4 src/save_optc.c (but that code may be moved to 
 *  lib/write_rc.c)
 * That code was following copyright:
 *
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

#include "def_utils.h"
#include "s_me.h"
#include "s_elm.h"
#include "s_elmrc.h"

#include "rc_imp.h"
#include "save_opts.h"

#include "reghelper.h"

DEBUG_VAR(Debug,__FILE__,"util");

extern char *optarg;		
extern int   optind;		

int    register_fd     = -1; 
const char * program_name    = "elmrc-write"; 
char * register_module = NULL;

static char version_buff[NLEN];

int main P_((int argc, char *argv[]));
int main(argc, argv)
     int argc;
     char *argv[];
{
    int err = 0;
    int global = 0;
    int c;
    int write_default = 0;
    char * targetfile = NULL;
    FILE * commentfile = NULL;
    char * elmrc_changes = NULL;
    struct elmrc_recorder * recorder = NULL;
    FILE * elmrc_changes_F = NULL;
    int have_errors_in_arg = 0;

    int read_flags = 0;
    
#if DEBUG
    init_debugfile("ELMRC-WRITE");
#endif
    locale_init();

    REGHELPER_INIT(argv[0]);

    while ((c = getopt(argc, argv, "GId:w:C:r:c:E")) != EOF) {
	
	switch(c) {
	case 'E':
	    have_errors_in_arg++;
	    break;

	case 'G':
	    global++;
	    break;

	case 'I':
	    write_default++;
	    break;
	    
	case 'd':
#if DEBUG
	    set_debugging(optarg);	 
#else
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmArgsIngoringDebug,
			      "Warning: system created without debugging enabled - request ignored\n"));
#endif
	    break;
	    
	case 'r':
	    set_user_rc_location(optarg); 
	    break;

	case 'w' : 
	    targetfile = optarg;
	    if (0 != access(targetfile,WRITE_ACCESS)) {
		int errcode = errno;
		
		if (errcode != ENOENT) {
		    lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotWriteable,
				      "File %.50s is not writeable: %s"),
			      targetfile, strerror(errcode));
		    err++;
		    goto fail;
		}
	    }
	    break;

	case 'c':
	    elmrc_changes = optarg;
	    if (0 != access(elmrc_changes,WRITE_ACCESS)) {
		int errcode = errno;
		
		if (errcode != ENOENT) {
		    lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotWriteable,
				      "File %.50s is not writeable: %s"),
			      elmrc_changes, strerror(errcode));
		    err++;
		    goto fail;
		}
	    }


	    elmrc_changes_F = open_or_create(elmrc_changes);
	    if (!elmrc_changes_F) {
		int errcode = errno;
		
		if (errcode != ENOENT) {
		    lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotWriteable,
				      "File %.50s is not writeable: %s"),
			      elmrc_changes, strerror(errcode));
		    err++;
		    goto fail;
		}
	    }

	    break;

	case 'C':
	    if (0 != access(optarg,READ_ACCESS)) {
		int errcode = errno;
		lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotReadable,
				  "File %.50s is not readable: %s"),
			  optarg, strerror(errcode));
		err++;
		goto fail;
	    }

	    commentfile = fopen(optarg,"r");
	    if (!commentfile) {
		int errcode = errno;
		lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotReadable,
				  "File %.50s is not readable: %s"),
			  optarg, strerror(errcode));
		err++;
		goto fail;
		
	    }
	    break;

	case '?':
	    err = 1;
	    goto fail;
	}

    }

    user_init();

    if (elmrc_changes_F) {
	recorder = enable_recorder(global ? SYSTEM_RC : LOCAL_RC);
	
	seed_history(elmrc_changes_F,elmrc_changes,recorder);
    }

    read_flags = global ? READ_FLAG_GLOBAL_ONLY : 0;
    
    init_defaults(read_flags);

    elm_sfprintf(version_buff, sizeof version_buff,
		 FRM("%s PL%s"), VERSION, PATCHLEVEL);
    
#ifdef DEBUG
    { 
	int d = panic_dprint("\n\
======================================================\n\
Debug output of the ELMRC-WRITE program (version %s).\n",
			     version_buff);

	if (d >= 50) {
#if 0	
	    panic_dprint("WARNING: Edit manually out sensitive information from that file!\n");
	    
	    lower_prompt("WARNING: Debug file may include passwords -- edit it!");
	    sleep(5+sleepmsg);	    
#endif
	}
    }
#endif
    
    if (!global)
	read_rc_file(read_flags);
    else
	post_init_check(read_flags);

    if (optind < argc) {
	FILE * F;

	if (0 != access(argv[optind],READ_ACCESS)) {
	    int errcode = errno;
	    lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotReadable,
			      "File %.50s is not readable: %s"),
		      argv[optind], strerror(errcode));
	    err++;
	    goto fail;
	}
	
	F = fopen(argv[optind],"r");
	if (!F) {
	    int errcode = errno;
	    lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotReadable,
			      "File %.50s is not readable: %s"),
		      argv[optind], strerror(errcode));
	    err++;
	    goto fail;	    
	}
	
	/* Returns number of errors */
	if (parse_elmrc(F,global,argv[optind],
			read_flags) != 0) {

	    if (have_errors_in_arg)
		lib_error(CATGETS(elm_msg_cat, MeSet, MeErrorsIgnored,
				  "Errors on %s ignored."),
			  argv[optind]);
	    else
		err++;
	}

	fclose(F);
	if (err)
	    goto fail;	    	
    }


    if (targetfile && write_default) {
	lib_error(CATGETS(elm_msg_cat, ElmrcSet, ElmrcNoBothwI,
			  "Can't specify both -w and -I options!"));
	err++;
	goto fail;

    }
    if (write_default)
	targetfile = global ? system_rc_file : user_rc_file;

    

    if (targetfile) {

	int r = write_rc(targetfile,commentfile,global,
			 "ELMRC-WRITE", 
			 targetfile == user_rc_file ?
			 full_username_s : NULL, version_buff);
       
	if (!r) {
	    err++;
	    goto fail;
	}

	log_config(targetfile);
    }


    if (elmrc_changes_F) {
	rewind(elmrc_changes_F);

#ifdef FTRUNCATE
	/* Not really necessary */
	if (-1 == ftruncate(fileno(elmrc_changes_F),0)) {
	    DPRINT(Debug,27,(&Debug,"ftruncate of %s failed\n",elmrc_changes));
	}
#endif

	print_history_changed(elmrc_changes_F,recorder);

    }

 fail:
    if (elmrc_changes_F) 
	fclose(elmrc_changes_F);

    if (commentfile)
	fclose(commentfile);

    if (err)
	lib_error(CATGETS(elm_msg_cat, MeSet, MeProgFailed,
			  "%s failed; exit code=%d"),
		  argv[0],err);

    return err;
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
