static char rcsid[] = "@(#)$Id: elmunidata.c,v 2.7 2018/12/21 11:21:43 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.7 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                  (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_utils.h"
#include "s_me.h"
#include "s_elm.h"

#include "unidata.h"

#include "reghelper.h"

DEBUG_VAR(Debug,__FILE__,"util");

int    register_fd     = -1; 
const char * program_name    = "elmunidata"; 
char * register_module = NULL;

extern char *optarg;		
extern int   optind;		

static char version_buff[NLEN];
static const char OPTION_LETTERS[] = "Gw:l:sd:b:BIT:r:";

int main P_((int argc, char *argv[]));
int main(argc, argv)
     int argc;
     char *argv[];
{
    struct unidata_mapped_data * unidata = NULL;
    char * target_file = NULL;
    FILE * text_target_file = NULL;
    FILE * logfile = NULL;
    int err = 0;
    int silent_gaps = 0;
    int rc_readed = 0;
    int global = 0;
    int read_flags = 0;
    
    int c;

#if DEBUG
    init_debugfile("ELMUNIDATA");
#endif

    while ((c = ELM_GETOPT(argc, argv, OPTION_LETTERS)) != EOF) {
	switch(c) {
	case 'G':
	    global++;
	    break;
	case 'd' : 	
#if DEBUG
	    set_debugging(optarg);	  
#endif
	    /* Error is printed later */
	    break;
	}
    }
    optind = 1;     /* Reset scanning */

    locale_init();
    
    REGHELPER_INIT(argv[0]);

    read_flags = global ? READ_FLAG_GLOBAL_ONLY : 0;
    
    user_init();
    init_defaults(read_flags);
    
    while ((c = ELM_GETOPT(argc, argv, OPTION_LETTERS)) != EOF) {
	switch(c) {
	case 'G':
	    global++;
	    break;
	case 'w':
	    target_file = optarg;
	    break;
	case 'I':
	    if (!rc_readed++) {
		if (!global)
		    read_rc_file(READ_FLAG_UNIDATA_INIT|read_flags);
		else
		    post_init_check(READ_FLAG_UNIDATA_INIT|read_flags);
	    }

	    target_file = unidata_path;

	    if (0 == strcmp(unidata_path,"none")) {
		/* This is more like debug option */
		fprintf(stderr,"%s: unidata = %s\n",
			program_name,unidata_path);
		target_file = NULL;
	    }

	    break;
	case 'l':
	    logfile = fopen(optarg,"w");
	break;
    case 's':
	silent_gaps = 1;
	break;
	case 'd' : 	
#if DEBUG
	    set_debugging(optarg);	  
#else
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmArgsIngoringDebug,
			      "Warning: system created without debugging enabled - request ignored\n"));
#endif
	    break;
	case 'r':
	    set_user_rc_location(optarg); 
	    break;
	case 'B':
	    if (!rc_readed++) {
		if (!global)
		    read_rc_file(READ_FLAG_UNIDATA_INIT|read_flags);
		else
		    post_init_check(READ_FLAG_UNIDATA_INIT|read_flags);
	    }

	    unidata = default_unidata();
	    if (!unidata) {
		err = 1;
		goto fail;
	    }
	    lib_error(CATGETS(elm_msg_cat, MeSet, MeFileLoaded,
			      "%s loaded"),
		      raw_unidata_path);
	    break;
	case 'b':
	    if (!get_unidata(&unidata,optarg)) {
		err = 1;
		goto fail;
	    }
	    lib_error(CATGETS(elm_msg_cat, MeSet, MeFileLoaded,
			      "%s loaded"),
		      optarg);
	    break;
	case 'T':
	    text_target_file = fopen(optarg,"w");
	    if (text_target_file)
		log_config(optarg);
	    break;
	case '?':
	    exit(1);
	}
    }

    if (!rc_readed++) {
	if (!global)
	    read_rc_file(READ_FLAG_UNIDATA_INIT|read_flags);
	else
	    post_init_check(READ_FLAG_UNIDATA_INIT|read_flags);
    }

    elm_sfprintf(version_buff, sizeof version_buff,
		 FRM("%s PL%s"), VERSION, PATCHLEVEL);
    
#ifdef DEBUG
    { 
	int d = panic_dprint("\n\
======================================================\n\
Debug output of the ELMUNIDATA program (version %s).\n",
			     version_buff);

	if (d >= 50) {
#if 0	
	    panic_dprint("WARNING: Edit manually out sensitive information from that file!\n");
    
	    lower_prompt("WARNING: Debug file may include passwords -- edit it!");
	    sleep(5+sleepmsg);	    
#endif
	}
    }
#endif


    if (optind < argc) {
	if (!read_unidata_text(&unidata,argv[optind],logfile,
			       silent_gaps)) {
	    
	    err = 1;
	    goto fail;
	}
	if (logfile) {
	    elm_fprintf(logfile,
			CATGETS(elm_msg_cat, MeSet, MeFileParsed,
				"%s parsed"),
		    argv[optind]);
	    putc('\n',logfile);
	}
	lib_error(CATGETS(elm_msg_cat, MeSet, MeFileParsed,
			  "%s parsed"),
		  argv[optind]);
    }
    
    if (target_file && unidata) {
	if (!write_unidata(unidata,target_file))
	    exit(1);

	if (0 == strcmp(unidata_path,target_file)) {
	    if (0 != chmod(target_file,0644)) {
		int errcode = errno;

		fprintf(stderr,"%s: chmod %s: %s\n",
			program_name, target_file, strerror(errcode));
		err = 1;
	    }
	}
	    
	log_config(target_file);
    }
    
    if (text_target_file && unidata) {
	if (!write_unidata_text(unidata,text_target_file))
	    exit(1);
    }
    
    if (text_target_file)
	fclose(text_target_file);
    
 fail:
    
    if (logfile) {
	if (err) {
	    elm_fprintf(logfile,
			CATGETS(elm_msg_cat, MeSet, MeProgFailed,
				"%s failed; exit code=%d"),
			argv[0],err);
	    putc('\n',logfile);
	}
	fclose(logfile);
    }
    if (err)
	lib_error(CATGETS(elm_msg_cat, MeSet, MeProgFailed,
			  "%s failed; exit code=%d"),
		  argv[0],err);
    return err;
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
