/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.2 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *       or Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include <stdio.h>
#include "elm_defs.h"
#include "cs_imp.h"

struct charset_type cs_ascii;
struct charset_type cs_unknown;
struct charset_type cs_onebyte;
struct charset_type cs_iso646;
struct charset_type cs_utf8;
struct charset_type cs_utf7;
struct charset_type cs_imap;
struct charset_type cs_iso2022;
struct charset_type cs_euc;

struct  map_info map_ascii;
struct  map_info map_latin1; 
struct  map_info map_koi8r; 
struct  map_info map_cp1251; 
struct  map_info map_invariant;
struct  map_info map_utf8; 
struct  map_info map_utf7; 
struct  map_info map_cp1252;
struct  map_info map_koi8u; 
struct  map_info map_885915;
struct  map_info map_ISO2022_ascii;
struct  map_info map_ISO2022_ascii_latin1;
struct  map_info map_EUC_ascii;
struct  map_info map_EUC_ascii_latin1;

struct setlist sets_iso_8859_X [10] ;
struct setlist set_latin8;
struct setlist set_utf8;
struct setlist set_ISO2022KR;
struct setlist set_EUCKR;
struct setlist set_ISO2022JP;
struct setlist set_EUCJP;
struct setlist set_ISO2022JP2;
struct setlist set_ISO2022CN;
struct setlist set_ISO2022CNEXT;
struct setlist set_EUCCN;
struct setlist set_ISO646JP;
struct setlist set_latin7;
struct setlist set_latin9;
struct setlist set_iso885916;
struct setlist set_koi8e;
struct setlist set_iso_ir_2;
struct setlist set_iso_ir_4;
struct setlist set_iso_ir_8_1;
struct setlist set_iso_ir_8_2;
struct setlist set_iso_ir_9_1;
struct setlist set_iso_ir_9_2;
struct setlist set_iso_ir_10;
struct setlist set_iso_ir_11;
struct setlist set_iso_ir_149;
struct setlist set_iso_ir_13;
struct setlist set_iso_ir_15;
struct setlist set_iso_ir_16;
struct setlist set_iso_ir_17;
struct setlist set_iso_ir_18;
struct setlist set_iso_ir_19;
struct setlist set_iso_ir_21;
struct setlist set_iso_ir_25;
struct setlist set_iso_ir_27;
struct setlist set_iso_ir_37;
struct setlist set_iso_ir_42;
struct setlist set_iso_ir_47;
struct setlist set_iso_ir_49;
struct setlist set_iso_ir_50;
struct setlist set_iso_ir_51;
struct setlist set_iso_ir_54;
struct setlist set_iso_ir_55;
struct setlist set_iso_ir_57;
struct setlist set_iso_ir_58;
struct setlist set_iso_ir_60;
struct setlist set_iso_ir_61;
struct setlist set_iso_ir_69;
struct setlist set_iso_ir_70;
struct setlist set_iso_ir_84;
struct setlist set_iso_ir_85;
struct setlist set_iso_ir_86;
struct setlist set_iso_ir_87;
struct setlist set_iso_ir_89;
struct setlist set_iso_ir_90;
struct setlist set_iso_ir_91;
struct setlist set_iso_ir_92;
struct setlist set_iso_ir_93;
struct setlist set_iso_ir_94;
struct setlist set_iso_ir_95;
struct setlist set_iso_ir_96;
struct setlist set_iso_ir_98;
struct setlist set_iso_ir_99;
struct setlist set_iso_ir_102;
struct setlist set_iso_ir_103;
struct setlist set_iso_ir_121;
struct setlist set_iso_ir_122;
struct setlist set_iso_ir_123;
struct setlist set_iso_ir_128;
struct setlist set_iso_ir_139;
struct setlist set_iso_ir_141;
struct setlist set_iso_ir_142;
struct setlist set_iso_ir_143;
struct setlist set_iso_ir_146;
struct setlist set_iso_ir_147;
struct setlist set_iso_ir_150;
struct setlist set_iso_ir_151;
struct setlist set_iso_ir_152;
struct setlist set_iso_ir_153;
struct setlist set_iso_ir_154;
struct setlist set_iso_ir_155;
struct setlist set_iso_ir_158;
struct setlist set_iso_ir_159;
struct setlist set_koi7_switched;

int main (argc, argv)
     int argc;
     char *argv[];
{
    char * munge;


    int i;

    if (argc != 2) {
	fprintf(stderr,"Usage: %s charset\n",argv[0]);
	exit(1);
    }

    for (i = 0; precompiled_sets[i].charset_type; i++) {
	if (precompiled_sets[i].MIME_name &&
	    0 == istrcmp(precompiled_sets[i].MIME_name,argv[1])) {
	    printf("%s\n",precompiled_sets[i].MIME_name);
	    exit(0);
	}
	if (precompiled_sets[i].codeset &&
	    0 == istrcmp(precompiled_sets[i].codeset,argv[1])) {
	    printf("codeset=\"%s\"\n",precompiled_sets[i].codeset);
	    exit(0);
	}
    }

    /* Then replace every , with : */

    munge = strdup(argv[1]);
    if (munge) {
	char * s;

	for (s = munge; *s; s++) {
	    if (',' == *s)
		*s = ':';
	}

	if (0 == strcmp(argv[1],munge))
	    exit(1);

	for (i = 0; precompiled_sets[i].charset_type; i++) {
	    if (precompiled_sets[i].MIME_name &&
		0 == istrcmp(precompiled_sets[i].MIME_name,munge)) {
		printf("%s\n",precompiled_sets[i].MIME_name);
		exit(0);
	    }
	    if (precompiled_sets[i].codeset &&
		0 == istrcmp(precompiled_sets[i].codeset,munge)) {
		printf("codeset=\"%s\"\n",precompiled_sets[i].codeset);
		exit(0);
	    }
	}
    }

    exit(1);
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
