case $CONFIG in
'')
    if test ! -f config.sh; then
	ln ../config.sh . || \
	ln ../../config.sh . || \
	ln ../../../config.sh . || \
	(echo "Can't find config.sh."; exit 1)
    fi
    . ./config.sh

    ;;
esac

case "$subdir" in
'')
    case "$0" in
    */*) cd `expr X$0 : 'X\(.*\)/'` ;;
    esac	    

    vpathdef="#VPATH = "
    ;;
*)
    vpathdef="VPATH = $source_dir/$subdir"
    ;;
esac


case "$d_symlink" in
*define*) sln='ln -s' ;;
*) sln='ln';;
esac

liblist="mailer mbox misc addr alias"

subdirlist="lib melib shared_libs src/messages src/screen src/aliases src/menu_common src/url src/block src/list src/command src/pager src utils/readmsg utils doc"

echo "Extracting Makefile (with variable substitutions)"
cat >Makefile <<!GROK!THIS!
#!$make
#
# $Id: Makefile.SH,v 2.15 2023/12/13 16:55:31 hurtta Exp $
#
#  Makefile for the entire ELM (ME+) mail system
#
# Modified by Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
#                     (was hurtta+elm@posti.FMI.FI)
#          or Kari Hurtta <elm@elmme-mailer.org>
######################################################################
# Based on Elm 2.4 Makefile.SH. That code was following copyright:
#
#         (C) Copyright 1986,1987, by Dave Taylor
#         (C) Copyright 1988-1992, USENET Community Trust
###################################################################### 
#
#	Variables established by Configure
CAT		=	$cat
GREP		=	$grep
ECHO		=	$echo
PR		=	$pr
SHAR		=	$shar -s 60000
SLEEP		=	$sleep
TAR		=	$tar
TAPE		=	$rmttape
BIN		=	bin
$vpathdef

!GROK!THIS!


if $test "$make_sets_make" != "$define" ; then  

	cat >>Makefile <<!GROK!THIS!
MAKE		=	$make
!GROK!THIS!

fi

cat >>Makefile <<'!NO!SUBS!'
#	Other variables
SHELL			=	/bin/sh
SOURCE_FILES		=	`$(GREP) -v 'doc/' MANIFEST`
DISTRIBUTED_FILES	=	`$(CAT) MANIFEST`

# Targets
#	Give default target first and alone
default_target:	installer all

installer: bin/elmregister
bin/elmregister: utils/elmregister.c config.sh
	cd hdrs; $(MAKE) $(MJ) $(MFLAGS) all
	cd utils; $(MAKE) $(MJ) $(MFLAGS) ../bin/elmregister

install: config.h config.sh hdrs/sysdefs.h Makefile installer all \
 $(BIN)/elm.terminalinfo $(BIN)/elm.mailinglists $(BIN)/elm.mimetypes \
 $(BIN)/elm.mimecharsets $(BIN)/elm.aliases $(BIN)/elm.tagfilter.entities
	@if [ "$(DESTDIR)x" != "x" ] ; then  echo Use make package ROOT="$(DESTDIR)" ; exit 1 ; fi
	@if [ "$(DEST)x" != "x" ] ; then  echo Use make package ROOT="$(DEST)" ; exit 1 ; fi
	@if [ "$(ELM_ROOT)x" != "x" ] ; then  echo Use make package ROOT="$(ELM_ROOT)" ; exit 1 ; fi
	bin/elmregister master $(MAKE) $(MJ) $(MFLAGS) install_s
	bin/elmregister replay -M all
	bin/elmregister unstage -M all

uninstall: config.h config.sh installer
	bin/elmregister master $(MAKE) $(MJ) $(MFLAGS) uninstall_s

# Helper target for testing
install_libs: config.h config.sh hdrs/sysdefs.h Makefile installer all
	bin/elmregister master $(MAKE) $(MJ) $(MFLAGS) install_libs_s
	bin/elmregister replay -M all

install_libs_s: install1_libs_s config.h config.sh hdrs/sysdefs.h
!NO!SUBS!

for i in $liblist
do
cat >>Makefile <<!SUBS!
	        cd lib/$i; \$(MAKE) \$(MJ) \$(MFLAGS) install_s
!SUBS!
done

cat >>Makefile <<'!NO!SUBS!'
	cd lib; $(MAKE) $(MJ) $(MFLAGS) install_s
	cd melib; $(MAKE) $(MJ) $(MFLAGS) install_s	
	cd shared_libs; $(MAKE) $(MJ) $(MFLAGS) install_s

#	Targets that are simply executed in each subordinate makefile as is
all install_s uninstall_s clean: config.h config.sh hdrs/sysdefs.h Makefile Makefile-1
		cd hdrs; $(MAKE) $(MJ) $(MFLAGS) $@
!NO!SUBS!

for i in $liblist
do
cat >>Makefile <<!SUBS!
	        cd lib/$i; \$(MAKE) \$(MJ) \$(MFLAGS) \$@
!SUBS!
done

for i in $subdirlist
do
cat >>Makefile <<!SUBS!
	        cd $i; \$(MAKE) \$(MJ) \$(MFLAGS) \$@
!SUBS!
done

cat >>Makefile <<'!NO!SUBS!'
		$(MAKE) -f Makefile-1 $(MJ) $(MFLAGS) $@

# Check that config.h is up of date
config.h: config.h.SH config.sh
	@echo "You must run 'sh Configure -S' or 'sh Configure'"
	exit 1

hdrs/sysdefs.h: hdrs/sysdefs.SH config.sh
	@echo "You must run 'sh Configure -S' or 'sh Configure'"
	exit 1

# Check that config.sh is up of data
config.sh: Configure hdrs/patchlevel.h	
	@echo "You must run 'sh Configure'"
	exit 1

Makefile: Makefile.SH config.sh
	@echo "You must run 'sh Configure -S' or 'sh Configure'"
	exit 1

$(BIN)/elm.terminalinfo: doc/terminal.info ConfTool/GenTerminalinfo
	@echo "You must run 'sh Configure -M' or 'sh Configure -S'"
	exit 1

$(BIN)/elm.mailinglists: doc/mailing.lists ConfTool/GenMailinglists
	@echo "You must run 'sh Configure -M' or 'sh Configure -S'"
	exit 1

$(BIN)/elm.mimetypes: doc/mime.types ConfTool/GenMimetypes
	@echo "You must run 'sh Configure -M' or 'sh Configure -S'"
	exit 1

$(BIN)/elm.mimecharsets: doc/mime.charsets ConfTool/mapfiles ConfTool/CharMap
	@echo "You must run 'sh Configure -M' or 'sh Configure -S'"
	exit 1

$(BIN)/elm.aliases: doc/elmaliases ConfTool/GenAliases
	@echo "You must run 'sh Configure -M' or 'sh Configure -S'"
	exit 1

$(BIN)/elm.tagfilter.entities: doc/tagfilter.entities ConfTool/GenEntities
	@echo "You must run 'sh Configure -M' or 'sh Configure -S'"
	exit 1


Makefile-1: Makefile-1.SH config.sh
	@echo "You must run 'sh Configure -S' or 'sh Configure'"
	exit 1

#	Targets that apply to all elm at once
listing:
		@$(ECHO) "Making source listing in file LISTING."
		@$(PR) -n -f $(SOURCE_FILES) > LISTING

shar:
		$(SHAR) $(DISTRIBUTED_FILES)

tar:
		$(TAR) cvf $(TAPE) $(DISTRIBUTED_FILES)

#	Targets that are really in subordinate make files
documentation:
	cd doc; $(MAKE) $(MJ) $(MFLAGS) $@

elm:
!NO!SUBS!

for i in $liblist
do
cat >>Makefile <<!SUBS!
	        cd lib/$i; \$(MAKE) \$(MJ) \$(MFLAGS) \$@
!SUBS!
done

for i in $subdirlist
do
cat >>Makefile <<!SUBS!
	        cd $i; \$(MAKE) \$(MJ) \$(MFLAGS) \$@
!SUBS!
done

cat >>Makefile <<'!NO!SUBS!'

#	The dummy dependency here prevents make from thinking the target is the
#	utils directory that sits in the current directory, rather than
#	an abstract target.
utils: _utils

_utils:
	cd utils; $(MAKE) $(MJ) $(MFLAGS) all


libs/libelmme-base.a:
	cd lib; $(MAKE) $(MJ) $(MFLAGS) ../libs/libelmme-base.a

libs/libelmme-mime.a:
	cd melib; $(MAKE) $(MJ) $(MFLAGS) ../libs/libelmme-mime.a

install1_libs_s:
!NO!SUBS!

for i in $liblist
do
cat >>Makefile <<!SUBS!
	cd lib/$i; \$(MAKE) \$(MJ) \$(MFLAGS) install_s	
!SUBS!
done

for i in $liblist
do
cat >>Makefile <<!SUBS!

libs/libelmme-$i.a:
	cd lib/$i; \$(MAKE) \$(MJ) \$(MFLAGS) ../../libs/libelmme-$i.a

!SUBS!
done

if $test "$d_shared" = "$define" ; then

cat >>Makefile <<'!NO!SUBS!'

shlib/libelmme-base.so: libs/libelmme-base.a
	cd lib; $(MAKE) $(MJ) $(MFLAGS) ../shlib/libelmme-base.so

shlib/libelmme-mime.so: libs/libelmme-mime.a
	cd melib; $(MAKE) $(MJ) $(MFLAGS) ../shlib/libelmme-mime.so

!NO!SUBS!

	for i in $liblist
	do
cat >>Makefile <<!SUBS!
shlib/libelmme-$i.so: libs/libelmme-$i.a
	cd lib/$i; \$(MAKE) \$(MJ) \$(MFLAGS) ../../shlib/libelmme-$i.so

!SUBS!
	done

fi


if $test "$build_package" = "$define" ; then  

cat >>Makefile <<!SUBS!

package: config.h config.sh hdrs/sysdefs.h Makefile installer all 
	bin/elmregister master -R "\$(ROOT)" \$(MAKE) \$(MJ) \$(MFLAGS) install_s
	@echo "#### Putting instructions to file \$(ROOT)/README.PACKAGE.sh"
	@echo "$startsh" >\$(ROOT)/README.PACKAGE.sh 
	@echo "# Package $package" >>\$(ROOT)/README.PACKAGE.sh 
	@echo "# package filelist is on .$etc/elm.filelist" >>\$(ROOT)/README.PACKAGE.sh 
	@echo "#To move files to final place, use command:" >>\$(ROOT)/README.PACKAGE.sh 
	@echo ".$lib/elmregister replay -M all -R \\\`pwd\\\` " >>\$(ROOT)/README.PACKAGE.sh

!SUBS!

fi
