/* $Id: addrlib.h,v 2.42 2024/06/10 18:05:34 hurtta Exp $ */

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.42 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#if ANSI_C
#define E_(x) extern x;
#else
#define E_(x)
#endif


/* init.c */

extern void init_addrlib P_((int read_flags /* READ_FLAG_IGNORE_MISSING */));

extern PATH valid_domains;
extern PATH valid_msgid_domains;

/* Defines from elm_defs.h ------------------------------------------------ */


/** "exit_disposition" values */
enum exit_disposition {
    UNSET      =   0,
    KEEP       =   1,
    STORE_RECV =   2,
    DELETE     =   3,
    HIDE       =   4,
    STORE_DSN  =   5,

    exit_disposition_COUNT
};


/* Content-Disposition */
enum {
    DISP_INLINE	     = 0,
    DISP_ATTACH	     = 1,
    DISP_AUTOATTACH  = 2,

    DISP_count             /* size of array */ 
};

enum encoding {
    ENCODING_ILLEGAL =	-1,
    ENCODING_NONE    =	0,
    ENCODING_7BIT    =	1,
    ENCODING_8BIT    =	2,
    ENCODING_BINARY  =	3,
    ENCODING_QUOTED  =	4,
    ENCODING_BASE64  =	5,
    ENCODING_EXPERIMENTAL  =	6,
    ENCODING_UUENCODED =  7,

    ENCODING_count            /* size of array */
};

/* mime_rec.mime_flag / mime_classify_media() */

enum NOTPLAIN_bits {
    NOTPLAIN_bit_need_metamail,
    NOTPLAIN_bit_need_mailcap,
    NOTPLAIN_bit_canuse_mailcap,
    NOTPLAIN_bit_is_fallback,
    NOTPLAIN_bit_metamail_blacklisted,
    NOTPLAIN_bit_type_not_found,
    NOTPLAIN_bit_mailcap_skipped,

    NOTPLAIN_bit_count  /* Number of bits */
};

#define    NOTPLAIN_need_metamail           (1 << NOTPLAIN_bit_need_metamail)
#define    NOTPLAIN_need_mailcap            (1 << NOTPLAIN_bit_need_mailcap)
#define    NOTPLAIN_canuse_mailcap          (1 << NOTPLAIN_bit_canuse_mailcap)
#define    NOTPLAIN_is_fallback             (1 << NOTPLAIN_bit_is_fallback)
#define    NOTPLAIN_metamail_blacklisted    (1 << NOTPLAIN_bit_metamail_blacklisted)
#define    NOTPLAIN_type_not_found          (1 << NOTPLAIN_bit_type_not_found)
#define    NOTPLAIN_mailcap_skipped         (1 << NOTPLAIN_bit_mailcap_skipped)

/* XXX struct mimeinfo is embedded to struct header_rec */
#define MIME_magic              0xFD00
typedef struct mimeinfo {
    unsigned short magic;         /* MIME_magic */
    unsigned int disposition : 2; /* DISP_INLINE or DISP_ATTACH or
				     DISP_AUTOATTACH
				  */

    unsigned int mime_flags : NOTPLAIN_bit_count;  /* NOTPLAIN_need_metamail           0x01
						      NOTPLAIN_need_mailcap            0x02
						      NOTPLAIN_canuse_mailcap          0x04
						      NOTPLAIN_is_fallback             0x08
						      NOTPLAIN_metamail_blacklisted    0x10
						      NOTPLAIN_type_not_found          0x20
						   */

    unsigned int unlink : 2;     /* used to mark that the file should be
				  * unlinked after sending the attachment 
				  */

    struct media_type *     TYPE;
    struct mime_param *     TYPE_opts;
    struct mime_param *     DISPOSITION_opts;
    struct string     *     description;
    struct message_id *     content_id;	/** the Content-ID: value	**/

    
    enum encoding encoding;      /* Notice: ENCODING_ILLEGAL == -1 */
    long length;
    long begin_offset; /* the beginning of the attachment (includes headers) */
    long offset;       /* where the real data starts */    

    struct mime_parser_data         * parser_data; 

    struct mime_selected_handler    * handler_data;   

    struct metamail_mailcap_entry   * metamail_blacklisted;


    /* These next fields are only used when sending multipart messages. */
    char          * pathname0;
    struct string * dispname; 

} mime_t;

struct header_rec {
    int  lines;		/** # of lines in the message	**/

    struct string *size_lines_s; /* (lines) or [bytesB] */
    
    int  status;		/** Urgent, Deleted, Expired?	**/
    int  status1;		/** Flagged?	                **/
    int  index_number_X;	/** relative loc in file...	**/
    int  encrypted;		/** whether msg has encryption	**/
    enum exit_disposition   exit_disposition;	/** whether to keep, store, delete **/
    int  status_chgd;	         /** whether became read or old, etc. **/
    long content_length;	/** content_length in bytes from message header	**/
    long offset;		/** offset in bytes of message	**/
    time_t received_time;	/** when elm received here	**/
    char env_from[STRING];      /* sender from "From "          */

    struct addr_list *from;	/** who sent the message?	**/
    struct addr_list *to;	/** who it was sent to		**/
    struct addr_list *cc;
    struct addr_list *reply_to;

    struct message_id * message_id;	/** the Message-ID: value	**/
    struct references * in_reply_to;    /* In-Reply-To   */
    struct references * references;     /* References */

    char time_zone[12];	        /**                incl. tz	**/
    time_t time_sent;	        /** gmt when sent for sorting	**/
    struct string *time_menu_s;	/** just the month..day for menu **/
                                /**  or hh:mm                    **/
    short time_menu_year;       /**   and year to separator      **/

    enum time_menu_mode {
	time_menu_null      = 0,
	/* ------------------------- */
	time_menu_hhmm_24hour,
	time_menu_month_day,	
	/* ------------------------- */
	time_menu_hhmm_or_year,	
	time_menu_month_day_hhmm,
	time_menu_month_day_year
	
    } time_menu_type;
    
    time_t tz_offset;	        /** offset to gmt of time sent	**/
    struct string *subject;     /** The subject of the mail	**/

    char mailx_status[WLEN];    /** mailx status flags (RO...)	**/
    mime_t mime_rec;            /** MIME information for this message **/


    /* == charset_t, but it is not yet declared ... */
    struct charcode_info *  header_charset;  /* charset for headers ...    */
    struct charcode_info *  override_charset; /* For O)verride command */
    struct charcode_info *  default_body_charset;
    
    struct mbx_hdr_info    * mbx_info;

    struct partial_vector  * partial_vector;
    int                      partial_len;

    struct list_info       * list_info; 
    struct header_errors   * header_error;

    unsigned int pgp : 3;
    unsigned int binary :1;  /* Binary message -- headers are terminated
			      * with \r\n 
			      */
    unsigned int have_from :1;  /* Body have unescaped "From " */
    unsigned int body_parsed :1;  /* Whatever body of message is read */
    unsigned int mime_parsed :1;  /* Whatever mime structure is parsed */
    unsigned int time_menu_today :1;  /* time_sent is today as given on struct today_info */
    unsigned int header_charset_set :1; /* header_charset set (not just default) */
};




/* ========================================================================= */

struct address;

/* address list operations ------------------------------------------------- */

extern struct addr_list  * new_empty_addr_list P_((int alloced));

extern void free_addr_list P_((struct addr_list **list));

extern struct addr_list * parse_header_address P_((const char *headername,
						   const char *buffer, 
						   int demime, 
						   charset_t defcharset,
						   struct header_errors **header_error));

extern struct addr_list * dup_addr_list P_((const struct addr_list *list));

extern void append_addr_list P_((struct addr_list *list,
				 const struct addr_list *src));


extern int addr_list_item_count   P_((const struct addr_list *list));
extern int addr_list_group_count  P_((const struct addr_list *list));

/* *group_num == -1 if not part of group */
extern const struct address * addr_list_get_item P_((const struct addr_list 
						     *list,
						     int idx,
						     int *group_num));
extern const struct string * addr_list_get_group P_((const struct addr_list 
						     *list,
						     int idx));


extern void addr_list_replace_item P_((struct addr_list *list,
				       int idx,
				       const struct address *addr,
				       int group_num));

/* groupidx == -1 if not part of group */
extern int add_address_to_list P_((struct addr_list *list,
				   const struct address *addr,
				   int groupidx));

/* Returns groupidx which can be used with add_address_to_list */
extern int add_group_to_list P_((struct addr_list *list,
				 const struct string *phrase));

/* Return -1 if group not found */
extern int addr_list_lookup_group P_((struct addr_list *list,
				      const struct string *group,
				      int create));

/* address operations ------------------------------------------------------ */

extern void free_address P_((struct address **addr));

extern struct address * new_address P_((const char * ascii_addr,
					const struct string  * phrase,
					const struct string  * comment));
extern struct address * new_address_string P_((const struct string * address,
					       const struct string * phrase,
					       const struct string * comment));

/* Rerurn 1 if address have all datat as NULL 
   (Note that <> is not NULL on that case)
*/

extern int address_is_empty P_((const struct address * addr));

extern const struct string * address_get_phrase P_((const struct address *
						    addr));
extern const struct string * address_get_comment P_((const struct address *
						     addr));
extern const char * address_get_ascii_addr P_((const struct address *addr));

extern struct address   * parse_one_address P_((const char *buffer,
						int demime,
						charset_t defcharset));

extern struct address * dup_address P_((const struct address *addr));

typedef int unq_can_print_error_f P_((const char *filename,
				      int lineno,
				      const struct string * value));

extern struct address  * parse_one_string_address 
    P_((const struct string *str,
	unq_can_print_error_f can_print_error,
	const char *filename /* MAY be NULL */,
	int lineno,
	int * haserror));

extern struct address  * parse_one_tokenized_address 
     P_((const struct string_token * tokenized,
	 int tok_start, int tok_end, 
	 int *parse_error,
	 unq_can_print_error_f can_print_error,
	 const char *filename /* MAY be NULL */,
	 int lineno));

extern struct addr_list * parse_string_address     
  P_((const struct string *str,
      unq_can_print_error_f can_print_error,
      const char *filename /* MAY be NULL */,
      int lineno,
      int * haserror));

extern struct addr_list * parse_tokenized_address  
  P_((const struct string_token * tokenized,
      int start_tok, int end_tok,
      charset_t defcharset,
      unq_can_print_error_f can_print_error,
      const char *filename /* MAY be NULL */,
      int lineno,
      int *haserror));

/* Caller must free string */
extern struct string * address_to_string P_((const struct address *addr));

/* Caller must frees tring */
extern struct string * addr_list_to_string P_((const  struct addr_list *list));

/* Caller must free string */
extern struct string *string_quote_phrase P_((const struct string *phrase));




/* mailing list  ------------------------------------------------------ */

struct mlist_info;
struct mlist_conf;

typedef int mlist_match_id_f P_((char * list_id,
				 struct list_info *list));

extern struct mlist_scan * mlist_get_matches P_((struct mlist_conf *list,
						 struct header_rec *hdr,
						 mlist_match_id_f *f));

extern void free_mlist_scan P_((struct mlist_scan **match));

extern void append_mlist_scan P_((struct mlist_scan *list,
				  const struct mlist_scan *other));

/* List is non-empty */
extern int have_mlist_scan P_((struct mlist_scan *match));

extern const struct mlist_info * get_mlist_info P_((struct mlist_scan *match));

/* Display address --------------------------------------------------------- */

struct header_rec;  
struct string;

typedef void decode_who P_((int class, char *ptr, int size));
extern int DisplayAddress  P_((struct header_rec    * h,
			       struct string       ** f,
			       const struct address * usraddr));

/* okay_addr.c ------------------------------------------------------------- */

/** This routine checks to ensure that the address we just got
    from the "To:" or "Cc:" line isn't us AND isn't the person	
    who sent the message.  Returns true iff neither is the case **/

extern int okay_address_l P_((const struct address   * address, 
			      const struct addr_list * return_address,
			      const struct address   * usraddr));


extern int addr_is_user P_((const char *addr));


/* split_addr.c    --------------------------------------------------------- */


/* Returns mailname (@domain part) useful for sender address 

   returns first item from "mailname" elmrc option

   if it is inside of (), retuns NULL
   if it does not include dot (.), returns NULL

   returns NULL if "mailname" elmrc option is not set

*/
extern const char * useful_mailname P_((void));


extern int match_local_addr P_((const char *addr, const char *pattern));

struct split_addr {
    unsigned short           magic;    /* SPLIT_ADDR_magic */

    char  * local_part;
    char  * local_part_raw;
    int     local_part_dequote;
    
    char  * host_part;
};


extern void clear_split_addr P_((struct split_addr *addr));

extern int match_splitted_addr P_((struct split_addr *addr,
				   struct split_addr *pattern));

/* Return 1, if address was splitted */
extern int split_internet_address P_((struct split_addr *result,
				      const char *addr));



/* mailer.c    ------------------------------------------------------------- */

struct mailing_headers;

extern char **argv_from_headers   P_((struct mailing_headers * headers));

extern void free_argv P_((char ***argv));

/* headers.c   ------------------------------------------------------------- */

#define   RHL_MARK_FOLDING      1
#define   RHL_CHECK_HEADER      2

extern int read_header_line             P_((FILE *,char *,int,int));
extern int state_read_hdr_line          P_((struct in_state *,char *, int, int));

typedef struct header_info * header_ptr;

/* Returns pointer to static storage */
extern const char * give_header_name P_((header_ptr X));
extern int is_mailing_header P_((header_ptr X));

extern int add_to_mailing_header P_((struct mailing_headers * headers,
				     header_ptr X,const char *value,
				     int demime,
				     charset_t defcharset,
				     int replace
				     ));

#define HEADER_magic        0xFC00

typedef struct header_list {
    unsigned short magic;
    header_ptr header_name;
    struct header_list * next_this_header;
    struct header_list * next_header;
    struct header_list * next_other_header;
    char * body;
} * header_list_ptr;

extern void update_header_list P_((header_list_ptr *list,
				   header_list_ptr *last1,
				   const char * name,
				   const char * value));
extern header_list_ptr update_header_list1 P_((header_list_ptr *list,
					       header_list_ptr *last1,
					       header_ptr       header_name));

extern header_ptr find_header  P_((const char *name, int create_flag));
extern header_list_ptr locate_header      P_((header_list_ptr,header_ptr));

#define locate_header_by_name(h,n)      locate_header(h,find_header(n,0))
extern void delete_headers              P_((header_list_ptr *hdr));


extern struct string * give_decoded_header P_((header_list_ptr tmphdr,
					       int demime, 
					       charset_t defcharset));

/* getword.c --------------------------------------------------------------- */

extern int get_word P_((const char *buffer,int start,
			char *word,int wordlen));

/* parsarpdat.c ------------------------------------------------------------ */

extern enum parse_date_time_result {
    parse_dt_fail = 0,
    parse_dt_unix = 1,
    parse_dt_mail,
    parse_dt_dateonly    
}  parse_parts_date_time P_((const char *str,
			     char *time_zone,int size_time_zone,
			     int *month_p,
			     int *day_p,
			     int *year_p,
			     int *hours_p,
			     int *mins_p,
			     int *secs_p,
			     int *tz_p,
			     int *wday_p /* 0 - 6 or -1 if not given */));

/* outdate.c ---------------------------------------------------------------*/

enum date_source { date_automatic = 0   /* automatically gnerated */,
		   date_explicit        /* explicit date given */
};

extern struct expanded_date * new_expanded_date 
   P_((const struct tm     * value    /* may be NULL */,
       time_t                t_value  /* 0, if not set */,
       enum date_source      explicit_date
       ));

extern void free_expanded_date P_((struct expanded_date **ptr));

/* May return NULL */
extern const struct tm * get_expanded_date_value P_((struct expanded_date *ptr));

/* May return 0 if fail or year < 1970 */
extern time_t get_expanded_date_cached_time P_((struct expanded_date *ptr));

extern enum date_source get_expanded_date_source P_((const struct expanded_date *ptr));

/* outexpires.c ------------------------------------------------------------ */

enum print_time {
    print_date_only = 0,
    print_date_and_time = 1 };

extern struct expanded_expires * new_expanded_expires
   P_((const struct string * textual  /* may be NULL */,
       const struct tm     * value    /* may be NULL */,
       int days_ahead      /* -1 if not given or
			      already expired */,
       enum print_time print_date
       ));


extern void free_expanded_expires P_((struct expanded_expires **ptr));

/* Caller must free */
/* May return NULL */
extern struct string * get_expanded_expires_textual
   P_((const struct expanded_expires *ptr));

extern void set_expanded_expires_textual P_((struct expanded_expires *ptr,
					     const struct string *textual));

/* May return NULL */
extern const struct tm * get_expanded_expires_value
   P_((const struct expanded_expires *ptr));

/* Return -1 if not available */
extern int get_expanded_expires_days_ahead
   P_((const struct expanded_expires *ptr));

extern enum print_time get_expanded_expires_print_time
   P_((const struct expanded_expires *ptr));

/* May return 0 if fail or year < 1970 */
extern time_t get_expanded_expires_cached_time
  P_((struct expanded_expires *ptr));

/* date.c -------------------------------------------------------------------*/

extern struct tm * days_ahead_tm P_((int days));

/* Return 1 if succeed */
extern int expanded_time_hdrval P_((const struct tm * the_time,
				    const time_t      cached_time,
				    char            * buffer,
				    size_t            size,
				    enum print_time   print_time,
				    const char      * override_zone,
				    time_t            override_tz_offset));


/* Return 1 if succeed */
extern int days_ahead_hdrval P_((struct expanded_expires *ptr,
				 char          * buffer,
				 size_t          size,
				 enum print_time print_time));


/* Return 1 if succeed */
extern int date_hdrval P_((struct expanded_date *ptr,
			   char            * buffer,
			   size_t            size,
			   enum print_time   print_time));

/* outheaders.c ------------------------------------------------------------ */

/* return (0 = Sunday, 1 = Monday, ... 6 = Saturday),
   input: month (m= 1 to 12), day (d= 1 to 31), and year
*/
extern int wday_from_year_month_day P_((int year, int month, int day));

struct textual {
    struct string *Textual;
    int pos;
    int len;
};

struct expanded_address {
    unsigned short magic;               /* EXP_ADDR_magic */
    struct addr_list  *addrs;           
    
    struct textual *surface;
    int surface_len;
};

extern void dump_expanded_address P_((int debuglevel, const char *text,
				      struct expanded_address expanded));

extern void expanded_address_from_list P_((struct expanded_address *result,
					    const struct addr_list *addr_list));


struct mailing_headers {
    unsigned short magic;                  /* MAIL_HDR_magic */

    struct string *subject;
    struct expanded_address from;

    struct references * in_reply_to;    /* In-Reply-To   */
    struct references * references;     /* References    */

    struct message_id * message_id;          /* Message-ID    */

    struct digest_proc * message_digest;    /* Message digest used for message-id */

    struct expanded_date    * date;     /* Date          */
    struct expanded_expires * expires;  /* Expires       */
    
    char *action; 
    char *priority;
    
    char *sender;

    struct expanded_address reply_to; 
    struct expanded_address to;
    struct expanded_address cc;

    struct string *xmailer;
    
    struct user_header {
	header_ptr      name;
	struct string  *value;
    }  * user_header;
    int  user_header_count;

    struct expanded_address bcc;
    char *precedence;

    char * encoded_user_agent; /* Ascii? serialization
				  of User Agent header field 
			       */

    struct mailer_env_from  *env_from;
};

enum import_mh_mode {
    import_mh_normal,
    import_mh_returnpath
};

    

extern void import_mailheaders P_((struct mailing_headers * headers,
				   enum import_mh_mode mode
				   ));

extern  int add_expanded_addr_ P_((struct expanded_address *x,
				   const char *ADR, 
				   const struct string *FN,
				   const struct string *COM));
extern int add_expanded_addr0_ P_((struct expanded_address *x,
				   const struct address *ADR,
				   int g));
extern int add_expanded_addr_g P_((struct expanded_address *x,
				   const struct address *ADR,
				   const struct string *group));

extern  int add_expanded_addr_4 P_((struct expanded_address *x,
				    const char *ADR, 
				    const struct string *FN,
				    const struct string *COM,
				    const struct string *group));


extern int add_group_phrase_ P_((struct expanded_address *x,
				 const struct string *GRP));

extern int add_textual_addr_ P_((struct expanded_address *x,
				 const struct string *TEXTUAL, 
				 int POS, int LEN));

#define ADD_EXPANDED(x,ADR,FN,COM)  add_expanded_addr_(&x,ADR,FN,COM)
#define ADD_EXPANDED0(x,ADR)        add_expanded_addr0_(&x,ADR,-1)
#define ADD_EXPANDED_g(x,ADR,G)        add_expanded_addr0_(&x,ADR,G)
#define ADD_EXPANDED_G(x,ADR,G)        add_expanded_addr_g(&x,ADR,G)
#define ADD_EXPANDED4(x,ADR,FN,COM,GRP) add_expanded_addr_4(&x,ADR,FN,COM,GRP)
#define ADD_GROUP(x,GRP)               add_group_phrase_(&x,GRP)
#define ADD_TEXTUAL(x,TEXTUAL,POS,LEN) add_textual_addr_(&x,TEXTUAL,POS,LEN)

#define ADD_EXPANDED_p(x,ADR,FN,COM)  add_expanded_addr_(x,ADR,FN,COM)
#define ADD_EXPANDED0_p(x,ADR)        add_expanded_addr0_(x,ADR,-1)
#define ADD_EXPANDED_g_p(x,ADR,G)        add_expanded_addr0_(x,ADR,G)
#define ADD_EXPANDED_G_p(x,ADR,G)        add_expanded_addr_g(x,ADR,G)
#define ADD_EXPANDED4_p(x,ADR,FN,COM,GRP) add_expanded_addr_4(x,ADR,FN,COM,GRP)
#define ADD_GROUP_p(x,GRP)               add_group_phrase_(x,GRP)
#define ADD_TEXTUAL_p(x,TEXTUAL,POS,LEN) add_textual_addr_(x,TEXTUAL,POS,LEN)



extern void zero_expanded_address P_((struct expanded_address *x));
extern void free_expanded_address P_((struct expanded_address *x));
extern void copy_expanded_address P_((struct expanded_address *result,
				      const struct expanded_address *source));
extern void append_expanded_address P_((struct expanded_address *result,
					const struct expanded_address *source));
extern int have_expanded_address P_((const struct expanded_address * source));

extern struct string * make_surface_addr P_((const struct address * address));

/* Returns domain name if matches to valid-domains */

extern const char * is_whitelisted_valid_domain P_((const char * mail_domain_name));

/* Returns domain name if matches to valid-msg-id-domains */
extern const char * is_whitelisted_msgid_domain P_((const char * msgid_domain_name));


/* error.c --------------------------------------------------------- */

extern void free_header_errors P_((struct header_errors **error));

extern void process_header_error P_((struct header_errors **error,
				     const char * format, const char *msg, 
				     ...));

extern int get_header_errors_count P_((struct header_errors *error));
extern const struct string * get_header_errors_msg P_((struct header_errors *
						       error, int idx));

extern void print_header_errors P_((struct header_errors *error));


/* message-id operations -------------------------------------------------- */

extern struct message_id  * new_message_id P_((const char * left,
					       const char * domain,
					       const struct string *comment));

extern struct message_id * dup_message_id P_((const struct message_id *id));

extern struct message_id * parse_header_message_id P_((const char *headername,
						       const char *buffer,
						       int demime,
						       charset_t defcharset,
						       struct header_errors 
						       **header_error));

extern int same_message_id P_((const struct message_id *id1,
			       const struct message_id *id2,
			       int ignore_comment));

extern int cmp_message_id P_((const struct message_id *id1,
			      const struct message_id *id2));
			      
extern void free_message_id P_((struct message_id  ** id));


/* Result is malloced,  < > are included to result, no comments */
extern char * get_message_id_ascii_brackets P_((const struct message_id *id));

extern const struct string * message_id_comment P_((const 
						    struct message_id *id));

extern struct string * message_id_to_string P_((const struct message_id *id));


extern const char * message_id_left P_((const struct message_id  *id));
extern const char * message_id_domain P_((const struct message_id  *id));


/* references / in-reply-to operations --------------------------------------- */

extern struct references * dup_references P_((const struct references *id));
extern struct references * dup_references_no_phrase P_((const struct references *id));

extern struct references * parse_header_references P_((const char *headername,
						       const char *buffer,
						       int demime,
						       charset_t defcharset,
						       struct header_errors 
						       **header_error));

extern int same_references P_((const struct references *id1,
			       const struct references *id2));

extern void free_references P_((struct references  ** id));

extern void append_references P_((struct references  * ref,
				  const struct references  * ref1));

extern struct references * new_references P_((const struct message_id  *id,
					      const struct string      *phrase,
					      const struct string      *comment));

extern void references_add_item P_((struct references * ref,
				    const struct message_id  *id,
				    const struct string      *phrase,
				    const struct string      *comment));

extern int references_item_count P_((const struct references * ref));


extern const struct message_id * references_get_message_id P_((
  			          const struct references * ref,
				  int idx));

extern const struct string * references_get_phrase P_((
  			          const struct references * ref,
				  int idx));

extern const struct string * references_get_comment P_((
  			          const struct references * ref,
				  int idx));

extern int header_references_have_phrase P_((const struct references * ref));

extern struct string * references_to_string P_((const struct references *ref));


/* write_hdr.c ------------------------------------------------------------- */

extern void write_addr_header P_((struct out_state *mailer,
				  char *hdr_name,
				  struct addr_list * addr,
				  enum encoding top_encoding,
				  int enmime,
				  charset_t hdr_charset,
				  int add_group));

#define HAVE_8BIT    1

extern int check_8bit_str P_((const char *str));
extern int check_8bit_string P_((struct string *P));


extern void write_string_header P_((struct out_state *mailer,
				    const char *hdr_name,
				    struct string * P,
				    enum encoding top_encoding,
				    int enmime,
				    charset_t charset));

extern void write_text_header P_((struct out_state *mailer, 
				  const char *hdr_name, 
				  const char * text,
				  enum encoding top_encoding));

extern void write_expires_header P_((struct out_state * mailer, 
				     const char       * hdr_name,
				     struct expanded_expires *expires,
				     enum encoding top_encoding));
extern void write_date_header P_((struct out_state        * mailer,
				  const char              * hdr_name,
				  struct expanded_date    * date_value,
				  enum encoding             top_encoding));

/* top_encoding is not required -- also if mailer->EOLN_is_CRLF
   is set, then \r\n is printed
*/
extern void print_EOLN P_((struct out_state *mailer,
			   enum encoding top_encoding));


extern void write_references_header P_((struct out_state *mailer,
					const char *hdr_name,
					struct references * ids,
					enum encoding top_encoding,
					int enmime,
					charset_t hdr_charset));

extern void write_msgid_header P_((struct out_state *mailer,
				   const char *hdr_name,
				   struct message_id * id,
				   enum encoding top_encoding,
				   int enmime,
				   charset_t hdr_charset));



/* Result is is malloced */
extern char * address_to_str P_((const struct address *address, int enmime,
				 charset_t hdr_charset));
/* Result is is malloced */
char * list_to_str P_((const struct addr_list *list, int enmime,
		       charset_t hdr_charset));

/* Caller must free string */
extern struct string *string_quote_comment P_((const struct string *phrase));


extern void append_quoted_to_string P_((struct string ** ret,
					const struct string * value));



E_(unq_can_print_error_f unq_can_print_error)
extern int unq_can_print_error P_((const char *filename,
				   int lineno,
				   const struct string *value));

/* Caller must free string */
extern struct string * unquote_string P_((const struct string * value,
		  unq_can_print_error_f can_print_error,
		  const char *filename /* MAY be NULL */,
		  int lineno, int *hasherror));

/* digest.c ----------------------------------------------------------- */

extern void digest_feed_str P_((struct digest_proc * ret, const char * str));
extern void digest_feed_references P_((struct digest_proc * ret,
				       const struct references *ref));

extern void digest_feed_message_id P_((struct digest_proc * ret,
				       const struct message_id * id));
extern void digest_feed_addrs P_((struct digest_proc * ret,
				  const struct addr_list * addrs,
				  int add_group));

extern void digest_feed_expires_hdr P_((struct digest_proc      * ret,
					const char              * hdr_name,
					struct expanded_expires *expires));

extern void digest_feed_date_hdr P_((struct digest_proc      * ret,
				     const char              * hdr_name,
				     struct expanded_date    * date_value));

/* duplicate.c -------------------------------------------------------- */

extern int addr_list_is_same P_((struct addr_list *a1, struct addr_list *a2));

/* md5_wrapper.c ------------------------------------------------------ */

extern const struct digest_proc_type * md5_available   P_((void));
extern       struct digest_proc      * digest_proc_md5 P_((void));


/* file_changes.c ----------------------------------------------------- */

#define FILE_CHANGES_magic	0xF612

extern const struct file_changes {
    unsigned short magic;     /* FILE_CHANGES_magic */

    size_t    self_size;      /* Size of struct file_changes */
    
    /* copy some stat information */
        
    dev_t     dev;	   /* ID of device containing file */
    ino_t     ino;         /* inode number */
    off_t     size;        /* total size, in bytes */
    time_t    mtime;	   /* time of last modification */
    
    unsigned int valid:1;
} NULL_file_changes;

#define FILE_CHANGES_INIT     {			\
	    FILE_CHANGES_magic,			\
	    sizeof (struct file_changes),	\
	    0,					\
	    0,					\
	    0,					\
	    0,					\
						\
	    0  /* No valid information */	\
 }


extern enum file_changes_result {
    file_changes_error = -1,
	no_file_changes    = 0,
	have_file_changes } test_file_changes P_((const char *filename,
						  const struct file_changes *old_file,
						  int *errno_res));

extern void stat_to_file_changes P_((const struct stat *st,
				     struct file_changes *file_information));


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
