/* $Id: browser.h,v 2.6 2014/07/14 15:07:25 hurtta Exp $ */

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.6 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/


/* Private API between src/browser.c and src/fbrowser.c */

enum browser_status { browser_error      = 0,
		      browser_select     = 1,
		      browser_fbrowser,
		      browser_rerun   };


/* browser.h */

extern int browser_check_extension P_((const struct string  * filename,
				       const struct string  * defext));



/* fbrowser.h */

#define FBROWSER_CALL_magic	0xF510

struct fbrowser_call {
    unsigned short   magic;          /* FBROWSER_CALL_magic */

    struct string  * filter;
    struct string  * prompt;

    int              flags;
    int              options;

    struct string  * save_dir;
    struct string  * last_fbrowser_dir;

    struct string  * default_extension;
    struct string  * default_filename;
};


extern enum browser_status fbrowser_hook_enter 
  P_((
      struct menu_context *page,
      struct folder_browser *p,
      struct MailboxView *mailbox,
      struct string **buffer,
      struct fbrowser_call *fc));

/* fb_options.c */


/* Returns 'q'
           'i'
            0
           EOF

*/         
int fbrowser_option P_((struct menu_context * parent_page,
			int *resort, int *setscreen));


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
