/* $Id: elmlib.h,v 2.178 2024/10/13 10:57:10 hurtta Exp $ */

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.178 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                  (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

/* declaration */

#if defined(USE_DLOPEN) || defined(REMOTE_MBX)
typedef enum { IMAP_error = 0,
	       IMAP_idle,
	       IMAP_command,
	       IMAP_command_ready_OK,
	       IMAP_command_ready_NO,
	       IMAP_command_ready_BAD,
	       IMAP_closing
} imap_states;

enum CAPA_phase { 
    capa_prelogin        = 0,
    capa_prelogin_again  = 1,
    capa_do_login        = 2,
    capa_logged          = 3,
    capa_logged_again    = 4
};

#ifdef ANSI_C
struct folder_info;                /* Needed for prototype */
#endif

typedef int f_pop_push_command P_((struct folder_info *folder,
				   char *command, int simple));
typedef int f_pop_command_ok P_((struct folder_info *folder));
typedef void f_pop_clear_command P_((struct folder_info *folder));

struct pop_callbacks {
    f_pop_push_command   * push_command;
    f_pop_command_ok     * command_ok;
    f_pop_clear_command  * clear_command;
};

#ifdef ANSI_C
struct IMAP_capa_libs;
struct connection_cache;
#endif


typedef void f_imap_wait P_((struct connection_cache *con));
typedef void f_imap_idle_wait P_((struct connection_cache *con));
typedef int f_imap_command_ok P_((struct connection_cache *con,
				  imap_states *cmd_result,
				  char        **extra_code));
typedef int f_start_imap_command P_((struct connection_cache *con,
				     char * verb));
typedef void f_imap_command_push_atom P_((struct connection_cache *con,
					  const char *st));
typedef void f_imap_command_push_literal P_((struct connection_cache *con,
					     int len, const char *st));
typedef void f_imap_command_push_string P_((struct connection_cache *con,
					    const char *st));
typedef void f_imap_command_push_astring P_((struct connection_cache *con,
					 const char *st));
typedef void f_imap_command_push_aliteral P_((struct connection_cache *con,
					      const char *st));
typedef void f_imap_command_push_range P_((struct connection_cache *con,
					   int A, int B));
typedef void f_imap_command_push_number P_((struct connection_cache *con,
					 int A));
typedef void f_imap_command_push_list P_((struct connection_cache *con,
					  const char **l));
typedef void f_end_imap_command P_((struct connection_cache *con));
typedef void f_imap_clear_command P_((struct connection_cache *con));

struct imap_callbacks {
    f_imap_wait                  * wait;
    f_imap_idle_wait             * idle_wait;
    f_imap_command_ok            * command_ok;
    f_start_imap_command         * start_command;
    f_imap_command_push_atom     * command_push_atom;
    f_imap_command_push_literal  * command_push_literal;
    f_imap_command_push_string   * command_push_string;
    f_imap_command_push_astring  * command_push_astring;
    f_imap_command_push_aliteral * command_push_aliteral;
    f_imap_command_push_range    * command_push_range;
    f_imap_command_push_number   * command_push_number;
    f_imap_command_push_list     * command_push_list;
    f_end_imap_command           * end_command;
    f_imap_clear_command         * clear_command;
};


#endif


/* lib/strmcpy.c */

extern char *strmcpy P_((char *, const char *));
extern char *strmcat P_((char *, const char *));

/* lib/safeopen.c */

extern FILE *safeopen P_((char *name,int *errno_res));
extern FILE *safeopen_rdwr P_((char *name,int *errno_res));

/* lib/istrcmp.c */

extern int istrcmp P_((const char *, const char *));

/* lib/atonum.c */

/*
 * This is similar to atoi(), but it complains if the string
 * contains any non-numeric characters.  Returns the numeric
 * value >= 0 on success, -1 on error. Does not accept negative
 * numbers as atoi() acceps
 */

extern int atonum P_((const char *));


/* lib/can_open.c */

extern int can_open P_((const char *, const char *));

/* lib/chloc.c */

/* Is this really needed? This does same than strchr or index, except
 *  that return type is different.
 *
 *                          - K E H <hurtta@ozone.FMI.FI>
 */

/* Argument (second) can't be char because there is both prototype and
 * non-prototype declaration.
 */
extern int chloc  P_((const char *,int));
extern int qchloc P_((const char *, int));

/* lib/date_util.c */

extern int cvt_dayname_to_daynum     P_((char *,int *));
extern int cvt_monthname_to_monthnum P_((char *,int *));
extern int cvt_yearstr_to_yearnum    P_((char *,int *));
extern int cvt_mmddyy_to_dayofyear   P_((int, int, int, int*));
extern int cvt_timezone_to_offset    P_((char *str,int *, int));
extern int cvt_numtz_to_mins         P_((char *));
extern int cvt_timestr_to_hhmmss     P_((char *, int *, int *, int *));
extern long make_gmttime             P_((int, int, int, int, int, int));


/* lib/delay_unlink.c */

extern struct delay_unlink * alloc_delay_unlink P_((const char *name,
						    int fd,
						    int timer_secs));
extern void free_delay_unlink P_((struct delay_unlink **delay_unlink_file));
extern int delay_unlink_add_name P_((struct delay_unlink * rec,
				     const char          * name));
extern void delay_unlink_mark_done P_((struct delay_unlink * rec));
extern void inc_delay_unlink_recount P_((struct delay_unlink *delay_unlink_file));

/* lib/digest_wrapper.c */

#ifdef ANSI_C
struct digest_proc_type;                /* Needed for prototype */
#endif

extern struct digest_proc *  malloc_digest_proc P_((const struct digest_proc_type *t));

extern const struct digest_proc_type * digest_type P_((struct digest_proc *ptr));

extern void free_digest_proc P_((struct digest_proc **ptr));
extern void inc_digest_proc_refcount P_((struct digest_proc *ptr));

/* Resets digest_proc mode */
extern void start_digest_proc P_((struct digest_proc *ptr));

extern void feed_digest_proc P_((struct digest_proc *ptr,
				 const unsigned char data[],
				 const size_t        data_len));

/* Return digest length -- constant */
extern size_t len_digest_proc P_((struct digest_proc *ptr));

enum digest_proc_mode {
    digest_proc_initial   = 0,
    digest_proc_started,
    digest_proc_ended
} mode_digest_proc P_((struct digest_proc *ptr));

/* also return length of digest. If called several times, returns
   cached result
 */
extern size_t end_digest_proc P_((struct digest_proc *ptr,
				  unsigned char digest_buffer[],
				  size_t        digest_buffer_len));

/* returns cached result of end_digest_proc() */
extern size_t result_digest_proc P_((struct digest_proc *ptr,
				     unsigned char digest_buffer[],
				     size_t        digest_buffer_len));

extern enum digest_proc_comp {
    digest_proc_incomplete = -1,
    digest_proc_differ     = 0,
    digest_proc_same
} digest_proc_equal P_((const struct digest_proc *ptr1,
			const struct digest_proc *ptr2));

/* lib/dynarray.c */

extern void ** DynamicArray P_((void **p, int record_size, int *max, int n));
extern void DestroyDynamicArray P_((void **p));

/* lib/errno.c */

#ifndef STRERROR
char *strerror P_((int errnumber));
#endif


/* lib/expand.c */

extern int expand P_((char *, int));
extern int expand_env P_((char *dest, const char *src,unsigned destlen));
extern int expand_meta P_((char *dest, const char *src,unsigned destlen));

/* expand_path is subset of expand_env and expand_meta
   Returns 0 if no expansion done
           1 if expansion done
	  -1 on failure
*/
extern int expand_path P_((char *dest, const char *src, unsigned destlen)); 

/* lib/gcos_name.c */

extern char * gcos_name          P_((const char *gcos_field, 
				     const char *logname));

/* lib/get_tz.c */

extern int get_tz_mins   P_((time_t tval));
extern const char *get_tz_name P_((const struct tm *));

/* lib/getaddr.c */

extern void free_rfc822tokenized   P_((char **res));
/* Removes comments from vector: */
extern void remove_space_tokenized P_((char ** tokenized));
extern char **rfc822_tokenize      P_((const char *line));

typedef struct charcode_info * charset_t;
#ifdef ANSI_C
struct string;
#endif

extern void look_special_tokens P_((char **tokenized,
				   const char *tok_chars,
				   int start, int *ended,
				   int demime, charset_t set,
				   struct string **comments,
				   char ***scanned));
extern struct string * scanned_to_phrase P_((char **scanned,
					     int demime, charset_t set));

/* lib/getarpdate.c */

extern char * get_arpa_date P_((void));

extern const char *arpa_dayname[8];   /* ./lib/addr/date.c,  uses this          */
extern const char *arpa_monname[13];   /* src/date.c and IMAP code uses */

/* getfullnam.c */

#ifdef ANSI_C
struct passwd;
#endif
extern char * get_fullname1 P_((struct passwd *P,const char *logname));
extern char * get_full_name P_((char *));

/* lib/in_string.c */

/* Is that needed? This is almost same as strstr (except return type).
 *                                     - K E H <hurtta@ozone.FMI.FI> 
 */
extern int in_string P_((const char *, const char *));

/* lib/ldstate.c */

struct folder_view {
    int         mailbox_number;
    int         index;
    int         thread_number;     /* -1 if not defined or not generated */
    int         separator_number;  /* -1 if not defined or not generated,
				      also HEADER_NO_SEPARATOR
				   */
};

extern void zero_folder_view P_((struct folder_view *X));

/*
 * Filled in by "load_folder_state_file()".  This allows an external program
 * (e.g. "readmsg") to receive information on the current Elm state.
 */
struct folder_state {
    unsigned short magic;       /* LDSTATE_magic */

    struct folder_view *view;
    int                 view_len;

    struct storage_state {
	char *folder_name;	/* full pathname to current folder	*/
	int num_mssgs;		/* number of messages in the folder	*/

	struct storage_msg {
	    long idx;		/* index of seek offsets for messages	*/
	    long cl;
	} * mssgs;

    } * storage;
    int storage_len;

    int num_sel;		/* number of messages selected		*/
    int *sel_list;		/* list of selected message numbers	*/
};

extern void zero_ldstate P_((struct folder_state *fst));
extern void clear_ldstate P_((struct folder_state *fst));

extern int load_folder_state_file P_((struct folder_state *fst));

/* lib/len_next.c */

extern int len_next_part P_((const char *));

/* lib/mail_gets.c */

extern int mail_gets P_((char *buffer,size_t size,FILE *mailfile));

/* malloc_gets added by Kari Hurtta 
   Do not return \n
   reallocs *buffer

   return -1 if limit exceeded, buffer is still alloced
   return -2 if error or if feof() is true before reading anything

   limit == -1 no limit
*/
extern int malloc_gets P_((char **buffer, int limit, FILE *mailfile));


/* lib/okay_addr.c */

extern int compare_helper P_((const char *A, const char *pat,
			      int ignore_case));


/*lib/opt_utils.c  */

/* Returns -1 on failure! */
extern int gethostdomain P_((char *hostdom,int size, int global_mode));

#ifndef STRTOK
extern char *strtok  P_((char *, char *));
#endif

#ifndef STRPBRK
extern char *strpbrk     P_((char *, char *));
#endif

#ifndef STRSPN
extern int strspn        P_((char *, char *));
#endif

#ifndef STRCSPN
extern int strcspn       P_((char *, char *));
#endif

#ifndef TEMPNAM
extern char *tempnam     P_((char *, char *));
#endif

#ifdef GETOPT

#if GETOPT == GETOPT_OK
#define ELM_GETOPT getopt
#elif GETOPT == GETOPT_BOKEN
extern int ELM_GETOPT P_((int argc,char	** const argv, const char *aopt));
#define compile_ELM_GETOPT
#endif

#else
extern int getopt P_((int argc,char	** const argv, const char *aopt));
#define ELM_GETOPT getopt
#define compile_ELM_GETOPT
#endif

/* lib/posixsig.c */

#ifdef POSIX_SIGNALS
extern SIGHAND_TYPE (*posig_signal  P_((int, 
					SIGHAND_TYPE (*fun)P_((int))
					))
		     )P_((int));
#endif

#ifndef S__
#if defined(BSD_TYPE) && !defined(WEXITSTATUS)
typedef union wait S__;
#else
typedef int        S__;
#endif
#define S__ S__
#endif

extern int my_wait P_((int pid, S__ *statptr)); 
extern int convert_status P_((S__ status,int *exit_code));

/* lib/putenv.c  */
#ifndef PUTENV
extern int putenv   P_((char *));
#endif

/* lib/qstrings.c */

extern char       *qstrpbrk   P_((char *, const char *));
extern const char *qstrpbrk_c P_((const char *, const char *));
extern int qstrspn      P_((char *, char *));
extern int qstrcspn     P_((char *, char *));

/* lib/reverse.c */

extern void reverse P_((char *));

/* lib/safemalloc.c */

extern void dflt_safe_malloc_fail_handler P_((char *proc,size_t len));
extern void (*safe_malloc_fail_handler)   P_((char *proc,size_t len));

extern malloc_t safe_malloc  P_((size_t len));
extern malloc_t safe_zero_alloc P_((size_t len));
extern malloc_t safe_realloc P_((malloc_t p,size_t len));
extern malloc_t safe_calloc  P_((size_t nmemb, size_t size));
extern malloc_t safe_array_realloc  P_((malloc_t p, 
					size_t nmemb, size_t size));

/* Return 1 if safe result */
extern int safe_array_size P_(( size_t *result_size,
				size_t nmemb,
				size_t size));

/* Allocs (*str_len) + append_len + 1 bytes, \0 terminate string */
extern void safe_stralloc_append P_((char **str, size_t *str_len,
				     char *append, size_t append_len));

extern char *safe_strdup     P_((const char *s));

#ifdef DEBUG
#define free(x)  safe_free(x)
extern void safe_free P_((malloc_t x));
#endif

/* Maximun possible value for size_t  */
extern const size_t size_MAX;     /* SIZE_MAX if defined */

/* lib/shiftlower.c */

extern char *shift_lower     P_((const char *));


/* lib/sortlist.c */

union sort_item {
    void                    * dummy;
    struct resolv_cache     * resolv;
    struct uidl_entry       * uidl;
    struct aliases_map_node * aliases;
    struct thread_name      * thread_name;
    struct entity_sort_item * entity;
    struct tagfilter_cmd    * tf_cmd;
    struct last_read_cache  * last_read_cache;
    struct last_read_entry  * last_read_entry;
};

union sort_key {
    const void         * dummy;
    const char         * str;
    struct string_sort * string_sort;
    struct tf_tag_sort * tf_tag_sort;
};

union sort_item_default {
    void                          * dummy;
    const struct uidl_entry_def   * uidl;
    const struct aliases_node_def * aliases;
    const struct tf_cmd_def       * tf_cmd;
    const struct last_read_cache_def * last_read_cache;
    const struct last_read_entry_def * last_read_entry;
};

typedef void alloc_sort_item_f P_((union sort_item             * res,
				   const union sort_key          key,
				   const union sort_item_default def));
typedef void free_sort_item_f  P_((union sort_item      * ptr)); /* Decrements refcount */

typedef void inc_sort_item_refcount_f P_((union sort_item item));

/* caller must free string */
typedef struct string * sort_item_debug_name_f P_((const union sort_item item));
typedef struct string * sort_key_debug_name_f  P_((const union sort_key key));

/* If NULL key is possible, compare_sort_key_to_item_f should support them !! */

typedef int compare_sort_key_to_item_f P_((const union sort_key key,
					   const union sort_item item));

#define SORT_OPERATION_magic 0xE600

struct sort_operation {
    unsigned short magic; 	/* SORT_OPERATION_magic */

    alloc_sort_item_f          * alloc_item;
    free_sort_item_f           * free_item;
    inc_sort_item_refcount_f   * inc_item_refcount;
    sort_item_debug_name_f     * item_name;
    
    compare_sort_key_to_item_f * cmp_key_item;

    /* KEY operations */
    sort_key_debug_name_f      * key_name;
    
};

extern struct sortlist * alloc_sort_list P_((const struct sort_operation * op,
					     size_t  prealloc));
extern void free_sort_list P_((struct sortlist ** sortlist));
extern size_t sort_list_len P_((struct sortlist * sortlist));

enum sort_list_get_op {
    sort_list_get_normal = 0,
    sort_list_get_remove = 2  /* moves indexes when removed */
};

/* increments refcount */
extern void get_sort_list_item P_((struct sortlist     * sortlist,
				   enum sort_list_get_op op,
				   size_t                idx,
				   union sort_item     * res));

/* caller must free string */
extern struct string  * get_sort_list_debug_name P_((struct sortlist     * sortlist,
						     size_t                idx));

enum sort_list_search_op {
    sort_list_search_normal = 0,
    sort_list_search_create,     /* moves indexes when created */
    sort_list_search_remove = 2, /* removes item from sort list, if found */
                                 /* moves indexes when removed */

    sort_list_insert_hint        /* Give hint *res_idx to where add
				    new index -- used when reading
				    from ordered file
				 */
};

/* Increments refcount, returns 1 if found or created */
extern int search_sort_list_item P_((struct sortlist             * sortlist,
				     enum sort_list_search_op      op,
				     const union sort_key          key,
				     const union sort_item_default def,
				     union sort_item             * res,
				     size_t                      * res_idx,
				     int                         * append_need_rewrite
				     ));

extern void prealloc_sort_list P_((struct sortlist * sortlist,
				  size_t  prealloc));





/* lib/strfcpy.c */

extern char *strfcpy P_((char *, const char *, int));
extern char *strfcat P_((char *, const char *, int));
extern char *strnfcpy P_((char *dest, const char *src, int len, int size,
                          int *produced));


/* lib/strincmp.c */

/* Is this needed? This is same than strncasecmp 
 *        - K E H <hurtta@ozone.FMI.FI>
 */

extern int strincmp P_((const char *, const char *, int));

/* lib/striparens.c */

extern char *strip_parens P_((const char *s));
extern char *get_parens   P_((const char *s));

/* lib/strstr.c */

/* Why there is both in_string and strstr????
 *     - K E H <hurtta@ozone.FMI.FI>
 */

#ifndef STRSTR
extern char *strstr P_((char *,char *)); 
#endif

/* lib/cs_utf.c */

extern const charset_t IMAP_ENCODING;
extern const charset_t UTF8_ENCODING;

/* lib/charset.c */

extern charset_t display_charset;	 /* current terminal charset */
extern charset_t system_charset;	 /* character set used by ctype()
					    routines
					  */
extern const charset_t RAW_BUFFER;       /* 'Raw' byte buffer !!!!!!  */

extern const charset_t ASCII_SET;

#define SET_valid   0x0001 /* make possible to 'clear' previous defination */
#define SET_mark    0x0002 /* mark used by charset_compatfunc and      */
#define SET_printed 0x0004
#define SET_nodata  0x0008
#define SET_havealias  0x0010


#define CS_printable         1     /* Have printable information */
#define CS_mapping           2     /* Have some mapping information */
#define CS_universal_set     4     /* Consider that to be universal charset */
#define CS_printable_len     8     /* supports struct cs_printable_len */
extern int charset_properties P_((charset_t ptr));

#define CHARSET_create       1
#define CHARSET_noautodef    2
#define CHARSET_noalias      4

/* May be called from signal hadler */
extern const char * get_charset_MIME_name P_((charset_t cs));

extern const struct  charset_type * get_charset_type P_((charset_t cs));

extern charset_t MIME_name_to_charset P_((const char *name,int flag));
extern charset_t codeset_name_to_charset P_((const char *name));
extern int charset_compatfunc P_((char **value, int enter,
				  int lineno, char *filename));
extern int charset_iso646func P_((char **value, int enter,
				  int lineno, char *filename));
extern int charset_ok_p P_((charset_t ptr));
extern int load_charset_map_info P_((charset_t *buffer, const char *data));
extern int charset_superset_of P_((charset_t charset, charset_t subset));

extern int ISO2022_superset_of P_((charset_t charset,
				   charset_t subset));

/* helper routines on charset.c */
extern char * mime_parse_content_opts P_((char *str, char **walk));
extern int mime_get_param             P_((const char *name, char *value,
					  const char *opts, int size));
extern void rfc822_reap_comments      P_((char *, char *, int));
extern char * dequote_opt P_((const char *source, int len));

extern int is_utf8_charset P_((charset_t cs)); /* helper */

/* lib/charset.c */

extern char base64chars[64];

#define to64(c) (((c) >= 0) && ((c) < 64)) ? base64chars[(c)] : -1

/* lib/charset_input.c */


extern struct charset_state * new_state P_((charset_t set));
extern void free_state P_((struct charset_state **state));
extern int state_ready P_((struct charset_state *st));
extern int state_printable P_((struct charset_state *st));
extern int add_streambyte_to_state P_((struct charset_state *st, int ch));
extern void reset_state P_((struct charset_state *st, int hard));
extern uint16 give_unicode_from_state P_((struct charset_state *st));
extern int state_same_char P_((struct charset_state *A,
			       struct charset_state *B,
			       int ignore_case));

/* If character corresponds one byte on stream, returns it.
 * Otherwise returns 0. This is used implement ReadCh().
 * It is assumed that returned character corresponds to
 * code characterter set (and perhaps also US-ASCII)
 */
extern int state_is_onebyte P_((struct charset_state *st));

extern charset_t get_state_charset
   P_((const struct charset_state *st));

extern void set_state_caller_flags P_((struct charset_state *st,
				       int caller_flags));
extern int get_state_caller_flags P_((struct charset_state *st));

/* lib/string.c */

extern struct string * new_string P_((charset_t set));
extern struct string * new_langstring P_((charset_t set, char *lang));
extern void free_string P_((struct string **str));
extern int verify_string P_((struct string *str));
extern const char * get_string_lang P_((const struct string *str));
extern const char * get_string_MIME_name P_((const struct string *str));
extern const struct  charset_type * get_string_charset_type 
    P_((const struct string *str));
extern charset_t get_string_type P_((const struct string *str));
extern struct string * new_string2 P_((charset_t set, 
				       const unsigned char *data));

extern enum charset_unicode_stat {
    charset_unicode_bad     = -2      /* Unicode value is bad */,
    charset_unicode_unknown = -1,
    charset_missing_unicode = 0       /* charset do not have given unicode
					 value 
				      */,
    charset_have_unicode              /* string with that type can store 
					 given unicode value 
				      */
	} string_type_have_unicode P_((charset_t set,
				       int unicode));

extern int add_streambyte_to_string P_((struct string *str, int ch));
extern int add_streambytes_to_string P_((struct string *str, 
					 int count, 
					 const unsigned char *data,
					 int *errors));
extern void add_state_to_string P_((struct string *str, 
				   struct charset_state *ch));

extern struct string * cat_strings P_((const struct string *str1, 
				       const struct string *str2,
				       int printind));
extern int string_len P_((const struct string *str));
extern int string_cmp P_((const struct string *str1, 
			  const struct string *str2,
			  int unknown_val));
extern struct string * dup_string P_((const struct string *str));
extern struct string * convert_string P_((charset_t set,
					  const struct string *str,
					  int printind));
extern struct string * convert_string2 P_((charset_t set,
					   const struct string *str,
					   int *failcount)); 

/* return 1 on succeed and 0 on failure */
extern int string_match P_((const struct string * name, 
			    const struct string * pat,
			    int ignore_case));

typedef struct display_settings * screen_info_p; 
/* result is malloced */
extern unsigned char *stream_from_string P_((const struct string *str,
					     int printable,
					     screen_info_p terminal));

/* result is malloced */
extern void bytestream_from_string P_((const struct string *str,
				       char **res,
				       int *reslen));

/* NOTE: struct cs_printable_len is only allowed if 
   charset_properties() gives CS_printable_len and
   also terminal argument is given
*/

struct cs_printable_len {
    int max_len;               /* Maximun printable len for streamclip_from_string() */
    int ret_len;               /* Printable len of result */
};

/* result is malloced, printable only */
extern unsigned char *streamclip_from_string P_((const struct string *str,
						 int *pos, int len,
						 screen_info_p terminal,
						 struct cs_printable_len *printable_len)); 

/* Returns how many characters fits to given printable_len, 
   from give pos  (do not update pos as actual clip -- to update pos
   use pos += returned_value -- does not handle unknown characters
   -- if first character is unknown returns -1
*/
extern int estimate_clip_string P_((const struct string *str,int pos, int len,
				    screen_info_p terminal,
				    struct cs_printable_len *printable_len));
					
extern struct string *ascify_string P_((const struct string *str));
extern int can_ascii_string P_((const struct string *str));
extern void add_ascii_to_string P_((struct string *str, 
				    const unsigned char *ascii));

enum { 
    UNICODE_NO_BREAK_SPACE =       0x00A0,
    UNICODE_SOFT_HYPHEN =          0x00AD,
    UNICODE_BAD_CHAR =             0xFFFD   /* REPLACEMENT CHARACTER */
};

extern void add_unicode_to_string P_((struct string *str, 
				      int len,
				      const uint16 *vector));

extern void fill_ascii_to_string P_((struct string *str, 
				     int count, unsigned int ascii));

extern struct string *clip_from_string P_((const struct string *str,
					   int *pos, int len));

extern int find_pattern_from_string P_((const struct string *str,
					const struct string *pattern,
					int ignore_case));

extern uint16 give_unicode_from_string P_((const struct string *str,
					   int pos));

#define GCHAR_unicode  0x0001
#define GCHAR_bytecode 0x0002
/* Returns flags what values are valid */
extern int  give_character_from_string P_((const struct string *str,
					   int pos,
					   uint16             *unicode,
					   unsigned char      *bytecode));

extern struct string *collapse_spaces_from_string P_((const struct string 
						      *str));
extern struct string *skip_ascii_head_from_string P_((const struct string *str,
						      const unsigned char *ascii,
						      int ignore_case));

#define GWF_lowercase 1
#define GWF_trim_space 2
extern int get_word_from_string P_((const struct string *str,
				    struct string **word,
				    int *pos,
				    int flags,
				    const unsigned char *ascii_delim,
				    uint16 *found_delim));

extern void remove_control P_((const struct string *str));

/* bad_pos is -1 if string is OK */
extern long string_to_long P_((const struct string *str,
			       int *bad_pos));


enum SMA_bits {
    SMA_bit_ignore_case,
    SMA_bit_return_len,
};

/* Return 1 on matches, otherwise 0 
   Return match len if flag&SMA_return_len

   Return 0 on matches (and otherwise <0 or >0) 
   if op == SMA_op_return_order 

   Find ascii subtring, 
   if op ==  SMA_op_find_ascii (return start pos or -1)

   SMA_return_len can not used with SMA_op_return_order 
*/
#define SMA_ignore_case   (1 << SMA_bit_ignore_case)
#define SMA_return_len	  (1 << SMA_bit_return_len)

enum SMA_operation {
    SMA_op_normal = 0,
    SMA_op_match_prefix,
    SMA_op_find_ascii,    /* Find ascii subtring, return start pos or -1  */
    SMA_op_return_order   /* return < 0 or > 0 if no match and 0 on macth 
			     
			     return 1 if unicode not found
			     return 1 if ascii ends first
			     
			     return -1 if str < ascii
			     return 1 if str > ascii

			     return -1 if str ends first
			  */
};

extern int string_matches_ascii P_((const struct string *str,
				    const unsigned char *ascii,
				    int flag,
				    enum SMA_operation op
				    ));

/* Returns prefix len, 0 on no match and -1 if unknown character 

   Note: because this returns prefix len, 
         empty prefix gives 0 which is same than no match
*/

extern int string_have_prefix  P_((const struct string *str,
				   const struct string *prefix));
				   

/* Returns -1 or index */
int string_have_ascii_sep P_((const struct string *str,
			      const unsigned char *ascii /* pick one char */));
int string_have_ascii_sep1 P_((const struct string *str,
			       const unsigned char *ascii /* pick one char */,
			       int start_pos,
			       int limit_pos));



/* Returns -1 or index */
extern int locate_unicode_from_string P_((const struct string *str,
					  int unicode));

extern void append_string P_((struct string ** res, 
			      const struct string *s,
			      int printend));

extern void string_copy_character P_((struct string ** res,
				      const struct string *s,
				      int *pos, int len,
				      int *errors));
extern void  digest_feed_string P_((struct digest_proc * ret,
				  const struct string *s));


/* lib/string_alt.c */

#ifdef ANSI_C
struct out_entity;
#endif

extern struct string_alt * new_string_alt_text P_((const struct string *str));
extern struct string_alt * new_string_alt_entity
   P_((struct out_entity *oe));

enum string_alt_type {
    string_alt_none = 0,
    string_alt_text,
    string_alt_entity
};

extern const union string_alt_value {
    unsigned short    *  magic;
    struct string     *  text;
    struct out_entity *  entity;
} get_string_alt_value P_((struct string_alt    * str_alt,
			   enum string_alt_type * res_type
			   ));


extern void inc_string_alt_refcount P_((struct string_alt *str_alt));

extern void free_string_alt P_((struct string_alt **str_alt));

/* lib/string_sort.c */

extern struct string_sort * new_string_sort P_((struct string *s));
extern void free_string_sort P_((struct string_sort **ptr));
extern int string_sort_cmp P_((const struct string_sort *ptr1,
			       const struct string_sort *ptr2));

/* Increments refcount, caller must call free_string() */
extern struct string * give_string_from_string_sort P_((struct string_sort *ptr));


extern void inc_string_sort_refcount P_((struct string_sort *ptr));


/* lib/pager_range.c */

#ifdef ANSI_C
struct pager_range;
struct pager_param_value;
#endif

extern void  free_pager_range P_((struct pager_range **range)); 

enum pr_flag_bits {
    PR_bit_REPLY_QUOTE  = 0,
    PR_bit_WORD_WRAP,
    PR_bit_JOIN_LINES,
    PR_bit_PREFORMAT,
    PR_bit_QUOTE_L,
    PR_bit_MAX_WIDTH,
    PR_bit_INDENT_ABSOLUTE,
    PR_bit_SAME_LINE,
    PR_bit_CENTER_THIS,
    PR_bit_FLAGS_ABSOLUTE,
    PR_bit_ADD_SPACE,
    PR_bit_COLLAPSE_NOINHERIT,
    
    NUM_pr_flag_bits
};


#define PR_REPLY_QUOTE          (1 << PR_bit_REPLY_QUOTE)       /* Is this needed? */

/* Used by text/plain; format=flowed    for flowed paragraphs
*/
#define PR_WORD_WRAP            (1 << PR_bit_WORD_WRAP)
#define PR_JOIN_LINES           (1 << PR_bit_JOIN_LINES)

/* Used by text/plain; format=fixed    and
   used by text/plain; format=flowed   for fixed lines 
*/
#define PR_PREFORMAT            (1 << PR_bit_PREFORMAT)

/* Used for decode_opt quote_l         */
#define PR_QUOTE_L              (1 << PR_bit_QUOTE_L)   /* Duplicate [ so that it is quoted */

/* Used for title                      */
#define PR_MAX_WIDTH            (1 << PR_bit_MAX_WIDTH)

/* Used in initialization of indent    */
#define PR_INDENT_ABSOLUTE      (1 << PR_bit_INDENT_ABSOLUTE)

/* get_pager_range_change() returns rc_same_line */
#define PR_SAME_LINE            (1 << PR_bit_SAME_LINE)

/* Center this line / part of line */
#define PR_CENTER_THIS          (1 << PR_bit_CENTER_THIS)        

/* Flags do not inherit */

#define PR_FLAGS_ABSOLUTE       (1 << PR_bit_FLAGS_ABSOLUTE)

/* Add space on join */
#define PR_ADD_SPACE            (1 << PR_bit_ADD_SPACE)

/* Collapse spaces when paging with builtin pager
   and do not inherit this
*/
#define PR_COLLAPSE_NOINHERIT	(1 << PR_bit_COLLAPSE_NOINHERIT)



extern int get_pager_range_flags P_((const struct pager_range *range));

/* Quote level of text/plain; format=flowed */
extern int get_pager_range_quote_level P_((const struct pager_range *range));

/* Indent column 0 .. (columns)-1  ... may be out of range */
extern int get_pager_range_indent P_((const struct pager_range *range));

extern enum pager_range_opcode {
    pr_opcode_none = 0,
	pr_opcode_pager_replace

} get_pager_range_opcode P_((const struct pager_range *range));

/* range1 and range2 may be NULL */
extern enum range_changed {  rc_same_range    = 0, /* range not changed
						      or no range   */
	rc_newline,                                /* range changed */
	rc_same_line 
	} get_pager_range_change P_((const struct pager_range * range1,
				     const struct pager_range * range2));

extern void inc_pager_range_refcount P_((struct pager_range *range));

enum pager_param_opcode {
    pp_opcode_ANY     = -1 /* search any */,
    pp_opcode_builtin = 0,

};

enum pager_param_type {
    pp_type_none = 0,
    pp_type_text
};

/* Similar than union string_alt_value */

extern const union pager_param_uvalue {
    unsigned short        * magic; 
    struct string         * text;
    
} get_pager_param_uvalue P_((struct pager_param_value * value,
			     enum pager_param_type    * res_type));

extern void free_pager_param_value P_((struct pager_param_value **value));


/* lib/pager_lineext.c */

#ifdef ANSI_C
struct pager_lineext;
#endif

/* Changes *walk_extension to point next line extension or to NULL */

extern struct string *get_lineext_and_walk 
     P_((struct pager_lineext **walk_extension,
	 int *pg_flags,
	 enum range_changed * range_changed,
	 struct pager_range **range));

extern struct string_alt * get_lineext_alt_and_walk
     P_((struct pager_lineext **walk_extension,
	 int *pg_flags,
	 enum range_changed * range_changed,
	 struct pager_range **range));

extern void free_pager_lineext P_((struct pager_lineext **extension));
extern void inc_pager_lineext_refcount P_((struct pager_lineext *extension));

/* lib/stringbuffer.c */

#ifdef ANSI_C
struct out_entity;
#endif

extern struct stringbuffer * create_membuffer P_((void));
extern struct stringbuffer * create_filebuffer P_((void));
extern void free_stringbuffer P_((struct stringbuffer **ptr));
extern void add_line_to_stringbuffer P_((struct stringbuffer *buffer,
					 const struct string *string,
					 int pg_flags,
					 struct pager_range *range,
					 int eoln));
extern int linecount_stringbuffer P_((const struct stringbuffer *ptr));

/* called of get_param_from_stringbuffer() is expected to
   free_pager_param_value()  resulting buffer */

extern struct pager_param_value * get_pager_param_from_stringbuffer
    P_((struct stringbuffer     * buffer,
	struct pager_range     * range,
	enum pager_param_opcode  opcode,
	int                    * next_pos /* iterator */,
	int                    * found_pos /* -1 if not found */));

/* caller of get_line_from_stringbuffer is expected to free_string ()
   resulting buffer, 

   also caller is expected to call free_pager_range()
   or give same pointer to get_line_from_stringbuffer()
*/
extern struct string *get_line_from_stringbuffer P_((struct stringbuffer *buffer,
						     int ptr,
						     int *pg_flags,
						     enum range_changed *
						     range_changed,
						     struct pager_range **range,
						     struct pager_lineext **first_extension));

/* Allocates new struct pager_range -- not used */
extern struct pager_range * stringbuffer_add_simple_pager_range 
  P_((struct stringbuffer *buffer, struct pager_range *inherit,
      int range_flags, int quote_level, int indent));

/* Add entity to last line */
extern enum stringbuffer_entity_result {
    sb_entity_reference_key = -2 /* Print reference_key */,
    sb_entity_fallback = -1,
    sb_entity_failed = 0,
    sb_entity_succeed,
    } stringbuffer_add_entity P_((struct stringbuffer *buffer,
				  struct out_entity *oe,
				  int pg_flags,
				  struct pager_range *range));


extern void stringbuffer_add_pager_param P_((struct stringbuffer *buffer,
					     struct pager_range *range,
					     enum pager_param_opcode opcode,
					     struct pager_param_value * param_value));

	
/* lib/unicode.c */

enum unicode_op { UOP_none, UOP_lowercase, UOP_noctrl, 
		  UOP_printable, UOP_space };

/* Returns 0 if char not OK, otherwise char or converted char */
extern uint16 unicode_ch P_((unsigned int ch, enum unicode_op op)); 


/* lib/rc_handle.c */

typedef struct dt_path_info PATH;

/* Pointer to internal list, do NOT free */
extern const char ** give_dt_path_as_elems P_((struct dt_path_info *ptr,     
					       const char * fieldname));

/* Result is malloced, caller must free */
extern char * give_dt_path_as_str P_((struct dt_path_info *ptr,
				      const char * fieldname));

typedef struct dt_estr_info ESTR;

/* Returns 1 if sepecial value "none" */
extern int dt_estr_is_disabled    P_((struct dt_estr_info *ptr));
extern const char * give_dt_estr_as_str P_((struct dt_estr_info *ptr,
					    const char * fieldname,
					    /* keyword and mask may be NULL */
					    unsigned int *keyword, 
					    unsigned int *cmask));

/* Set initial value */
extern void set_dt_estr P_((struct dt_estr_info *ptr,
			    const char *const_val,
			    char *def_env,
			    unsigned int is_keyword,
			    unsigned int  continue_mask));

typedef struct dt_enumerate_info ENUMERATE;

/* < 0 if enumarated value is on form tag:value */
extern int give_dt_enumerate_as_int P_((struct dt_enumerate_info *ptr));


/* *translated_value is relative to *tag */
extern struct dt_enum_shared * 
    give_dt_shared_value P_((struct dt_enumerate_info *ptr,
			     const char **tag,
			     int * translated_value));

/* give_dt_enumerate_as_str / set_dt_enumerate_as_str do not support
   boolean values */

extern const char * give_dt_enumerate_as_str P_((struct dt_enumerate_info *ptr));
extern int set_dt_enumerate_as_str P_((struct dt_enumerate_info *ptr,
				       char *str,
				       const char * fieldname,
				       int lineno,
				       const char *filename
				       ));


typedef struct dt_sort_info SORT;

extern const char * give_dt_sort_as_str P_((struct dt_sort_info *ptr));
extern int give_dt_sort_as_int P_((struct dt_sort_info *ptr));
extern void set_dt_sort_as_int P_((struct dt_sort_info *ptr, int val));

typedef struct dt_flags_info FLAGS;

extern int dt_flag_is_set P_((struct dt_flags_info *ptr, int tag));
extern const char * give_dt_flag_as_str P_((struct dt_flags_info *ptr));
extern const char * dt_flag_tag P_((struct dt_flags_info *ptr, int tag));

/* lib/read_rc.c */

enum record_mode { SYSTEM_RC = 0, LOCAL_RC = 1, RC_MODE_COUNT };

extern struct elmrc_recorder  * enable_recorder P_((enum record_mode mode));
extern int seed_history P_((FILE *F, char * filename,
			    struct elmrc_recorder  *recorder));
extern void print_history_changed P_((FILE *F, 
				      struct elmrc_recorder  *recorder));

extern char * mode_to_str P_((int mode));

typedef int option_func P_((char **value, int enter,
			    int lineno, const char *filename,
			    int read_flags /* READ_FLAG_IGNORE_MISSING */
			    ));

extern void mark_local_changed P_((void *A, int no_history_record));
extern void mark_flocal_changed P_((option_func *A, int no_history_record));


#define SLEN		256	    /* length for elmrc variables ... */

struct charset_map_item * load_charset_map P_((const char *filename, 
					       int *errors));

extern struct charset_map_item   * system_charset_map;
extern struct charset_map_item   * user_charset_map;

extern void set_user_rc_location P_((char *p));

extern void locale_init P_((void));     /* sets locale and elm_msg_cat */
extern void user_init P_((void));       /* get username and home directory */

#define  READ_FLAG_GLOBAL_ONLY     4    /* Called for global initialization */
#define  READ_FLAG_IGNORE_MISSING  8    /* elmconfwriter called before installation */

extern int init_defaults P_((int global_mode));

#define  READ_FLAG_UNIDATA_INIT    1    /* Called from elmunidata routine */
#define  READ_FLAG_BINDATA_INIT    2    /* Called from elmbindata routine */
extern int read_rc_file  P_((int read_flags));
extern void post_init_check P_((int read_flags));  /* read_rc_file calls this */

extern int parse_elmrc P_((FILE *F,int global, char *filename,
			   int read_flags /* READ_FLAG_IGNORE_MISSING */));
extern void post_process_charset_options P_((void));
extern int matches_weedlist P_((char *buffer, int have_title));

extern char old_system_text_file[SLEN];      /* $etc/aliases.text */
extern char old_system_data_file[SLEN];      /* $etc/aliases */
extern char system_aliases_file[SLEN];       /* $elm/elm.aliases */
extern char system_rc_file[SLEN];        /* $etc/elm.rc */
extern char system_mime_types[SLEN];     /* $etc/elm.mimetypes */
extern char hostdomfile[SLEN];           /* $etc/domain */
extern char system_mime_charsets[SLEN];  /* $etc/elm.mimecharsets */

extern char system_iso2022_sets[SLEN];   /* $etc/elm.iso2022sets */
extern struct iso2022_map_conf  * system_iso2022_map_conf;

extern char system_terminal_info[SLEN];  /* $etc/elm.terminalinfo */

extern char system_mail_services[SLEN];  /* $etc/elm.mailservices */
extern charset_t                   system_mail_services_cs;
extern struct editor_propline    * system_mail_services_pl;
extern struct mail_services_conf * system_mail_services_conf;

extern char system_mlist_file[SLEN];     /* $etc/elm.mlists     */
extern char system_hash_marks[SLEN];     /* $etc/elm.hashmarks  */
extern char system_tagfilter_entfile[SLEN];  /* $etc/elm.tagfilter.entities */


extern ESTR map_txtdir_e;                /* $lib/elm.map.txt */
extern ESTR map_bindir_e;                /* $lib/elm.map.bin */
extern char unidata_path[SLEN];          /* $lib/elm.map.bin */
extern char unidata_path_global[SLEN];   /* Used before user elm.rc is read */
extern char raw_unidata_path[SLEN];      /* $lib/elm.map.bin */

extern int  unstable_reverse_thread;

extern char bindata_path[SLEN];            /* $lib/elm.map.bin */
extern char bindata_path_global[SLEN];   /* Used before user elm.rc is read */
extern char raw_bindata_path[SLEN];        /* $lib/elm.map.bin */

extern char user_rc_file[SLEN];          /* .elm/elmrc */
extern char old_user_text_file[SLEN];        /* .elm/aliases.text */
extern char old_user_data_file[SLEN];        /* .elm/aliases */
extern char user_aliases_file[SLEN];         /* .elm/elmaliases */
extern char user_mime_types[SLEN];       /* .elm/mime.types */
extern char user_mailheaders[SLEN];      /* .elm/elmheaders */
extern char user_mime_charsets[SLEN];    /* .elm/mime.charsets */

extern char user_iso2022_sets[SLEN];     /* .elm/iso2022.sets */
extern struct iso2022_map_conf      * user_iso2022_map_conf;

extern char user_terminal_info[SLEN];    /* .elm/terminal.info */

extern char user_mail_services[SLEN];    /* .elm/mail.services */

extern charset_t                   user_mail_services_cs;
extern struct editor_propline    * user_mail_services_pl;
extern struct mail_services_conf * user_mail_services_conf;

extern char user_mlist_file[SLEN];    /* .elm/mlists             */
extern char user_hash_marks[SLEN];    /* .elm/hash.marks         */
extern char user_tagfilter_entfile[SLEN]; /* .elm/tagfilter.entities */ 

extern char user_last_read_def[SLEN]; /* .elm/last.read    */
extern char user_last_read_dot[SLEN]; /* .elm-last-read-{uid}  */

extern ESTR calendar_file_e;	/* name of file for clndr       */

#define defaultfile_KW_MAIL        0x0001
#define FOLDER_is_local_file       0x0100  /* Used by enter_new_folder */

extern ESTR defaultfile_e;	/* name of default folder       */


extern nl_catd elm_msg_cat;	/* message catalog	        */
extern int  title_messages;	/* flag: title message display? */
extern char home[SLEN];		/* home directory of user       */
extern char username[SLEN];	/* return address name!         */
extern int userid;		/* uid for current user	        */
extern int groupid;		/* groupid for current user     */

extern int mailgroupid;		/* groupid for current user     */
extern int have_saved_ids;      /* sysconf _SC_SAVED_IDS        */

extern const char * have_dummy_domain;   /* DUMMYDOMAIN  -- ".localdomain" */

/* Really constants currently:  ----------------  */

extern const int ALLOW_mailbox_editing; /* set if 
				    ALLOW_MAILBOX_EDITING
				    defined */
extern const int ALLOW_subshell; /* Set if ALLOW_SUBSHELL
				    defined */
extern const int ENABLE_calendar; /* Set if ENABLE_CALENDAR
				     defined */
extern const int have_ISPELL;    /* set if ISPELL defined */
extern const char ISPELL_path[];   /* set if ISPELL_PATH defined */
extern const char ISPELL_options[]; /* set if ISPELL_OPTIONS defined */

extern const int have_MMDF;      /* set if MMDF defined */
extern const enum poll_method {
        POLL_method_none = 0,
	POLL_method_select = 1,
	POLL_method_poll = 2 } 
    POLL_method;                 /* set if POLL_METHOD defined */
extern const int use_PGP;        /* set if USE_PGP defined     */

extern const int CHOWN_neg1;    /* Set if CHOWN_NEG1 defined   */

extern const char dsn_mail_tag[]; /* [dsn] */

/* *** Read from elmrc: */

extern int  add_irt_phrase;     /* In-reply-to: Add phare to in-reply-to ?
				   True = Do not follow RFC 2822 */

enum add_sender_v {
    add_sender_no               /* Add Sender: header only when there is
				   more than  one address on From: -header */,
    add_sender_yes              /* Add Sender: header also when user
				    specifies From: -header or user changes
				    changes envelope sender address (aka Return-Path)
				*/,
    add_sender_auto             /* If mailer is local or mail domain can
				   be verified (or verify is diabled), add 
				   Sender: header when user
				   specifies From: -header or user changes
				   changes envelope sender address (aka Return-Path)
				*/,
				   
    NUM_add_sender
};

extern ENUMERATE add_sender_header;  /* If set add Sender: header if user specifies
					From: -header
				     */

enum addr_lookup_v {
    addr_lookup_normal             /* same as gethostbyaddr     */,
    addr_lookup_shared             /* RESERVED                  */,
    addr_lookup_gethostbyaddr      /* gethostbyaddr             */,
    addr_lookup_getnameinfo        /* getnameinfo               */,

    NUM_addr_lookup
}; 

extern ENUMERATE address_lookup;      /* Should try some odd address 
				        lookup ? 
				       */


extern int allow_charset_switching; /* flag: allow changing charset of terminal
				      if terminal supports it */
extern int allow_setuid;

extern SORT alias_sortby;	/* how to sort aliases        */
extern int  alias_group_phrase; /* Use phrases on group aliases */

/* must use same values that editor_* */
enum alteditor_keyword { alteditor_kw_NO   = 0,
			 alteditor_kw_builtin = 1, /* indirectly, not keyword */
			 alteditor_kw_EDITOR = 2
};

#define  alteditor_KW_EDITOR      0x0001    /* == editor_KW_EDITOR */
#define  alteditor_KW_VISUAL      0x0002    /* == editor_KW_VISUAL */
extern ESTR alternative_editor_e;/* the 'other' editor    */

extern PATH alternative_addresses;	/* how else do we get mail? */
extern int  always_del;		/* flag: always delete marked msgs?   */
extern int  always_keep;	/* flag: always keep unread msgs?     */
extern int  always_store;	/* flag: always store read mail?      */

extern int  ask_delete;         /* confirm delete on resync? */
extern int  ask_keep;           /* ask to keep unread msgs? */
extern int  ask_reply_copy;     /* ask to copy mssg into reply? */
extern int  ask_store;          /* ask to store read mail? */

extern int  arrow_cursor;	/* flag: use "->" regardless?	      */

extern ESTR attachment_dir_e;
extern int  attachment_fix_extension; /* flag: fix extension of attashment when saving */

extern int  prompt_for_cc;	/* flag: prompt user for 'cc' value?  */
extern int pgp_askpgpsig;   /* Should pgp ask userid to sign messages with? */
extern int pgp_interactive; /* Should pgp/gpg encryption/signing to be
			       run always on interactive mode */

enum pgp_sign_type_v { 
    pgp_sign_application_pgp = 0,
    pgp_sign_text_plain      = 1,
    pgp_sign_text_x_pgp      = 2,
    NUM_pgp_sign_type };
extern ENUMERATE pgp_sign_type;   /* 0 = application/pgp
			             1 = text/plain
			             2 = text/x-pgp
				  */
enum pgp_encrypt_type_v { 
    pgp_encrypt_application_pgp = 0,
    pgp_encrypt_text_plain      = 1,
    pgp_encrypt_text_x_pgp      = 2,
    NUM_pgp_encrypt_type };
extern ENUMERATE pgp_encrypt_type;   /* 0 = application/pgp
					1 = text/plain
					2 = text/x-pgp
				     */
enum pgp_version { pgp_none = 0, pgp2 = 1, pgp5 = 2, gpg = 3,
                   PGP_NUM };
extern ENUMERATE send_pgp_version; /* preferred pgp version*/

extern struct string * attribution_s;    /* attribution string for replies     */
extern struct string * fwdattribution_s; /* attribution string for forwarded mssgs */

enum auto_attachment_v { 
    auto_attachment_none        = 0,
    auto_attachment_application = 1,
    auto_attachment_non_text    = 2,
    NUM_auto_attachment };
extern ENUMERATE auto_attachment;    /* 0 = none,
					1 = application,
					2 = non-text
				*/
extern int  reply_copy;		/* flag: copy message into reply */
extern int  auto_iso_8859;      /* flag: Should ISO-8859-X charsets defined
				   on demand ?                        */
#ifdef BACKGROUD_PROCESSES       
extern int background_wait_time; /* If > 0 background mailer after
				  * this number of seconds
				  */
#endif
/* extern int  bounceback;	*/   /* flag: bounce copy off remote?      */

enum browser_wildcards_v { 
    browser_wildcard_no  = 0,
    browser_wildcard_yes = 1,
    browser_wildcard_file_browser = 2,
    NUM_browser_wildcards };
extern ENUMERATE browser_wildcards;   
                                 /* 0 == no
				    1 == yes
				    2 == on Elm 2.5 style file browser
				  */
extern int browser_tabcomplete; /* flag:  tabcomplete prompt?    */
extern int  builtin_lines;	/* int use builtin pager?             */
extern int charset_convert_ok;  /* flag: no warning about conversion? */
extern int check_type_pattern;  /* flag: check magic numbers when paging */
extern char      raw_text_charset[SLEN];  /* name of character set       */
extern charset_t text_charset;	          /* pointer to character set    */
extern ESTR dead_letter_dir_e;     /* Canceled.mail.dir        */

#define FLAGVAL(tag)    (1L << (tag))

enum mail_menu_time_v {
    mmtime_yseparator_flag,                 /* "year-separator" */
    mmtime_aseparator_flag,                 /* "auto-separator" */
    mmtime_today_flag,                      /* "today"          */
    mmtime_todaysep_flag,                   /* "today-separator" */
    mmtime_year_time_flag,                  /* "year-or-time"   */
    
    NUM_mail_menu_time_v
};
extern FLAGS mail_menu_time;


enum mailbox_locking_v {
    lock_lockfile_flag,                    /* not used on folder locking */
    lock_flock_flag,
    lock_fcntl_flag,
    lock_prefer_flag,                      /* Not used for locking       */
    NUM_mailbox_locking_v
};
extern FLAGS folder_locking;

extern char raw_default_mimetext_charset[SLEN]; /* name of character set    */
extern charset_t default_mimetext_charset;      /* pointer to character set */
extern char raw_default_nomime_charset[SLEN]; /* name of character set       */
extern charset_t default_nomime_charset;      /* pointer to character set    */

enum folder_status_v {        /* moved from elm_defs.h #defines */
    FOLDER_STATUS_READ = 0,           
    FOLDER_STATUS_OLD  = 1,
    FOLDER_STATUS_NEW  = 2,
    NUM_folder_status };
extern ENUMERATE def_folder_status;       /* 0 = Read
					     1 = Old
					     2 = New
					   */

extern FLAGS conf_merge_locking;

extern char config_options[SLEN];	/* which options are in o)ptions */
extern int  confirm_append;	/* flag: confirm append to folder?    */
extern int  confirm_create;	/* flag: confirm create new folder?   */
extern int  confirm_files;	/* flag: confirm files for append?    */
extern int  confirm_folders;	/* flag: confirm folders for create?     */
extern int  confirm_print;      /* flag: confirm printing of messages ?    */
extern int  confirm_tag_save;   /* flag: confirm saving of tagged messages */
extern int  edit_flush;	        /* flag: flush input after extern edit? */
extern int  convert_comment;    /* flag: convert comment to fullname ?   */

enum convert_cr_v {
    convert_cr_off,
    convert_cr_error,
    convert_cr_silent,

    NUM_convert_cr_hack
};
extern ENUMERATE convert_cr_to_newline_hack;  /* 0 = off                      */
                                              /* 1 = on-with-error            */
                                              /* 2 = on-silent                */

extern int  convert_utf_header; /* flag: convert utf-8 mime encoded words to utf-7 when sending?   */
extern int  auto_copy_sent;	/* flag:  automatically copy sent mail?  */
extern char display_locale[SLEN];	/* LC_CTYPE locale (character set) */
extern char display_codeset[SLEN];     /* nl_langinfo(CODESET) for current locale (character set) */

extern char raw_display_charset[SLEN];
extern charset_t wanted_display_charset; /* name of character set */
extern int DSN_success;         /* flag: Ask successfull DSNes      */

extern ESTR dsn_mail_e;	        /* folder for storing DSN mail	*/

extern char e_editor[SLEN];	/* "~e" editor...   */

enum editor_keyword { editor_kw_NO   = 0,
		      editor_kw_builtin = 1 
};

#define  editor_KW_EDITOR      0x0001
#define  editor_KW_VISUAL      0x0002
extern ESTR editor_e;             /* editor for outgoing mail*/


enum editor_propline_v {
    editor_propline_none   = -1,   /* No property line detected */
    editor_propline_auto   = 0,
    editor_propline_emacs  = 1,
    editor_propline_ignore = 2,
    NUM_editor_propline
};
extern ENUMERATE editor_elmrc_propline;   /* 0 = auto
					     1 = emacs
					     2 = ignore
					  */

extern ENUMERATE editor_ms_propline;   /* 0 = auto
					  1 = emacs
					  2 = ignore
				       */


extern int mime_rfc1522_filename;         /* flag: mime-encoded-filename-hack
					     If this is set, then MIME encoded 
					     words (RFC 2047 or RFC 1522) 
					     filename parameter is detected. 
					     However RFC 2231 style encoding 
					     is preferred if 
					     mime_parameters > 0 (below)
					  */

enum mime_parameters_v { 
    mime_parameters_plain             = 0,
    mime_parameters_encoded           = 1,
    mime_parameters_plain_and_encoded = 2,
    NUM_mime_parameters };
extern ENUMERATE mime_parameters; /* 0 == plain
				     1 == encoded
				     2 == plain-and-encoded
				  */

enum env_from_source_v { 
    env_source_forward_from  = 0,
    env_source_from          = 1,
    env_source_return_path   = 2,
    NUM_env_from_source };
extern ENUMERATE env_from_source; /* 0 == forward-from,
				     1 == from,
				     2 == return-path
				   */

extern char escape_char;	/* '~' or something else...    */
extern int  force_name;		/* flag: save by name forced?	      */

enum fragment_handling_v { 
    fragment_handling_none   = 0,
    fragment_handling_manual = 1,
    fragment_handling_auto   = 2,
    NUM_fragment_handling };
extern ENUMERATE fragment_handling;   /* 0 == none,
					 1 == manual,
					 2 == auto  */

extern struct string * full_username_s;/* Full username - gecos   */

enum phrase_display_mode_v { 
    phrase_display_plain  = 0,
    phrase_display_quoted = 1,
    NUM_phrase_display_mode };
extern ENUMERATE phrase_display_mode; /* 0 == plain, 1 = quoted */

extern char hostdomain[SLEN];	/* name of domain we're in */
extern char hostfullname[SLEN]; /* name of FQDN we're in */
extern char hostname[SLEN];	/* name of machine we're on*/
extern int  menu_display_host;  /* flag: Display host on mailbox menu* */
extern int  keep_empty_files;	/* flag: keep empty files??	      */
extern int pgp_keeppassfor;    /* should Elm keep the passphrase? */

enum { LD_NONE = 0, LD_NAME_SORT, LD_MTIME_SORT };
extern SORT local_dir_sortby;	  /* how to sort local directories  */
extern int local_fast_lookup;     /* flag: directory listing not needed 
				     for lookup */

extern int fb_show_dotfiles;   /* flag: Show .dotfiles on Elm 2.5 style browser */
extern int fb_show_title;   /* flag: Show title of columns on Elm 2.5 style browser */
extern int fb_show_protection; /* flag: show permission and owner columns on Elm 2.5 style browser */

extern SORT fb_sort_order;     /* How to sort files on Elm 2.5 style browser */

enum lockfile_pidcheck_v {  
    pidcheck_no       = 0,
    pidcheck_yes      = 1,
    pidcheck_hostname = 2,
    pidcheck_ignore_hostname = 3,
    pidcheck_require_hostname = 4,
    NUM_lockfile_pidcheck };

#ifdef PIDCHECK
extern ENUMERATE local_lockfile_pidcheck;     /* 0 == no
						 1 == yes
						 2 == hostname
						 3 == ignore-hostname
						 4 == require-hostname
					      */
#endif

extern char local_sessionlock_dir[SLEN];
enum local_seslck_use_home_v { 
    local_seslck_use_home_never     = 0,
    local_seslck_use_home_spool     = 1,
    local_seslck_use_home_always    = 2,
    local_seslck_use_home_non_spool = 3,
    NUM_local_seslck_use_home };
extern ENUMERATE local_sessionlock_use_home;  /* 0 == never,
						 1 == spool
						 2 == always 
						 3 == non-spool */
extern char raw_local_fs_charset[SLEN]; /* filesystem charset */
extern charset_t local_fs_charset;     /* filesystem charset */
extern ESTR local_signature_e;  /* local msg signature file   */
extern int lockfolders;         /* Lock folder when open */
extern int lock_in_copy;        /* Lock folder when copied to it */
extern int long_encoded_headers;  /* Produce over 80 character mime encoded
				     headers */

enum mserv_lookup_v {
    mserv_lookup_hostname = 0,   /* hostname */
    mserv_lookup_shared,
    mserv_lookup_gethostbyname,        /* Use gethostbyname() */
    mserv_lookup_getaddrinfo,          /* Use getaddrinfo()   */
    NUM_mserv_lookup
};
extern ENUMERATE mail_services_lookup;  /* Should try some odd
					   hostname lookup ?
					*/

#if defined(WCHAR) && defined(__STDC_ISO_10646__)
extern PATH locale_charsets;    /* Use type=unknown for these charsets
				 * if system charset
				 */
#endif

extern ESTR folders_e;	        /* folder home directory   */
extern int Expires_have_time;   /* Expires: -header field generated from
				   Message Header Edit Screen have
				   date and time; if not set, only
				   date in shown.
				*/
extern ESTR extra_mailbox_dir_e;
extern FLAGS mailbox_locking;

extern PATH mailname;           /* Name used after the @  -character on addresses and 
				   aliases of that. That is similar than alternatives 
				   option, but includes only part after the @ -character.
				*/

extern ESTR mailhome_dir_e;     /* local mail spool directory        */
extern FLAGS mailhome_locking;

extern int mail_permissions;	/* int: permissions for mailbox files   */
extern PATH mailcap_bl_programs; /* Do not execute program or call metamail */
extern int mailcap_select_other; /* flag: Show o)ther alternative on 
				    "Mailcap program selection" ? 
				 */

extern int mailcap_tempfile_lifetime;  /* Time (seconds) to keep mailcap temporary files */
extern int mini_menu_rc;	/* flag: display menu?     	      */

enum message_hide_v { 
    message_hide_none   = 0,
    message_hide_FID    = 1,
    NUM_message_hide_hack };
extern ENUMERATE message_hide_hack;  /* 0 = none                           */
                                     /* 1 = FOLDER INTERNAL DATA           */

extern ESTR metamail_path_e;      /* Metamail path or "none" if no metamail */
extern PATH metamail_mailcaps;    /* mailcaps for metamail */
extern PATH internal_mailcaps;    /* mailcaps for internal handler */
extern PATH internal_mailcap_t_programs; /* Execute program without asking */
extern PATH incomingfolders;      /* treate as mailbox */
extern int internal_mailcap_t_prompt;    /* ... really? */

#ifdef HAVE_SCOPE
enum ipv6_scope_id_v {
    scope_auto_flag,                 /* convigure on startup */
    scope_link_local_if_index_flag,  /* use if_index for link local addresses
					as scope id */
    NUM_ipv6_scope_id_v
};
extern FLAGS ipv6_scope_id;
#endif

extern int  metoo;		/* flag: copy me on mail to alias?    */

enum mimeforward_v {
    mimeforward_no  = 0,
    mimeforward_yes = 1,
    mimeforward_auto,
    NUM_mimeforward  };
extern ENUMERATE mimeforward;

extern int askmimeforward;
extern int mime_body_keywords; /* flag: if false the body is not parsed for keywords */
extern int  move_when_paged;	/* flag: move when '+' or '-' used?   */

extern int name_lookup_cache_time;        /*  DEFAULT_CACHE_TIME
					      defaul cache time for mail
					      services (seconds) */

enum name_lookup_cancel_v {
    name_lookup_cancel_disabled = 0,
    name_lookup_cancel_enabled  = 1,
    name_lookup_cancel_auto,
    NUM_name_lookup_cancel
};
extern ENUMERATE name_lookup_cancel;

enum name_resolution { nr_DEFAULT_aliases  = -3,
                       nr_DEFAULT_names = -2,
                       nr_BAD = -1,
		       nr_gethostname = 0, nr_uname, nr_lookup, 
		       nr_getdomainname, nr_mailname,
		       nr_getifaddrs,
		       nr_COUNT };

extern int have_name_resolution P_((enum name_resolution x));
extern const char * name_resolution_tag P_((enum name_resolution x));
extern const char * name_resolution_gives P_((enum name_resolution x));
extern int name_resolution_errno P_((enum name_resolution x));

/* Returns name only if it is ok, may update error counter and print error message */
extern const char * name_resolution_okname P_((enum name_resolution tag,int global_mode));

extern int  names_only;		/* flag: display names but no addrs?  */

enum allow_no_encoding_v { 
    allow_pass_7bit      = 0,
    allow_pass_8bit      = 1,
    allow_pass_binary    = 2,
    NUM_allow_no_encoding };
extern ENUMERATE allow_no_encoding;       /* 1: Allow 8bit without -B8BITMIME
                                     * 2: Allow binary without -BBINARYMIME
                                     *    and 8bit without -B8BITMIME */

extern int allow_no_hdrencoding;    /* TRUE, if header encoding is 
				     * not required */
extern int  noheader;		/* flag: copy + header to file?       */
extern int  noheaderfwd;	/* flag: copy + header to file?(fwd)  */
extern int page_known_charsets;
extern int pagealternative;
extern int pagemultipart;
extern int pagesigned;

enum pagerelated_v {
    pagerelated_no,
    pagerelated_yes,
    pagerelated_singlepart,
    NUM_pagerelated
};  
extern ENUMERATE pagerelated;

enum pager_keyword  { pager_kw_NO   = 0,
		      pager_kw_builtin = 1
};

#define  pager_KW_PAGER 0x0001
extern ESTR pager_e;            /* what pager to use...    */

enum header_display_mode_v {
    hdr_display_plain  = 0,
    hdr_display_bold  = 1,
    NUM_header_display_mode };
extern ENUMERATE pg_header_display_mode; /* 0 == plain, 1 == bold */

extern int pager_indicate_wrapping;  /* Indicate wrapping with \ on builtin
					pager                               */

extern int pager_paragraph_width;   /* Indicate preferred width for flowed 
				       (word wrapped) paragraph. */

enum pager_time_display_v {
    ptr_date_header_field = -1      /* Date: header field format,
				       not availabel as config option    */,
    
    ptd_legacy = 0                  /*  MeDateStrTimeFmt */,
    ptd_default                     /*  MeDateStrTime24Fmt */,

    /* Rest are fixed */
    ptd_month_day_year_12h          /* month day, Year 12h (am/pm) */,
    ptd_month_day_year_24h          /*        month day, Year 24h         */,
    ptd_month_day_year_HH_MM        /*        month day, Year HH:MH       */,
    ptd_preferred                   /*        %c                          */,
    ptd_day_month_year_12h          /*        day month year  12h (am/pm) */,
    ptd_day_month_year_24h          /*        day month year  24h         */,
    ptd_day_month_year_HH_MM        /*        day month year  HH:MM       */,
    ptd_YYYY_MM_DD_HH_MM            /* numeric YYYY-MM-DD HH:MM           */,
    ptd_YYYY_MM_DD_HH_MM_SS         /* numeric YYYY-MM-DD HH:MM:SS        */,
    NUM_pager_time_display
};
extern ENUMERATE pager_time_display;

extern ESTR pgp2_path_e;      /* Pgp2 path or "none" if no pgp2 */
extern ESTR pgp5_dir_e;       /* pgp5 binary directory or "none" if no pgp5 */
extern ESTR gpg_path_e;
extern int  point_to_new;	/* flag: start pointing at new msgs?  */
extern int  point_to_flagged;	/* flag: start pointing at flagged msgs?  */
extern char allowed_precedences[SLEN];	/* list of precedences user may specify */
extern ESTR printout_e;	/* how to print messages   */
extern char printhdrs[SLEN];		/* headers to select and weed on printing */

enum program_snd_ident_v {
    snd_ident_x_mailer    /* send X-Mailer: header field     */,
    snd_ident_version     /* and include version information */,
    snd_ident_user_agent  /* send User-Agent: header field   */,
    NUM_program_snd_ident_v
};
extern FLAGS program_snd_ident;  /* program-identification */

extern int  prompt_after_pager;	/* flag: prompt after pager exits     */
extern int  prompt_after_metamail;	/* flag: prompt after metamail exits     */
extern int  prompt_metamail;     /* flag: prompt for calling of metamil */
extern int  quote_forward;	/* flag: fwd'd msgs quoted like replies */
extern struct string * quote_prefix;	/* prefix char(s) for msgs */
extern int  readdatapercentinc;	/* data percent increment during new mbox read */
extern ESTR readmsg_e;	        /* path to readmsg program	*/
extern int  readmsginc;		/* msg cnt increment during new mbox read */
extern ESTR recvd_mail_e;	/* folder for storing received mail	*/
extern ESTR remote_signature_e;/* remote msg signature file */
extern int req_mime_bodyencoding;
extern int req_mime_hdrencoding;
extern int  resolve_mode;	/* flag: resolve before moving mode?  */
extern int  save_by_name;  	/* flag: save mail by login name?     */
extern int save_by_alias;	/* save mail by alias of login name? */
extern ESTR sent_mail_e;	/* name of file to save copies to */
extern int  set_window_title;   /* flag: set (xterm?) window title and 
				   icon name */
extern ESTR shell_e;	/* default system shell    */
extern int pgp_noarmor;     /* Should Elm display text before PGP armor */
extern int  showto;
extern int  show_mlists;	/* show mailing list info? */
extern int  show_reply;	        /* flag: show 'r' for replied mail */

enum show_header_errors_v { 
    show_hdr_error_OFF   = 0,
    show_hdr_error_ON    = 1,
    show_hdr_error_store = 2,
    NUM_show_header_errors };
extern ENUMERATE show_header_errors_e; /* How header errors should be 
					  reported */

enum show_mail_quota_v {
    show_mquota_OFF      = 0,
    show_mquota_ON_open  = 1,
    NUM_show_mail_quota
};
extern ENUMERATE show_mail_quota_e;    /* Should mail quota to be shown on 
					  mailbox open? */

extern int  sig_dashes;		/* flag: put dashes above signature?  */
extern int  sleepmsg;		/* time to sleep for messages being overwritten on screen */

extern SORT sortby;		/* how to sort messages (on folders)	      */
extern PATH special_bl_domains; /* Blacklist special use domains  */
#ifdef REMOTE_MBX
enum special_domains_v {
    special_dom_static_hosts_flag,
    NUM_special_domains_v
};
extern FLAGS special_domains_lookup;


extern int static_hosts_max_names;  /* threshold for /etc/hosts caching */
#endif

extern SORT thread_sortby;      /* how to sort threads of messages */
extern long elm_timeout;        /* seconds for main level timeout     */
extern int sort_thread_max_time; /* Number of days which can considered 
				    be same thread */
extern char to_chars[SLEN];	/* chars to indicate who mail is to */
extern ESTR temp_dir_e;         /* name of temp directory */
extern int pgp_keeppass;         /* should Elm keep the passphrase in*/

enum user_level_v { 
    user_level_beginner      = 0,
    user_level_intermediate  = 1,
    user_level_expert        = 2,
    NUM_user_level };
extern ENUMERATE user_level;	/* flag: how knowledgable is user?    */

extern int use_char_set_field_hack;   /* flag: Recognise non-standard header 
					 field Char-Set */
extern int use_ct_cs_for_subj_hack;   /* flag: Process 8-bit subject with using 
					 charset parameter from
					 header field Content-Type.
				      */

extern int  use_tite;		/* flag: use termcap/terminfo ti/te?  */

/* This requires USE_DLOPEN and REMOTE_MBX */
enum use_tls_v {
    use_tls_implicit,
    use_tls_starttls,
    use_tls_verify_cert,
    use_tls_require_name,
    use_tls_display_host,
    NUM_use_tls_v
};
extern FLAGS use_tls;


extern int utf7_encode_optional; /* flag: Should utf7 optional direct 
				    characters to be encoded?        */

enum verify_domain_v {
    verify_domain_no          = 0,
#ifdef I_NETDB
    verify_domain_yes,         
    verify_domain_hostname,
#endif
    verify_domain_shared,

    NUM_verify_domain
};

extern int verify_alias_domain;  /* Should we try check existence
				    of mail domain from alias 
				    expanded addresses ? */

extern ENUMERATE verify_domain;  /* Should we try check existence
				    of mail domain?
				 */
extern int verify_local_address; /* flag: Should we try check existence
				    of local user
				 */

enum verify_ldomain_v {
    verify_ldomain_no          = 0,
    verify_ldomain_yes,
    verify_ldomain_remote_mailer,
    NUM_verify_ldomain
}; 

extern ENUMERATE verify_local_domain; /* Should we try check existence of
					 "mailname" or "hostfullname" ?
				      */

extern char v_editor[SLEN];	/* "~v" editor...   */
extern int  elm_filter;		/* flag: weed out header lines?	      */
extern int  send_mime_plain;    /* Send text/plain US-ASCII as MIME?  */
extern PATH weedlist;
extern PATH weedlist_no_title;


#ifdef REMOTE_MBX
extern char raw_imap_charset[SLEN];  /* IMAP foldername charset */
enum { ID_NONE = 0, ID_NAME_SORT };
extern SORT imap_dir_sortby;	  /* how to sort local directories  */
extern int imap_fast_lookup;         /* flag: skip directory listing */
extern int imap_idle_alive_interval;  /* Idle timeout on seconds for IMAP connection;
					 NOOP command interval
				      */
extern int imap_max_dl_size;         /* Maximum size of message to be 
					downloaded */
extern charset_t imap_charset;       /* IMAP foldername charset */
extern int IMAP_connection_cache; /* flag: call cache_connection() ? */
extern int IMAP_name_convention; /* flag: Should imap international folder
				    convention be used? */
extern int IMAP_use_examine;   /* flag: Should EXAMINE command to be used? */
extern int IMAP_show_greeting; /* flag: Should untagged OK messages be shown? */
extern int IMAP_show_warning; /* flag: Should untagged NO messages be shown? */
extern int IMAP_show_error;  /* flag: Should untagged BAD messages be shown? */
extern int pop_idle_alive_interval;  /* Idle timeout on seconds for POP connection;
					NOOP command interval
				     */
extern int pop_max_dl_size;         /* Maximum size of message to be 
					downloaded */
extern int POP_show_greeting;  /* flag: Should POP server greeting be shown? */
#endif

typedef void  init_default_hook P_((int *errors));
extern void add_init_default_hook P_((init_default_hook *hook));
extern void add_read_rc_file_hook P_((init_default_hook *hook));


typedef void free_rc_hook P_((void));
extern void add_free_rc_hook P_((free_rc_hook *hook));
extern void free_rc_options P_((void));

extern enum charset_keyword { cskw_none = 0, cskw_SYSTEM, 
	cskw_DISPLAY, cskw_TEXT 
	} special_charset_keyword P_((const char *value));


/* lib/out_entity.c */


extern struct out_entity * new_out_entity
    P_((const struct string  * reference_key,
	const struct string  * entity_value
	/* May be NULL */,
	uint16           unicode_value,
	int              reference_key_pg_flags));
extern void free_out_entity P_((struct out_entity ** ptr));
extern void inc_out_entity_refcount P_((struct out_entity *ptr));

/* Drop const --  duplicate/copy this */

struct out_entity * dup_out_entity P_((const struct out_entity * ptr));

/* Returns pointer to underline string on struct out_entity - do not free */
extern const struct string  * out_entity_reference_key P_((const struct out_entity *oe,
							   int *pg_flags));
/* May be NULL */
extern const struct string  * out_entity_text_value P_((const struct out_entity *oe));
/* May be UNICODE_BAD_CHAR */
extern const uint16  out_entity_unicode_value P_((const struct out_entity *oe));

/* lib/output.c */

#define FRM(format)  format,format
#define CATGETS(cat,set,def,format) format,catgets(cat,set,def,format) 

typedef int err_handler_W P_((const struct string *str));
extern int lib_error P_((const char * format, const char *msg, ...));
extern void set_error_handler_W P_((err_handler_W *h));

extern int lib_transient P_((const char * format, const char *msg, ...));
extern void set_transient_handler_W P_((err_handler_W *h));

extern char *elm_vmessage P_((int max_alloc,
			      const char *format, const char *msg, 
			      va_list args));
extern struct string * elm_smessage P_((int max_alloc,
					const char *format, const char *msg,
					va_list args));
extern char *elm_message P_((const char * format, const char *msg, ...));
extern struct string *format_string P_((const char * format, 
					const char *msg, ...));
extern void  elm_append_message P_((struct string **res,
				    const char * format, 
				    const char *msg, ...));

extern int elm_sfprintf P_((char *buffer, int size,
			    const char * format, const char *msg, ...));
extern int elm_fprintf P_((FILE *f,const char * format, const char *msg, ...));

/* result mast be malloced */
typedef char * prompt_handler P_((const char *str, int pass)); 
extern char * lib_prompt P_((int pass, const char * format, 
			     const char *msg, ...));
extern void set_prompt_handler P_((prompt_handler *h));


/* low level output routines: */
struct  format_elem {
    int fill;
    int left;
    int plus;
    int val1, val2;
    enum width_type {
	W_normal = 0,
	W_long   = 1,
	W_size   = 2
	
    } long_f;
    
    enum val_type  { V_none,
		     V_signed_val, V_unsigned_val, V_str_val,
		     V_chr_val, V_string_val, V_cs_val,
		     V_ptr_val, V_double_val } type;
    union val_value {
	long                      signed_val;
	unsigned long           unsigned_val;
	char *                       str_val;
	int                          chr_val;
	struct string *           string_val;
	struct charset_state *        cs_val;
	void *                       ptr_val;
	double                    double_val;
    } value;	

    char format_chr;

};

/* Returns number of args parsed: -1 is parse error,
   - this routine can be called from interrupt handler,
     so this does not malloc anything or call charset routines ...
   - this routine is also part of debugging output routine,
     so do not call debugging output on here...
 */

extern int parse_format_args P_((struct  format_elem *elems,
				 int              max_elems,
				 const char        * format,
				 va_list               args,
				 char        **format_error));


/* convert_number may be callled form signal handler, therefore
   it must not malloc annything ... 
*/

extern int convert_number P_((char * buffer, int buffer_size, 
			      struct  format_elem *elem));


extern struct string * format_S_helper P_((const struct string       * S,
					   struct  format_elem       * elem,
					   int max_alloc,
					   int *len));



/* lib/file_util.c */

enum syscall_status {
    syscall_success = 0,
    syscall_error   = -1
};


extern long file_bytes P_((const char *name, int *err_p  /* errno value */));
extern int save_file_stats P_((const char *fname,
			       struct stat *stat_copy));
extern int restore_file_stats P_((const char *fname));
extern FILE *open_or_create P_((const char *name));
extern int copy_to_fh P_((FILE *from, FILE *to));
extern int copy1 P_((FILE *from, char *to, int isspool));


extern enum syscall_status elm_chown P_((const char *file,
					 int userid, int groupid,
					 int *errno_res));

/* lib/schedule.c */

extern const union action_routine_data {
    void                  * data;
    struct streamsched    * stream;
    struct bgconnect_info * connect;    /* For non-blocking connect() */
    struct resolv_message_state * resolv;
} NO_action_routine_data;

#ifdef ANSI_C
struct schedule_timelimit;                /* Needed for prototype */
#endif


enum action_status {
    action_disable = 0,
    action_continue };

/* if returns 0 -- action is removed from list */
typedef enum action_status action_routine P_((int fd,
					      union action_routine_data         data,
					      const struct schedule_timelimit * now));
extern enum action_status no_action_routine P_((int fd,
						union action_routine_data data,
						const struct schedule_timelimit *now));

typedef void free_action_data_f P_((union action_routine_data * data,
				    int fd,
				    int badpid));
extern void no_free_action_data P_((union action_routine_data * data,
				    int fd,
				    int badpid));

typedef void inc_action_data_refcount_f P_((union action_routine_data data));
extern void no_inc_action_data_refcount  P_((union action_routine_data data));

/* Report that caller_pid is changed -- so this is child now */
typedef enum badpid_status {
    badpid_disable = 0  /* action_disable */,
    badpid_ignore       /* action_continue */,
    badpid_remove       /* remove action */,
    badpid_change       /* change pid to current */  
	} badpid_action_f  P_((int fd,
			       union action_routine_data         data,
			       int badpid));
extern enum badpid_status no_badpid_action P_((int fd,
					       union action_routine_data data,
					       int badpid));
extern enum badpid_status badpid_remove_action P_((int fd,
						   union action_routine_data         data,
						   int badpid));

extern void change_action2 P_((int                          fd, 
			       int                          timeout_sec,
			       action_routine             * read_act, 
			       action_routine             * write_act, 		       
			       action_routine             * timeout_act,
			       free_action_data_f         * free_action_data,
			       inc_action_data_refcount_f * inc_action_data_refcount,
			       badpid_action_f            * badpid_act,
			       union action_routine_data    data));
extern void change_action P_((int                          fd, 
                              int                          timeout_sec,
                              action_routine             * read_act, 
                              action_routine             * write_act,                  
                              action_routine             * timeout_act,
                              free_action_data_f         * free_action_data,
                              inc_action_data_refcount_f * inc_action_data_refcount,
                              union action_routine_data    data));


extern void clear_action P_((int fd));
extern int have_actions P_((void));

extern void clear_other_actions P_((int mypid));

extern const union schedule_routine_data {
    void               * data;
    struct streamsched * stream;
} NO_schedule_routine_data;

typedef enum schedule_return { 
    schedule_remove = 0, schedule_reconsider = 1,
    schedule_done = 2, schedule_have_action = 3
} schedule_routine P_((int fd, union schedule_routine_data data,
		       const struct schedule_timelimit * now));
extern enum schedule_return no_schedule_routine P_((int fd,
						    union schedule_routine_data data,
						    const struct schedule_timelimit * now));

typedef void free_schedule_data_f P_((union schedule_routine_data * data,
				      int fd,
				      int badpid));
extern void no_free_schedule_data  P_((union schedule_routine_data * data,
				       int fd,
				       int badpid));

typedef void inc_schedule_data_refcount_f P_((union schedule_routine_data data));
extern void no_inc_schedule_data_refcount P_((union schedule_routine_data data));

extern void set_schedule_action P_((int fd,
				    schedule_routine             * routine,
				    free_schedule_data_f         * free_schedule_data,
				    inc_schedule_data_refcount_f * inc_schedule_data_refcount, 
				    union schedule_routine_data data));

#ifdef ANSI_C
struct action_setups;
struct schedule_setup;
#endif
/* Only call for setup_actions0(fd,is_badpid,NULL,NULL) exported */

extern void setup_actions0 P_((int                            fd, 
			       int                            is_badpid,
			       const struct action_setups   * basic_setup,
			       const struct schedule_setup  * sched_setup));
extern void clear_action0 P_((int                            fd, 
			      int                            is_badpid));

extern volatile int wait_can_signal;
extern void wait_got_jump P_((void));  /* Got alarm --
					  Perhaps jumped out from wait_* routines() 
					  or arrived via setjump
				       */

#ifdef ANSI_C
struct cancel_data;
#endif

enum wait_for_status {
    wait_for_error = -1,
    wait_for_none  = 0,
    wait_for_done  = 1
};


/* Returns 1 if action occured                     */
extern enum wait_for_status wait_for_action P_((action_routine * action));
extern enum wait_for_status wait_for_any_action P_((void));

extern enum wait_for_status wait_for_timeout P_((int seconds));

#define WAIT_FOR_intr            1     /* Interupt quit        (racy) */
#define WAIT_FOR_handle_sigchld  2     /* handle_sigchld quits (racy) */

extern enum wait_for_status wait_for_timeout_f P_((int   seconds,
						   int   wait_flags,
						   int * err_p
						   ));



/* Returns 1 if action or timeout occured          */
extern enum wait_for_status wait_for_action_or_timeout P_((action_routine * action,
							   int seconds));

extern enum wait_for_status wait_for_action_or_timeout_f P_((action_routine * action,
							     int seconds /* -1 no timeout */,
							     int   wait_flags,
							     int * err_p));

extern enum wait_for_status wait_for_any_action_or_timeout P_((int seconds));

extern enum wait_for_status wait_for_action_c P_((action_routine * action,  struct cancel_data *cd));


extern enum wait_for_status wait_for_any_action_c P_((struct cancel_data *cd));
extern enum wait_for_status wait_for_timeout_c P_((int seconds, struct cancel_data *cd));
/* Returns 1 if action or timeout occured          */
extern enum wait_for_status wait_for_action_or_timeout_c P_((action_routine * action,
							     int seconds,
							     struct cancel_data *cd));
extern enum wait_for_status wait_for_any_action_or_timeout_c P_((int seconds,
								 struct cancel_data *cd));


extern void free_schedule P_((void));

/* lib/panic.c */

typedef void panic_prepare P_((const int interrupt, 
			       const char * title,
			       const char * ms));

extern void set_panic_prepare P_((panic_prepare *fn));

typedef void panic_exit P_((const int interrupt));
extern void set_panic_exit P_((panic_exit *fn));

extern void panic P_((const char * title,
		      const char * f,
		      const int ln,
		      const char * pr,
		      const char * ms,
		      const int interrupt));

/* fd == -1 unsets */
extern void set_panic_tty_fd P_((int fd, int pid));


/* lib/hdrdecode.c */

#define HDR_TEXT       1
#define HDR_STRUCTURED 2
#define HDR_PHRASE     4
#define HDR_COMMENT    8     /* inside of comment -- for rfc1522_encode_text */

extern char * blstrpbrk P_((char *string, const char *set));
extern struct string * hdr_to_string P_((int class,const char *buffer,
					 charset_t defcharset, int demime));

extern int index_hex[128];
extern int index_64[128];

#define base64(c) ((((c) > 0) && ((c) < 127)) ? index_64[ (c) ] : -1)
#define hex(c) ((((c) > 0) && ((c) < 127)) ? index_hex[ (c) ] : -1)

/* lib/hdrencode.c */

extern char hexchars[16];

/* result is malloced */
/*    *is_encoded = 1  ... mime encoded
      *is_encoded = -1     quoted phrase
 */

extern char * string_to_hdr P_((int class, const struct string *buffer,
				charset_t defcharset, int enmime,
				int *is_encoded,
				int do_ascii_prefix));



/* lib/terminal.c */

extern int match_charset_name P_((charset_t cs1, charset_t cs2));


extern screen_info_p create_terminal_info P_((void));

/* lib/remote_mbx.c */

/* same as option letter */
enum ipv_option {
    ipv4_option = '4',
    ipv6_option = '6'
};
enum ipv_option_print {
    ipv4_option_silent = 0,
    ipv4_option_printerr
};


extern enum ipv_opt_res {
    ipv_opt_already     = -1 /* already given */,
    ipv_opt_unsupported = 0,
    ipv_opt_succeed,
    ipc_opt_noactice         /* no actice interace found */
	}  add_ipv_option P_((enum ipv_option opt,enum ipv_option_print printerr));


extern int set_transaction_file P_((const char *filename));
extern void free_transaction_file P_((void));

#ifdef REMOTE_MBX
extern int close_cached_connections P_((struct cancel_data  * cd));
#endif

/* modifies string f, return param value or NULL */
extern char * conf_split_param_value P_((char * f));

/* Return 1 if value found */
extern int conf_select_value P_((const char *f,
				 const char *array[],
				 const int array_len,
				 int *value  /* Return value */));
/* rfc822tlen.c */

extern int rfc822_toklen P_((const char *str));
extern int rfc822_special P_((int c));

/* shared.c */

#ifdef USE_DLOPEN
typedef struct dt_shared_info  SHAREDLIB;

extern SHAREDLIB use_shared_all;
extern SHAREDLIB use_shared_base;
extern SHAREDLIB use_shared_config;
extern SHAREDLIB use_shared_connect;

extern void test_and_set_shared P_((char **argv, 
				    int will_write));  /* For elmlibregister.c */
extern int use_sharedfunc P_((char **value, int enter,
			      int lineno, char *filename));

extern void seed_rand_bits P_((const char *buf, int size,
			       int entropy_bits));

extern struct SE_option_type * get_option_type P_((const char *prefix));

extern void free_shared_caches P_((void));

#endif



/* service_list.c */

/* What is maximum value of time_t ?
   INT_MAX = 2147483647   fails at Tue Jan 19 03:14:07 2038 UTC
*/

extern const time_t time_MAX;

extern struct mail_services_conf * parse_service_entries P_((const char *filename, 
							     int *errors, 
							     charset_t *fileset,
							     struct editor_propline **propline));

extern void free_mail_services_conf P_((struct mail_services_conf **conf));
extern void free_service_list P_((void));  /* clears timed cache action */

/* Returns domain name if matches to special-use-domains-blacklist */
extern const char * is_special_use_domain P_((const char * host_domain_name));

extern const char * on_domain_blacklist P_((struct dt_path_info *ptr,     
					    const char * fieldname,
					    const char * host_domain_name));

/* Returns new len */
extern int trim_whitespace_from_end P_((char *buf, int l1));

/* Return 1 if @charset seen */
extern int read_charset_tag P_((char *buf, int l1, 
				const char * filename, 
				const int lineno,
				int *errors,
				charset_t *cs,
				const char ** csn));

/* Returns 1 if name is not empty and uses only abcdefghijklmnopqrstuvwxyz.- */

extern int host_name_ok P_((const char *name));

/* static-hosts.c */

extern void free_static_hosts P_((void));


/* debug.c */

#if DEBUG

/* Given argument must be statically alloced */
extern void init_debugfile P_((const char *progname));
extern int  set_debugging P_((const char *arg));

struct debug_struct {
    const char          * class;
    const char          * file;
    const char          * ID;
    struct debug_target * target;
    int   active;
    int   header_printed;
};

extern void debug_level_check P_((struct debug_struct *a));
extern void debug_file_header P_((struct debug_struct *a));
extern void debug_action_call P_((struct debug_struct *a, 
				  const char * format,
				  ...));

extern void debug_action_sigcall P_((struct debug_struct *a, 
				     const char * format,
				     ...));

extern void debug_user_init P_((void));   

#define DEBUG_CHECK_INIT(x) do {					\
	if (x.active == -1) debug_level_check(&x);			\
	if (x.active > 0 && !x.header_printed) debug_file_header(&x);	\
    } while(0)
#define DEBUG_CHECK(x,level) (x.active >= (level))

#define DPRINT(x,level,action) do {					\
	if (x.active == -1) debug_level_check(&x);			\
	if (x.active > 0 && !x.header_printed) debug_file_header(&x);	\
	if (x.active >= (level)) debug_action_call action;		\
} while(0)

#define SIGDPRINT(x,level,action) do {				\
    if (x.active >= (level)) debug_action_sigcall action;	\
} while(0)

extern void debug_print_buffer P_((struct debug_struct *a, int len, unsigned char *str));
extern void debug_puts P_((struct debug_struct *a, int len, const char *str));

#define DEBUG_PRINT_BUFFER(x,level,len,str) do {			\
	if (x.active == -1) debug_level_check(&x);			\
	if (x.active > 0 && !x.header_printed) debug_file_header(&x);	\
	if (x.active >= (level)) debug_print_buffer(&x,len,str);	\
} while(0)


/* Called from signal handler, returns largest debug level */
extern int panic_dprint P_((const char * format, ...));
extern void panic_print_backtrace(void *const *buffer, int size);

extern void debug_print_backtrace P_((struct debug_struct *a,void *const *buffer, int size));

extern FILE * debug_to_FILE P_((struct debug_struct *a));

#else
struct debug_struct {
    const char          * class;
    const char          * file;
    const char          * ID;
    void                * target;
    int   active;
    int   header_printed;
};


/* Dummy .... */
#define DEBUG_CHECK_INIT(x)         do { } while(0)
#define DEBUG_CHECK(x,level)        ((x.active >= (level)),0)
#define DPRINT(x,level,action)      do { if (x.active >= (level)) { } } while(0)
#define SIGDPRINT(x,level,action)   do { if (x.active >= (level)) { } } while(0)
#define DEBUG_PRINT_BUFFER(x,level,len,str) do { if (x.active >= (level)) { } } while(0)

/* Not available !!! */
extern void debug_action_call P_((struct debug_struct *a, 
				  const char * format,
				  ...));


#endif
#define DEBUG_VAR(x,file,class) \
 static struct debug_struct x UNUSED_VAROK = { class, file, rcsid, NULL, -1, 0 }


/* state.c */

/** Definitions for state operations **/

#ifdef ANSI_C
struct in_state;                              /* Needed for prototype */
struct out_state;                             /* Needed for prototype */
#endif

/* can't be 'char' as argument because problems of default
 * promotion rules of arguments -- therefore 'int' is used
 * in functios: state_putc
 *
 * Notice also that we assume here that char agument (as int)
 * is 'unsigned char'
 *
 *  - K E H
 */


/* state types */
extern struct in_state_type  STATE_in_file_type;
#define   STATE_in_file      &STATE_in_file_type

extern struct out_state_type STATE_out_file_type;
#define   STATE_out_file     &STATE_out_file_type

extern struct out_state_type STATE_out_buffer_type;
#define   STATE_out_buffer   &STATE_out_buffer_type


extern struct in_state * new_in_state P_((struct in_state_type * m));    
extern void free_in_state P_((struct in_state **ptr)); 
extern int inc_in_state_refcount P_((struct in_state *ptr));



extern void set_in_state_file   P_((FILE *,struct in_state *));   /* STATE_in_file */

extern int  in_state_seekable P_((struct in_state *)); 
extern int  in_state_fseek P_((struct in_state *, long)); 
extern long in_state_ftell P_((struct in_state *));       

extern char *state_gets P_((char *, int, struct in_state *));
extern int   state_getl P_((char *dest, int len, struct in_state *s));
extern int   state_getc P_((struct in_state *s));
extern int   state_ungetc P_((int,struct in_state *));

extern const struct string * in_state_error_message P_((struct in_state *s,
							int clearerr /* pop message from stack*/ ));

extern int in_state_ferror P_((struct in_state *));
extern int in_state_feof P_((struct in_state *));


extern struct out_state * new_out_state P_((struct out_state_type * m));    
extern void free_out_state P_((struct out_state **ptr)); 

extern int out_state_EOLN_is_CRLF P_((struct out_state *ptr));
extern charset_t get_out_state_filter P_((struct out_state *ptr));
extern void set_out_state_filter P_((struct out_state *ptr,
				     charset_t cs));
extern const char *get_out_state_f_MIME_name P_((struct out_state *ptr));
extern const charset_t * get_out_state_charset_vector P_((
   struct out_state *ptr));
extern const char * get_out_state_cv_MIME_name P_((struct out_state *ptr,
						   int idx));
extern void set_out_state_cs_from_state P_((struct out_state *ptr,
					    const struct out_state *src));
extern void set_out_state_cs P_((struct out_state *ptr,
				 charset_t filter,
				 charset_t * vector));
extern void set_out_state_EOLN P_((struct out_state *ptr,
				   int is_CRLF));


/* Returns 0 if pg_ line flags are not supported,
   should called on beginning of line, may flush line 
 */
extern int set_out_state_line_pg_flags P_((struct out_state *ptr,
					   int pg_flags));

/* STATE_out_file */
extern void set_out_state_file   P_((FILE *,struct out_state *));  

/* STATE_out_buffer */
extern void set_out_state_sbuffer   P_((struct stringbuffer *,struct out_state *));  

extern int state_put  P_((const char *, int, struct out_state *));

/* convert one line -- *len is assumed to point end of line */
extern void state_convert_EOLN P_((char *buffer, int *len, int buffer_size,
				   struct out_state *st));
				   
extern int state_puts P_((const char *, struct out_state *));
extern void state_nlputs P_((char *, struct out_state *));
extern int state_putstring P_((const struct string *S, struct out_state *st)); 
extern int state_putunicode P_((int len, const uint16 *vector, struct out_state *st)); 
extern int state_putstchar P_((struct charset_state *C, struct out_state *st)); 
extern int state_putentity P_((struct out_entity *C,struct out_state *st));
			       
extern int state_putc P_((int,  struct out_state *));
extern int state_printf P_((struct out_state *s,
			    const char * format, const char *msg, ...));


extern int  out_state_seekable P_((struct out_state *)); 
extern int  out_state_fseek P_((struct out_state *, long)); /* STATE_out_file */
extern long out_state_ftell P_((struct out_state *));       /* STATE_out_file */

/* Returns NULL if no available ... */
extern FILE *out_state_FILE P_((struct out_state *));  
extern int out_state_ferror P_((struct out_state *));

/* Return 1 if is copy succeed */
extern int state_copy P_((struct in_state *infile, struct out_state *outfile)); 

/* Return 1 if is copy succeed, return -1 on unexpected EOF */
extern int state_copy_range P_((struct in_state *infile,  
				struct out_state *outfile,
				int bytes));

/* Allocates new struct pager_range */
extern struct pager_range * state_add_simple_pager_range 
  P_((struct out_state *outfile,
      struct pager_range *inherit,
      int range_flags,
      int quote_level,
      int indent));


/* Allocates new struct pager_range */
extern struct pager_range * state_add_opcode_pager_range
   P_((struct out_state       * outfile,
       enum pager_range_opcode  opcode,
       struct pager_range *inherit,
       int range_flags,
       int quote_level,
       int indent));

extern void state_pager_add_param_text P_((struct out_state      * outfile,
					   struct pager_range    * range,
					   enum pager_param_opcode opcode,
					   struct string         * text));
				      

/* should called on beginning of line, may flush line 
   range may be NULL
 */
extern void set_out_state_line_pager_range P_((struct out_state *ptr,
					       struct pager_range *range));

/* Returns 0 if pg_ line flags are not supported,
   should called on beginning of line, may flush line 

   if range is not set, keeps current range
 */
extern int set_out_state_line_mode P_((struct out_state *ptr,int pg_flags,
				       struct pager_range *range,
				       int force_eoln));
				       

  
/* syscall.c */

enum rawstate { OFF = 0, ON = 1 };

#ifdef BACKGROUD_PROCESSES       
extern volatile int handle_sigchld;       /* got SIGCHLD */

#endif

/* options to the system_call() and start_run() procedure */
#define SY_USER_SHELL	(1<<0)		/* use user shell instead of /bin/sh */
#define SY_ENV_SHELL	(1<<1)		/* put SHELL=[shell] into environ    */
#define SY_ENAB_SIGHUP	(1<<2)		/* pgm to exec can handle signals    */
#define SY_ENAB_SIGINT	(1<<3)		/*  ...and it can handle SIGINT too  */
#define SY_DUMPSTATE	(1<<4)		/* create folder state dump file     */
#define SY_ENV_METAMAIL	(1<<5)		/* put MM_CHARSET to environ         */
#define SY_NOTTY	(1<<6)		/* no tty                    */
#define SY_CLRWAIT	(1<<7)		/* clr and wait 'any key' in end     */
#define SY_RUN_STATE_ENV (1<<8)         /* struct run_state have ext_env     */
#define SY_RUN_STATE_INIT (1<<9)        /* struct run_state have ext_init    */
#define SY_RUN_STATE_OPIPE (1<<10)      /* create {run_state}.pfd 
					 * pipe for output of command        */
#define SY_RUN_STATE_EPIPE (1<<11)      /* create {run_state}.pfd 
					 * pipe for error output of command  */

extern int set_child_signals P_((int));      /* Prototype */
extern int set_child_env P_((int));         /* Prototype */

#ifdef BACKGROUD_PROCESSES
extern void init_backgroud_handling P_((void));
#endif

#ifdef BACKGROUD_PROCESSES      
#ifdef ANSI_C
struct process_list;               /* Needed for prototype */
#endif

extern void sigchld_handler P_((void));
#endif

struct run_state {
    int pid;
    int save_errno;
    enum rawstate raw;
  int options;
#ifdef BACKGROUD_PROCESSES      
    struct process_list *listptr;
#endif
    char ** ext_env;
    void (*ext_init) P_((struct run_state *rs));
    void * ext_init_data;
    FILE *pfd;
};

union any_fd {
    FILE                    * file_fd;
    struct in_state         * state_in_fd;
    struct out_state        * out_state_fd;
    void                    * void_fd;
    struct mail_send_state  * mail_fd;
    struct resolv_process   * resolv_process;  /* not really fd */
};

typedef void end_handler P_((union any_fd fd, char * title, 
			     struct run_state *rs, int ret, int exit_stat));
typedef void free_any_fd_f P_((union any_fd *fd));
typedef void inc_any_fd_refcount_f  P_((union any_fd fd));
extern void NO_free_any_fd  P_((union any_fd *fd));
extern void NO_inc_any_fd_refcount  P_((union any_fd fd));

#ifdef BACKGROUD_PROCESSES      
extern int maybe_background P_((struct run_state *rs, int *exit_code,
				union any_fd fd, const char *title, 
				end_handler           * func,
				free_any_fd_f         * free_any_fd,
				inc_any_fd_refcount_f * inc_any_fd_refcount
				));
extern void add_foreign_background P_((int pid, 
				       union any_fd fd, const char *title, 
				       end_handler *func,
				       	free_any_fd_f         * free_any_fd,
				       inc_any_fd_refcount_f * inc_any_fd_refcount));

/* < 0 signal,0 not found,   removes job from process list 
   1 exited normally
   2 no process (removed from list)
   waits process to end
*/
extern int wait_background_end P_((int pid, int *exit_code));
#endif

extern int start_run        P_((struct run_state *rs, int options,
				const char * argv[], int infd, int outfd));
extern int run_already_done P_((struct run_state *rs, int *exit_code));
extern int wait_end         P_((struct run_state *rs, int *exit_code));
extern const char ** join_argv    P_((char * argv1[], 
				      char * argv2[]));
extern const char ** join_argvc1  P_((const char * argv1[], 
				      char * argv2[]));


typedef void SR_print_status        P_((struct run_state *rs,int sig,int exit_code));
typedef enum rawstate SR_RawState   P_((void));
typedef void SR_Raw          P_((int state));
typedef void SR_tty_init     P_((void));
typedef void SR_ClearScreen  P_((void));
typedef void SR_PutLineS P_((struct string *S));


void set_start_run_hooks P_((SR_print_status * print_status_func,
			     SR_RawState     * raw_query_func,
			     SR_Raw          * raw_set_func,
			     SR_tty_init     * run_tty_init,
			     SR_ClearScreen  * clear_screen_func,
			     SR_PutLineS     * put_line_function,
			     SR_print_status * print_status_cooked_func
			     ));

extern void sr_call_ClearScreen P_((void));
extern void sr_call_Raw P_((int x));
extern int sr_call_RawState P_((void));
extern void sr_call_Write_to_screen P_((const char *format, 
					const char *msg, ...
					));
extern void call_print_status_cooked P_((struct run_state *rs,int sig,
					 int exit_code));

/* iso2022.c */

enum map_list_mode { ml_none, ml_system, ml_global, ml_user };
extern struct iso2022_map_conf *parse_iso2022_map P_((const char *filename,
						      int *errors,
						      enum map_list_mode mode));

extern void free_iso2022_map_conf P_((struct iso2022_map_conf **ptr));

extern void free_iso2022_map_list P_((void));

extern int realloc_iso2022_map_list P_((int add));

/* stringtok.c */

#define TOK_mail      1
#define TOK_mime      2

extern struct string_token {
    uint16          special;              /* unicode of special or 0 */
    struct string  *token;
    enum token_status {
	token_fail    = 0,
	token_parsed,
	token_icomplete   /* unbalaced quote? */
    }               status;
} * string_tokenize P_((const struct string *line,
			int flags));

extern void free_string_tokenized P_((struct string_token **ptr));

extern int unicode_is_special P_((int x, int flags));

/* "space" for  tokenizer */
extern int unicode_is_space P_((int x));

extern int string_need_quote P_((const struct string * value));

/* pmalloc.c */

extern char *pmalloc P_((int size));

/* cancel.c */

typedef void cancel_set_ttysig_f P_((void));
typedef void cancel_reset_ttysig_f P_((void));
typedef void cancel_transient_f   P_((struct string *x, int reserve));
typedef void cancel_clear_f       P_((void));
typedef void cancel_progress_f     P_((struct string *x, int *reserve,
				       struct string *progress));

extern int is_cancel_installed P_((void));

extern void setup_cancel_cb P_((cancel_set_ttysig_f   *cancel_set_ttysig,
				cancel_reset_ttysig_f *cancel_reset_ttysig,
				cancel_transient_f    *cancel_transient,
				cancel_clear_f        *cancel_clear,
				cancel_progress_f     *cancel_progress));

extern struct cancel_data * new_cancel P_((const char * format, 
					   const char *msg, ...));

/* works only if schedule is waiting this */
extern struct cancel_data * new_schedule_cancel P_((int delay_msec,
						    const char * format, 
						    const char *msg, ...));

void set_cancel_message P_((struct cancel_data *cancel,
			    int delay_msec       /* -1 if not schedule cancel, 
						    >= 0 works only if schedule is waiting this
						  */,
			    const char * format, 
			    const char *msg, ...));


extern int is_schedule_cancel P_((struct cancel_data *cd,
				  int * delay_msec));
extern void schedule_cancel_timeout P_((struct cancel_data *cd));

extern int is_canceled P_((struct cancel_data *cd));

extern void free_cancel P_((struct cancel_data **cd));

extern void  cancel_progress P_((struct cancel_data *cd,
				 const char * format, 
				 const char *msg, 
				 ...));

extern int refresh_cancel_message P_((void));

/* write_rc.c */


extern int write_rc P_((char *targetfile, FILE * commentfile, int global,
			const char *actor,struct string *username, 
			char *version_buff));

/* conf_writer.c */

typedef int dump_conf_map_f P_((FILE       * f,
				const char * actor,
				char       * version_buff,
				int        * erro_res));
typedef void dump_message_f P_((char *fname));

/* Return 1 if merge succeed */
typedef int merge_conf_map_f P_((const char  * fname,
				 FILE        * f));

#ifdef ANSI_C
extern merge_conf_map_f NO_merge_conf_map;
#endif
extern int NO_merge_conf_map P_((const char  * fname,
				 FILE        * f));

extern void register_conf_write P_((char             * shorname,
				    char             * fname,
				    dump_conf_map_f  * dump_map,
				    dump_message_f   * write_message,
				    int              * rewrite_flag,
				    merge_conf_map_f * merge_map
				    ));


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
