/* $Id: hashmark.h,v 2.6 2022/02/12 14:00:06 hurtta Exp $ */

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.6 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#ifdef ANSI_C
struct hashmark_item;           /* Needed for prototype */
struct service_entry;
#endif


extern void inc_hashmark_item_refcount P_((struct hashmark_item *item));
extern void free_hashmark_item P_((struct hashmark_item **item));
extern const struct string * hashmark_item_name P_((const struct hashmark_item *item));

/* increments refcount */
extern struct hashmark_item * search_hashmark_name P_((const struct string *name,
						       enum selection_type sel_type));

/* Caller maust free vector */
extern struct hashmark_item ** hashmark_dir P_((int *len,
						 enum selection_type sel_type));

/* 'flags' value for add_dir_vector() */
extern  int hashmark_browser_flags  P_((const struct hashmark_item *item));

union hashmark_data {
    void                   * dummy;
    struct hashmark_rdata * remote;
};

extern void  hashmark_init_data P_((const struct hashmark_item *item,
				    union hashmark_data      * hashmark_data));
extern void  hashmark_free_data P_((const struct hashmark_item *item,
				    union hashmark_data      * hashmark_data));



/* Return 1 if change done */

extern int hashmark_changebr_dir P_((struct hashmark_item  * item,
				     struct folder_browser * dir,
				     union hashmark_data   * hashmark_data,
				     const struct string   * path_tail,
				     struct string        ** dispname));


/* Return 1 if succeed */

extern int hashmark_passhm_verify_ra_con P_((const struct hashmark_item * item,
					     struct browser_passhm      * passhm,
					     struct remote_account *C));

/*  Return 1 if succeed, 
    caller does remote_account_init_tls()
    -1 == use fallback
*/

extern int hashmark_passhm_open_ra P_((const struct hashmark_item * item,
				       struct browser_passhm      * passhm,
				       struct remote_account      * ra,
				       const PORTS                  default_portlist[],
				       int                          give_service_entry_flag,
				       PORTS                        force_port));

/*  Return 1 if succeed, 
    caller does remote_account_init_tls()
    -1 == use fallback
*/

extern int hashmark_passhm_open_ra2 P_((const struct hashmark_item * item,
					struct browser_passhm      * passhm,
					struct remote_account      * ra,
					int                          give_service_entry_flag,
					
					/* For enumerate_service_type */
					struct enum_service_type *est));


/* Return 1 if succeed */
extern int hashmark_selectbr_item P_((struct hashmark_item  * item,
				      struct folder_browser * dir,
				      union hashmark_data   * hashmark_data,
				      const struct string   * path_tail,
				      struct string        ** dispname,
				      int                   * newpos));

/* Return 1 if succeed */
extern int hashmark_changebr_root_dir P_((struct hashmark_item  * item,
					  struct folder_browser * dir,
					  union hashmark_data   * hashmark_data,
					  struct string        ** dispname));

extern struct folder_info * hashmark_folder_from_browser P_((
	struct hashmark_item  * item,
	struct folder_browser * dir,
	union hashmark_data   * hashmark_data,	     
	int treat_as_spooled));

/* -1 == use fallback 
    caller must free *se, *username, *hostname

*/
extern int hashmark_remote_lookup P_((const struct hashmark_item * item,
				      struct service_entry      ** se,
				      int                          lookup_flags,
				      char                      ** username,
				      char                      ** hostname,
				      struct address            ** addr,
				      int                        * useraddr_flags,
				      struct cancel_data         ** cancel_p
				      /* May be NULL, Used if dns lookup was
					 cancelable 
				      */
				      ));

/* Return 1 if succeed */
extern int hashmark_selection_is_folder P_((struct hashmark_item  * item,
					    struct folder_browser * dir,
					    union hashmark_data   * hashmark_data,
					    struct folder_info    * folder));

/* Return 1 if succeed, changes browser type */
extern int hashmark_prepare_write P_((struct hashmark_item  * item,
				      struct folder_browser * dir,
				      union hashmark_data   * hashmark_data,
				      WRITE_STATE             ptr));

/* Return directory prefix and l_item,
   changes browser type
*/
extern struct string * hashmark_cat_item P_((struct hashmark_item  * h_item,
					     struct folder_browser * dir,
					     union hashmark_data   * hashmark_data,
					     const struct string   * l_item));

extern enum hashtype_v { hashtype_none = 0,        
	hashtype_remote_mbx       /*  enum selection_type: selection_folder  */,
	hashtype_folder_dir       /*  enum selection_type: selection_folder  */,
	hashtype_dir              /*  enum selection_type: selection_file    */,
	NUM_hashtype } hashmark_type P_((const struct hashmark_item *item));

extern enum haskmark_valid_v { hashmark_unusable = 0,
	hashmark_valid,
	hashmark_default_menu   /* valid for current user and 
				   show on default menu */,
	hashmark_hidden
	} hashmark_valid_on_user P_((const struct hashmark_item  * item));
				      
extern int hashmark_visible  P_((const struct hashmark_item  * item));

const struct string * hashmark_item_description P_((const struct hashmark_item *item));

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */

