/* $Id: mailer_imp.h,v 2.13 2020/05/12 18:18:18 hurtta Exp $ */

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.13 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                  (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#define MAILER_CANCEL_TICKET_magic	0xF206

struct mailer_cancel_ticket {
    unsigned short      magic;	/* MAILER_CANCEL_TICKET_magic */

    enum msd_action     msd_action;
    
    char              * fname;
    struct out_state  * OUT;
};

/* ------------------------------------------------------------ */

#if ANSI_C
struct mailer_config;
struct mailer_option_list;
struct mailer_info;
#endif


typedef int mailer_set_option  P_((struct mailer_config *M,
				   struct mailer_option_list *X,
				   char *value));
typedef int mailer_init_hook P_((struct mailer_config *M,
				 struct mail_send_state *C,
				 struct mailer_info *I));
typedef void mailer_close_hook P_((struct mailer_config *M,
				   struct mail_send_state *C));
typedef int mailer_backend3_hook P_((struct mailer_config *M,
				     struct mail_send_state **C,
				     int encoding_top,
				     char * title,
				     sending_message_func *sm,
				     int *exit_status,
				     struct mailer_cancel_ticket * ticket,
				     long message_size));

typedef int mailer_info_init_hook P_((struct mailer_config *M,
				      struct mailer_info *I));

typedef void mailer_info_close_hook P_((struct mailer_config *M,
					struct mailer_info *I));

typedef int mailer_info_query_hook P_((struct mailer_config *M,
				       struct mailer_info *I,
				       enum MI_query query));

/* Result is malloced */
typedef char ** mailer_info_s_query_hook P_((size_t                * reslen_p,
					     struct mailer_config  * M,
					     struct mailer_info    * I,
					     enum MI_query_string    query,
					     struct cancel_data   ** cancel_p));

/* Return
 -1  if connection lost          (mailer_disconnected)
  0  if OK                       (mailer_not_restarted)
  1  if mailer reinitialized and  query_mailer_info()
        need to be called again  (mailer_reinitialized)
*/
typedef enum restart_mailer_status mailer_info_restart_hook P_((struct mailer_config *M,
								struct mailer_info *I));


/* Return 
   -1 if caller should result with default data (return 1)  (mi_vrfyaddr_default_ok)
   -2 if caller should just test passwd                     (mi_vrfyaddr_test_passwd)
   0  if failure                                            (mi_vrfyaddr_failure)
   1  is succees                                            (mi_vrfyaddr_success)
*/
typedef enum mi_vrfyaddr_mailer_status {
    mi_vrfyaddr_test_passwd = -2,
    mi_vrfyaddr_default_ok  = -1,
    mi_vrfyaddr_failure     =  0,
    mi_vrfyaddr_success     =  1

} mailer_info_verify_addr P_((struct mailer_config *M,
			      struct mailer_info  *I, 
			      const char *text,
			      struct addr_verify_result *result));
					
typedef void mailer_info_gen_def_ef P_((struct mailer_config *M,
					struct mailer_info *I,
					struct mailer_env_from *X)); 

/* Return 1 if changed */
typedef int mailer_info_set_ef     P_((struct mailer_config *M,
				       struct mailer_info *I,
				       struct mailer_env_from *X,
				       const char *value));
typedef int MO_value_hook P_((struct mailer_config      * M,
			      struct mailer_option_list * L,
			      char **value,int set));

struct mailer_option_list {
    const char              * field;
    char                   ** value;
    MO_value_hook           * value_func;
    int malloced;
};


/* mailer_bits mask */
#define MB_DONT_ADD_FROM       1
#define MB_USE_DOMAIN          2
#define MB_ALLOW_SET_SENDER    4
#define MB_REQ_DEFAULT_SENDER  8
#define MB_SENDING_DISPLAY    16

#define MAILER_CONFIG_magic     0xF205

struct mailer_config {
    unsigned short               magic;      /*  MAILER_CONFIG_magic */

    const char                 * mailer_type;
    struct mailer_option_list  * list;    /* {NULL, NULL} terminated */ 
    mailer_set_option          * m_set_option;
    mailer_init_hook           * m_init_hook;
    mailer_close_hook          * m_close_hook;
    mailer_backend3_hook       * m_backend3_hook;
    char                      ** mailer_path;
    mailer_info_init_hook      * mi_init_hook;
    mailer_info_close_hook     * mi_close_hook;
    mailer_info_query_hook     * mi_query_hook;
    mailer_info_verify_addr    * mi_verify_addr;
    mailer_info_gen_def_ef     * mi_def_env_from;  
    mailer_info_set_ef         * mi_set_env_from;
    mailer_info_restart_hook   * mi_restart_hook;
    mailer_info_s_query_hook   * mi_query_s_hook;
    
    int                         mailer_bits;
    /* TODO: Add to this mailer specific data
       (if any)
    */
};


#define MAILER_magic		0xF200

struct mail_send_state {
    unsigned short          magic;    /* MAILER_magic */
    struct mailer_config   *mailer_type;
    char **addrs;
    int   addr_count;
    int   dsn;
    int   verbose;

    char      * fname;
    struct out_state   * OUT;              
    end_handler *orig_func;

    char      *  mail_from;              /* From struct mailer_env_from */

    /* TODO: Add mailer specific state to here ... */

    /* -------------------------------- */
    /* set by mailer_set_sending_display() */

    struct sending_display           * msd_sd;  /* opaque */
    msd_free_sending_display_cb      * msd_free_cb;
    msd_inc_sending_display_cb       * msd_inc_cb;
    msd_update_addr_cb               * msd_addr_upd_cb;
    msd_check_addr_cb                * msd_addr_check_cb;
    msd_update_data_cb               * msd_data_upd_cb;
    msd_check_fail_cb                * msd_fail_check_cb;
    msd_update_con_cb                * msd_con_upd_cb;
    msd_check_size_cb                * msd_size_check_cb;
    msd_update_size_cb               * msd_size_upd_cb;

    /* -------------------------------- */


    struct mailer_info     *head;
    struct mail_send_state *next;
};

#define MAILER_INFO_magic	0xF201

struct mailer_info  {
    unsigned short          magic;
    struct mailer_config   *mailer_type;
    
    int                    delete_pending;

    union any_mailer_info {
        void                  * ptr;
	struct smtp_info      * smtp;
        struct mailer_info_1  * p1;
        struct mailer_info_2  * p2;
    } p;

    struct mail_send_state *first;
    struct mailer_env_from *first_e;
};

int MO_default_value P_((struct mailer_config      * M,
			 struct mailer_option_list * L,
			 char **value,int set));
int MO_allow_set_sender P_((struct mailer_config      * M,
			    struct mailer_option_list * L,
			    char **value,int set));

#define MAILER_ef_magic	        0xF202

#define MAILER_ef_can_set       1
#define MAILER_ef_need_default  2
#define MAILER_ef_changed       4
#define MAILER_ef_verified      8

struct mailer_env_from {
    unsigned short          magic;   /* MAILER_ef_magic */
    struct mailer_config   *mailer_type;

    char                  * mail_from;
    char                  * domain; /* If return value is not pointer to
				       mail_from
				    */
    char                  * angleaddr; /* If return value is not pointer to
					  mail_from
				       */
    unsigned int            flags;

    struct mailer_info     *head;
    struct mailer_env_from *next;
};

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
