/* $Id: mailerlib.h,v 2.27 2020/11/15 16:02:34 hurtta Exp $ */

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.27 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

/* init.c */

extern void init_mailerlib P_((int read_flags /* READ_FLAG_IGNORE_MISSING */));

/* mailer.c */

extern int mailerfunc P_((char **value, int enter,
			  int lineno, const char *filename,
			  int read_flags /* READ_FLAG_IGNORE_MISSING */
			  ));

typedef void sending_message_func P_((int background));

extern struct mailer_info  *get_mailer_info P_((void));
extern void free_mailer_info P_((struct mailer_info **S));

enum MI_query { MI_HAVE_8BITMIME = 1, MI_HAVE_BINARYMIME = 2,
		MI_HAVE_DSN      = 3, MI_DONT_ADD_FROM  = 4,
		MI_USE_DOMAIN    = 5, MI_HAVE_SENDING_DISPLAY = 6,
		MI_REMOTE_MAILER
};
	
		    
extern int query_mailer_info P_((struct mailer_info  *I,
				 enum MI_query query));

enum MI_query_string {
    MI_con_name_local = 1 /* Get name from local addess of connection */
};

/* Result is malloced */
extern char ** query_s_mailer_info P_((size_t                * reslen_p,
				       struct mailer_info    * I,
				       enum MI_query_string    query,
				       struct cancel_data   ** cancel_p));


/* -1  if connection lost          (mailer_disconnected)
    0  if OK                       (mailer_not_restarted)
    1  if mailer reinitialized and  query_mailer_info()
          need to be called again  (mailer_reinitialized)
	  and maybe update_message_id()
*/
extern enum restart_mailer_status {
    mailer_disconnected  = -1,
    mailer_not_restarted =  0,
    mailer_reinitialized =  1
} mailer_restarted P_((struct mailer_info  *I));

/* Should return 1 if verify succees and fields of result to be filled 
   -- caller should free fields of result
   Returns 0 on failure
*/

enum mailer_errcode {
    MAILER_OK = 0,                  /* Address OK */
    MAILER_NOT_AVAIL,               /* Address verify not available */
    MAILER_NOT_EXIST                /* Address not exists */
};

struct addr_verify_result {   /* OLD struct addr_item */
    char *addr;
    struct string *fullname;
    struct string *comment;
};

int verify_mailer_addr P_((struct mailer_info  *I,
			   const char *text,
			   struct addr_verify_result *result,
			   enum mailer_errcode *errcode));
int verify_mailer_domaddr P_((struct mailer_info  *I,
			   const char *text,
			   struct addr_verify_result *result,
			   enum mailer_errcode *errcode));

/* Return NULL if no editor (and no value either) */
extern struct mailer_env_from * mailer_get_env_from P_((struct mailer_info  *I));
extern void mailer_free_env_from P_((struct mailer_env_from **X));
extern int mailer_env_from_changed P_((struct mailer_env_from *X));

/* This should be set only for local address,
   This is 250 status
   but not 252 relayed mail status
*/
extern int mailer_env_from_verified  P_((struct mailer_env_from *X));

/* return temporary pointer  value -- do not free 
   return NULL if currently no value set (use implicit default)
  */
extern const char * mailer_env_from_value P_((struct mailer_env_from *X,
					      int *can_edit));
extern const char * mailer_env_from_angleaddr P_((struct mailer_env_from *X));


/* Return 1 if succeed */
extern int mailer_env_from_change P_((struct mailer_env_from *X,
				      const char * value));

/* return temporary pointer  value -- do not free 
   return NULL if currently no value set (use implicit default)
   also return NULL is env_from is <>
  */
extern const char * mailer_env_from_domain P_((struct mailer_env_from *X));



extern struct mail_send_state  *mailer_init P_((char **addr_args,
						int dsn,
						int verbose,
						struct mailer_info *info,
						struct mailer_env_from *env_from));


/* Note that also mail_backend3 does freeing ... */
extern void free_mail_send_state P_((struct mail_send_state **S));


extern struct out_state *get_mail_outfd P_((struct mail_send_state  *X));


extern struct mailer_cancel_ticket * new_mailer_cancel_ticket P_((void));
extern void free_mailer_cancel_ticket P_((struct mailer_cancel_ticket **
					  ticket));

extern enum msd_action { 
    msd_act_EOF        = -1  /* EOF seen on user input       */,
    msd_act_SIG        = -2  /* Ctrl-C or OE_SIG_CHAR        */,
    msd_act_need_restart = -3  /* mailer_restarted() need to be called 
				  (cancel copy) then send again           */,

    msd_act_default  = 0  /* default action or not defined or OK */,
    msd_act_cancel        /* forget/cancel or do not send  (cancel copy)  */,
    msd_act_edit          /* 'edit' again                  (cancel copy)  */,
    msd_act_send          /* 'send' or continue anyway    */
} have_msd_action P_((struct mailer_cancel_ticket *ticket));

extern const char * have_cancel_filename  P_((struct mailer_cancel_ticket *
					      ticket));
extern FILE * have_cancel_FILE P_((struct mailer_cancel_ticket *
					      ticket));
/* free_mailer_cancel_ticket closes / unlinks this file (if exists) */



/* mail_backend3 may free (*mail_fd) pointer ... */
extern int mail_backend3 P_((struct mail_send_state **mail_fd,
			     end_handler *func,
			     int encoding_top,
			     char * title,
			     sending_message_func *sm,
			     int *exit_status  /* may be NULL */,

			     struct mailer_cancel_ticket *
			     ticket  /* may be NULL */,
			     long message_size));


/* Return mailer path or type ... */
extern const char *get_mailer_path P_((struct mail_send_state *mail_fd));

void init_default_mailer P_((int read_flags /* READ_FLAG_IGNORE_MISSING */));

extern char * kludge_addr P_((char **addr));

/* mail sending (recipient) display */

#if ANSI_C
struct sending_display;
#endif

/* callbacks */

typedef void msd_free_sending_display_cb P_((struct sending_display **sd));


typedef void msd_inc_sending_display_cb P_((struct sending_display *sd));


enum msd_addr_status { msd_addr_tmpfail  = -1,
		       msd_addr_fail     = -2,
		       msd_addrstat_none = 0, /* status not yet available */
		       msd_sending_addr  = 1,
		       msd_addr_ok       = 2
};


/* idx == -1  is sender (MAIL FROM) 
   idx == 0 .. (count of addr_args from mailer_init) is recipient (RCPT TO)
*/
typedef void msd_update_addr_cb P_((struct sending_display *sd,
				    int                    idx,
				    struct string        * addr,
				    enum msd_addr_status   status,
				    struct string        * message /* server */
				    ));
	

enum msd_can_continue { msd_mail_failed = 0, msd_address_problem };


/* Return 0 (msd_act_default) on timeout, wait ~second for user input 
   idx == -1  is sender (MAIL FROM) 
   idx == 0 .. (count of addr_args from mailer_init) is recipient (RCPT TO)

   block (wait user) if not can_continue

   Called if at one address fails 
   AND struct mailer_cancel_ticket is available 
*/

typedef enum msd_action msd_check_addr_cb P_((struct sending_display *sd,
					      int                    idx,
					      struct string        * addr,
					      enum msd_addr_status   status,
					      struct string  * message 
					      /* server */,
					      enum msd_can_continue 
					      can_continue));
			      
enum msd_data_status { msd_mail_tmpfail = -1,
		       msd_mail_fail    = -2,
		       msd_mail_backgrounded = -3,  /* Can not pass ticket */
		       msd_calling_mailer = -4, /* calling mailer      */
		       msd_datastat_none  = 0,  /* status not yet available */
		       msd_sending_data = 1,
		       msd_data_ok      = 2,    /* DATA command accepted */
		       msd_mail_sent    = 3     /* Final dot OK */
};

typedef void msd_update_data_cb P_((struct sending_display * sd,
				    enum msd_data_status     status,
				    struct string    * message /* server */));


/* Called if at least one address or DATA fails 
   AND struct mailer_cancel_ticket is available 

   Not called if  msd_check_addr_cb already returns msd_action
*/
typedef enum msd_action msd_check_fail_cb P_((struct sending_display *sd,
					      enum msd_data_status   status,
					      struct string  * message /* server */,
					      enum msd_can_continue 
					      can_continue));

enum msd_connection_info { msd_server = 0,
			   msd_verified_as    /* if certificate ok */,

			   NUM_msd_connection_info
};

typedef void msd_update_con_cb  P_((struct sending_display *sd,
				    enum msd_connection_info idx,
				    struct string *text));

/* Called when mail is too big */
typedef enum msd_action msd_check_size_cb P_((struct sending_display *sd,
					      long message_size,
					      long size_limit));


enum msd_size_info   { msd_message_size = 0,
		       msd_size_limit,
		       NUM_msd_size_info };

typedef void msd_update_size_cb P_((struct sending_display *sd,
				    enum msd_size_info idx,
				    long size));

/* 0 .. not supported 
   1 .. supported 

   calls msd_inc_sending_display_cb
   if take reference from struct sending_display *sd
*/

extern int mailer_set_sending_display 
                  P_((struct mail_send_state      * S,
		      struct sending_display      * sd /* opaque */,
		      msd_free_sending_display_cb * free_cb,
		      msd_inc_sending_display_cb  * inc_cb,
		      msd_update_addr_cb          * addr_upd_cb,
		      msd_check_addr_cb           * addr_check_cb,
		      msd_update_data_cb          * data_upd_cb,
		      msd_check_fail_cb           * check_fail_cb,
		      msd_update_con_cb           * con_upd_cb,
		      msd_check_size_cb           * check_size_cb,
		      msd_update_size_cb          * size_upd_cb
		      ));

/* outheaders.c */

struct mailing_headers;
extern void zero_mailing_headers P_((struct mailing_headers *hdrs));
extern void free_mailing_headers P_((struct mailing_headers *hdrs));

/* Result is malloced */
extern char * from_addr_literal1 P_((int add_dom,
				     char **used_domain  /* result malloced */));
/* Result is malloced */
extern char * from_addr_literal P_((struct mailer_info *mailer_info,
				    char **used_domain  /* result malloced */));

struct expanded_address;

extern struct string * username_to_surface_addr P_((void));

/* Returns >= 1 if from address was added */
extern enum make_from_status {
        make_from_fail        = 0,
	make_from_normal      = 1 /* normal domain */,
	make_from_localaddr   = 2 /* no domain */,
	make_from_literal     = 3 /* [literal] domain */,
	make_from_whitelisted = 4 /* whitelisted domain */
} make_from_addr P_((struct expanded_address *expanded,
		     struct mailer_info *mailer_info,
		     char **used_domain  /* result malloced */,
		     char **used_address /* result malloced */
		     ));
extern void force_from_addr P_((struct expanded_address *expanded,
				const char *force_domain));

/* shared_mailer.c */

#ifdef USE_DLOPEN
extern SHAREDLIB use_shared_mailer;
#endif


extern struct mailer_config  * loc_mailer_type P_((char *f));

extern enum mailerdom_lib_status {
     mailerdomlib_bad         = -1        /* not valid library tag or library does not exists */,
     mailerdomlib_not_loaded  = 0        /* library not loaded (stauts not used?) */,
     mailerdomlib_found,
     mailerdomlib_delayed                /* library exists, but not checked */
	 } mailerdom_verify_lib_status P_((const char *tag,
					   int read_flags /* READ_FLAG_IGNORE_MISSING */
					   ));

extern enum verify_domain_result { 
    verify_domain_not_available = -3 /* no shared library or routine */,
    verify_domain_fallback  = -2 /* call default routine instead */,
    verify_domain_failure   = -1   /* can't verify */,
    verify_domain_not_found  = 0   /* domain not found */,
    verify_domain_ok         = 1   /* domain found */,
    verify_domain_no_mail    = 2   /* domain accept no mail */,
    verify_domain_bad_syntax = 3   /* domain have bad syntax       */
	} shared_verify_domain P_((const char *domain,char **rewrite,
				   const char *tag, int translated_value,
				   const struct dt_enum_shared * is_shared_value,
				   const struct schedule_timelimit * now,
				   struct schedule_timelimit       * valid_until,
				   struct cancel_data             ** cancel_p
				   /* May be NULL, Used if dns lookup was cancelable */

				   ));

extern enum check_dname_result {
    check_dname_no_routine = -3   /* no lookup name routine       */,
    check_dname_query_blacklisted = -2  /* lookup blacklisted, not dns name */,
    check_dname_failure    = -1   /* can't lookup                 */,
    check_dname_not_found  = 0    /* name not found               */,  
    check_dname_have_name  = 1    /* name found                   */,
    check_dname_bad_syntax = 3    /* name have bad syntax         */
	} shared_check_dname P_((const char                      * domainname,
				 char                           ** rewrite,
				 const char                      * tag,
				 const struct schedule_timelimit * now,
				 const struct schedule_timelimit * default_valid_until
				 /* for other data */,			 
				 struct schedule_timelimit       * valid_until,
				 int                             * was_error_p,
				 struct cancel_data             ** cancel_p));



/* mime_encode.c */

extern void base64_encode P_((FILE *srcfp,
			      struct out_state *mailer,
			      int istext,
			      int top_encoding,
			      int source_is_binary));

extern void line_quoted_printable_encode P_((char *input, 
					     struct out_state *mailer, int len, 
					     int istext,
					     int top_encoding,
					     int source_is_binary));


extern void quoted_printable_encode  P_((FILE *srcfp, struct out_state *mailer, 
					 int istext,
					 int top_encoding,
					 int source_is_binary));

extern void add_parameter P_((char *opts, 
			      const char *name, const char *value,
			      int size, int quoted));


/* message-id.c */

#if ANSI_C
struct message_id;
#endif

extern enum message_id_status {
    msid_stat_need_hash = -4,
    msid_stat_need_restart = -3  /* mailer_restarted() need to be called */,
    msid_stat_none      = 0     /* No message-id */,
    msid_stat_updated           /* message-id updated */,
    msid_stat_no_changes
} update_message_id P_((struct message_id      ** msg_id_res,
			struct digest_proc     * old_hash,
			struct digest_proc     * current_hash,
			struct mailer_info      * info,
			const struct digest_proc_type ** need_hash,
			struct cancel_data             ** cancel_p
			/* May be NULL, Used if dns lookup was cancelable
			 *cancel_p is set if DNS lookup is cancelable
			 */
			));

/* write_common.c */

enum write_header_mode { write_header_send = 0,
			 write_header_copy,
			 write_header_preview };

extern void write_common_mailing_headers P_((struct out_state              * fh,
					     struct mailing_headers        * headers,
					     enum encoding                   message_encoding,
					     int                             encode_hdr,
					     charset_t                       cs,
					     enum write_header_mode          mode));


/* feed_common.c */

extern void  feed_common_mailing_headers P_((struct digest_proc * ret,
					     struct mailing_headers        * headers,
					     int                             encode_hdr,
					     charset_t                       cs));   

/* senderhelper.c */

/* Returns ".localdomain" if domain ends .localdomain and
   Configure or setup_names() selected that for placeholder
   domain.
*/

extern  const char * matches_dummy_domain P_((const char  * domain));

 

extern void sndhelper_get_sender P_((const enum add_sender_v add_sender_h,
				     struct mailer_info    * mailer_info,
				     char                 ** sender_domain_p,
				     int                   * sender_domain_verify_p,
				     char                 ** sender_addr_p,
				     const int               from_addr_len				     
				     ));

extern enum sndhelper_status {
    sndhelper_domain_failure = -1,
    sndhelper_none = 0           /* No specific status */

} sndhelper_handle_sender P_((const enum add_sender_v   add_sender_h,
					struct mailer_info      * mailer_info,
					char                   ** sender_domain_p,
					int                     * sender_domain_verify_p,
					char                   ** sender_addr_p,
					const int                 from_addr_len,
					int                     * sender_ok_p,
					struct mailing_headers  * headers));

/* Return 1 if parses OK, 0 if invalid */
extern int build_address_classify_domain P_((const char  * domain,
					     int         * is_literal_p,
					     const char ** whitelisted_name_p,	 
					     const char ** reserved_name_p));


/* Explain invalid address */
extern void build_address_classify_message P_((const char * addr,
					       const char * domain,
					       int          is_literal,
					       const char * whitelisted_name,
					       const char * reserved_name));

extern struct cancel_data  *build_address_cancel_mode P_((const char *domain));

extern enum verify_domain_result verify_mail_domain_util
     P_((const char          * domain,
	 char               ** rewrite,
	 struct cancel_data ** cancel_p));

typedef struct string * default_xmailer_cb P_((void));

void sndhelper_update_user_agent P_((struct mailing_headers * headers,
				     charset_t                hdr_charset,
				     int                      enmime,
				     default_xmailer_cb     * default_xmailer));

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
