/* $Id: mbx_imp.h,v 2.37 2024/06/23 07:38:36 hurtta Exp $ */

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.37 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                  (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#ifdef REMOTE_MBX
struct imap_uid_ref {
    int last_mbx_index;        /* Not necessary valid -- just chache */
    int uid_number;
};
#endif

#define RF_magic        0xFA00
struct read_folder_state {
    unsigned short magic;            /* RF_magic */
    long    fbytes;
    int     linecounter;
    long    fbytes_body;
    enum prepare_mode mode;
    enum skipping_mode {
	sm_EOM      = -1,
	sm_reading  = 0,
	sm_skipping = 1
    }     skipping;   /*  0 == reading, 1 = skipping, -1 == end of message */
    int     skip_count;
    long    skip_bytes;

    union {
	struct FILE_rs {
	    char    * next_line;
	    int     next_line_len;
	} file;
#ifdef REMOTE_MBX
	struct POP_MBX_rs {
	    int msg_num;              /* Current msg_num */
	    int data_idx;
	    char **uidl_vector;
	    int uidl_count;
	    int *rfc822_size_vector;
	    int rfc822_size_count;
	} pop_mbx;
	struct IMAP_MBX_rs {
	    struct imap_uid_ref  current_message;
	    int                  data_idx;
	} imap_mbx;
#endif
    } a;

    /* Hook for copy_previous_mail() */
    struct copy_previous_rs * reconnect_copy_previous;
};

#define RECONNECT_MODE_magic	0xFA06

struct reconnect_mode {
    unsigned short magic;       /* RECONNECT_MODE_magic */
    
    char * tempfolder_name;
    FILE * tempfolder_fh;

    long tempfolder_size;
};


typedef int mbx_close_folder P_((struct folder_info *folder,
				 enum close_mode mode,
				 struct cancel_data  * cd  /* Allow cancelation (Ctrl-C)
							      on remote mailbox
							   */));
typedef int  mbx_lock_folder  P_((enum lock_direction direction,struct folder_info *folder));
typedef int  mbx_unlock_folder P_((int interrupt, struct folder_info *folder));

/* Flush may fail if canceled */
typedef int mbx_flush_folder P_((struct folder_info *folder,
				 int *err_p  /* errno value */,
				 struct cancel_data  * cd  /* Allow cancelation (Ctrl-C)
							      on remote mailbox
							   */
				 ));

typedef void mbx_init_folder P_((struct folder_info *folder));
typedef int mbx_free_folder P_((struct folder_info *folder,
				 struct cancel_data  * cd));
typedef enum sessionlock_status mbx_sessionlock_folder P_((struct folder_info *folder,
							   enum sessionlock_mode mode,
							   int *err /* errno */,
							   RECONNECT_MODE * reconnect_ptr));
typedef int mbx_ferror_folder P_((struct folder_info *folder, int clean));
typedef enum prepare_result mbx_prepare_read_folder
                     P_((struct folder_info *folder,
			 enum prepare_mode mode,
			 READ_STATE read_state_ptr,
			 RECONNECT_MODE reconnect_ptr));
typedef int mbx_end_read_folder P_((struct folder_info *folder,
				    READ_STATE read_state_ptr,
				    RECONNECT_MODE reconnect_ptr,
				    int silent));
typedef enum copy_env_status mbx_copy_envelope_folder P_((struct folder_info *folder,
					 READ_STATE read_state_ptr,
					 struct header_rec *entry,
					 int force));
typedef const char * mbx_is_forwarded_folder P_((struct folder_info *folder,
						 READ_STATE read_state_ptr));
typedef int mbx_copy_header_folder P_((struct folder_info *folder,
				       READ_STATE read_state_ptr,
				       char **buffer, int *len));
typedef int mbx_copy_body_folder P_((struct folder_info *folder,
				     READ_STATE read_state_ptr,
				     char **buffer, int *len,
				     long *content_remaining));
typedef enum copy_env_end_status mbx_copy_envelope_end_folder
   P_((struct folder_info *folder,
       READ_STATE read_state_ptr,
       long *newbytes,
       int  *newmails ));
typedef int mbx_copy_envelope_reset_body P_((struct folder_info *folder,
					     READ_STATE read_state_ptr));
typedef FILE * mbx_folder_to_fd P_((struct folder_info *folder,long offset));
typedef enum new_mail_stat mbx_new_mail_on_folder P_((struct folder_info *folder,
						      long *bytes,
						      int  *new_mailcount /* -1 for local mailbox */,
						      int *err_p  /* errno value */,
						      struct cancel_data  * cd  /* Allow cancelation (Ctrl-C)
						      check of remote mailbox
										 */
						      ));
typedef int mbx_consider_remove_folder P_((struct folder_info *folder));
typedef int mbx_prepare_keep_folder P_((struct folder_info *folder,
					KEEP_STATE keep_state_ptr));
typedef int mbx_end_keep_folder P_((struct folder_info *folder,
				    KEEP_STATE keep_state_ptr));
typedef int mbx_mark_keep_folder P_((struct folder_info *folder,
				      KEEP_STATE keep_state_ptr,
				      struct header_rec *entry,
				      int keep));
typedef const char * mbx_folder_type P_((struct folder_info *folder));
typedef int mbx_start_edit_folder P_((struct folder_info *folder, 
				      const char **buffer));
typedef enum end_edit_fol_status mbx_end_edit_folder P_((struct folder_info *folder));
typedef void mbx_zero_rs_fields_folder P_((struct read_folder_state *rs));
typedef void mbx_free_rs_fields_folder P_((struct read_folder_state *rs));
typedef void mbx_zero_ks_fields_folder P_((struct keep_folder_state *rs));
typedef void mbx_free_ks_fields_folder P_((struct keep_folder_state *rs));
typedef int mbx_get_folder_mode P_((struct folder_info *folder));

typedef const struct remote_server * mbx_give_folder_server P_((struct folder_info *folder));

typedef enum comp_prev_hdr_result {
    comp_prev_hdr_miss = -1   /* Does not match */,
    comp_prev_hdr_pass = 0    /* Use generic algrithm */,
    comp_prev_hdr_found = 1   /* Assume found, need not use generic algrithm */
} mbx_comp_prev_hdr_folder P_((struct folder_info * folder,
			       struct header_rec  * entry,
			       struct header_rec  * prev_entry,
			       RECONNECT_MODE    reconnect_mode_ptr));

typedef void mbx_update_prev_hdr_folder
              P_((struct folder_info * folder,
		  struct header_rec  * entry,
		  struct header_rec  * prev_entry,
		  RECONNECT_MODE    reconnect_mode_ptr,
		  READ_STATE        read_state_ptr));

typedef struct mail_quota          * mbx_have_folder_quota P_((struct folder_info * folder));
typedef struct mail_quotaroot_list * mbx_give_folder_quotar_list
    P_((struct folder_info * folder,
	struct mail_quota  * mq,
	struct cancel_data * cd /* Allow cancelation (Ctrl-C) on remote mailbox */,
	enum quota_mode      refresh));

typedef int mbx_give_message_msize_folder P_((struct folder_info * folder,
					      struct header_rec  * entry,
					      unsigned long      * ret_size));

/* Return -1 if not available (local mail) */
typedef int mbx_give_message_count_folder P_((struct folder_info * folder));

#define FOLDER_TYPE_magic	0xFA01

struct folder_type {
    unsigned short magic;            /* FOLDER_TYPE_magic */
    const char                   * type_name;
    mbx_close_folder             * close_it;
    mbx_lock_folder              * lock_it;
    mbx_init_folder              * init_it;
    mbx_sessionlock_folder       * sessionlock_it;
    mbx_unlock_folder            * unlock_it;
    mbx_flush_folder             * flush_it;
    mbx_ferror_folder            * ferror_it;
    mbx_prepare_read_folder      * prepare_read_it;
    mbx_end_read_folder          * end_read_it;
    mbx_copy_envelope_folder     * copy_envelope_it;
    mbx_is_forwarded_folder      * is_forwarded_it;
    mbx_copy_header_folder       * copy_header_it;
    mbx_copy_body_folder         * copy_body_it;
    mbx_copy_envelope_end_folder * copy_envelope_end_it;
    mbx_copy_envelope_reset_body * copy_envelope_reset_it;
    mbx_folder_to_fd             * xxx_to_fd;
    mbx_new_mail_on_folder       * new_mail_on_it;
    mbx_consider_remove_folder   * consider_remove_it;
    mbx_prepare_keep_folder      * prepare_keep_it;
    mbx_end_keep_folder          * end_keep_it;
    mbx_mark_keep_folder         * mark_keep_it;
    mbx_folder_type              * type;
    mbx_start_edit_folder        * start_edit_it;
    mbx_end_edit_folder          * end_edit_it;
    mbx_free_folder              * free_it;
    mbx_zero_rs_fields_folder    * zero_rs_fields_it;
    mbx_free_rs_fields_folder    * free_rs_fields_it;
    mbx_zero_ks_fields_folder    * zero_ks_fields_it;  
    mbx_free_ks_fields_folder    * free_ks_fields_it;
    mbx_get_folder_mode          * get_it_mode;
    mbx_give_folder_server       * get_it_server;
    mbx_comp_prev_hdr_folder     * comp_prev_hdr_it;
    mbx_update_prev_hdr_folder   * update_prev_hdr_it;
    mbx_have_folder_quota        * have_it_quota;
    mbx_give_folder_quotar_list  * mbx_give_it_quotar_list;
    mbx_give_message_msize_folder * mbx_give_message_msize_it;
    mbx_give_message_count_folder * mbx_give_message_count_it;
};

extern int mbx_copy_line_to_temp P_((struct folder_info *folder,
				     char *buffer, int len));
extern void append_buffer P_((char **buffer, int *len,
			      char *buffer1, int len1));
extern int mbx_flush_temp P_((struct folder_info *folder,
			      int *err_p  /* errno value */
			      ));

#define KS_magic        0xF000

struct keep_folder_state {
    unsigned short     magic;          /* KS_magic */
    union {
	struct FILE_ks {
	    char * temp_keep_file;
	    FILE * keep_file;
	} file;
    } a;
};

int remote_folder_type P_((struct folder_info *fh));

extern struct folder_type read_only, non_spool, spool;


#ifdef REMOTE_MBX
extern struct folder_type pop_mbx, imap_mbx;

typedef enum { POP_error = 0,
	       POP_idle, POP_simple_command, POP_simple_response,
	       POP_multiline_command, POP_multiline_response, 
	       POP_multiline_data,
	       POP_command_ready, 
	       POP_not_logged } pop_states;



extern void set_remote_tempmbox P_((struct folder_info *fh,
				    struct remote_account *X));

struct imap_token {
    enum token_type { imap_atom, imap_number, 
		      imap_continue, imap_notag,
		      imap_status_keyword,
		      imap_other_keyword,
		      imap_list_begin, imap_list_end,
		      imap_code_begin,  imap_code_end,
		      imap_string, imap_literal ,
		      imap_zero
    }          imap_token;
    uint32     value;
    size_t     str_len;
    char     * str;
};


struct imap_reference {
    long uid_number;       /* used correlate with Elm mailbox structure */
    long imap_flags;       /* imap \Flag bits                           */

    int    rfc822_size;
    
    int    From_size;    /* From separator size */
    char * From_separator;
    
    char * internaldate;

    int     header_len;
    char  * header;

    int     body_len;
    char  * body;
};

struct Imap_Token_Buffer {
    struct imap_token * tokens;
    int                 token_count;
};

extern const folder_type_p POP_MBX ;
extern const folder_type_p IMAP_MBX ;

#define IMAP_writable     1
#define IMAP_flusherr     2
#define IMAP_folder_open  4
#define IMAP_can_CLOSE   16 

#define  POP_disable_skip    1



extern struct connection_type IMAP_connection;


extern void set_imap_connection_state P_((struct connection_cache  *Ch, 
					  imap_states st));


#endif
extern const folder_type_p NO_NAME;

#define PRIVATE_DATA_magic	0xFA03

enum FLAG1_bits {
    FLAG1_bit_CHECKNEW = 0,
    FLAG1_bit_have_ostat,

    FLAG1_bit_count
};

#define FLAG1_CHECKNEW		(1 << FLAG1_bit_CHECKNEW)
#define FLAG1_have_ostat	(1 << FLAG1_bit_have_ostat)
    
extern struct private_data {
    unsigned short magic;           /* PRIVATE_DATA_magic */

    FILE *fh_temp;		   /* current folder 	     */
    FILE *fh_folder;               /* current folder 	     */


    unsigned   flags1 :  FLAG1_bit_count;                 /* Set by sessionlock_folder() */

    /* Only used for local folder / mailbox */
    struct stat        ostat; 

    
    struct dt_flags_info  * lock_info;


    
    union {
	int dummy;
	struct SPOOL {
	    int  lock_state;
	    char *lockfile;
	} spool;
#ifdef REMOTE_MBX
	struct POP_MBX {
	    struct remote_account  C;
	    struct remote_server   * this_server;   
	    struct browser_passhm  * passhm;

	    struct Read_Buffer read_buffer;

	    pop_states pop_state;
	    long       pop_flags;

	    time_t             default_received_time;
	    
	    struct Write_Buffer write_buffer;

	    /* Last command */
	    char      command[4];
	    struct schedule_timelimit   NOOP_start;
	    
	    /* parsed response */
	    char      *command_status;
	    char      *command_data;
	    int       data_len;

	    /* size from STAT */
	    int       stat_size;
	    int       stat_count;

	    struct sortlist  * uidl_list;
	    
	    int seen_badpid;

	    unsigned                    stalled:1;
	    
	} pop_mbx;

	struct IMAP_MBX {
	    struct connection_cache  *Ch;
	    struct browser_passhm  * passhm;

	    char      * folder;       /* IMAP folder, for example INBOX */
	    struct string * folder_name_cache;

	    int       folder_status;
	    long      flag_bits;

	    int       num_recent;
	    int       uidvalidity;
	    
	    struct imap_reference  *references;   /* references[0] not used */
	    int                     reference_count; /* actual number of
							messages +1 */

	    int last_uid_number;    /* uid of last message parsed */

	    unsigned int            got_EXPUNGE  :1;   /* Have received EXPUNGE */
	    
	} imap_mbx;

#endif /* REMOTE_MBX */
    } a;

    struct mail_quota   * quota;
    
}  * malloc_mbx_private_data P_((struct dt_flags_info  * lock_info));
extern void free_mbx_private_data P_((struct private_data **p));

struct mbx_hdr_info {
    struct info_type * type_code;

    union {
	int dummy;
#ifdef REMOTE_MBX
	struct POP_MBX_if {
	    int msg_num;
	    char * uidl;   
	} pop_mbx;
	
	struct IMAP_MBX_IF {
	    struct imap_uid_ref ref;
	    int       uidvalidity;        /* For reconnect checking */;
	} imap_mbx;
#endif
    } a;
};

typedef void info_zero_routine P_((struct mbx_hdr_info *info));
typedef void info_free_routine P_((struct mbx_hdr_info *info));
typedef void info_status_routine P_((struct mbx_hdr_info *info,
				     char status_buffer[3]));

#define INFO_TYPE_magic   	0xFA05
typedef struct info_type {
    unsigned short magic;      /* INFO_TYPE_magic */

    info_zero_routine    * zero_it;
    info_free_routine    * free_it;
    info_status_routine  * it_status;
}  * info_type_t;

void change_rec_mbx_info P_((struct header_rec *entry,
			     info_type_t t));


typedef void browser_zero_dir P_((struct folder_browser *dir));
typedef void browser_free_dir P_((struct folder_browser *dir));


/* rel_dirname is relative to type -- not include user@hostname */
typedef int browser_change_dir P_((struct folder_browser *dir,
				   const struct string *rel_dirname,
				   struct string **dispname));
typedef int browser_select_dir P_((struct folder_browser *dir,
				   const struct string *rel_itemname,
				   struct string **dispname,
				   int *newpos));
#if ANSI_C
struct name_vector;
#endif
typedef int browser_change_v_dir P_((struct folder_browser *dir,
				     struct name_vector *X,
				     struct string **dispname));
typedef int browser_change_up_dir P_((struct folder_browser *dir,
				      struct string **dispname,
				      struct string **disp_tail));

typedef struct string * browser_give_title_dir P_((struct folder_browser *dir));

typedef char browser_separator_dir P_((struct folder_browser *dir));
typedef struct string * browser_name_dir P_((struct folder_browser *dir));
typedef struct string * browser_cat_dir P_((struct folder_browser *dir,
					    const struct string * item));

typedef struct folder_info * 
browser_folder_from_dir P_((struct folder_browser *dir,
			    int treat_as_spooled));
			
typedef int browser_create_selection_dir P_((struct folder_browser *dir));

typedef void zero_ws_fields_browser P_((WRITE_STATE ptr));
typedef void free_ws_fields_browser P_((WRITE_STATE ptr));
typedef int browser_prepare_write_dir P_((struct folder_browser *dir,
					  WRITE_STATE ptr));
typedef int browser_end_write_dir P_((struct folder_browser *dir,
				      WRITE_STATE ptr));

typedef int browser_sync_write_dir P_((struct folder_browser *dir,
				      WRITE_STATE ptr));

typedef long browser_tell_dir_ws P_((struct folder_browser *dir,
				     WRITE_STATE write_state_ptr));
typedef int browser_seek_dir_ws P_((struct folder_browser *dir,
				    WRITE_STATE write_state_ptr,
				    long pos));
typedef int browser_write_dir_ws P_((struct folder_browser *dir,
				     WRITE_STATE write_state_ptr,
				     int l, const char *buffer));

typedef int browser_start_we_dir P_((struct folder_browser *dir,
				     WRITE_STATE write_state_ptr,
				     int write_envelope,
				     struct header_rec *current_header,
				     int *env_flags));

typedef int browser_end_we_dir P_((struct folder_browser *dir,
				   WRITE_STATE write_state_ptr,
				   int write_envelope,
				   struct header_rec *current_header));

typedef int browser_selection_is_folder P_((struct folder_browser *dir,
					    struct folder_info *folder));

typedef int browser_make_ref_folder P_((struct folder_browser *dir,
					char **refname, int *iscopy,
					int is_text));

typedef void browser_update_dir P_((struct folder_browser *dir));

/* Call only if BROWSER_NEEDSTAT is set */
typedef void browser_do_stat P_((struct folder_browser *dir,
				 int idx));
				 
typedef void browser_folder_sort_dir P_((struct folder_browser *dir,
					print_sort_message * print));

typedef void browser_free_name_vector_dir P_((struct folder_browser * dir,
					      struct name_vector    * entry));

/* Increments refcount */
typedef  struct hashmark_item *
   browser_gethm_name_vector_dir P_((struct folder_browser * dir,
				     struct name_vector    * entry));

/* Returns 1 if hashmark saved
   Increments refcount, if hashmark saved */
typedef int browser_sethm_name_vector_dir P_((struct folder_browser * dir,
					      struct name_vector    * entry,
					      struct hashmark_item  * hm
					      ));

/* Returns 1 if changed, -1 error */
typedef int browser_reset_filter_dir P_((struct folder_browser *dir));

typedef int browser_select_idx_dir P_((struct folder_browser *dir,
				       struct name_vector *entry,
				       struct string **buffer));

typedef const struct string * browser_line_idx_dir P_((struct folder_browser * dir,
						       struct name_vector    * entry,
						       const struct string  ** comment));

typedef int browser_reload_dir P_((struct folder_browser *dir));

#define WS_magic        0xFE00

struct browser_write_state {
    unsigned short magic;
    union {
	struct LOCAL_ws {
	    int     save_fd;
	    FILE *  save_file;
	    struct dt_flags_info *folder_lock;
	} local;
#ifdef REMOTE_MBX
	struct IMAP_ws {
	    int    literal_len;
	    char * literal;
	} imap;
#endif
        struct remote_server_ws * remote;
    } a;
};

#define BROWSER_TYPE_magic	0xF523

struct browser_type {
    unsigned short         magic;      /* BROWSER_TYPE_magic */

    browser_zero_dir              * browser_zero_it;
    browser_free_dir              * browser_free_it;
    browser_change_dir            * browser_change_it;
    browser_give_title_dir        * browser_give_title_it;
    browser_separator_dir         * browser_separator_it;
    browser_name_dir              * browser_name_it;
    browser_cat_dir               * browser_cat_it;
    browser_select_dir            * browser_select_it;
    browser_folder_from_dir       * browser_folder_from_it;
    browser_change_v_dir          * browser_change_v_it;
    browser_change_up_dir         * browser_change_up_it;
    browser_create_selection_dir  * browser_create_selection_it;
    zero_ws_fields_browser        * zero_ws_fields_it;
    free_ws_fields_browser        * free_ws_fields_it;
    browser_prepare_write_dir     * browser_prepare_write_it;
    browser_end_write_dir         * browser_end_write_it;
    browser_tell_dir_ws           * browser_tell_it_ws;
    browser_seek_dir_ws           * browser_seek_it_ws;
    browser_write_dir_ws          * browser_write_it_ws;
    browser_start_we_dir          * browser_start_we_it;
    browser_end_we_dir            * browser_end_we_it;
    browser_selection_is_folder   * browser_selection_is_it;
    browser_make_ref_folder       * browser_make_ref_it;
    browser_update_dir            * browser_update_it;
    browser_do_stat               * browser_stat_routine;
    browser_sync_write_dir        * browser_sync_write_it;
    browser_folder_sort_dir       * browser_folder_sort_it;

    browser_free_name_vector_dir  * browser_free_name_vector_it;      
    browser_reset_filter_dir      * browser_reset_filter_it;
    browser_select_idx_dir        * browser_select_idx_it;
    browser_line_idx_dir          * browser_line_idx_it; 
    browser_reload_dir            * browser_reload_it;
    browser_gethm_name_vector_dir * browser_gethm_name_vector_it;
    browser_sethm_name_vector_dir * browser_sethm_name_vector_it;
};

#ifdef REMOTE_MBX
extern struct browser_type imap_browser;
#endif
#ifdef DIROPS
extern struct browser_type local_browser;

#if DIROPS == USE_DIRENT
#include <dirent.h>
#endif /* DIROPS == USE_DIRENT */
#if DIROPS == USE_SYSDIR
#include <sys/dir.h>
#endif /* DIROPS == USE_SYSDIR */

#endif /* DIROPS */
        
#define FOLDER_BROWSER_magic	0xFA04
struct folder_browser {
    unsigned short magic;                /* FOLDER_BROWSER_magic */
    struct browser_type    * type;

    /* NOTE: sys_dir does not include possible user@host
     *  but  dirname includes possible user@host !
     */
    char                   * sys_dir;     /* Unspecified character set! */
    struct string          * dirname;     /* Display name               */

    struct remote_server   * default_server;


    enum selection_type    sel_type;

    int     vector_len;       /* -1 indicates that browser_update_it
				 should be called ...
			      */
    struct name_vector {
	char           *  sys_name;
	struct string  *  disp_name;
	int               flags;
	time_t            mtime;      /* modify time  for local files */

	union {
	    void                       * dummy;
	    struct DUMMY_BROWSER_entry * dummy_browser;
#ifdef DIROPS
	    struct LOCAL_BROWSER_entry * local_browser;
#endif
	    struct hashmark_item       * hashmark_item;
	} a;

    }  * vector, *selection;

    struct string * filter;          /*  name filter */

    union {
	struct DUMMY_BROWSER  * dummy_browser;
#ifdef REMOTE_MBX
	struct IMAP_BROWSER   * imap_browser;
#endif /* REMOTE_MBX */
#ifdef DIROPS
	struct LOCAL_BROWSER  * local_browser;
#endif
	struct REMOTE_BROWSER * remote_browser;
	struct HASHMARK_BROWSER * hashmark_browser;
    } a;
};

extern void clear_dir_vector P_((struct folder_browser *dir));
extern struct name_vector * add_dir_vector P_((struct folder_browser *dir,
					       char *sys_name,
					       struct string * disp_name,
					       int flags));
extern void clear_dir_selection P_((struct folder_browser *dir));
extern struct name_vector * set_dir_selection P_((struct folder_browser *dir,
						  char *sys_name,
						  struct string * disp_name,
						  int flags));

enum folder_place { in_none = 0, in_folders = 1, in_home = 2,
		    in_extra_dir
};

extern struct folder_info *mbx_new_folder P_((void));
extern folder_type_p get_folder_type P_((const char *filename, 
					 enum folder_place *in_mail,
					 int treat_as_spooled));

extern int create_as_user P_((const char *name));
extern void zero_ws_fields_local P_((WRITE_STATE ptr));
extern void free_ws_fields_local P_((WRITE_STATE ptr));


extern int browser_select_generic P_((struct folder_browser *dir,
				      struct string * relative_path,
				      const struct string * rel_dirname,
				      struct string * relative,
				      struct string ** Lstr,
				      char          ** str,
				      int sep,
				      charset_t default_charset));

extern int browser_vector_len P_((struct folder_browser *dir));

extern int browser_change_up_helper P_((const struct string * X, int sep));
extern struct string * browser_disp_tail_helper P_((const struct string *S,
						    int X,
						    int sep));

#ifdef REMOTE_MBX

extern int make_remote_mbox P_((struct folder_info *fh, 
				struct remote_account *X,
				struct service_entry *se, 
				char * rest,
				int rewrite,
				struct browser_passhm *passhm,
				struct cancel_data *main_cancel /* Used if
								   dns lookup was
								   cancelable */
				));

typedef uint16 url_default_port_f P_((
	 const struct browser_url_method  *schema));

/* May not be 
      uin16 port
   because this is promoted to int
*/

typedef struct connection_cache * url_make_connection_f P_((
	 const struct browser_url_method  *schema,
	 const struct string              *user   /* May be NULL */,
	 const struct string              *password /* May be NULL */,
	 const char                       *host   /* May be NULL */,
	 int                      port   /* May be NULL */));

/* This is always absolute path -- from root as defined for URL */
typedef int url_select_item_from_URL_f P_((
	const struct browser_url_method  *schema,
	struct folder_browser *dir,
	int elems_count,
	const struct string **elems));


#define BROWSER_URL_method_magic 0xEC09

struct browser_url_method {
    unsigned short         magic;    /*  BROWSER_URL_method_magic */

    struct browser_type    *type;

    url_default_port_f          * url_default_port_it;
    url_make_connection_f       * url_make_it;
    url_select_item_from_URL_f  * url_select_item_from_it_URL;
};

#endif

/* result MALLOCED */
extern char * return_path_to_env_from_1 P_((const char *value));

/* lib/mbox/hashmark_helper.c */

#define BROWSER_PASSHM_magic	0xF522

extern struct browser_passhm {   /* pass hashmark */
    unsigned short         magic;

    int                    refcount;

    struct hashmark_item       * item;
    struct address             * from_address;

    enum hmcon { hmcon_none  = 0, hmcon_pop, hmcon_imap }
	contype;                 /* for message */

    enum hmcert { hmcert_needcheck = 0, hmcert_ok = 1, 
		  hmcert_none = 2, hmcert_fail = -1 } 
	need_cert_check;

}  * new_browser_passhm P_((struct hashmark_item       * item,
			    struct address             * from_address,
			    enum hmcert                  need_cert_check,
			    enum hmcon                   contype));

extern void free_browser_passhm P_((struct browser_passhm **passhm));
extern void inc_browser_passhm_refcount P_((struct browser_passhm *passhm));
extern int browser_passhm_check_type P_((const struct browser_passhm *passhm,
					 const enum hmcon contype));

#ifdef REMOTE_MBX
extern int browser_passhm_verify_ra_con P_((struct browser_passhm *passhm,
					    struct remote_account *C));


/* -1 == use fallback ;  
   caller does remote_account_init_tls()
 */
extern int browser_passhm_open_ra P_((struct browser_passhm * passhm,
				      struct remote_account * ra,
				      const PORTS default_portlist[],
				      int give_service_entry_flag,
				      PORTS force_port));


/* -1 == use fallback ;  
   caller does remote_account_init_tls()
 */
extern int browser_passhm_open_ra2 P_((struct browser_passhm * passhm,
				      struct remote_account * ra,
				      int give_service_entry_flag,
				      /* For enumerate_service_type */
				      struct enum_service_type *est));

/* -1 == use fallback
    0 == lookup failed
    1 == ok

    caller must free *se, *username, *hostname, *addr
*/
extern int browser_passhm_remote_lookup P_((struct browser_passhm      * passhm,
					    struct service_entry      ** se,
					    int                          lookup_flags,
					    char                      ** username,
					    char                      ** hostname,
					    struct address            ** addr,
					    int                        * useraddr_flags,
					    struct cancel_data        ** cancel_p
					    /* May be NULL, Used if dns 
					       lookup was cancelable 
					    */
					    ));

#endif

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
