/* $Id: mbximap_imp.h,v 2.9 2024/06/23 07:38:36 hurtta Exp $ */

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.9 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *                  (was hurtta+elm@posti.FMI.FI)  
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

/* IMAP connection -------------------------------------------------------- */

/* capability_bits */

enum CAPA_bits {
    CAPA_bit_IMAP4rev1 = 0,
    CAPA_bit_UNSELECT,
    CAPA_bit_QUOTA,	       

    NUM_CAPA_bits
};

#define CAPA_IMAP4rev1       (1 << CAPA_bit_IMAP4rev1)
#define CAPA_UNSELECT        (1 << CAPA_bit_UNSELECT)
#define CAPA_QUOTA	     (1 << CAPA_bit_QUOTA)

struct IMAP_CON {
	    
    unsigned int             capability_bits : NUM_CAPA_bits;
#ifdef USE_DLOPEN
    struct IMAP_capa_libs   *capability_libs;
    int                      capability_lib_count;
#endif

    struct Read_Buffer read_buffer;
    int                wanna_literal;
    uint32             wanted_literal_len;   /* Imap 'number' is unsigned 32 bit */
    
    struct Imap_Token_Buffer read_tokens;
    
    enum token_state { state_tag, state_response, 
		       state_text, state_text_code,
		       state_list } tokenizer_state;

    char  *      current_tag ;  /* TAG of command waiting response */
    
    imap_states  imap_state;
    char  *      command_result_code;
    
    struct Imap_Token_Buffer write_tokens;
    int                 token_index; /* -1 == tag, -2 == NOOP_tag */
    
    struct Write_Buffer write_buffer;
    
    enum  { no_literal,
	    waiting_literal_continue,
	    continue_literal } literal_mode;
    
    char  *      current_NOOP_tag ;   /* TAG for NOOP command .... */
    struct schedule_timelimit   NOOP_start;

    unsigned                    stalled:1;
};
       

#define IMAP_BROWSER_magic	0xF50E

struct IMAP_BROWSER {
    unsigned short            magic;     /* IMAP_BROWSER_magic */

    struct connection_cache * Ch;
    
    struct string           * dir_name_cache;
    
    /* Assumed that current separator is ASCII here ... */
    char cur_sep;
    
    struct imap_dir_entry {
	char                   * imap_name;
	struct string          * translated_name;
	char                   sep;
	int flags;
    }                     * dir_entries;
    int                     dir_entry_count;

    struct browser_passhm * passhm; /* pass hashmark */
    
}; 


/* con_imap.c ---------------------------------------------------- */

E_(f_imap_wait imap_wait)
extern void imap_wait P_((struct connection_cache *con));

E_(f_imap_idle_wait imapcon_idle_wait)
extern void imapcon_idle_wait P_((struct connection_cache *con));

E_(f_imap_command_ok imap_command_ok)
extern int imap_command_ok P_((struct connection_cache *con,
			       imap_states *cmd_result,
			       char        **extra_code));


extern int imap_command_ok_c P_((struct connection_cache *con,
				 imap_states *cmd_result,
				 char        **extra_code,
				 struct cancel_data  * cd
				 /* Allow cancelation (Ctrl-C)
				    check of remote mailbox
				 */));
				    
E_(f_start_imap_command start_imap_command)
extern int start_imap_command P_((struct connection_cache *con,
				  char * verb));

extern int start_imap_command_c P_((struct connection_cache *con,
				    char * verb,
				    struct cancel_data  * cd
				    /* Allow cancelation (Ctrl-C)
				       check of remote mailbox
				    */
				    ));

E_(f_imap_command_push_atom imap_command_push_atom)
extern void imap_command_push_atom P_((struct connection_cache *con,
				       const char *st));

E_(f_imap_command_push_literal imap_command_push_literal)
extern void imap_command_push_literal P_((struct connection_cache *con,
					 int len, const char *st));

E_(f_imap_command_push_string imap_command_push_string)
extern void imap_command_push_string P_((struct connection_cache *con,
					 const char *st));

E_(f_imap_command_push_astring imap_command_push_astring)
extern void imap_command_push_astring P_((struct connection_cache *con,
					 const char *st));

E_(f_imap_command_push_aliteral imap_command_push_aliteral)
extern void imap_command_push_aliteral P_((struct connection_cache *con,
					 const char *st));

E_(f_imap_command_push_range imap_command_push_range)
extern void imap_command_push_range P_((struct connection_cache *con,
					int A, int B));

E_(f_imap_command_push_number imap_command_push_number)
extern void imap_command_push_number P_((struct connection_cache *con,
					 int A));

E_(f_imap_command_push_list imap_command_push_list)
extern void imap_command_push_list P_((struct connection_cache *con,
				       const char **l));


E_(f_end_imap_command end_imap_command)
extern void end_imap_command P_((struct connection_cache *con));

E_(f_imap_clear_command imap_clear_command)
extern void imap_clear_command P_((struct connection_cache *con));

/* imap_clear_command_c can be interrupted, and therefore 
   fail 
*/
extern int imap_clear_command_c  P_((struct connection_cache *con,
				     struct cancel_data  * cd
				     /* Allow cancelation (Ctrl-C)
					check of remote mailbox
				     */));


#define  IMAP_Seen               1
#define  IMAP_Answered           2
#define  IMAP_Flagged            4
#define  IMAP_Deleted            8
#define  IMAP_Draft             16
#define  IMAP_Recent            32

extern struct imap_flag {
    char         *   flag;
    int              mask_elm;
    int              mask_elm1;
    long             mask_imap;
} IMAP_flags[];
extern int IMAP_flags_count;


extern void imap_free_reference P_((struct imap_reference *item));
extern struct string *conv_from_imap_name P_((const char *name));

/* imap_quota.c */

E_(mbx_have_folder_quota  mbx_have_imap_quota)
extern struct mail_quota * mbx_have_imap_quota P_((struct folder_info * folder));

E_(mbx_give_folder_quotar_list mbx_give_imap_quotar_list)
extern struct mail_quotaroot_list * mbx_give_imap_quotar_list P_((struct folder_info * folder,
								  struct mail_quota  * mq,
		  struct cancel_data  * cd /* Allow cancelation (Ctrl-C) on remote mailbox */,
								  enum quota_mode      refresh
								  ));


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
