/* $Id: melib.h,v 2.31 2023/12/13 16:55:32 hurtta Exp $ */

/************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.31 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                  (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 ***********************************************************************/




/* --------------------------------------------------------- */

/* melib/init.c */

extern charset_t                        system_tagfilter_entities_cs;
extern struct editor_propline         * system_tagfilter_entities_pl;
extern struct tagfilter_entities_conf * system_tagfilter_entities_conf;

extern charset_t                        user_tagfilter_entities_cs;
extern struct editor_propline         * user_tagfilter_entities_pl;
extern struct tagfilter_entities_conf * user_tagfilter_entities_conf;

extern ENUMERATE editor_tfent_propline;

enum page_tagfilter_v {
    page_text_enriched   /* page text/enriched */,
    page_text_html       /* page text/html     */,
    
    NUM_page_tagfilter_v
};
extern FLAGS page_tagfilter;

extern void init_melib P_((int read_flags /* READ_FLAG_IGNORE_MISSING */));


/* melib/type_check.c */

/* Return 1 to decode */
typedef int type_mismatch_prompt P_((mime_t *ptr, int displaying));

/* melib/pgp_decode.c */

extern char pgp_passphrase[PGP_NUM][STRING];
extern int pgp_expires;

extern enum pgp_version have_pgp        P_((enum pgp_version v));
extern enum pgp_version decode_pgp_version P_((char * c));
extern int pgp_void_passphrase          P_((void));
extern int pgp_goodPassphrase           P_((enum pgp_version v));
extern int pgp_decrypt_init		P_((FILE **fpin, FILE **fpout, 
					    int opt, enum pgp_version v,
					    struct run_state *rs));

/* melib/decodeopts.c */

struct decode_opts {
    unsigned int displaying   : 1;
    unsigned int show_error   : 1;
    
    struct pager_range        * range;
};

extern const struct decode_opts NULL_decode_opt;


/* melib/parse_util.c */

typedef int header_filter    P_((header_list_ptr hdr, int flag, int have_title));
extern int NULL_header_filter    P_((header_list_ptr, int flag, int have_title));

extern void state_write_headers P_((struct out_state        * s,
				    const struct decode_opts *decode_opt,
				    header_list_ptr    hdr,
				    header_filter    * filter,
				    int                flag,
				    int                demime,
				    charset_t          defcharset,
				    int have_title,
				    charset_t subject_charset_hack
				    ));

extern void state_write_raw_headers P_((struct out_state      * s,
					const struct decode_opts *decode_opt,
					header_list_ptr    hdr,
					header_filter    * filter,
					int                flag,
					int have_title));

extern void state_write_header P_((struct out_state * s,
				   const struct decode_opts *decode_opt,
				   header_list_ptr next,
				   int                demime,
				   charset_t          defcharset));

extern void state_write_raw_header P_((struct out_state   * s,
				       const struct decode_opts *decode_opt,
				       header_list_ptr next));
			

  
extern header_list_ptr file_read_headers  P_((FILE *, int));

extern long skip_envelope P_((struct header_rec *hdr, FILE *fp));

/* melib/mime.c */

extern void mime_panic          P_((char *,int,char *, char *));
extern int check_encoding       P_((char *));

/* Is mime type multipart/report; report-type=delivery-status; ? */
extern int mime_type_is_dsn P_((mime_t *p));


/* melib/mime_decode.c */

extern int rfc822_header_filter     P_((header_list_ptr hdr, int flag, int have_title));

extern void null_decode		P_((mime_t *ptr, struct in_state * s_in, struct out_state *s_out,
				    const struct decode_opts *decode_opt,
				    charset_t defcharset, struct header_rec *mss));

extern int is_rfc1522 P_((const char *));

/* return < 0 : is structural */
extern int decoder_is_textual P_((mime_t *ptr));


/* Print total 10 error messages */
extern int print_in_errors P_((struct in_state *state_in,
			       struct out_state *state_out /* may be NULL */,
			       const struct decode_opts *decode_opt));


/* melib/mime_parse.c */

extern void mime_t_clear                P_((mime_t *mt));
extern void mime_t_copy                 P_((mime_t *, mime_t *));
extern void mime_t_zero                 P_((mime_t *));
extern int mime_get_content1 P_((const char *str,
                                 media_type_t *TYPE, struct mime_param **TYPE_opts,
                                 charset_t def_charset,
				 struct header_errors **header_error,
				 int header_status));

extern int mime_get_charset             P_((charset_t *ret, 
					    struct mime_param *buffer,
					    const charset_t * display_charset,
					    charset_t default_content_charset
					    ));
extern int mime_warnings		P_((struct header_rec *));
extern int mime_parse_routine1 		P_((struct header_rec *hdr,FILE *fp));
extern int mime_parse_routine		P_((struct folder_info *folder,
					    struct header_rec *hdr,
					    FILE *fp));

extern int is_pre_mime_content_type P_((mime_t *ptr, char *content_type));
extern const char * mime_get_boundary P_((struct mime_param *P));

/* melib/mparser.c */

extern int  mime_parser_subparts P_((struct mime_parser_data *P));
extern struct mimeinfo * mime_parser_index P_((struct mime_parser_data *P,
					       int idx));

/* 0 == no parser, 1 == parser found */
extern int mime_parser_parse P_((struct mimeinfo *s,
				 charset_t defcharset,
				 FILE *fp,
				 struct header_errors **header_error,
				 int header_status,
				 struct header_rec * hdr
				 ));

extern void copy_parser_data P_((struct mime_parser_data **target,
				 struct mime_parser_data *source));				 

extern void mime_parser_free P_((struct mime_parser_data **P));


/* melib/mailcap.c ----------------------------------------------------------- */

extern void read_mailcaps P_((void)); 

#if ANSI_C
struct mailcap_entry;
#endif


/* Return value must be free()ed */
extern char * mailcap_view_command P_((struct mailcap_entry *f, mime_t *p));

/* Return value must be free()ed */
extern char * metamail_mailcap_view_command P_((
    struct  metamail_mailcap_entry  *f,
    mime_t *p));

/* melib/mime_selector.c ---------------------------------------------------- */


enum mime_classify_mode {
    mime_classify_all = 1,
    mime_classify_skip_mailcap    /* DO not register mailcap yet */
};
    
extern int mime_classify_media P_((mime_t *p,struct header_rec * hdr,
				   enum mime_classify_mode mode));

extern char * mime_debug_classify_f P_((int c));

/* Returns -1 on failure otherwise same mask than mime_classify_media() */
typedef int mime_run_selector P_((mime_t *p,struct header_rec * hdr));
typedef mime_run_selector *mime_run_selector_t;

typedef void encrypted_decoder P_((mime_t *init, mime_t *data,
				   struct in_state   *state_in,
				   struct out_state  *state_out,
				   const struct decode_opts *decode_opt,
				   charset_t    defcharset,
				   struct header_rec *mss,
				   type_mismatch_prompt *badtype,
				   charset_t  bodydefcharset
				   ));

typedef encrypted_decoder * EC_decoder_t;


typedef void signed_decoder P_((mime_t *body, mime_t *sign,
				struct in_state   *state_in,
				struct out_state  *state_out,
				const struct decode_opts *decode_opt,
				const char *micalg, 
				charset_t defcharset,
				struct header_rec *mss,
				type_mismatch_prompt *badtype,
				charset_t  bodydefcharset
				));
typedef signed_decoder * SG_decoder_t;

typedef void text_decoder_f P_((mime_t *body,
				struct in_state   *state_in,
				struct out_state  *state_out,
				const struct decode_opts *decode_opt,
				charset_t text_charset));
typedef text_decoder_f * TXT_decoder_t;


#define MIME_selector_magic     0xFD04

struct mime_selected_handler {
    unsigned short              magic;             /* MIME_selector_magic */

    struct  mt_handle_pager     *handler;          /* Found internal handler */
    
    struct mailcap_entry        *entry;            /* Found external handler */

    struct mailcap_entry      ** other_entries;      /* Found entries if 
						      "mailcap-select-other"
						      is set (default)
						   */
    size_t                       num_other_entries;
    
    EC_decoder_t        EC_decoder;
    SG_decoder_t        SG_decoder;
    TXT_decoder_t       TXT_decoder;   

    mime_t            * selected_alternative;  /* subpart of multipart/alternative */
    mime_t            * start_part;            /* subpart of multipart/related     */

    unsigned                     use_entry:1;

};

typedef void CT_decoder	        P_((mime_t      *part, 
				    struct in_state  *instream, 
				    struct out_state *outstream,
				    const struct decode_opts *decode_opt,
				    charset_t defcharset, 
				    struct header_rec *hdr,
				    type_mismatch_prompt *badtype,
				    charset_t bodydefcharset
				    ));
typedef CT_decoder *CT_decoder_t;

struct  mt_handle_pager {
    CT_decoder_t        func;
    mime_run_selector_t selector;
};

extern void mime_decode		P_((mime_t *ptr, struct in_state *state_in, 
				    struct out_state *state_out,
				    const struct decode_opts *decode_opt,
				    charset_t defcharset, 
				    struct header_rec *mss,
				    type_mismatch_prompt *badtype,
				    charset_t bodydefcharset
));

/* ----------- */

#define WALKHANDLER_magic       0xFD05

struct walk_handler {
    unsigned short            magic;      /* WALKHANDLER_magic */

    struct handler_type * handler_type;

    union walk_hadler_data {
	struct search_mes  * search_mes;
	
	void               * dummy;
    } u;

};

typedef void mw_init_handler   P_((struct walk_handler *hdl));
typedef void mw_free_handler   P_((struct walk_handler *hdl));
typedef void mw_action_handler P_((struct walk_handler *hdl,mime_t *ptr,
				   struct in_state *state_in, /* May be NULL */
				   FILE *F,
				   struct out_state *state_out  /* May be NULL */ 
				   ));


#define WALKTYPE_magic          0xFD06

struct handler_type {
    unsigned short            magic;      /* WALKTYPE_magic */

    mw_init_handler    *mw_init;
    mw_free_handler    *mw_free;
    mw_action_handler  *mw_action;
};


enum mime_walk_buffer { mime_walk_no_buffer = 0,
			mime_walk_buffer_decoded,
			mime_walk_need_fp /* also buffered */ };
			
extern struct walk_handler * malloc_walk_handler P_((struct handler_type *t));
extern void free_walk_handler P_((struct walk_handler **ptr));
extern void simple_mime_walk P_((mime_t *ptr, struct walk_handler *handler,
				 struct in_state *state_in, /* May be NULL */
				 struct out_state *state_out,   /* May be NULL */
				 const struct decode_opts *decode_opt,
				 enum mime_walk_buffer buffer_decoded
				 ));

/* melib/partial.c */

struct partial_vector {
    mime_t   * reference;
    char     * id;                   /* Unique identifier field */
    int        number;               /* 1 .. total */
    int        total;                /* -1 if not given */
};

extern void free_partial_vector P_((struct header_rec *mss));
extern struct partial_vector *reg_partial P_((struct header_rec *mss,
					      mime_t   * reference));

/* --- --- */

#define DISPOSITION(x) (x >= 0 && x < DISP_count && mime_disposition_names[x] ?\
	mime_disposition_names[x] : "<ILLEGAL>")
extern char * mime_disposition_names[DISP_count]; /* defined in mime.c */

#define ENCODING(x) (x >= 0 && x < ENCODING_count && mime_encode_names[x] ?\
   mime_encode_names[x] : "<ILLEGAL>")
extern char *mime_encode_names[ENCODING_count]; /* defined in mime.c */

/* special cookies that may appear in the user's message text */
#define START_ENCODE	"[encode]"
#define END_ENCODE	"[clear]"

/* mime_param.c */

#if ANSI_C
struct mime_param;
#endif

extern const char * get_mime_param_compat P_((struct mime_param *P, 
					      char *name));

extern const char * get_mime_param_ascii P_((struct mime_param *P, char *name));
extern const struct string * get_mime_param P_((struct mime_param *P, 
						char *name, 
						int skip_compat));
extern const struct string * get_mime_param_rfc1522_hack P_((struct mime_param *P, 
							     char *name));

extern void free_mime_param P_((struct mime_param **x));

extern struct mime_param * parse_mime_param P_((const char *headername,
						const char *value,
						charset_t def,
						struct header_errors **header_error,
						int header_status));

extern struct mime_param * parse_mime_param_string P_((struct string *value,
						       int gen_compat_len,
						       int plain_mode));

extern struct mime_param * copy_mime_param P_((struct mime_param *src));
extern struct string * show_mime_params P_((struct mime_param *P));
extern char * encode_mime_params P_((const struct mime_param *P));
extern char ** encode_mime_params_v P_((struct mime_param *P));

extern char ** split_mime_params P_((struct mime_param **P, 
				     struct string *in_buffer,
				     int gen_compat_len,
				     int plain_mode));


extern void mime_params_add_compat P_((struct mime_param **P, 
				       const char *name,
				       const char *value));
extern void mime_params_add P_((struct mime_param **P, 
				const char *name,
				struct string *value));


extern void append_quoted_to_string P_((struct string ** ret,
					const struct string * value));

extern struct mime_param *mime_param_encode P_((struct mime_param *P));

/* melib/encode.c */

/* 0 == failure
   1 == OK 
   -1 == Ctrl-C */
extern int getkey P_((int send));

extern void get_key_no_prompt P_((void));
extern void encode P_((char *line));
extern void makekey P_((char *rkey));


/* melib/parse_helper.c */

extern void mime_parse_helper P_((struct header_rec *entry,
				  header_list_ptr parsed_headers ));

extern void start_body_helper P_((struct header_rec *current_header,
				  long content_start,
				  header_list_ptr parsed_headers));

/* melib/state_decode.c */

extern struct in_state_type  STATE_in_decode_type;
#define STATE_in_decode      &STATE_in_decode_type

#define STATE_DECODE_is_text       0x01   /* treate input as text 
					    (ie includes newlines) */
#define STATE_DECODE_EOLN_is_CRLF  0x02   /* Output newline as CRLF */
#define STATE_DECODE_buffer        0x04
#define STATE_DECODE_keep_file     0x08   /* Do not unlink buffer file */

/* Returns 1 if decoding is possible */
extern int set_in_state_decode   P_((struct in_state *src,
				     struct in_state *state,
				     int length,
				     int state_decode_flags,
				     enum encoding encoding,
				     const char **name
				     ));   /* STATE_in_decode */


extern /* Returns 1 if decoding is possible */
int set_in_state_decode_helper P_((mime_t *ptr,struct in_state *src,
				   struct in_state *state, int flags,
				   const char **name       /* Only if STATE_DECODE_buffer */));


/* Opens new handle FILE *, original handle is dup()ed, caller must fclose() */
extern FILE * file_handle_from_state_decode P_((struct in_state *state));

/* Increments refcount, possibly also creates struct delay_unlink */ 

extern struct delay_unlink * delay_unlink_from_state_decode P_((struct in_state *state,
							        int timer_secs));

extern int is_valid_encoding P_((enum encoding encoding));

/* melib/tagfilter_entity.c */

extern int dump_tagfilter_entities
      P_((FILE *f, struct tagfilter_entities_conf *conf,
	  FILE *commentfile,
	  const char *actor,
	  char *version_buff,
	  charset_t fileset,
	  const struct editor_propline *propline,
	  enum record_mode rc  /* SYSTEM_RC = 0, LOCAL_RC = 1 */,
	  int * errno_res));

extern struct tagfilter_entities_conf * parse_tagfilter_entities
      P_((const char *filename, 
	  int *errors, 
	  charset_t *fileset,
	  struct editor_propline **propline,
	  enum record_mode rc  /* SYSTEM_RC = 0, 
				  LOCAL_RC = 1 */,
	  int *need_rewrite
	  ));

extern int merge_tagfilter_entities P_((const char                     * filename,
					FILE                           * f,
					struct tagfilter_entities_conf * conf,
					int *errors, 
					charset_t *fileset,
					struct editor_propline **propline,
					enum record_mode rc  /* SYSTEM_RC = 0, 
								LOCAL_RC = 1 */,
					int *need_rewrite));

extern int change_tagfilter_entities P_((struct tagfilter_entities_conf **conf,
					 struct tagfilter_entities_conf * new,
					 enum record_mode rc  /* SYSTEM_RC = 0, 
								 LOCAL_RC = 1 */,
					 const char                     * filename,
					 int                            * errors
					 ));

extern struct tagfilter_entities_conf * new_tagfilter_entities_conf P_((enum record_mode rc,
									const char *filename));

extern void free_tagfilter_entities_conf P_((struct tagfilter_entities_conf **ptr));

extern void link_tagfilter_entities P_(( struct tagfilter_entities_conf *conf,
					 int * errors));
extern void unlink_tagfilter_entities P_((void));

/* melib/tagfilter_tag.c */

extern void tagfilter_free_sorted_tags P_((void));

/* melib/tagfilter.c */

#if DEBUG
extern void debug_print_string P_((struct debug_struct *a,
				   const char * prefix,
				   const char * prefix2,
				   struct string *S));

#define DEBUG_PRINT_STRING(x,level,prefix,prefix2,S) do {		\
	if (x.active == -1) debug_level_check(&x);			\
	if (x.active > 0 && !x.header_printed) debug_file_header(&x);	\
	if (x.active >= (level)) debug_print_string(&x,prefix,prefix2,S); \
    } while(0)

#else
#define DEBUG_PRINT_STRING(x,level,prefix,prefix2,S) do { if (x.active >= (level)) { } } while(0)

#endif

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
