/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.2 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *                       (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *           or  Kari Hurtta <elm@elmme-mailer.org>
 ******************************************************************************
 *  The Elm Mail System 
 *
 * 			Copyright (c) 1988-1992 USENET Community Trust
 * 			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

#define	MIME_HEADER	"MIME-Version: 1.0"

struct mime_send_part {
    /* Information for text parts */
    int               encoding_part ;
    char *            encoding_part_text;  /* [include ..] produces */

    /* Is media_type_t, but it is defined on misclib.h */
    struct media_type *  TYPE;   
    struct mime_param *  TYPE_opts_part;

    int               disposition;
    struct mime_param * DISPOSITION_opts;
    
    struct string   * description;

    int               is_text;
    int               save_it_on_copy;
    charset_t         result_charset; /* Charset of text after conversion */

    long             start_loc, end_loc;
};

enum mailer_capab {  mailer_7bit=0, mailer_8bit=1, mailer_binary=2 };

typedef struct mime_send {    /* Mime parameters for this mail */
    enum mailer_capab  raw_level;

    /* Information for multipart  */
    enum encoding encoding_top; 
    /* Encoding for top multipart type.
     * ENCODING_8BIT:   add content_transfer_encoding: 8bit
     *                  pass -B8BITMIME to mailer
     * ENCODING_BINARY: add content_transfer_encoding: binary
     *                  pass -BBINARYMIME to mailer
     */

    char mime_boundary[STRING];
    struct mime_param * TYPE_opts_top;

    charset_t    hdr_charset;   /* to what charset headers should be flagged */
    int          encode_hdr;

    int                      top_parts_count;
    struct mime_send_part  * top_parts;

    int msg_is_multipart;

    /* not actually _MIME_ information ... */
    long cl_offset;
    long cl_start;
    long cl_end;

} mime_send_t;

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
