/* $Id: misclib.h,v 2.28 2023/12/13 16:55:32 hurtta Exp $ */

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.28 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

/* lib/misc/init.c */

extern struct terminal_map_item * system_terminal_map;
extern struct terminal_map_item * user_terminal_map;
extern struct mime_types_item   * system_mimetypes_map;
extern struct mime_types_item   * user_mimetypes_map;

extern struct mlist_conf        * system_mlist_conf;
extern charset_t                  system_mlist_cs;
extern struct editor_propline   * system_mlist_pl;

extern struct mlist_conf        * user_mlist_conf;
extern charset_t                  user_mlist_cs;
extern struct editor_propline   * user_mlist_pl;

extern ENUMERATE editor_ml_propline;   /* 0 = auto
					  1 = emacs
					  2 = ignore
				       */

extern void init_misclib P_((int read_flags /* READ_FLAG_IGNORE_MISSING */));

/* lib/misc/terminal.c */

/* May be called from signal handler -- on that situation use
   buffer specified as argument -- otherwise result is malloced
*/
extern char * terminal_set_title P_((char *terminal,
				     char *window_title,
				     char *icon_title,
				     char * buffer,
				     int size));
extern struct terminal_map_item  * load_terminal_map P_((const char *filename, 
							 int *errors));
extern void terminal_can_switch P_((const char *terminal,
				    charset_t *storage,
				    int *n,
				    int max,
				    int maybe_signal));			   


extern int terminal_can_switch_to P_((const char *terminal, charset_t set, 
				      int silent, int maybe_signal));

extern void dump_terminal_map P_((FILE *f, struct terminal_map_item *map,
				  FILE *commentfile, const char *actor,
				  char *version_buff));

extern void terminal_change_system_charset P_((char *terminal,
					       int have_DW_characters));

extern char * terminal_set_info P_((char *terminal,
				    charset_t set,
				    screen_info_p terminal_info,
				    int have_DW_characters));

/* May be called from signal handler -- on that situation use
   buffer specified as argument -- otherwise result is malloced
   
   -- terminal_info must be alloced with create_terminal_info()
      beforehand
*/
extern char * terminal_switch_to P_((char *terminal, charset_t set,
				     screen_info_p terminal_info,
				     char * buffer, int size,
				     int silent,  int maybe_signal));

extern void change_terminal_map P_((struct terminal_map_item **map,
				    struct terminal_map_item *new));

extern void free_terminal_map P_((struct terminal_map_item **map));

enum pg_attr_bit {
    pg_bit_BOLD = 0,
    pg_bit_UNDERLINE,
    pg_bit_STANDOUT,
    pg_bit_BLINKING,
    pg_bit_REVERSE,
    pg_bit_ITALIC,
    pg_bit_DIM,

    /* These are unlikely to work */
    pg_bit_SUBSCRIPT,
    pg_bit_SUPERSCRIPT,

    /* Not supported by termcap */
    pg_bit_STRIKETHROUGH,

    NUM_pg_attr_bits
};

#define pg_BOLD       (1 << pg_bit_BOLD)
#define pg_UNDERLINE  (1 << pg_bit_UNDERLINE)
#define pg_STANDOUT   (1 << pg_bit_STANDOUT)
#define pg_BLINKING   (1 << pg_bit_BLINKING)
#define pg_REVERSE    (1 << pg_bit_REVERSE)
#define pg_ITALIC     (1 << pg_bit_ITALIC)
#define pg_DIM        (1 << pg_bit_DIM)
#define pg_SUBSCRIPT	 (1 << pg_bit_SUBSCRIPT)
#define pg_SUPERSCRIPT	 (1 << pg_bit_SUPERSCRIPT)
#define pg_STRIKETHROUGH (1 << pg_bit_STRIKETHROUGH)

/* pg_STANDOUT is probably  pg_BOLD and pg_REVERSE 
   or
   pg_STANDOUT is same than pg_REVERSE   
*/

extern struct ansi_sgr_attribute {
    const char * name;
    int pg_flag;
    short start_value;
    short end_value;
    int disable_pg_flags;
} ANSI_sgr_values[];
extern size_t NUM_ANSI_sgr_values;

#if DEBUG
/* Returns pointer to static storage */
extern char * give_pg_flags P_((int p));
#endif

/* Returns incompatible flags */

extern int pg_set_or_disable_flags P_((int * res_pg_flag /* maybe NULL */,
				       int pg_flag));


/* Returns available pg_flags */

extern int ansi_sgr_attributes P_((char *terminal,
				   const struct ansi_sgr_attribute **vector,
				   size_t                      vector_len,
				   size_t * result_len));

/* lib/misc/mediatype.c */

enum mime_major_type {      
    MIME_TYPE_LEAF       = -1 /* Only avaliable for register_mt_defhandler */,

    MIME_TYPE_UNKNOWN	     = 0,   
    MIME_TYPE_APPLICATION    = 1,
    MIME_TYPE_AUDIO	     = 2,
    MIME_TYPE_IMAGE	     = 3,
    MIME_TYPE_MESSAGE	     = 4,
    MIME_TYPE_MULTIPART	     = 5,
    MIME_TYPE_TEXT	     = 6,
    MIME_TYPE_VIDEO          = 7,
    MIME_TYPE_FONT           = 8,
    MIME_TYPE_MODEL          = 9,
    MIME_TYPE_EXAMPLE        = 10,
};

typedef struct media_type *  media_type_t;

/* WARNING: May return codes > MIME_TYPE_EXAMPLE if unknown or bad type */
extern enum mime_major_type get_major_type_code P_((media_type_t T));
extern const char *         get_major_type_name P_((media_type_t T));
extern const char *         get_major_type_name2 P_((enum mime_major_type m));

extern char * TYPE_UNKNOWN_STRING;

enum mime_bits {
    MIME_bit_RFC822 = 0,
    MIME_bit_MIXED,
    MIME_bit_DIGEST,
    MIME_bit_ALTERNATIVE,
    MIME_bit_SIGNED,
    MIME_bit_ENCRYPTED,
    MIME_bit_PARTIAL,
    MIME_bit_REPORT
};

#define MIME_RFC822      (1 << MIME_bit_RFC822)
#define MIME_MIXED       (1 << MIME_bit_MIXED)
#define MIME_DIGEST      (1 << MIME_bit_DIGEST)
#define MIME_ALTERNATIVE (1 << MIME_bit_ALTERNATIVE)
#define MIME_SIGNED      (1 << MIME_bit_SIGNED)
#define MIME_ENCRYPTED   (1 << MIME_bit_ENCRYPTED)
#define MIME_PARTIAL     (1 << MIME_bit_PARTIAL)       /* Message fragment */
#define MIME_REPORT      (1 << MIME_bit_REPORT)       /* Maybe DSN */

extern int                  get_type_flags       P_((media_type_t T));
extern const char *         get_subtype_name     P_((media_type_t T));

extern enum mime_major_type give_major_type P_(( const char * major,
						 int create));

extern media_type_t give_media_type P_(( const char * major,
					 const char * minor,
					 int create));

extern media_type_t give_media_type2 P_((enum mime_major_type major_type_code,
					 const char * minor,
					 int create));

extern int give_text_type_code P_((media_type_t T));

enum  mt_handle_type { handle_pager,
		       handle_mime_parser,
		       handle_mailcap_entry,
		       handle_remail,
		       handle_metamail_mailcap_entry, /* for blacklisting */
		       handle_ANY = -1
};

struct media_type_handle {
    enum  mt_handle_type type;
    union mt_handles {
	void                       *any;
	struct  mt_handle_pager    *pager;
	struct mailcap_entry       *mailcap;
	struct mime_parser         *parser_code;
	struct mt_handle_remail    *remail;

	struct metamail_mailcap_entry * metamail_mailcap; /* for blacklisting */
	
    } p;
};

struct COMPAT_media_type_handle {
    enum  mt_handle_type type;
    void                       *any;
};


extern void register_mt_handler P_((media_type_t T,
				    struct media_type_handle *H));
extern void register_mt_defhandler P_((int major_type_code,
				       struct media_type_handle *H));

extern int walk_mt_handler P_((media_type_t T,
			       struct media_type_handle **H,
			       int *is_default,
			       enum  mt_handle_type kind
			       ));


/* lib/misc/mime_types.c */

extern struct mime_types_item  * builtin_mimetypes_map;

extern struct mime_types_item  * load_mime_types_map P_((const char *filename, 
							 int *errors));
extern void ignore_mime_types_map P_((struct mime_types_item *map,
				      struct mime_types_item *ignore));

extern struct mime_types_item * loc_mime_type P_((struct mime_types_item *list,
						  const char *extension));
extern media_type_t mime_type_to_media_type P_((const struct mime_types_item 
						*item));
extern const char * mime_type_to_params P_((const struct mime_types_item *item,
					    charset_t *cs));
extern const char * mime_type_to_extension P_((struct mime_types_item *item));

extern void dump_mime_types_map P_((FILE *f,
				    struct mime_types_item  *map,
				    FILE *commentfile, const char *actor,
				    char *version_buff));

extern struct scan_list * get_scan_list P_((struct mime_types_item *list,
					    const char *extension));

extern void free_scan_list P_((struct scan_list **list));

extern void append_scanlist P_((struct scan_list *list,
				const struct scan_list *other));

extern int scanlist_need_more P_((struct scan_list *list, int ch));
extern struct mime_types_item * loc_mime_type_from_scan P_((struct scan_list 
							    *list));
extern struct mime_types_item * loc_mime_type_from_scan_extension
P_((struct scan_list *list, char *extension));

extern void change_mime_types_map P_((struct mime_types_item **map,
				      struct mime_types_item *new));
extern void free_mime_types_map P_((struct mime_types_item **map));

extern struct scan_list * get_scan_list_by_type P_((struct mime_types_item 
						    *list,
						    media_type_t mime_type));

/* Returns 1 is list is not empty */
extern int have_scanlist P_((struct scan_list *list));

#ifdef ANSI_C
struct mimeinfo;
#endif

typedef int filter_scanlist_OK_f P_((const struct mimeinfo * att, 
				     const struct mime_types_item *type_item));

void filter_scanlist P_((struct scan_list *list, const struct mimeinfo * att,
			 filter_scanlist_OK_f filter));

/* lib/misc/charset.c */

/* Return 0 if empty */
extern int dump_by_MIBenum P_((FILE *f,FILE *commentfile, const char *actor,
			       char *version_buff,int have_data));
extern int dump_charset_map P_((FILE *f, struct charset_map_item *map,
				FILE *commentfile, const char *actor,
				char *version_buff,int have_data));

extern void change_charset_map P_((struct charset_map_item **map,
				   struct charset_map_item *new));
extern void free_charset_map P_((struct charset_map_item **map));

/* lib/misc/mlist.c */

#include "mlist_common.h"

/* Mailing list configuration */
extern struct mlist_conf * load_mlist_conf P_((const char *filename, 
					       int *errors,
					       charset_t *fileset,
					       struct editor_propline 
					       **propline));

extern void free_mlist_conf P_((struct mlist_conf ** conf));
extern void change_mlist_conf P_((struct mlist_conf ** conf,
				  struct mlist_conf * new)); 

extern void dump_mlist_conf P_((FILE *f, struct mlist_conf *conf,
				FILE *commentfile, const char *actor,
				char *version_buff,
				charset_t fileset,
				const struct editor_propline *propline));

extern const struct string * get_mlist_token P_((struct mlist_conf *list,
						 enum mlist_tokens idx));


struct mlist_info;
extern const struct string * get_mlist_display_name P_((const struct mlist_info *info));

/* lib/misc/conf_writer.c */

/* Return 1 if suffix is OK */
extern int check_file_backup_suffix P_((const char * name,
					const char * option /* for error message */,
					const char * backup_suffix));

/* Return 1 if suffix is OK */
extern int check_conf_backup_suffix P_((const char * option /* for error message */,
				 const char * backup_suffix));


enum write_conf_rewrite {
    write_conf_full_rewrite = 0,
    write_conf_auto_rewrite
};

extern void write_conf P_((const char            * actor,
			   char                  * version_buff,
			   enum write_conf_rewrite rewrite /* Automatic rewrite to
							      some files */,
			   const char            * backup_suffix
			   
			   ));
				  
extern struct string * conf_taglist P_((struct string *sep));

/* lib/misc/mimesend.c */

#define HAVE_8BIT    1
#define HAVE_CTRL    4
#define HAVE_BINARY  8
#define HAVE_UTF8   16

/* Does not rewind state, leaves it on middle! */
extern int in_state_needs_encoding P_((struct in_state *st,
				       struct scan_list *list,
				       int utf8    /* Check for UTF-8 */));

/* Rewinds file */
extern int needs_encoding       P_((FILE *f,struct scan_list *list, int utf8));


/* lib/misc/commentfile.c */

extern void insert_commentfile P_((FILE *f, const char *defaultfile,
				   FILE *commentfile, const char *actor,
				   char *version_buff));

/* lib/misc/service_list.c */

extern int dump_service_entries P_((FILE *f,
				    struct mail_services_conf *mail_services,
				    FILE *commentfile, const char *actor,
				    char *version_buff, charset_t fileset,
				    const struct editor_propline *propline));

extern void change_mail_services_conf P_((struct mail_services_conf **conf,
					  struct mail_services_conf *new));


/* lib/misc/iso2022.c ------------------------------------------------------------ */

extern void change_iso2022_map P_((struct iso2022_map_conf **conf,
				   struct iso2022_map_conf *new,
				   enum map_list_mode mode));

extern void dump_iso2022_map P_((FILE  *F, struct iso2022_map_conf *conf,
				 FILE *commentfile, const char *actor,
				 char *version_buff));

/* lib/misc/filelock.c ----------------------------------------------------------- */


extern enum FLOCKING_status filelock_fd P_((int fd,
					    enum FLOCKING_mode     op,
					    struct dt_flags_info * flags,
					    const char           * filename /* may be NULL */,
					    enum FLOCKING_blocking blockit,
					    int                  * errno_res
					    ));

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */

