/* $Id: pager.h,v 2.11 2024/10/13 10:57:10 hurtta Exp $ */

/*************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.11 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *       or Kari Hurtta <elm@elmme-mailer.org>
 ************************************************************************/

/* Returns 1 if processed OK, 0 on failure 
 *
 * (0,0) = (*cur_line,*cur_col) is the top left!
 */
extern enum span_result {
        span_failure = 0,
	span_ok      = 1,
	span_FF_seen,
	span_EOS     /* End of string */,
	span_NL_seen,
	span_wrapping,
	    span_wordwrapped,
	    span_clear_alt_data,
	    span_space_collapsed /* flags: PR_COLLAPSE_NOINHERIT */,
} span_line P_((struct menu_context *ctx,
		int cur_line, int *cur_col,
		const struct string * buffer,
		int *pos, int *mayclear,
		int this_flags,
		int max_width,
		int max_len,
		int wrap_indicator,
		int * on_space_p
		));

/* Word wrapping */
extern enum span_result span_words P_((struct menu_context *ctx,
				       int cur_line, int *cur_col,
				       const struct string * buffer,
				       int *pos, int *mayclear,
				       int this_flags,
				       int max_width,
				       int max_len,
				       int joined_line,
				       int p_start_COL,
				       int p_width,
				       int wrap_indicator,
				       int * on_space_p));


extern struct pg_wrap_info * new_pg_wrap_info P_((void));
extern void free_pg_wrap_info P_((struct pg_wrap_info **info));

/* Increments *virtual_line */
extern void record_pg_wrap_info P_((struct pg_wrap_info *info,
				    int *virtual_line,
				    int buffer_idx, int buffer_x,
				    struct pager_lineext *buffer_lineext));

/* Returns 1 if info found and *buffer_idx, *buffer_x, * buffer_lineext updated */
extern int goto_pg_wrap_info P_((struct pg_wrap_info *info,
				 int virtual_line,
				 int *buffer_idx, int *buffer_x,
				 struct pager_lineext ** buffer_lineext));

/* Returns virtual line or -1 if not found
 *
 *   *real_buffer_idx gives really found ( *real_buffer_idx <= buffer_idx)
 */

extern int find_pg_wrap_info P_((struct pg_wrap_info * info,
				 int                   buffer_idx,
				 int                 * real_buffer_idx,
				 int                 * buffer_x,
				 struct pager_lineext ** buffer_lineext));

/* ----------------------------------------------------------------------- */

#define SPAN_HELPER_DATA_magic  0xEB21

extern const struct span_helper_data {
    unsigned short magic;      /* SPAN_HELPER_DATA_magic */

    int                 range_flags;

    
    int                 virtual_line;
    int                 idx;
    struct pager_lineext * lineext;
    int                 buffer_x;
    int                 cur_line;
    int                 cur_col;
    
    int                 p_start_COL;
    int                 p_width;

    int                 this_flags;

    unsigned int        force_word_wrap : 1;
    unsigned int        start_of_line   : 1;
    unsigned int        joined_line     : 1;
    unsigned int        mayclear        : 1;
    unsigned int        start_of_range  : 1;
    unsigned int        wrap_indicator  : 1;
    unsigned int        on_space        : 1;
                         
} NULL_span_helper_data;

extern void clear_span_helper_data P_((struct span_helper_data *data));

enum span_result span_alt_data_helper P_((struct menu_context * ctx,
					  struct pager_range  * pager_range,
					  struct pg_wrap_info * info,
					  struct string_alt   * alt_buffer,
					  struct string      ** res_buffer,
					  int                 * res_pg_flags,
					  struct span_helper_data * data));

extern enum span_result span_helper P_((struct menu_context * ctx,
                                        struct pager_range  * pager_range,
                                        struct pg_wrap_info * info,
                                        struct string       * buffer,
                                        struct span_helper_data * data
                                        ));



/* ----------------------------------------------------------------------- */

union pager_help_param {
    struct stringbuffer    * stringbuf;
    struct browser_edit    * browser_edit; 
    struct sending_display * sending_display;
};

extern const struct pager_helper_data  {
    unsigned short  magic;          /* PAGER_HELPER_DATA_magic */

    int             scroll_line;    /* Not really flags */
    int             search_matches;

    int             pg_flags;

    unsigned int    FF_seen      :1;
    unsigned int    preformatted :1;
    unsigned int    word_wrapped :1;    
    unsigned int    hard_wrapped :1;
}  NULL_pager_helper_data;

/* opcode == pp_opcode_ANY matchs for any opcode 
   (*idx) == 0 starts from first param 
*/

typedef struct pager_param_value * helper_get_param_f
    P_((union pager_help_param   buffer,
	struct pager_range     * range,
	enum pager_param_opcode  opcode,
	int                    * next_pos,
	int                    * found_pos));

typedef struct string * helper_get_line_f P_((union pager_help_param   buffer,
                                              int                      idx,
                                              int                    * pg_flags,
                                              enum range_changed     * range_changed,
                                              struct pager_range    ** range,
                                              struct pager_lineext  ** first_lineext));
                                                 
extern enum pager_helper_status { phelper_EOD = EOF   /* End of data */,
	phelper_failure = 0,
	phelper_done    = 1
	
} pager_helper_process_line P_((struct menu_context      * ctx,
				helper_get_line_f        * get_line,
				union pager_help_param     pager_buffer,
				struct span_helper_data  * helper_data_sp,
				struct pg_wrap_info      * wrap_info,
				struct string           ** current_line,
				struct pager_range      ** current_pager_range,
				struct pager_helper_data * helper_data_pg,
				struct string_alt       ** current_alt_data,
				helper_get_param_f       * get_range_param
				));

extern void pager_helper_end_of_page(struct menu_context      * ctx,
                                     struct span_helper_data  * helper_data_sp,
                                     struct pager_helper_data * helper_data_pg,
				     int limit,
				     int print_tilde);



/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
