/* @(#)$Id: pg_lineext_imp.h,v 2.4 2023/12/13 16:55:32 hurtta Exp $ */

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.4 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#if ANSI_C
struct pager_lineext_write;
#endif

typedef void plext_init_extension P_((struct pager_lineext *ext,
				      struct stringbuffer * stringbuffer));
typedef void plext_dest_extension P_((struct pager_lineext *ext,
				      struct stringbuffer * stringbuffer));
typedef struct string * plext_walk_extension P_((struct pager_lineext *ext,
						 struct pager_lineext **
						 walk_extension,
						 int *pg_flags,
						 struct pager_range **range));

typedef struct string_alt * plext_walk_alt_extension P_((struct pager_lineext *ext,
							 struct pager_lineext **
							 walk_extension,
							 int *pg_flags,
							 struct pager_range **range));


#define LINEEXT_TYPE_magic   0xEB13

struct lineext_type {
    unsigned short            magic;       /* LINEEXT_TYPE_magic */

    plext_init_extension  *    plext_init_it;
    plext_dest_extension  *    plext_dest_it;
    plext_walk_extension  *    plext_walk_it;
    plext_walk_alt_extension * plext_walk_alt_it;
};

#define PAGER_LINEEXT_magic  0xEB12

extern struct pager_lineext {
    unsigned short            magic;       /* PAGER_LINEEXT_magic */

    int                       refcount;
    
    struct lineext_type     * lineext_type;
    union {
	void                 * dummy;
	struct plext_in_file * file;
	struct plext_in_mem  * mem;
	struct plext_in_snd  * snd_display;
    } a;
    
    struct stringbuffer      * stringbuffer;

} * malloc_pager_lineext P_((struct lineext_type * lineext_type,
			     struct stringbuffer * stringbuffer));

#if ANSI_C
#define E_(x) extern x;
#else
#define E_(x)
#endif

/* Default routine */
E_(plext_walk_extension plext_walk_stringbuffer)
extern struct string * plext_walk_stringbuffer P_((struct pager_lineext *ext,
						   struct pager_lineext **
						   walk_extension,
						   int *pg_flags,
						   struct pager_range **range));


/* ------------ */

extern void inc_stringbuffer_refcount P_((struct stringbuffer *buffer));


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
