/* @(#)$Id: pg_params_imp.h,v 2.1 2023/12/13 16:55:32 hurtta Exp $ */

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.1 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

enum pg_param_value_type {
    pg_pv_text = STRING_magic

};

#define PAGER_PARAM_VALUE_magic	0xEB26

extern struct pager_param_value {
    unsigned short              magic;    /* PAGER_PARAM_VALUE_magic */

    int                         refcount;

    struct pgrng_bfr_binding   * backlink; /* backlink act as refcount */
            
    enum pager_param_opcode    opcode;
    
    union pager_param_uvalue value;

} * malloc_pager_param_value P_((enum pager_param_opcode opcode,
				 union pager_param_uvalue value));
				
extern void reset_pager_param_value_bcklink P_((struct pager_param_value **value,
						struct pgrng_bfr_binding   * backlink));


extern void inc_pager_param_value_refcount P_((struct pager_param_value * value));

extern struct pager_param_value * get_pager_param_serialization_from_file P_(( FILE *fh));

extern void put_pager_param_serialization_to_file P_((FILE *fh,
						      struct pager_param_value *param_value));

extern int match_pager_param_value P_((struct pager_param_value *param_value,
				       enum pager_param_opcode    opcode));

/* sb_file.c */

extern void put_string_serialization_to_file P_((FILE *fh,
						 const struct string *Str));
struct string * get_string_serialization_from_file P_((FILE *fh));


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */

