/* $Id: quota_imp.h,v 2.2 2024/06/23 07:38:36 hurtta Exp $ */

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.2 $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *       or Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#if ANSI_C
struct mail_quota;
#endif

typedef void mq_init_mail_quota P_((struct mail_quota *mq));
typedef void mq_dest_mail_quota P_((struct mail_quota *mq));

typedef void mq_init_mail_quotarootl P_((struct mail_quota *mq,
					 struct mail_quotaroot_list *mqrl));
typedef void mq_disc_mail_quotarootl P_((struct mail_quota *mq,
					 struct mail_quotaroot_list *mqrl));
typedef void mq_dest_mail_quotarootl P_((struct mail_quotaroot_list *mqrl));

typedef size_t mq_quotarootl_list_len P_((struct mail_quota *mq,
					 struct mail_quotaroot_list *mqrl));

/* Increments refcount or return NULL */
typedef struct mail_quotaroot * mq_quotarootl_list_item P_((struct mail_quota *mq,
						    struct mail_quotaroot_list *mqrl,
							    size_t idx,
							    struct cancel_data  * cd
							    ));

typedef void mq_quotarootl_refresh  P_((struct mail_quota *mq,
					struct mail_quotaroot_list *mqrl,
					enum quota_mode refresh));

typedef void mq_init_mail_quotaroot P_((struct mail_quota *mq,
					struct mail_quotaroot *mqr));
typedef void mq_disc_mail_quotaroot P_((struct mail_quota *mq,
					struct mail_quotaroot *mqr));
typedef void mq_dest_mail_quotaroot P_((struct mail_quotaroot *mqr));

typedef size_t mq_quotaroot_item_count P_((struct mail_quota *mq,
					   struct mail_quotaroot *mqr));

/* Increments refcount or return NULL */
typedef struct mail_quota_item * mq_quotaroot_item P_((struct mail_quota *mq,
						       struct mail_quotaroot *mqr,
						       size_t idx));

typedef enum quota_quotaroot_status mq_quotaroot_status  P_((struct mail_quota *mq,
							     struct mail_quotaroot *mqr));


typedef void mq_init_mquota_item P_((struct mail_quota *mq,
				    struct mail_quota_item *mqi));
typedef void mq_disc_mquota_item P_((struct mail_quota *mq,
				     struct mail_quota_item *mqi));
typedef void mq_dest_mquota_item P_((struct mail_quota_item *mqi));

/* Returns bitmask tells  which return values are valid */
typedef int mq_mquota_item_values P_((struct mail_quota *mq,
				      struct mail_quota_item *mqi,
				      uint32 * usage_r /* return value */,
				      uint32 * limit_r /* return value */));

typedef void mq_unlink_con P_((struct mail_quota *mq,
			       struct connection_cache *con));

#define MAIL_QUOTA_TYPE_magic	0xF52B

struct mail_quota_type {
    unsigned short magic;   /* MAIL_QUOTA_TYPE_magic */

    /* struct mail_quota */
    
    mq_init_mail_quota  * mq_init_it;
    mq_dest_mail_quota  * mq_dest_it;

    /* struct mail_quotaroot_list */

    mq_init_mail_quotarootl * mq_init_mqrl_it;
    mq_disc_mail_quotarootl * mq_disc_mqrl_it;
    mq_dest_mail_quotarootl * mq_dest_mqrl_it;

    mq_quotarootl_list_len  * mq_listlen_mqrl_it;
    mq_quotarootl_list_item * mq_listitem_mqrl_it;
    mq_quotarootl_refresh   * mq_refresh_mqrl_it;

    /* struct mail_quotaroot */

    mq_init_mail_quotaroot  * mq_init_mqr_it;
    mq_disc_mail_quotaroot  * mq_disc_mqr_it;
    mq_dest_mail_quotaroot  * mq_dest_mqr_it;

    mq_quotaroot_item_count * mq_itemcount_mqr_it;
    mq_quotaroot_item       * mq_item_mqr_it;
    mq_quotaroot_status     * mq_status_mqr_it;
    
    /* struct mail_quota_item */
    mq_init_mquota_item     * mq_init_mqi_it;
    mq_disc_mquota_item     * mq_disc_mqi_it;
    mq_dest_mquota_item     * mq_dest_mqi_it;
    mq_mquota_item_values   * mq_values_mqi_it;

    /*  struct connection_cache */
    
    mq_unlink_con           *  mq_unlink_con_it;
};


#define MAIL_QUOTA_magic	0xF52A

extern struct mail_quota {
    unsigned short magic;   /* MAIL_QUOTA_magic */

    int refcount;

    struct mail_quota_type * quota_type;

    /* Refcounted */
    struct mail_quotaroot_list ** quotarootl_list;
    size_t                        quotarootl_count;

    /* Refcounted */
    struct mail_quotaroot      ** quotaroot_list;
    size_t                        quotaroot_count;

    /* Not refcounted -- free_mail_quota_item() removes this link */
    struct mail_quota_item     ** quotaitem_list;
    size_t                        quotaitem_count;

    union {
	void               * dummy;
	struct mquota_imap * imap;

    } p;
    
} * malloc_mail_quota P_((struct mail_quota_type      * quota_type));


#define MAIL_QUOTAROOT_LIST_magic	0xF52C

extern struct mail_quotaroot_list {

    unsigned short magic;             /* MAIL_QUOTAROOT_LIST_magic */

    struct mail_quota_type * quota_type;
    
    int refcount;                     /* mail_quota->quotarootl_list[] link is counted */
    struct mail_quota  * mail_quota;  /* NOT counted to mail_quota->refcount      */

    union {
	void              * dummy;
	struct mqrl_imap  * imap;
    } p;
    
} * malloc_mail_quotaroot_list P_((struct mail_quota *mail_quota));

#define MAIL_QUOTAROOT_magic	0xF52D

extern struct mail_quotaroot {

    unsigned short magic;        /* MAIL_QUOTAROOT_magic */

    struct mail_quota_type * quota_type;
    
    int refcount;
    struct mail_quota  * mail_quota;  /* NOT counted to mail_quota->refcount      */
    
    struct string                 * name;   /* may be NULL */
    enum quota_reserved_quotaroot   name_token;

    union {
	void             * dummy;   
	struct mqr_imap  * imap;
	
    } p;

    
} * malloc_mail_quotaroot P_((struct mail_quota * mail_quota,
			      struct string     * name /* may be NULL */,
			      enum quota_reserved_quotaroot   name_token
			      ));


#define MAIL_QUOTA_ITEM_magic	0xF52E

extern struct mail_quota_item {


    unsigned short magic;  	    /* MAIL_QUOTA_ITEM_magic */

    struct mail_quota_type * quota_type;
   

    int refcount;                  /* mail_quota->quotaitem_list[] not counted */
    struct mail_quota  * mail_quota;  /* NOT counted to mail_quota->refcount  */

    struct string       * name     /* May be NULL */;
    enum quota_reserved_resource name_token;

    union {
	void            * dummy;
	struct mqi_imap * imap;      

    } p;
    
    
} * malloc_mail_quota_item P_((struct mail_quota * mail_quota,
			       struct string     * name /* May be NULL */,
			       enum quota_reserved_resource name_token
			       ));

    
/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */

