/* $Id: rc_imp.h,v 2.26 2024/06/10 18:05:34 hurtta Exp $ */

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.26 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                  (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#if ANSI_C
struct rc_save_info_rec;
struct parsed_rc;
struct hist_record;
#endif


enum rec_line_mode { line_normal, line_negate, line_continue };

/* Returns 0 on error
           1 if parsed OK
*/
typedef int rc_parse_line P_((struct rc_save_info_rec * r,
			      enum record_mode          lcl,
			      struct string           * value,
			      int                       lineno, 
			      const char              * filename,
			      int                       negate,
			      int read_flags /* READ_FLAG_IGNORE_MISSING */
			      ));
typedef int rc_parse_cline P_((struct rc_save_info_rec * r,
			       enum record_mode          lcl,
			       struct string           * value,
			       int                       lineno, 
			       const char             * filename,
			       int read_flags /* READ_FLAG_IGNORE_MISSING */
			       ));

typedef void rc_print_value P_((FILE *F,
				struct rc_save_info_rec *r,
				int comment,
				charset_t rcset));

/* Returns pointer to static buffer */
typedef char * rc_get_value P_((struct rc_save_info_rec *r));

/* frees memory alloced by option */
typedef void rc_free_option  P_((struct rc_save_info_rec *r));





#define RCTYPE_magic            0xF402

extern struct rc_type {
    unsigned short magic;                      /* RCTYPE_magic */


    rc_parse_line      * parse_line;            /* Parse line */
    rc_parse_cline     * parse_cline;           /* Parse continuation line */
    rc_print_value     * print_value;
    rc_get_value       * get_value;
    rc_free_option     * free_option;

} rc_DT_SYN, rc_DT_STR, rc_DT_NUM, rc_DT_BOL,
    rc_DT_CHR, rc_DT_SORT,
    rc_DT_MLT,  rc_DT_PRM, rc_DT_FUNC,
    rc_DT_LONG, rc_DT_PATH, rc_DT_OBS, rc_DT_ESTR,
    rc_DT_ENUM, rc_DT_DELAY, rc_DT_DELAYSHARED,
    rc_DT_STRING, rc_DT_FLAGS;

extern int valid_rc_type P_((struct rc_type *T));

extern struct rc_type rc_DT_PGPVER;

#ifdef USE_DLOPEN
extern struct rc_type rc_DT_SHARED;
#endif

#define DT_SYN      &rc_DT_SYN    /* synonym entry (old name) */
#define DT_STR      &rc_DT_STR    /* string */
#define DT_NUM      &rc_DT_NUM    /* number */
#define DT_BOL      &rc_DT_BOL    /* ON/OFF (boolean) */
#define DT_WEE      &rc_DT_WEE    /* weed list */
#define DT_MLT      &rc_DT_MLT    /* multiple destinations for data */
#define DT_PRM      &rc_DT_PRM   /* file permissions */
#define DT_FUNC     &rc_DT_FUNC  /* function to be called for process option */
#define DT_LONG     &rc_DT_LONG    /* number */
#define DT_PGPVER   &rc_DT_PGPVER    /* enum pgp_version */

/* rc_parse.c */

struct cached_line {
    char   * keyword;    /* NULL == continue line */
    char   * rest;
    size_t   restlen;
    int      lineno;
};
#if ANSI_C
struct delayed_block;
#endif

extern void rc_line_ignored_message P_((const char              * rest,
					size_t                    restlen,
					int                       lineno,
					const char              * filename));

extern struct string * cs_option_value P_((const char *rest,
					   size_t restlen,
					   int lineno,
					   const char *filename,
					   charset_t cs));

/* return 1 if tag found */
extern int give_cached_lines P_((const char            * tag,
				 /* In out */
				 struct delayed_block ** walk,
				 
				 /* Output: */
				 enum record_mode      * lcl,
				 charset_t             * rcset,
				 char                 ** filename,
				 struct cached_line   ** cached_lines,
				 size_t                * cached_lines_len));

extern void free_delayed_blocks P_((void));

extern struct editor_propline * current_editor_propline; /* Also other values */

extern void free_parsed_rc P_((struct parsed_rc **rc));

#define MAX_LINE 10000

extern struct parsed_rc * do_rc_parse P_((FILE *file,
					  enum record_mode lcl,
					  const char *filename,
					  int *errors_p,
					  int read_flags /* READ_FLAG_IGNORE_MISSING */
					  ));

extern void do_rc_process P_((struct parsed_rc *rc, enum record_mode lcl,
			      const char *filename, charset_t elmrc_charset,
			      int *errors_p,
			      int read_flags /* READ_FLAG_IGNORE_MISSING */));



extern void process_delayed_blocks P_((const char              * tag,
				       struct rc_save_info_rec * rc_options,
				       size_t                    rc_option_count,
				       int                     * errors_p,
				       int read_flags /* READ_FLAG_IGNORE_MISSING */));

/* shared.c */

enum shared_have_code {
    have_code_invalid = -1   /* Invalid tag     */,
    have_code_not     = 0    /* code not loaded */,
    have_code_loaded  = 1    /* code was loaded */,
    have_code_delayed        /* code not loaded (deleyd option) */
};

#ifdef USE_DLOPEN

extern int give_options P_((char                     * tag, 
			    struct rc_save_info_rec ** rc_options,
			    size_t                   * rc_option_count,
			    enum shared_have_code    * have_code));

extern void mark_shared_changed P_((void *A,
				    int no_history_record));

extern void mark_fshared_changed P_((option_func *A,
				     int no_history_record));

extern struct dt_enum_shared *  
   shared_fill_dt_enumerate_values P_((struct dt_enumerate_info *ptr,
				       const char *tag,
				       enum shared_have_code * have_code,
				       const char * fieldname));

extern int delay_lib_reg P_((struct rc_save_info_rec *r,
			     char **value, int lineno,
			     const char *filename,
			     int read_flags /* READ_FLAG_IGNORE_MISSING */));

#endif

/* rc_propline.c */

extern void free_editor_propline P_((struct editor_propline **propline));

extern struct editor_propline *detect_editor_propline 
  P_((enum editor_propline_v detect_mode,
      char * buffer, int buffer_len,
      const char *filename, int lineno,
      charset_t *current_charset));

struct editor_propline * copy_editor_propline P_((const struct editor_propline 
						  *propline));

extern void write_editor_propline P_((const struct editor_propline *propline,
				      enum editor_propline_v detect_mode,
				      FILE *f,
				      const char * line_prefix, 
				      const char * line_tail,
				      charset_t file_charset));

/* read_rc.c */

/* return NULL on failure 
                 otherwise pointer to option
*/
extern struct rc_save_info_rec  * do_set P_((enum record_mode          lcl,
					     char                    * word1, 
					     struct string           * word2, 
					     const char              * filename,
					     int read_flags /* READ_FLAG_IGNORE_MISSING */
					     ));


extern struct hist_record * rc_need_hist_record P_((enum record_mode mode,
						    struct rc_save_info_rec *X,
						    const char *tag));

extern void mark_XX P_((struct rc_save_info_rec *x,
			int no_history_record));

extern char * rc_split_keyword P_((char *buffer, int line_len,
				   char *keyword, int size,
				   char **tag,
				   int *assig,
				   int *restlen));
extern struct rc_save_info_rec *rc_locate_option P_((struct rc_save_info_rec * 
						     rc_options,
						     size_t rc_option_count,
						     const char *word1,
						     int *negate));


extern void hist_record_add_line P_((struct hist_record *rec, char *rest));

extern void hist_record_first_line P_((struct hist_record *rec, char *rest));

extern void hist_record_changed P_((struct hist_record *rec));

extern struct hist_record * rc_need_hist_record P_((enum record_mode mode,
						    struct rc_save_info_rec *X,
						    const char *tag));


extern int rc_eval_tail P_((struct rc_save_info_rec *ret,
			    enum record_mode          lcl,
			    struct string *value,
			    int lineno, const char *filename, int negate,
			    int read_flags /* READ_FLAG_IGNORE_MISSING */));
extern int rc_eval_tail_cline P_((struct rc_save_info_rec *ret,
				  enum record_mode          lcl,
				  struct string *value,
				  int lineno,
				  const char *filename,
				  int read_flags /* READ_FLAG_IGNORE_MISSING */));

extern int rc_eval_tail_line P_((struct rc_save_info_rec *ret,
				 enum record_mode          lcl,
				 struct string *value,
				 int lineno,
				 const char *filename,
				 enum rec_line_mode line_mode,
				 int read_flags /* READ_FLAG_IGNORE_MISSING */));

/* exported for lib/mbox/init.c */
extern char * MAILBOX_LOCKING[NUM_mailbox_locking_v+1];

/* rc_handle.c */

extern int expand_dt_path P_((struct dt_path_info *ptr, const char *fieldname, 
			      const char *val, int recursive,
			      int read_flags /* READ_FLAG_IGNORE_MISSING */
			      ));

/* Return 1 if no errors */
extern int convert_to_system_charset P_((struct string *value,
					 int lineno,
					 const char *filename,
					 char **buffer,
					 int *buffer_len));

/* in_buffer_len = -1 ... uses  strlen() 
   0 == failure, 1 = ok
*/

extern int convert_to_rcset P_((const char * in_buffer,int in_buffer_len,
				const char *fieldname,
				charset_t rcset,
				char **buffer,
				int *buffer_len));


extern int sconvert_to_rcset P_((struct string *S,const char *fieldname,
				  charset_t rcset,
				  char **buffer,
				  int *buffer_len));

/* Expands ptr->unexpanded 
   0 = failed to expand
   1 = expanded
   -1 = expanded but do string available
*/
extern int expand_dt_estr P_((struct dt_estr_info *ptr,
			      const char *fieldname));

extern void estr_set_expanded P_((struct dt_estr_info *ptr, 
				  const char *buffer));


/* return 0 if errors ,  tag == NULL process all*/
extern int process_delayed_enumerated P_((const char *tag));

extern void free_delayed_enumerated_list P_((void));

/* rc_delay.c */

extern void register_delayed P_((struct rc_save_info_rec * rc_options,
				 int rc_option_count,
				 int read_flags /* READ_FLAG_IGNORE_MISSING */
				 ));

extern void  mark_delayed_changed P_((void *A, int no_history_record));
extern void  mark_fdelayed_changed P_((option_func *A,
				       int no_history_record));
extern void free_delayed_rc_options P_((void));


/* write_rc.c */

extern charset_t rcset;             /* What charset use for writing */

struct collected_keywords {
    char                 * keyword;
    enum record_mode       lcl;
    
    struct string       ** rest;
    size_t                 rest_count;
    
    unsigned int           seen   : 1;
    unsigned int           failed : 1;
};


extern void write_rc_part_cached P_((FILE       * targetfile_F,
				     const char * part_tag,
				     FILE       * commentfile_F     /* NULL if no commentfile */,
				     int          global,
				     charset_t    rcset,
				     struct collected_keywords * keywords,
				     size_t                      keywords_len));
     
/* service_list.c */

/* Mallocs to result */
extern char * convert_to_fileset2 P_((const struct string *value, 
				      charset_t fileset, int *err));

/* Mallocs to result, if conversion, otherwise returns value */
extern char * convert_to_fileset P_((char *value, charset_t fileset, int *err));

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
