/* $Id: service_imp.h,v 2.1 2018/01/17 20:41:07 hurtta Exp $ */

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.1 $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *       or Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#ifdef REMOTE_MBX

/* static_hosts.c */

extern int static_hosts_opened;

extern int free_expired_static_hosts
   P_(( const struct schedule_timelimit * now,
	struct schedule_timelimit       * next_cleanup));

struct service_entry * lookup_static_host_sentry
   P_((const char * lookup_name,
       const struct schedule_timelimit * now,
       const struct schedule_timelimit * valid_until /* default        */,
       struct cancel_data             ** cancel_p,
       enum lookup_class                 lc           /* Optimization */,
       int                             * was_error_p  /* Print errors only if
							 was_error_p != NULL */,
       enum etc_hosts_status           * static_status_p
       ));

/* Return 1 if there is some expired data */
int expired_service_entry P_((struct service_entry            * se,
			      const struct schedule_timelimit * now));



/* service_list.c */
extern struct service_type * const any_service_type;

/* Returns number of cleared entries */
extern int free_expired_on_service_entry
   P_((struct service_entry            * se,
       const struct schedule_timelimit * now,
       struct schedule_timelimit       * next_cleanup));

extern struct service_entry * malloc_service_entry
   P_((const char *name,
       const struct service_type *st,
       int flags));

extern void merge1_entries P_((struct service_entry *target,
			       struct service_entry *value));


#endif
