/* $Id: ss_imp.h,v 2.12 2022/02/19 07:51:39 hurtta Exp $ */

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.12 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                  (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

/* Closed only implicity on exit */
extern FILE * transaction_file;

/* struct Read_Buffer is defined on mbx_imp.h */
#if ANSI_C
struct Read_Buffer;
struct Write_Buffer;
#endif

#define SS_magic   0xF100

struct streamsched;

union ss_action_routine_data {
    void                    * data;
    struct connection_cache * con;
    struct folder_info      * folder;    
    struct smtp_info        * smtp;
};

typedef int ss_action_routine P_((struct streamsched *ss,
				  union  ss_action_routine_data data,
				  const struct schedule_timelimit * now));
extern int ss_noaction_routine P_((struct streamsched *ss,
				   union  ss_action_routine_data data,
				   const struct schedule_timelimit * now));
typedef void ss_free_action_rt_data P_((struct streamsched *ss,
					union  ss_action_routine_data * data,
					int badpid
					));
extern void ss_nofree_action_rt_data P_((struct streamsched *ss,
					 union  ss_action_routine_data * data,
					 int badpid
					 ));

typedef void ss_inc_action_rt_data_refcount P_((union  ss_action_routine_data data));
extern void ss_noinc_action_rt_data_refcount P_((union  ss_action_routine_data data));

typedef enum badpid_status ss_badpid_routine P_((struct streamsched *ss,
						 union  ss_action_routine_data data,
						 int badpid));
extern enum badpid_status ss_nobadpid_routine P_((struct streamsched *ss,
						  union  ss_action_routine_data data,
						  int badpid));
extern enum badpid_status ss_badpid_remove P_((struct streamsched *ss,
						union  ss_action_routine_data data,
						int badpid));


#define SS_read_act           0x01
#define SS_write_act          0x02
#define SS_timeout_act        0x04
#define SS_setup_act          0x08
#define SS_shutdown_act       0x10

typedef int ss_ReadFromStream P_((struct streamsched *ss,
				  int stack_idx,
				  struct Read_Buffer *buffer,
				  int wanted));
typedef int ss_WriteToStream P_((struct streamsched *ss, 
				 int stack_idx,
				 struct Write_Buffer *buffer));

typedef void ss_FreeThis P_((struct streamsched *ss,
			     int stack_idx,
			     int badpid));

typedef  enum action_status ss_StreamAction P_((struct streamsched *ss,
						int stack_idx,
						const struct schedule_timelimit * now));

typedef void ss_StreamSchedule P_((struct streamsched *ss, int stack_idx,
				  int previous_needs, 
				  int *needs, int *provides));

enum SS_info { SS_ssf = 1, SS_verify };

/* Unknown functions does not modify *int_val, *str_val 
   or *string_val
*/

typedef void ss_StreamInfo P_((struct streamsched *ss, int stack_idx,
			       enum SS_info function,
			       int *int_val,  char **str_val,
			       struct string **string_val));

enum SS_name_type { SS_peer_cn = 1, SS_check_host };

/* Unknown functions does not modify **returned_name */
typedef int ss_StreamVerifyName P_((struct streamsched *ss, int stack_idx,
				    enum SS_name_type name_type,
				    const struct string *required_name,
				    struct string      **returned_name));

#define SS_type_magic		0xF101

extern struct stream_type {
    unsigned short            magic;       /* SS_type_magic */

    char                      * tag;
    ss_ReadFromStream         * read_from_it;
    ss_WriteToStream          * write_to_it;
    ss_FreeThis               * free_it;
    ss_StreamAction           * read_action;
    ss_StreamAction           * write_action;
    ss_StreamSchedule         * schedule_data;
    ss_StreamAction           * setup_action;
    ss_StreamAction           * shutdown_action;
    ss_StreamInfo             * query_it;
    ss_StreamVerifyName       * verify_name_it;

			  }  SocketStream;

struct streamsched {
    unsigned short magic;        /* SS_magic */

    int refcount;
    
    unsigned  short active_flags;
    
    ss_action_routine  * read_act;
    ss_action_routine  * write_act;
    ss_action_routine  * timeout_act;
    ss_free_action_rt_data * free_act;
    ss_inc_action_rt_data_refcount * inc_refcount;
    ss_badpid_routine  * badpid_act;

    char               * error_state;
    int                timeout_sec;

    union stream_types {
	struct stream_type    **TYPE;
	struct simple_type    *simple;
	
	/* Notice that shared_type_1 and shared_type_2 is not 
	   defined on here. Shared (dynamic) libraries are free
	   to define they..
	*/
	struct shared_type_1  *generic_1;
	struct shared_type_2  *generic_2;
    }                  * this_stack;
    int                  stack_len;

    int                free_stack_lock;
    int                nested_FreeStreamStack0;

    
    union  ss_action_routine_data data;
};

extern void WaitStreamFor P_((struct streamsched *ss, int flags));
extern int WaitStreamFor_c P_((struct streamsched *ss, int flags,
			       struct cancel_data *cd));


extern int ReadFromStream P_((struct streamsched *ss, 
			      struct Read_Buffer *buffer,
			      int wanted));

extern int WriteToStream P_((struct streamsched *ss, 
			     struct Write_Buffer *buffer));

extern struct streamsched * returnSimpleStream P_((int socket));

extern void ConfigStream0 P_((struct streamsched *ss,
			      ss_action_routine  * read_act,
			      ss_action_routine  * write_act,
			      ss_action_routine  * timeout_act,
			      ss_free_action_rt_data * free_act,
			      ss_inc_action_rt_data_refcount * inc_refcount,
			      ss_badpid_routine  * badpid_act,
			      int timeout_sec,
			      union ss_action_routine_data data,
			      int badpid));

extern void ConfigStream P_((struct streamsched *ss,
			     ss_action_routine  * read_act,
			     ss_action_routine  * write_act,
			     ss_action_routine  * timeout_act,
			     int timeout_sec,
			     union ss_action_routine_data data));

extern void ConfigStream2 P_((struct streamsched *ss,
			      ss_action_routine  * read_act,
			      ss_action_routine  * write_act,
			      ss_action_routine  * timeout_act,
			      ss_free_action_rt_data * free_act,
			      ss_inc_action_rt_data_refcount * inc_refcount,
			      ss_badpid_routine  * badpid_act,
			      int timeout_sec,
			      union ss_action_routine_data data));

extern void FreeStreamStack0 P_((struct streamsched **ss,
				 int badpid, int reset));
extern void FreeStreamStack P_((struct streamsched **ss));
extern void FreeStreamStack2 P_((struct streamsched **ss,
				 int reset));

extern void IncStreamStackRefcount P_((struct streamsched *ss));

extern void add_stream_to_head P_((struct streamsched *ss,
				   union stream_types stream));

extern char * RemoveStreamError P_((struct streamsched *ss));

/* Unknown functions does not modify *int_val, *str_val 
   or *string_val
 */

extern void StreamInfo P_((struct streamsched *ss, 
			   enum SS_info function,
			   int *int_val,  char **str_val,
			   struct string **string_val));


extern int StreamVerifyName P_((struct streamsched *ss,
				enum SS_name_type name_type,
				const struct string *required_name,
				struct string      **returned_name));

/* Guard for shared modules */

extern int StreamOK P_((size_t st_size));
					    
/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */
