static char rcsid[] = "@(#)$Id: date.c,v 2.3 2020/05/23 15:44:23 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.3 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *           or  Kari Hurtta <elm@elmme-mailer.org>
 ******************************************************************************
 *  Based on Elm 2.4 src/date.c. That code was following copyright:
 *
 *  The Elm Mail System 
 *
 * 			Copyright (c) 1988-1992 USENET Community Trust
 * 			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************
 *  Incorparated Elm 2.5 code from src/date.c
 *  That code have following copyright:
 *
 *  The Elm Mail System  
 *
 *                      Copyright (c) 1988-1995 USENET Community Trust
 * 			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

#include "def_addr.h"

DEBUG_VAR(Debug,__FILE__,"addr");

#include <limits.h>

#define MONTHS_IN_YEAR	11	/* 0-11 equals 12 months! */
#define FEB		 1	/* 0 = January 		  */
#define DAYS_IN_LEAP_FEB 29	/* leap year only 	  */

#define leapyear(year)  (((year) % 4 == 0) && (((year) % 100 != 0) || ((year) % 400 == 0)) )

static int  days_in_month[] = { 31,    28,    31,    30,    31,     30, 
				31,     31,    30,   31,    30,     31,  -1};

struct tm * days_ahead_tm(days)
     int days;
{
    /** return the date (Day, Mon Day, Year) of the date
	'days' days after today.  
    **/

    time_t      now = 0;               /* time in seconds....		     */
                                       /* this must be here for it to work! */

    struct tm * the_time = NULL;       /* Time structure, see CTIME(3C)     */
	    
    if (((time_t) -1) != time(&now)) {
   
	the_time = localtime(&now);
    
	if (the_time) {

	    DPRINT(Debug,16,(&Debug,
			     "days_ahead_tm: localtime gives tm_mday %d (1-31), tm_mon %d (0-11), tm_year %d (Year - 1900), tm_wday %d (0-6, Sunday = 0)\n",
			     the_time->tm_mday,
			     the_time->tm_mon,
			     the_time->tm_year,
			     the_time->tm_wday
			     ));
	    
	    /* If expires-have-time is shown then also time is shown */
	    
	    DPRINT(Debug,16,(&Debug,
			     "days_ahead_tm: localtime gives tm_sec %d (0-60), tm_min %d (0-59), tm_hour %d (0-23)\n",
			     the_time->tm_sec,
			     the_time->tm_min,
			     the_time->tm_hour));
	    
	    if (the_time->tm_hour < 17) {
		DPRINT(Debug,16,(&Debug,
				 "days_ahead_tm: Rounding expires time to 18:00:00\n"));
		
		the_time->tm_sec  = 0;
		the_time->tm_min  = 0;
		the_time->tm_hour = 18;
	    } else {
		DPRINT(Debug,16,(&Debug,
				 "days_ahead_tm: Rounding expires time to 23:59:59\n"));
		
		the_time->tm_sec  = 59;
		the_time->tm_min  = 59;
		the_time->tm_hour = 23;
	    }
		
	    /* increment the day of the week */	
	    if (INT_MAX - days < the_time->tm_wday) {
		DPRINT(Debug,16,(&Debug,
				 "days_ahead_tm: Overflow tm_wday, days=%d\n",
				 days));
		
		return NULL;	    
	    }       
	    the_time->tm_wday = (the_time->tm_wday + days) % 7;
	    
	    
	    /* increment the day of the month... */
	    if (INT_MAX - days <  the_time->tm_mday) {
		DPRINT(Debug,16,(&Debug,
				 "days_ahead_tm: Overflow tm_mday, days=%d\n",
				 days));
		
		return NULL;	    
	    }		
	    the_time->tm_mday += days;
	    
	    /* adjust overflowing day of the month ... */
	    
	    while (the_time->tm_mday > days_in_month[the_time->tm_mon]) {
		
		if (the_time->tm_mon == FEB && leapyear(the_time->tm_year+1900)) {
		    if (the_time->tm_mday > DAYS_IN_LEAP_FEB) {
			the_time->tm_mday -= DAYS_IN_LEAP_FEB;
			the_time->tm_mon += 1;
		    } else
			break;            /* Is Feb 29, so leave */
		} else {
		    the_time->tm_mday -= days_in_month[the_time->tm_mon];
		    the_time->tm_mon += 1;
		}
		
		/* check the month of the year */
		if (the_time->tm_mon > MONTHS_IN_YEAR) {
		    
		    if (the_time->tm_year < INT_MAX) {
			the_time->tm_mon -= (MONTHS_IN_YEAR + 1);
			the_time->tm_year += 1;
		    } else {
			DPRINT(Debug,16,(&Debug,
					 "days_ahead_tm: Overflow tm_year, days=%d\n",
					 days));
			return NULL;
		    }
		}
	    }
	    
	    DPRINT(Debug,16,(&Debug,
			     "days_ahead_tm: %d days gives tm_mday %d (1-31), tm_mon %d (0-11), tm_year %d (Year - 1900), tm_wday %d (0-6, Sunday = 0)\n",
			     days,
			     the_time->tm_mday,
			     the_time->tm_mon,
			     the_time->tm_year,
			     the_time->tm_wday));
	    
	    DPRINT(Debug,16,(&Debug,
			     "days_ahead_tm: tm_sec %d (0-60), tm_min %d (0-59), tm_hour %d (0-23)\n",
			     the_time->tm_sec,
			     the_time->tm_min,
			     the_time->tm_hour));
	    
	    
	} else {
	    int err UNUSED_VAROK = errno;
	    
	    DPRINT(Debug,4,(&Debug, 
			    "days_ahead_tm: %d days -- localtime failed, time=%ld",
			    days,
			    (long)now
			    ));
	    if (err) {
		DPRINT(Debug,4,(&Debug, ": %s",
				strerror(err)));
	    }

	    DPRINT(Debug,4,(&Debug, "\n"));
	    
	}

    } else {
	int err UNUSED_VAROK = errno;
	
	DPRINT(Debug,4,(&Debug,
			"mail: Date: not given, time: %s\n",
			strerror(err)));
    }
	
    return the_time;
}

/* Return 1 if succeed */			       
int expanded_time_hdrval(the_time,cached_time,buffer,size,print_time,
			 override_zone,override_tz_offset)
     const struct tm * the_time;
     const time_t      cached_time;
     char            * buffer;
     size_t            size;
     enum print_time   print_time;
     const char      * override_zone;
     time_t            override_tz_offset;
{	
    if (the_time->tm_wday < 0 ||
	the_time->tm_wday >=
	sizeof (arpa_dayname) / sizeof (arpa_dayname[0]) ||
	the_time->tm_mday < 1 ||
	the_time->tm_mday > 31 ||
	the_time->tm_mon < 0 ||
	the_time->tm_mon >=
	sizeof (arpa_monname) / sizeof (arpa_monname[0])) {
	
	DPRINT(Debug,16,(&Debug,
			 "expanded_time_hdrval=0: date failure tm_mday %d (1-31), tm_mon %d (0-11), tm_year %d (Year - 1900), tm_wday %d (0-6, Sunday = 0)\n",
			 the_time->tm_mday,
			 the_time->tm_mon,
			 the_time->tm_year,
			 the_time->tm_wday));
	
	return 0;
    }

    if (size < 1) {
	DPRINT(Debug,16,(&Debug,
			 "expanded_time_hdrval=0: size=%zu\n",size));
	return 0;
    }
    buffer[0] = '\0';
    
    switch (print_time) {
	int tz_mins;
	const char * zone;
	char sign;

    case print_date_and_time:
	tz_mins = 0;
	zone = NULL;
	sign = '+';

	
	if (the_time->tm_sec < 0  ||
	    the_time->tm_sec > 60 ||
	    the_time->tm_min < 0  ||
	    the_time->tm_min > 59 ||
	    the_time->tm_hour < 0 ||
	    the_time->tm_hour > 23) {
	    
	    DPRINT(Debug,16,(&Debug,
			     "expanded_time_hdrval: time failure tm_sec %d (0-60), tm_min %d (0-59), tm_hour %d (0-23)\n",
			     the_time->tm_sec,
			     the_time->tm_min,
			     the_time->tm_hour));
	    
	    
	    goto fail_time;
	}

	if (override_zone) {
	    zone = override_zone;
	    tz_mins = override_tz_offset/60;

	    
	    DPRINT(Debug,16,(&Debug,
			     "expanded_time_hdrval: override tz_offset %ld, zone %s\n",
			     (long)override_tz_offset,override_zone));
	    
	} else {
#ifdef TZNAME_USE_TM_ZONE
	    tz_mins = the_time->tm_gmtoff / 60;
	    zone    = the_time->tm_zone;
	
	    DPRINT(Debug,16,(&Debug,
			     "expanded_time_hdrval: tm_gmtoff %ld, tm_zone %s\n",
			     (long)(the_time->tm_gmtoff),
			     the_time->tm_zone ? the_time->tm_zone : "NULL"));	    
#endif
	}
	
	if (!zone) {
	    DPRINT(Debug,16,(&Debug,
			     "expanded_time_hdrval: Assuming local time zone, cached_time=%ld\n",
			     (long)cached_time));
	    
	    if (cached_time > 0) {
		tz_mins = get_tz_mins(cached_time);
	    } else {
		DPRINT(Debug,16,(&Debug,
				 "expanded_time_hdrval: timezone not available\n"));
		goto fail_time;
	    }
	    
	    zone = get_tz_name(the_time);	    
	}
	
	if (tz_mins < 0) {
	    sign = '-';
	    tz_mins = -tz_mins;
	}

	if (zone &&
	    ( '-' == zone[0] ||
	      '+' == zone[0])) {
	    DPRINT(Debug,16,(&Debug,
			     "expanded_time_hdrval: Ignoring zone name %s\n",
			     zone));
	    zone = NULL;
	}
	
	DPRINT(Debug,16,(&Debug,
			 "expanded_time_hdrval: tz_mins %d sign %c zone %s\n",
			 tz_mins,sign,zone ? zone : "NULL"));

	if (zone) {
	
	    elm_sfprintf(buffer, size,
			 FRM("%s, %d %s %d %02d:%02d:%02d %c%02d%02d (%s)"),
			 arpa_dayname[the_time->tm_wday],
			 the_time->tm_mday,
			 arpa_monname[the_time->tm_mon],
			 1900+the_time->tm_year,
			 the_time->tm_hour,
			 the_time->tm_min,
			 the_time->tm_sec,
			 sign,
			 tz_mins / 60,
			 tz_mins % 60,
			 zone);
	} else {
	    elm_sfprintf(buffer, size,
			 FRM("%s, %d %s %d %02d:%02d:%02d %c%02d%02d"),
			 arpa_dayname[the_time->tm_wday],
			 the_time->tm_mday,
			 arpa_monname[the_time->tm_mon],
			 1900+the_time->tm_year,
			 the_time->tm_hour,
			 the_time->tm_min,
			 the_time->tm_sec,
			 sign,
			 tz_mins / 60,
			 tz_mins % 60);
	}

	break;
	
    case print_date_only:
    fail_time:
	elm_sfprintf(buffer, size,
		     FRM("%s, %d %s %d"),
		     arpa_dayname[the_time->tm_wday],
		     the_time->tm_mday,
		     arpa_monname[the_time->tm_mon],
		     1900+(the_time->tm_year));
	break;
    }

    DPRINT(Debug,16,(&Debug,
		     "expanded_time_hdrval=1: %s\n",
		     buffer));
    
    return 1;
}
    



/* Return 1 if succeed */
int days_ahead_hdrval(ptr,buffer,size,print_time)
     struct expanded_expires * ptr;
     char                    * buffer;
     size_t                    size;
     enum print_time           print_time;
{
    int r = 0;
    
    const struct tm * expire_time =
	get_expanded_expires_value(ptr);
    
    if (expire_time) {

	r = expanded_time_hdrval(expire_time,get_expanded_expires_cached_time(ptr),
				 buffer,size,print_time,NULL,0);

    } else {
	DPRINT(Debug,16,(&Debug,
			 "days_ahead_hdrval: no expire_time\n"));
    }

    DPRINT(Debug,16,(&Debug,
		     "days_ahead_hdrval=%d\n",r));

     return r;
}

/* Return 1 if succeed */
int date_hdrval(ptr,buffer,size,print_time)
     struct expanded_date * ptr;
     char                 * buffer;
     size_t                 size;
     enum print_time        print_time;
{
    int r = 0;
    
    const struct tm * time_value =
	get_expanded_date_value(ptr);
    
    if (time_value) {

	r = expanded_time_hdrval(time_value,get_expanded_date_cached_time(ptr),
				 buffer,size,print_time,NULL,0);

    } else {
	DPRINT(Debug,16,(&Debug,
			 "date_hdrval: no time_value\n"));
    }

    DPRINT(Debug,16,(&Debug,
		     "date_hdrval=%d\n",r));

     return r;
}


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */

