static char rcsid[] = "@(#)$Id: duplicate.c,v 2.1 2019/03/11 18:23:55 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.1 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_addr.h"

DEBUG_VAR(Debug,__FILE__,"addr");

int addr_list_is_same(a1,a2)
     struct addr_list *a1; 
     struct addr_list *a2;
{
    int len  = addr_list_item_count(a1);
    int glen = addr_list_group_count(a1);

    int g,i;


    if (len != addr_list_item_count(a2))    /* Different number of addresses */
	return 0;
    if (glen != addr_list_group_count(a2))  /* Different number of groups */
	return 0;

    /* Groups must be on same order */
    for (g = 0; g < glen; g++) {
	const struct string *g1 = addr_list_get_group(a1,g);
	const struct string *g2 = addr_list_get_group(a2,g);
	
	if (0 != string_cmp(g1, g2, 99))
	    return 0;
    }
    
    /* Addresses must be on same order */
    for (i = 0; i < len; i++) {
	int g1 = -1;
	const struct address * address1 = addr_list_get_item(a1,i,&g1);

	const char          * addr1     = address_get_ascii_addr(address1);
	const struct string * fullname1 = address_get_phrase(address1);
	const struct string * comment1  = address_get_comment(address1);

	int g2 = -1;
	const struct address * address2 = addr_list_get_item(a2,i,&g2);

	const char          * addr2     = address_get_ascii_addr(address2);
	const struct string * fullname2 = address_get_phrase(address2);
	const struct string * comment2  = address_get_comment(address2);

	if (g1 != g2)               /* On different group */
	    return 0;

	if (!addr1 || !addr2)
	    return 0;             /* unsupported */

	if (0 != strcmp(addr1,addr2))
	    return 0;

	if (fullname1 && fullname2) {	
	    if (0 != string_cmp(fullname1,
				fullname2, 99)) 
		return 0;
	} else if (fullname1 || fullname2)
	    return 0;

	if (comment1 && comment1) {
	    if (0 != string_cmp(comment1,
				comment2, 99)) 
		return 0;
	} else if (comment1 || comment2) 
	    return 0;
    }

    /* All addresses passes */

    return 1;
}


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */

