static char rcsid[] = "@(#)$Id: error.c,v 2.10 2020/03/21 08:28:58 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.10 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_addr.h"

DEBUG_VAR(Debug,__FILE__,"addr");

#define HEADER_ERROR_magic      0xFC07

struct header_errors {
    unsigned short magic;       /* HEADER_ERROR_magic */
  
    struct string   ** errors;
    int                errors_len;
    
};

void free_header_errors(error)
     struct header_errors **error;
{

    if (HEADER_ERROR_magic != (*error)->magic)
	    panic("HEADERS PANIC",__FILE__,__LINE__,"free_header_errors",
		  "bad magic number",0);
    
    if ((*error)->errors) {
	int i;

	for (i = 0; i < (*error)->errors_len; i++) {
	    if ((*error)->errors[i])
		free_string(& ((*error)->errors[i]));
	}

	free((*error)->errors);
	(*error)->errors = NULL;
    }
    (*error)->errors_len = 0;

    (*error)->magic = 0;  /* Invalidate */
    free(*error);
    *error = NULL;
}

static struct header_errors * malloc_header_errors P_((void));
static struct header_errors * malloc_header_errors()
{
    struct header_errors * ret = safe_zero_alloc(sizeof (*ret));

    ret->errors     = NULL;
    ret->errors_len = 0;
    ret->magic      = HEADER_ERROR_magic;

    return ret;
}

void process_header_error P_((struct header_errors **error,
			     const char * format, const char *msg, 
			     ...));


void process_header_error (
#if ANSI_C
			   struct header_errors **error,
			   const char * format, const char *msg, 
			   ...
#else
			   error,format, msg, va_alist
#endif
			 )
#if !ANSI_C
     struct header_errors **error;
     const char * format;
     const char *msg; 
     va_dcl
#endif
{
    va_list vl;

    enum show_header_errors_v show_header_errors = 
	give_dt_enumerate_as_int(&show_header_errors_e);
    struct string * S;

    /* If error is NULL, then show erros always ... */

    if (error && show_hdr_error_OFF == show_header_errors)
	return;

    Va_start(vl, msg);           /* defined in hdrs/elm_defs.h */
    
    S = elm_smessage(0,format,msg,vl);
    
    va_end(vl);
       
    if (!error)
	lib_error(FRM("%S"),S);

    else {

	switch (show_header_errors) {

	case show_hdr_error_ON: 
	    lib_error(FRM("%S"),S);
	    break;
	    
	case show_hdr_error_store: 
	    
	    if (!*error)
		*error = malloc_header_errors();
	    else if (HEADER_ERROR_magic != (*error)->magic)
		panic("HEADERS PANIC",__FILE__,__LINE__,"process_header_error",
		      "bad magic number",0);
	    
	    (*error)->errors = 
		safe_array_realloc((*error)->errors,
				   ((*error)->errors_len+1),
				   sizeof((*error)->errors[0]));
					    
	    (*error)->errors[(*error)->errors_len] = S;
	    S = NULL;
	    (*error)->errors_len++;
	    
	    break;
	case show_hdr_error_OFF:
	case NUM_show_header_errors:
	    /* Not used */
	    break;
	}
    }
    

    if (S)
	free_string(&S);

}


int get_header_errors_count(error)
     struct header_errors *error;
{
    if (HEADER_ERROR_magic != error->magic)
	panic("HEADERS PANIC",__FILE__,__LINE__,"get_header_errors_count",
	      "bad magic number",0);

    return error->errors_len;
}

const struct string * get_header_errors_msg(error,idx)
     struct header_errors *error;
     int idx;
{
    if (HEADER_ERROR_magic != error->magic)
	panic("HEADERS PANIC",__FILE__,__LINE__,"get_header_errors_msg",
	      "bad magic number",0);

    if (idx < 0 || idx >= error->errors_len ||
	! error->errors[idx])
	panic("HEADERS PANIC",__FILE__,__LINE__,"get_header_errors_msg",
	      "bad index",0);
	
    return error->errors[idx];
}

void print_header_errors(error)
     struct header_errors *error;
{
    int i;

    if (HEADER_ERROR_magic != error->magic)
	panic("HEADERS PANIC",__FILE__,__LINE__,"print_header_erros",
	      "bad magic number",0);

    for (i = 0; i < error->errors_len; i++) {
	if (error->errors[i])
	    lib_error(FRM("%S"),error->errors[i]);
    }

}
/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */


