static char rcsid[] = "@(#)$Id: mlist.c,v 2.5 2016/03/21 20:26:13 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.5 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_addr.h"
#include "mlist_common.h"
#include "mlist_imp.h"

DEBUG_VAR(Debug,__FILE__,"addr");

static int address_list_match P_((const struct addr_list *addrx,
				  char * pattern));
static int address_list_match(addrx,pattern)
     const struct addr_list *addrx;
     char * pattern;
{
    struct split_addr  splitted_pattern;
    int ret = 0;

    /* Internet hostnames are case insensitive */

    if (split_internet_address(&splitted_pattern,pattern)) {

	int idx, addr_item_count  = addr_list_item_count(addrx);
	
	
	for (idx = 0; idx < addr_item_count; idx++) {
	    int group = -1;
	    
	    const struct address * address = 
		addr_list_get_item(addrx,idx,&group);
	    
	    const char          * addr     = address_get_ascii_addr(address);
	    
	    struct split_addr  splitted_addr;

	    if (addr &&
		split_internet_address(&splitted_addr,addr)) {

		if (match_splitted_addr(& splitted_addr,
					&splitted_pattern))
		    ret = 1;
					

		clear_split_addr(&splitted_addr);
	    }

	    if (ret)
		break;
	}
       
	clear_split_addr(&splitted_pattern);
    } else {

	int idx, addr_item_count  = addr_list_item_count(addrx);


	for (idx = 0; idx < addr_item_count; idx++) {
	    int group = -1;
	    
	    const struct address * address = 
		addr_list_get_item(addrx,idx,&group);
	    
	    const char          * addr     = address_get_ascii_addr(address);
	    
	    if (addr &&
		match_local_addr(addr,pattern)) {
		ret = 1;
		break;
	    }
	    
	}

    }

    return ret;
}

#define MLIST_SCAN_magic	0xEF02

struct mlist_scan {
    unsigned short           magic;               /* MLIST_SCAN_magic */

    struct mlist_matches {
	struct mlist_info  *ptr;
	int                 score;
    }                      * matches;
    int                      match_count;

};

static struct mlist_scan * malloc_mlist_scan P_((void));
static struct mlist_scan * malloc_mlist_scan()
{
    struct mlist_scan *ret = safe_zero_alloc(sizeof (*ret));

    ret->magic = MLIST_SCAN_magic;

    ret->matches = NULL;
    ret->match_count = 0;

    return ret;
}


struct mlist_scan * mlist_get_matches(list,hdr,match_id)
     struct mlist_conf *list;
     struct header_rec *hdr;
     mlist_match_id_f  *match_id;
{
    struct mlist_scan * ret = malloc_mlist_scan();

    int i;

    if (MLIST_CONF_magic != list ->magic)
	panic("MLIST PANIC",__FILE__,__LINE__,"mlist_get_matches",
	      "Bad magic number",0);

    for (i = 0; i < list->nlist; i++) {
	
	int score = 0;

	if (list->lists[i].list_id) {
	    if (! hdr->list_info)
		continue;     /* Failure */
	    if (match_id(list->lists[i].list_id,
			 hdr->list_info))
		score += 3;
	    else 
		continue;     /* Failure */
			 
	}

	if (list->lists[i].to_pattern) {

	    if (hdr->to &&
		address_list_match(hdr->to,
				   list->lists[i].to_pattern)) {
		score += 2;

	    } else if (hdr->cc &&
		       address_list_match(hdr->cc,
					  list->lists[i].to_pattern)) {
		score += 1;

	    } else 
		continue;     /* Failure */	       
	}

	if (!score) {
	    /* Empty match */

	    DPRINT(Debug,2,(&Debug,
			    "mlist_get_matches: Matches to empty match\n"));

	} 

	ret->matches = safe_array_realloc(ret->matches,
					  (ret->match_count+1),
					  sizeof(ret->matches[0]));
	
	ret->matches[ret->match_count].ptr   = & ( list->lists[i] );
	ret->matches[ret->match_count].score = score;
	ret->match_count++;
    }

    DPRINT(Debug,7,(&Debug,
		    "mlist_get_matches: %d matches\n",
		    ret->match_count));

    return ret;
}

void free_mlist_scan(match)
     struct mlist_scan **match;
{
    if (MLIST_SCAN_magic != (*match)->magic)
	panic("MLIST PANIC",__FILE__,__LINE__,"free_mlist_scan",
	      "Bad magic number",0);

    if ((*match)->matches) {
	free((*match)->matches);
	(*match)->matches = NULL;
    }

    (*match)->match_count = 0;

    (*match)->magic = 0;  /* Invalidated */
    free(*match);
    *match = NULL;
}

void append_mlist_scan(list,other)
     struct mlist_scan *list;
     const struct mlist_scan *other;
{
    int i;

    if (MLIST_SCAN_magic != list->magic)
	panic("MLIST PANIC",__FILE__,__LINE__,"append_mlist_scan",
	      "Bad magic number (list)",0);

    if (MLIST_SCAN_magic != other->magic)
	panic("MLIST PANIC",__FILE__,__LINE__,"append_mlist_scan",
	      "Bad magic number (other)",0);

    /* Avoid allocing 0 bytes */
    if (other->match_count < 1)
	return;

    list->matches = safe_array_realloc(list->matches,
				       (list->match_count+
					other->match_count),
				       sizeof(list->matches[0]));

    for (i = 0; i < other->match_count; i++) {
	list->matches[list->match_count] = other->matches[i];
	list->match_count++;
    }
}

/* List is non-empty */
int have_mlist_scan(match)
     struct mlist_scan *match;
{
    if (MLIST_SCAN_magic != match->magic)
	panic("MLIST PANIC",__FILE__,__LINE__,"have_mlist_scan",
	      "Bad magic number",0);

    return match->match_count > 0;
}


const struct mlist_info * get_mlist_info(match)
     struct mlist_scan *match;
{
    struct mlist_info * ret = NULL;
    int score = -1;
    int i;

    if (MLIST_SCAN_magic != match->magic)
	panic("MLIST PANIC",__FILE__,__LINE__,"get_mlist_info",
	      "Bad magic number",0);
    
    for (i = 0; i < match->match_count; i++) {
	if (match->matches[i].score > score) {
	    ret   =  match->matches[i].ptr;
	    score =  match->matches[i].score;
	}
    }

    return ret;
}


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
