static char rcsid[] = "@(#)$Id: okay_addr.c,v 2.8 2018/07/30 16:50:52 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.8 $   $State: Exp $
 *
 *  Reimplemented by: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                            (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *                or  Kari Hurtta <elm@elmme-mailer.org>
 ******************************************************************************
 *  This code is reimplemented. Original code on Elm 2.4 lib/okay_addr.c 
 *  was following copyright:
 *
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

#include "def_addr.h"


DEBUG_VAR(Debug,__FILE__,"addr");


int okay_address_l(address, return_address_list,usraddr)
     const struct address   * address;
     const struct addr_list * return_address_list;
     const struct address   * usraddr;   /* from address from hashmark */
{  
    const char          * addr     = address_get_ascii_addr(address);
    const struct string * fullname UNUSED_VAROK = 
	address_get_phrase(address);
    
    /** This routine checks to ensure that the address we just got
	from the "To:" or "Cc:" line isn't us AND isn't the person	
	who sent the message.  Returns true iff neither is the case **/
    
    
    if (!addr) {
	DPRINT(Debug,25,(&Debug,
			 "okay_address_l=0\n"));

	return 0;
    }

    if (usraddr) {
	 const char          * usraddr_addr     = address_get_ascii_addr(usraddr);
	 const struct string * usraddr_fullname UNUSED_VAROK = 
	     address_get_phrase(usraddr);

	 if (0 == strcmp(usraddr_addr, addr)) {
	     DPRINT(Debug,25,(&Debug,
			      "okay_address_l=0:\n"));
	     DPRINT(Debug,25,(&Debug,
			      "     address{addr=%s,fullname=%S} same as user address {addr=%s,fullname=%S}\n",
			      addr, fullname,
			      usraddr_addr, usraddr_fullname));
		return 0;		
	 }
    }
    
    if (return_address_list) {

	int idx, addr_item_count = addr_list_item_count(return_address_list);

	for (idx = 0; idx < addr_item_count; idx++) {
	    int group = -1;
	    const struct address * return_address = 
		addr_list_get_item(return_address_list,idx,&group);
	    
	    const char          * return_addr     = address_get_ascii_addr(return_address);
	    const struct string * return_fullname UNUSED_VAROK = 
		address_get_phrase(return_address);
	    
	    if (!return_addr)
		continue;
	
	    if (0 == strcmp(return_addr, addr)) {
		DPRINT(Debug,25,(&Debug,
				 "okay_address_l=0:\n"));
		DPRINT(Debug,25,(&Debug,
				 "     address{addr=%s,fullname=%S} same as return_address {addr=%s,fullname=%S}\n",
				 addr, fullname,
				 return_addr, return_fullname));
		return 0;
	    }
	}
    }

    if (addr_is_user(addr)) {
	DPRINT(Debug,25,(&Debug,
			 "okay_address_l=0:\n"));
	DPRINT(Debug,25,(&Debug,
			 "     address{addr=%s,fullname=%S} is user's address\n",
			 addr, fullname));	
	return 0;
    }
    
    DPRINT(Debug,25,(&Debug,
		     "okay_address_l=1:\n"));
    DPRINT(Debug,25,(&Debug,
		     "     address{addr=%s,fullname=%S} is not our address.\n",
		     addr, fullname)); 
    return 1;
}

int addr_is_user(addr)
     const char *addr;
{
    const char **alternatives = give_dt_path_as_elems(&alternative_addresses,
						      "alternatives");
    const char **mailname_list = give_dt_path_as_elems(&mailname,"mailname");

    char our_address[SLEN]; 
    char deqbuffer[SLEN];

    struct split_addr  splitted_addr;

    int D = strcpy_dequote(deqbuffer, addr, sizeof deqbuffer);

    if (D != 0) {
	DPRINT(Debug,25,(&Debug,
			 "addr_is_user(\"%s\"): Dequotation: %s\n",
			 addr,deqbuffer));
    }

    if (0 == strcmp(username, deqbuffer)) {
	DPRINT(Debug,25,(&Debug,
			 "addr_is_user(\"%s\")=TRUE: %s matches username\n",
			 D > 0 ? "(dequoted)" : "",
			 addr));
	return TRUE;
    }
	
          
    /* UUCP hostnames are case sensitive */
    elm_sfprintf(our_address, sizeof our_address,
		 FRM("%s!%s"), hostname, username);

    if (0 == strcmp(our_address, deqbuffer)) {
	DPRINT(Debug,25,(&Debug,				    
			 "addr_is_user(\"%s\")=TRUE: %s matches UUCP address\n",
			 D > 0 ? "(dequoted)" : "",
			 addr));
	return TRUE;
    }

    elm_sfprintf(our_address, sizeof our_address,
		 FRM("%s!%s"), hostfullname, username);

    if (0 == strcmp(our_address, deqbuffer)) {
	DPRINT(Debug,25,(&Debug,
			 "addr_is_user(\"%s\")=TRUE: %s matches UUCP address\n",
			 D > 0 ? "(dequoted)" : "",
			 addr));
	return TRUE;
    }    
    
    /* Internet hostnames are case insensitive */

    if (split_internet_address(&splitted_addr,addr)) {
       
	DPRINT(Debug,25,(&Debug,
			 "addr_is_user(\"%s\"): user part=%s%s, host part=%s\n",
			 addr,
			 splitted_addr.local_part,
			 splitted_addr.local_part_dequote > 0 ? 
			 " (dequoted)" : "",
			 splitted_addr.host_part));
    
	if (0 == strcmp(splitted_addr.local_part,username)) {

	    if (mailname_list) {

		int i;
	    
		for (i = 0; mailname_list[i]; i++) {

		    if (0 == istrcmp(mailname_list[i],splitted_addr.host_part)) {
			DPRINT(Debug,25,(&Debug,
					 "addr_is_user(\"%s\")=TRUE: matches internet address [mailname[%d]=%s]\n",
					 addr,i,mailname_list[i]));
			
			clear_split_addr(&splitted_addr);
			
			return(TRUE);
		    }
		}

	    } else {   /* mailname setting overrides hostname and hostfullname */
		
		if (0 == istrcmp(hostname,splitted_addr.host_part)) {
		    DPRINT(Debug,25,(&Debug,
				     "addr_is_user(\"%s\")=TRUE: matches internet address [hostname]\n",
				     addr));
		    
		    clear_split_addr(&splitted_addr);
		    
		    return(TRUE);
		}
		
		if (0 == istrcmp(hostfullname,splitted_addr.host_part)) {
		    DPRINT(Debug,25,(&Debug,
				     "addr_is_user(\"%s\")=TRUE: matches internet address [hostfullname]\n",
				     addr));		
		    
		    clear_split_addr(&splitted_addr);
		    
		    return(TRUE);
		}
	    }
	}

	if (alternatives) {

	    int i;

	    for (i = 0; alternatives[i]; i++) {

		struct split_addr  splitted_alternative;
		
		if (split_internet_address(&splitted_alternative,
					   alternatives[i])) {
		  
		    DPRINT(Debug,26,(&Debug,
				     "addr_is_user: %s: user part=%s%s, host part=%s\n",
				     alternatives[i],
				     splitted_alternative.local_part,
				     splitted_alternative.local_part_dequote > 0 ? 
				     " (dequoted)" : "",
				     splitted_alternative.host_part));


		    if (match_splitted_addr(& splitted_addr,
					    & splitted_alternative)) {

			DPRINT(Debug,25,(&Debug,
					 "addr_is_user(\"%s\")=TRUE: matches alternative\n",
					 addr));		
			
			clear_split_addr(&splitted_alternative);
			clear_split_addr(&splitted_addr);
			
			return(TRUE);		    
		    }

		    clear_split_addr(&splitted_alternative);
		}
	    }
	}

	clear_split_addr(&splitted_addr);
    }

    if (alternatives) {

	int i;
	
	for (i = 0; alternatives[i]; i++) {
	    
	    if (match_local_addr(addr,alternatives[i])) {
		DPRINT(Debug,25,(&Debug,				   
				 "addr_is_user(\"%s\")=TRUE: matches alternative address\n",
				 addr));		
		return(TRUE);
	    }

	}
    }
    DPRINT(Debug,25,(&Debug,
		     "addr_is_user(\"%s\")=FALSE\n",addr));
    return FALSE;
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
